/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: device/Device.proto

package io.opencannabis.schema.device;

/**
 * <pre>
 * Credentials that assert a device's identity or authorization.
 * </pre>
 *
 * Protobuf type {@code opencannabis.device.DeviceCredentials}
 */
public  final class DeviceCredentials extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.device.DeviceCredentials)
    DeviceCredentialsOrBuilder {
private static final long serialVersionUID = 0L;
  // Use DeviceCredentials.newBuilder() to construct.
  private DeviceCredentials(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private DeviceCredentials() {
    publicKey_ = com.google.protobuf.ByteString.EMPTY;
    privateKey_ = com.google.protobuf.ByteString.EMPTY;
    sha256_ = "";
    identity_ = "";
    authorities_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private DeviceCredentials(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {

            publicKey_ = input.readBytes();
            break;
          }
          case 18: {

            privateKey_ = input.readBytes();
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            sha256_ = s;
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            identity_ = s;
            break;
          }
          case 42: {
            if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
              authorities_ = new java.util.ArrayList<com.google.protobuf.ByteString>();
              mutable_bitField0_ |= 0x00000010;
            }
            authorities_.add(input.readBytes());
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
        authorities_ = java.util.Collections.unmodifiableList(authorities_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.device.DeviceOuterClass.internal_static_opencannabis_device_DeviceCredentials_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.device.DeviceOuterClass.internal_static_opencannabis_device_DeviceCredentials_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.device.DeviceCredentials.class, io.opencannabis.schema.device.DeviceCredentials.Builder.class);
  }

  private int bitField0_;
  public static final int PUBLIC_KEY_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString publicKey_;
  /**
   * <pre>
   * Raw bytes for a device's public key.
   * </pre>
   *
   * <code>bytes public_key = 1 [(.gen_bq_schema.ignore) = true];</code>
   */
  public com.google.protobuf.ByteString getPublicKey() {
    return publicKey_;
  }

  public static final int PRIVATE_KEY_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString privateKey_;
  /**
   * <pre>
   * Raw bytes for the device's private key.
   * </pre>
   *
   * <code>bytes private_key = 2 [(.gen_bq_schema.ignore) = true];</code>
   */
  public com.google.protobuf.ByteString getPrivateKey() {
    return privateKey_;
  }

  public static final int SHA256_FIELD_NUMBER = 3;
  private volatile java.lang.Object sha256_;
  /**
   * <pre>
   * SHA256 hash of this device's public key.
   * </pre>
   *
   * <code>string sha256 = 3 [(.gen_bq_schema.description) = "SHA256 hash of this device&#92;'s public key."];</code>
   */
  public java.lang.String getSha256() {
    java.lang.Object ref = sha256_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sha256_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * SHA256 hash of this device's public key.
   * </pre>
   *
   * <code>string sha256 = 3 [(.gen_bq_schema.description) = "SHA256 hash of this device&#92;'s public key."];</code>
   */
  public com.google.protobuf.ByteString
      getSha256Bytes() {
    java.lang.Object ref = sha256_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      sha256_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IDENTITY_FIELD_NUMBER = 4;
  private volatile java.lang.Object identity_;
  /**
   * <pre>
   * A device's raw identity payload.
   * </pre>
   *
   * <code>string identity = 4 [(.gen_bq_schema.ignore) = true];</code>
   */
  public java.lang.String getIdentity() {
    java.lang.Object ref = identity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      identity_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * A device's raw identity payload.
   * </pre>
   *
   * <code>string identity = 4 [(.gen_bq_schema.ignore) = true];</code>
   */
  public com.google.protobuf.ByteString
      getIdentityBytes() {
    java.lang.Object ref = identity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      identity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTHORITIES_FIELD_NUMBER = 5;
  private java.util.List<com.google.protobuf.ByteString> authorities_;
  /**
   * <pre>
   * Repeated PEM authority payloads, asserted as trusted by the server.
   * </pre>
   *
   * <code>repeated bytes authorities = 5 [(.gen_bq_schema.ignore) = true];</code>
   */
  public java.util.List<com.google.protobuf.ByteString>
      getAuthoritiesList() {
    return authorities_;
  }
  /**
   * <pre>
   * Repeated PEM authority payloads, asserted as trusted by the server.
   * </pre>
   *
   * <code>repeated bytes authorities = 5 [(.gen_bq_schema.ignore) = true];</code>
   */
  public int getAuthoritiesCount() {
    return authorities_.size();
  }
  /**
   * <pre>
   * Repeated PEM authority payloads, asserted as trusted by the server.
   * </pre>
   *
   * <code>repeated bytes authorities = 5 [(.gen_bq_schema.ignore) = true];</code>
   */
  public com.google.protobuf.ByteString getAuthorities(int index) {
    return authorities_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!publicKey_.isEmpty()) {
      output.writeBytes(1, publicKey_);
    }
    if (!privateKey_.isEmpty()) {
      output.writeBytes(2, privateKey_);
    }
    if (!getSha256Bytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sha256_);
    }
    if (!getIdentityBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, identity_);
    }
    for (int i = 0; i < authorities_.size(); i++) {
      output.writeBytes(5, authorities_.get(i));
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!publicKey_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream
        .computeBytesSize(1, publicKey_);
    }
    if (!privateKey_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream
        .computeBytesSize(2, privateKey_);
    }
    if (!getSha256Bytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sha256_);
    }
    if (!getIdentityBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, identity_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < authorities_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeBytesSizeNoTag(authorities_.get(i));
      }
      size += dataSize;
      size += 1 * getAuthoritiesList().size();
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.device.DeviceCredentials)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.device.DeviceCredentials other = (io.opencannabis.schema.device.DeviceCredentials) obj;

    boolean result = true;
    result = result && getPublicKey()
        .equals(other.getPublicKey());
    result = result && getPrivateKey()
        .equals(other.getPrivateKey());
    result = result && getSha256()
        .equals(other.getSha256());
    result = result && getIdentity()
        .equals(other.getIdentity());
    result = result && getAuthoritiesList()
        .equals(other.getAuthoritiesList());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PUBLIC_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getPublicKey().hashCode();
    hash = (37 * hash) + PRIVATE_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getPrivateKey().hashCode();
    hash = (37 * hash) + SHA256_FIELD_NUMBER;
    hash = (53 * hash) + getSha256().hashCode();
    hash = (37 * hash) + IDENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getIdentity().hashCode();
    if (getAuthoritiesCount() > 0) {
      hash = (37 * hash) + AUTHORITIES_FIELD_NUMBER;
      hash = (53 * hash) + getAuthoritiesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.device.DeviceCredentials parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.device.DeviceCredentials parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.device.DeviceCredentials parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.device.DeviceCredentials parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.device.DeviceCredentials parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.device.DeviceCredentials parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.device.DeviceCredentials parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.device.DeviceCredentials parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.device.DeviceCredentials parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.device.DeviceCredentials parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.device.DeviceCredentials parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.device.DeviceCredentials parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.device.DeviceCredentials prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Credentials that assert a device's identity or authorization.
   * </pre>
   *
   * Protobuf type {@code opencannabis.device.DeviceCredentials}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.device.DeviceCredentials)
      io.opencannabis.schema.device.DeviceCredentialsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.device.DeviceOuterClass.internal_static_opencannabis_device_DeviceCredentials_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.device.DeviceOuterClass.internal_static_opencannabis_device_DeviceCredentials_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.device.DeviceCredentials.class, io.opencannabis.schema.device.DeviceCredentials.Builder.class);
    }

    // Construct using io.opencannabis.schema.device.DeviceCredentials.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      publicKey_ = com.google.protobuf.ByteString.EMPTY;

      privateKey_ = com.google.protobuf.ByteString.EMPTY;

      sha256_ = "";

      identity_ = "";

      authorities_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.device.DeviceOuterClass.internal_static_opencannabis_device_DeviceCredentials_descriptor;
    }

    public io.opencannabis.schema.device.DeviceCredentials getDefaultInstanceForType() {
      return io.opencannabis.schema.device.DeviceCredentials.getDefaultInstance();
    }

    public io.opencannabis.schema.device.DeviceCredentials build() {
      io.opencannabis.schema.device.DeviceCredentials result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.device.DeviceCredentials buildPartial() {
      io.opencannabis.schema.device.DeviceCredentials result = new io.opencannabis.schema.device.DeviceCredentials(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.publicKey_ = publicKey_;
      result.privateKey_ = privateKey_;
      result.sha256_ = sha256_;
      result.identity_ = identity_;
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        authorities_ = java.util.Collections.unmodifiableList(authorities_);
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.authorities_ = authorities_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.device.DeviceCredentials) {
        return mergeFrom((io.opencannabis.schema.device.DeviceCredentials)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.device.DeviceCredentials other) {
      if (other == io.opencannabis.schema.device.DeviceCredentials.getDefaultInstance()) return this;
      if (other.getPublicKey() != com.google.protobuf.ByteString.EMPTY) {
        setPublicKey(other.getPublicKey());
      }
      if (other.getPrivateKey() != com.google.protobuf.ByteString.EMPTY) {
        setPrivateKey(other.getPrivateKey());
      }
      if (!other.getSha256().isEmpty()) {
        sha256_ = other.sha256_;
        onChanged();
      }
      if (!other.getIdentity().isEmpty()) {
        identity_ = other.identity_;
        onChanged();
      }
      if (!other.authorities_.isEmpty()) {
        if (authorities_.isEmpty()) {
          authorities_ = other.authorities_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureAuthoritiesIsMutable();
          authorities_.addAll(other.authorities_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.device.DeviceCredentials parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.device.DeviceCredentials) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private com.google.protobuf.ByteString publicKey_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     * Raw bytes for a device's public key.
     * </pre>
     *
     * <code>bytes public_key = 1 [(.gen_bq_schema.ignore) = true];</code>
     */
    public com.google.protobuf.ByteString getPublicKey() {
      return publicKey_;
    }
    /**
     * <pre>
     * Raw bytes for a device's public key.
     * </pre>
     *
     * <code>bytes public_key = 1 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder setPublicKey(com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      publicKey_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Raw bytes for a device's public key.
     * </pre>
     *
     * <code>bytes public_key = 1 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder clearPublicKey() {
      
      publicKey_ = getDefaultInstance().getPublicKey();
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString privateKey_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     * Raw bytes for the device's private key.
     * </pre>
     *
     * <code>bytes private_key = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public com.google.protobuf.ByteString getPrivateKey() {
      return privateKey_;
    }
    /**
     * <pre>
     * Raw bytes for the device's private key.
     * </pre>
     *
     * <code>bytes private_key = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder setPrivateKey(com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      privateKey_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Raw bytes for the device's private key.
     * </pre>
     *
     * <code>bytes private_key = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder clearPrivateKey() {
      
      privateKey_ = getDefaultInstance().getPrivateKey();
      onChanged();
      return this;
    }

    private java.lang.Object sha256_ = "";
    /**
     * <pre>
     * SHA256 hash of this device's public key.
     * </pre>
     *
     * <code>string sha256 = 3 [(.gen_bq_schema.description) = "SHA256 hash of this device&#92;'s public key."];</code>
     */
    public java.lang.String getSha256() {
      java.lang.Object ref = sha256_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sha256_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * SHA256 hash of this device's public key.
     * </pre>
     *
     * <code>string sha256 = 3 [(.gen_bq_schema.description) = "SHA256 hash of this device&#92;'s public key."];</code>
     */
    public com.google.protobuf.ByteString
        getSha256Bytes() {
      java.lang.Object ref = sha256_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sha256_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * SHA256 hash of this device's public key.
     * </pre>
     *
     * <code>string sha256 = 3 [(.gen_bq_schema.description) = "SHA256 hash of this device&#92;'s public key."];</code>
     */
    public Builder setSha256(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      sha256_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * SHA256 hash of this device's public key.
     * </pre>
     *
     * <code>string sha256 = 3 [(.gen_bq_schema.description) = "SHA256 hash of this device&#92;'s public key."];</code>
     */
    public Builder clearSha256() {
      
      sha256_ = getDefaultInstance().getSha256();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * SHA256 hash of this device's public key.
     * </pre>
     *
     * <code>string sha256 = 3 [(.gen_bq_schema.description) = "SHA256 hash of this device&#92;'s public key."];</code>
     */
    public Builder setSha256Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      sha256_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object identity_ = "";
    /**
     * <pre>
     * A device's raw identity payload.
     * </pre>
     *
     * <code>string identity = 4 [(.gen_bq_schema.ignore) = true];</code>
     */
    public java.lang.String getIdentity() {
      java.lang.Object ref = identity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        identity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * A device's raw identity payload.
     * </pre>
     *
     * <code>string identity = 4 [(.gen_bq_schema.ignore) = true];</code>
     */
    public com.google.protobuf.ByteString
        getIdentityBytes() {
      java.lang.Object ref = identity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        identity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * A device's raw identity payload.
     * </pre>
     *
     * <code>string identity = 4 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder setIdentity(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      identity_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A device's raw identity payload.
     * </pre>
     *
     * <code>string identity = 4 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder clearIdentity() {
      
      identity_ = getDefaultInstance().getIdentity();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A device's raw identity payload.
     * </pre>
     *
     * <code>string identity = 4 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder setIdentityBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      identity_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.ByteString> authorities_ = java.util.Collections.emptyList();
    private void ensureAuthoritiesIsMutable() {
      if (!((bitField0_ & 0x00000010) == 0x00000010)) {
        authorities_ = new java.util.ArrayList<com.google.protobuf.ByteString>(authorities_);
        bitField0_ |= 0x00000010;
       }
    }
    /**
     * <pre>
     * Repeated PEM authority payloads, asserted as trusted by the server.
     * </pre>
     *
     * <code>repeated bytes authorities = 5 [(.gen_bq_schema.ignore) = true];</code>
     */
    public java.util.List<com.google.protobuf.ByteString>
        getAuthoritiesList() {
      return java.util.Collections.unmodifiableList(authorities_);
    }
    /**
     * <pre>
     * Repeated PEM authority payloads, asserted as trusted by the server.
     * </pre>
     *
     * <code>repeated bytes authorities = 5 [(.gen_bq_schema.ignore) = true];</code>
     */
    public int getAuthoritiesCount() {
      return authorities_.size();
    }
    /**
     * <pre>
     * Repeated PEM authority payloads, asserted as trusted by the server.
     * </pre>
     *
     * <code>repeated bytes authorities = 5 [(.gen_bq_schema.ignore) = true];</code>
     */
    public com.google.protobuf.ByteString getAuthorities(int index) {
      return authorities_.get(index);
    }
    /**
     * <pre>
     * Repeated PEM authority payloads, asserted as trusted by the server.
     * </pre>
     *
     * <code>repeated bytes authorities = 5 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder setAuthorities(
        int index, com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthoritiesIsMutable();
      authorities_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Repeated PEM authority payloads, asserted as trusted by the server.
     * </pre>
     *
     * <code>repeated bytes authorities = 5 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder addAuthorities(com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthoritiesIsMutable();
      authorities_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Repeated PEM authority payloads, asserted as trusted by the server.
     * </pre>
     *
     * <code>repeated bytes authorities = 5 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder addAllAuthorities(
        java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
      ensureAuthoritiesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, authorities_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Repeated PEM authority payloads, asserted as trusted by the server.
     * </pre>
     *
     * <code>repeated bytes authorities = 5 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder clearAuthorities() {
      authorities_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.device.DeviceCredentials)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.device.DeviceCredentials)
  private static final io.opencannabis.schema.device.DeviceCredentials DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.device.DeviceCredentials();
  }

  public static io.opencannabis.schema.device.DeviceCredentials getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeviceCredentials>
      PARSER = new com.google.protobuf.AbstractParser<DeviceCredentials>() {
    public DeviceCredentials parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new DeviceCredentials(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<DeviceCredentials> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeviceCredentials> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.device.DeviceCredentials getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

