/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: device/Device.proto

package io.opencannabis.schema.device;

/**
 * <pre>
 * Enumerates major types of devices that might be encountered, including desktops, phones, tablets, TVs, and browsers.
 * </pre>
 *
 * Protobuf enum {@code opencannabis.device.DeviceType}
 */
public enum DeviceType
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * The end-device type is not known.
   * </pre>
   *
   * <code>UNKNOWN_DEVICE_TYPE = 0;</code>
   */
  UNKNOWN_DEVICE_TYPE(0),
  /**
   * <pre>
   * The end-device is a desktop of some kind.
   * </pre>
   *
   * <code>DESKTOP = 1;</code>
   */
  DESKTOP(1),
  /**
   * <pre>
   * The end-device is a phone.
   * </pre>
   *
   * <code>PHONE = 2;</code>
   */
  PHONE(2),
  /**
   * <pre>
   * The end-device is a tablet.
   * </pre>
   *
   * <code>TABLET = 3;</code>
   */
  TABLET(3),
  /**
   * <pre>
   * The end-device is a TV of some kind.
   * </pre>
   *
   * <code>TV = 4;</code>
   */
  TV(4),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * The end-device type is not known.
   * </pre>
   *
   * <code>UNKNOWN_DEVICE_TYPE = 0;</code>
   */
  public static final int UNKNOWN_DEVICE_TYPE_VALUE = 0;
  /**
   * <pre>
   * The end-device is a desktop of some kind.
   * </pre>
   *
   * <code>DESKTOP = 1;</code>
   */
  public static final int DESKTOP_VALUE = 1;
  /**
   * <pre>
   * The end-device is a phone.
   * </pre>
   *
   * <code>PHONE = 2;</code>
   */
  public static final int PHONE_VALUE = 2;
  /**
   * <pre>
   * The end-device is a tablet.
   * </pre>
   *
   * <code>TABLET = 3;</code>
   */
  public static final int TABLET_VALUE = 3;
  /**
   * <pre>
   * The end-device is a TV of some kind.
   * </pre>
   *
   * <code>TV = 4;</code>
   */
  public static final int TV_VALUE = 4;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static DeviceType valueOf(int value) {
    return forNumber(value);
  }

  public static DeviceType forNumber(int value) {
    switch (value) {
      case 0: return UNKNOWN_DEVICE_TYPE;
      case 1: return DESKTOP;
      case 2: return PHONE;
      case 3: return TABLET;
      case 4: return TV;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<DeviceType>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      DeviceType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DeviceType>() {
          public DeviceType findValueByNumber(int number) {
            return DeviceType.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.opencannabis.schema.device.DeviceOuterClass.getDescriptor().getEnumTypes().get(0);
  }

  private static final DeviceType[] VALUES = values();

  public static DeviceType valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private DeviceType(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:opencannabis.device.DeviceType)
}

