/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: geo/Address.proto

package io.opencannabis.schema.geo;

/**
 * <pre>
 * Specifies a standard postal address, with two address lines, and space for a municipality ('city'), provincial
 * authority ('state'), and national authority ('country').
 * </pre>
 *
 * Protobuf type {@code opencannabis.geo.Address}
 */
public  final class Address extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.geo.Address)
    AddressOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Address.newBuilder() to construct.
  private Address(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Address() {
    firstLine_ = "";
    secondLine_ = "";
    city_ = "";
    state_ = "";
    zipcode_ = "";
    country_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Address(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            firstLine_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            secondLine_ = s;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            city_ = s;
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            state_ = s;
            break;
          }
          case 42: {
            java.lang.String s = input.readStringRequireUtf8();

            zipcode_ = s;
            break;
          }
          case 50: {
            java.lang.String s = input.readStringRequireUtf8();

            country_ = s;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.geo.AddressOuterClass.internal_static_opencannabis_geo_Address_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.geo.AddressOuterClass.internal_static_opencannabis_geo_Address_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.geo.Address.class, io.opencannabis.schema.geo.Address.Builder.class);
  }

  public static final int FIRST_LINE_FIELD_NUMBER = 1;
  private volatile java.lang.Object firstLine_;
  /**
   * <pre>
   * First line of the address.
   * </pre>
   *
   * <code>string first_line = 1 [(.gen_bq_schema.description) = "First line of the address."];</code>
   */
  public java.lang.String getFirstLine() {
    java.lang.Object ref = firstLine_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      firstLine_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * First line of the address.
   * </pre>
   *
   * <code>string first_line = 1 [(.gen_bq_schema.description) = "First line of the address."];</code>
   */
  public com.google.protobuf.ByteString
      getFirstLineBytes() {
    java.lang.Object ref = firstLine_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      firstLine_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECOND_LINE_FIELD_NUMBER = 2;
  private volatile java.lang.Object secondLine_;
  /**
   * <pre>
   * Second line of the address, if applicable.
   * </pre>
   *
   * <code>string second_line = 2 [(.gen_bq_schema.description) = "Second line of the address, if applicable."];</code>
   */
  public java.lang.String getSecondLine() {
    java.lang.Object ref = secondLine_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      secondLine_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Second line of the address, if applicable.
   * </pre>
   *
   * <code>string second_line = 2 [(.gen_bq_schema.description) = "Second line of the address, if applicable."];</code>
   */
  public com.google.protobuf.ByteString
      getSecondLineBytes() {
    java.lang.Object ref = secondLine_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      secondLine_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CITY_FIELD_NUMBER = 3;
  private volatile java.lang.Object city_;
  /**
   * <pre>
   * City or municipality name for the address.
   * </pre>
   *
   * <code>string city = 3 [(.gen_bq_schema.description) = "City or municipality name for the address."];</code>
   */
  public java.lang.String getCity() {
    java.lang.Object ref = city_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      city_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * City or municipality name for the address.
   * </pre>
   *
   * <code>string city = 3 [(.gen_bq_schema.description) = "City or municipality name for the address."];</code>
   */
  public com.google.protobuf.ByteString
      getCityBytes() {
    java.lang.Object ref = city_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      city_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private volatile java.lang.Object state_;
  /**
   * <pre>
   * State that contains the city or municipality for this address.
   * </pre>
   *
   * <code>string state = 4 [(.gen_bq_schema.description) = "State that contains the city or municipality for this address."];</code>
   */
  public java.lang.String getState() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      state_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * State that contains the city or municipality for this address.
   * </pre>
   *
   * <code>string state = 4 [(.gen_bq_schema.description) = "State that contains the city or municipality for this address."];</code>
   */
  public com.google.protobuf.ByteString
      getStateBytes() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      state_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZIPCODE_FIELD_NUMBER = 5;
  private volatile java.lang.Object zipcode_;
  /**
   * <pre>
   * USPS zipcode associated with this address.
   * </pre>
   *
   * <code>string zipcode = 5 [(.gen_bq_schema.description) = "USPS zipcode associated with this address."];</code>
   */
  public java.lang.String getZipcode() {
    java.lang.Object ref = zipcode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zipcode_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * USPS zipcode associated with this address.
   * </pre>
   *
   * <code>string zipcode = 5 [(.gen_bq_schema.description) = "USPS zipcode associated with this address."];</code>
   */
  public com.google.protobuf.ByteString
      getZipcodeBytes() {
    java.lang.Object ref = zipcode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      zipcode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COUNTRY_FIELD_NUMBER = 6;
  private volatile java.lang.Object country_;
  /**
   * <pre>
   * Country code associated with this address ('US' or 'USA' for United States, for instance).
   * </pre>
   *
   * <code>string country = 6 [(.gen_bq_schema.description) = "Country code associated with this address (&#92;'US&#92;' or &#92;'USA&#92;' for United States, for instance)."];</code>
   */
  public java.lang.String getCountry() {
    java.lang.Object ref = country_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      country_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Country code associated with this address ('US' or 'USA' for United States, for instance).
   * </pre>
   *
   * <code>string country = 6 [(.gen_bq_schema.description) = "Country code associated with this address (&#92;'US&#92;' or &#92;'USA&#92;' for United States, for instance)."];</code>
   */
  public com.google.protobuf.ByteString
      getCountryBytes() {
    java.lang.Object ref = country_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      country_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getFirstLineBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, firstLine_);
    }
    if (!getSecondLineBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, secondLine_);
    }
    if (!getCityBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, city_);
    }
    if (!getStateBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, state_);
    }
    if (!getZipcodeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, zipcode_);
    }
    if (!getCountryBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, country_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getFirstLineBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, firstLine_);
    }
    if (!getSecondLineBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, secondLine_);
    }
    if (!getCityBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, city_);
    }
    if (!getStateBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, state_);
    }
    if (!getZipcodeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, zipcode_);
    }
    if (!getCountryBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, country_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.geo.Address)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.geo.Address other = (io.opencannabis.schema.geo.Address) obj;

    boolean result = true;
    result = result && getFirstLine()
        .equals(other.getFirstLine());
    result = result && getSecondLine()
        .equals(other.getSecondLine());
    result = result && getCity()
        .equals(other.getCity());
    result = result && getState()
        .equals(other.getState());
    result = result && getZipcode()
        .equals(other.getZipcode());
    result = result && getCountry()
        .equals(other.getCountry());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FIRST_LINE_FIELD_NUMBER;
    hash = (53 * hash) + getFirstLine().hashCode();
    hash = (37 * hash) + SECOND_LINE_FIELD_NUMBER;
    hash = (53 * hash) + getSecondLine().hashCode();
    hash = (37 * hash) + CITY_FIELD_NUMBER;
    hash = (53 * hash) + getCity().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + getState().hashCode();
    hash = (37 * hash) + ZIPCODE_FIELD_NUMBER;
    hash = (53 * hash) + getZipcode().hashCode();
    hash = (37 * hash) + COUNTRY_FIELD_NUMBER;
    hash = (53 * hash) + getCountry().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.geo.Address parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.geo.Address parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Address parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.geo.Address parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Address parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.geo.Address parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Address parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.geo.Address parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Address parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.geo.Address parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Address parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.geo.Address parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.geo.Address prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a standard postal address, with two address lines, and space for a municipality ('city'), provincial
   * authority ('state'), and national authority ('country').
   * </pre>
   *
   * Protobuf type {@code opencannabis.geo.Address}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.geo.Address)
      io.opencannabis.schema.geo.AddressOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.geo.AddressOuterClass.internal_static_opencannabis_geo_Address_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.geo.AddressOuterClass.internal_static_opencannabis_geo_Address_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.geo.Address.class, io.opencannabis.schema.geo.Address.Builder.class);
    }

    // Construct using io.opencannabis.schema.geo.Address.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      firstLine_ = "";

      secondLine_ = "";

      city_ = "";

      state_ = "";

      zipcode_ = "";

      country_ = "";

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.geo.AddressOuterClass.internal_static_opencannabis_geo_Address_descriptor;
    }

    public io.opencannabis.schema.geo.Address getDefaultInstanceForType() {
      return io.opencannabis.schema.geo.Address.getDefaultInstance();
    }

    public io.opencannabis.schema.geo.Address build() {
      io.opencannabis.schema.geo.Address result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.geo.Address buildPartial() {
      io.opencannabis.schema.geo.Address result = new io.opencannabis.schema.geo.Address(this);
      result.firstLine_ = firstLine_;
      result.secondLine_ = secondLine_;
      result.city_ = city_;
      result.state_ = state_;
      result.zipcode_ = zipcode_;
      result.country_ = country_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.geo.Address) {
        return mergeFrom((io.opencannabis.schema.geo.Address)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.geo.Address other) {
      if (other == io.opencannabis.schema.geo.Address.getDefaultInstance()) return this;
      if (!other.getFirstLine().isEmpty()) {
        firstLine_ = other.firstLine_;
        onChanged();
      }
      if (!other.getSecondLine().isEmpty()) {
        secondLine_ = other.secondLine_;
        onChanged();
      }
      if (!other.getCity().isEmpty()) {
        city_ = other.city_;
        onChanged();
      }
      if (!other.getState().isEmpty()) {
        state_ = other.state_;
        onChanged();
      }
      if (!other.getZipcode().isEmpty()) {
        zipcode_ = other.zipcode_;
        onChanged();
      }
      if (!other.getCountry().isEmpty()) {
        country_ = other.country_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.geo.Address parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.geo.Address) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object firstLine_ = "";
    /**
     * <pre>
     * First line of the address.
     * </pre>
     *
     * <code>string first_line = 1 [(.gen_bq_schema.description) = "First line of the address."];</code>
     */
    public java.lang.String getFirstLine() {
      java.lang.Object ref = firstLine_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        firstLine_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * First line of the address.
     * </pre>
     *
     * <code>string first_line = 1 [(.gen_bq_schema.description) = "First line of the address."];</code>
     */
    public com.google.protobuf.ByteString
        getFirstLineBytes() {
      java.lang.Object ref = firstLine_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        firstLine_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * First line of the address.
     * </pre>
     *
     * <code>string first_line = 1 [(.gen_bq_schema.description) = "First line of the address."];</code>
     */
    public Builder setFirstLine(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      firstLine_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * First line of the address.
     * </pre>
     *
     * <code>string first_line = 1 [(.gen_bq_schema.description) = "First line of the address."];</code>
     */
    public Builder clearFirstLine() {
      
      firstLine_ = getDefaultInstance().getFirstLine();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * First line of the address.
     * </pre>
     *
     * <code>string first_line = 1 [(.gen_bq_schema.description) = "First line of the address."];</code>
     */
    public Builder setFirstLineBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      firstLine_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object secondLine_ = "";
    /**
     * <pre>
     * Second line of the address, if applicable.
     * </pre>
     *
     * <code>string second_line = 2 [(.gen_bq_schema.description) = "Second line of the address, if applicable."];</code>
     */
    public java.lang.String getSecondLine() {
      java.lang.Object ref = secondLine_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        secondLine_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Second line of the address, if applicable.
     * </pre>
     *
     * <code>string second_line = 2 [(.gen_bq_schema.description) = "Second line of the address, if applicable."];</code>
     */
    public com.google.protobuf.ByteString
        getSecondLineBytes() {
      java.lang.Object ref = secondLine_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        secondLine_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Second line of the address, if applicable.
     * </pre>
     *
     * <code>string second_line = 2 [(.gen_bq_schema.description) = "Second line of the address, if applicable."];</code>
     */
    public Builder setSecondLine(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      secondLine_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Second line of the address, if applicable.
     * </pre>
     *
     * <code>string second_line = 2 [(.gen_bq_schema.description) = "Second line of the address, if applicable."];</code>
     */
    public Builder clearSecondLine() {
      
      secondLine_ = getDefaultInstance().getSecondLine();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Second line of the address, if applicable.
     * </pre>
     *
     * <code>string second_line = 2 [(.gen_bq_schema.description) = "Second line of the address, if applicable."];</code>
     */
    public Builder setSecondLineBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      secondLine_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object city_ = "";
    /**
     * <pre>
     * City or municipality name for the address.
     * </pre>
     *
     * <code>string city = 3 [(.gen_bq_schema.description) = "City or municipality name for the address."];</code>
     */
    public java.lang.String getCity() {
      java.lang.Object ref = city_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        city_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * City or municipality name for the address.
     * </pre>
     *
     * <code>string city = 3 [(.gen_bq_schema.description) = "City or municipality name for the address."];</code>
     */
    public com.google.protobuf.ByteString
        getCityBytes() {
      java.lang.Object ref = city_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        city_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * City or municipality name for the address.
     * </pre>
     *
     * <code>string city = 3 [(.gen_bq_schema.description) = "City or municipality name for the address."];</code>
     */
    public Builder setCity(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      city_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * City or municipality name for the address.
     * </pre>
     *
     * <code>string city = 3 [(.gen_bq_schema.description) = "City or municipality name for the address."];</code>
     */
    public Builder clearCity() {
      
      city_ = getDefaultInstance().getCity();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * City or municipality name for the address.
     * </pre>
     *
     * <code>string city = 3 [(.gen_bq_schema.description) = "City or municipality name for the address."];</code>
     */
    public Builder setCityBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      city_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object state_ = "";
    /**
     * <pre>
     * State that contains the city or municipality for this address.
     * </pre>
     *
     * <code>string state = 4 [(.gen_bq_schema.description) = "State that contains the city or municipality for this address."];</code>
     */
    public java.lang.String getState() {
      java.lang.Object ref = state_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        state_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * State that contains the city or municipality for this address.
     * </pre>
     *
     * <code>string state = 4 [(.gen_bq_schema.description) = "State that contains the city or municipality for this address."];</code>
     */
    public com.google.protobuf.ByteString
        getStateBytes() {
      java.lang.Object ref = state_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        state_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * State that contains the city or municipality for this address.
     * </pre>
     *
     * <code>string state = 4 [(.gen_bq_schema.description) = "State that contains the city or municipality for this address."];</code>
     */
    public Builder setState(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      state_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * State that contains the city or municipality for this address.
     * </pre>
     *
     * <code>string state = 4 [(.gen_bq_schema.description) = "State that contains the city or municipality for this address."];</code>
     */
    public Builder clearState() {
      
      state_ = getDefaultInstance().getState();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * State that contains the city or municipality for this address.
     * </pre>
     *
     * <code>string state = 4 [(.gen_bq_schema.description) = "State that contains the city or municipality for this address."];</code>
     */
    public Builder setStateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      state_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object zipcode_ = "";
    /**
     * <pre>
     * USPS zipcode associated with this address.
     * </pre>
     *
     * <code>string zipcode = 5 [(.gen_bq_schema.description) = "USPS zipcode associated with this address."];</code>
     */
    public java.lang.String getZipcode() {
      java.lang.Object ref = zipcode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zipcode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * USPS zipcode associated with this address.
     * </pre>
     *
     * <code>string zipcode = 5 [(.gen_bq_schema.description) = "USPS zipcode associated with this address."];</code>
     */
    public com.google.protobuf.ByteString
        getZipcodeBytes() {
      java.lang.Object ref = zipcode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        zipcode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * USPS zipcode associated with this address.
     * </pre>
     *
     * <code>string zipcode = 5 [(.gen_bq_schema.description) = "USPS zipcode associated with this address."];</code>
     */
    public Builder setZipcode(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      zipcode_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * USPS zipcode associated with this address.
     * </pre>
     *
     * <code>string zipcode = 5 [(.gen_bq_schema.description) = "USPS zipcode associated with this address."];</code>
     */
    public Builder clearZipcode() {
      
      zipcode_ = getDefaultInstance().getZipcode();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * USPS zipcode associated with this address.
     * </pre>
     *
     * <code>string zipcode = 5 [(.gen_bq_schema.description) = "USPS zipcode associated with this address."];</code>
     */
    public Builder setZipcodeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      zipcode_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object country_ = "";
    /**
     * <pre>
     * Country code associated with this address ('US' or 'USA' for United States, for instance).
     * </pre>
     *
     * <code>string country = 6 [(.gen_bq_schema.description) = "Country code associated with this address (&#92;'US&#92;' or &#92;'USA&#92;' for United States, for instance)."];</code>
     */
    public java.lang.String getCountry() {
      java.lang.Object ref = country_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        country_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Country code associated with this address ('US' or 'USA' for United States, for instance).
     * </pre>
     *
     * <code>string country = 6 [(.gen_bq_schema.description) = "Country code associated with this address (&#92;'US&#92;' or &#92;'USA&#92;' for United States, for instance)."];</code>
     */
    public com.google.protobuf.ByteString
        getCountryBytes() {
      java.lang.Object ref = country_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        country_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Country code associated with this address ('US' or 'USA' for United States, for instance).
     * </pre>
     *
     * <code>string country = 6 [(.gen_bq_schema.description) = "Country code associated with this address (&#92;'US&#92;' or &#92;'USA&#92;' for United States, for instance)."];</code>
     */
    public Builder setCountry(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      country_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Country code associated with this address ('US' or 'USA' for United States, for instance).
     * </pre>
     *
     * <code>string country = 6 [(.gen_bq_schema.description) = "Country code associated with this address (&#92;'US&#92;' or &#92;'USA&#92;' for United States, for instance)."];</code>
     */
    public Builder clearCountry() {
      
      country_ = getDefaultInstance().getCountry();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Country code associated with this address ('US' or 'USA' for United States, for instance).
     * </pre>
     *
     * <code>string country = 6 [(.gen_bq_schema.description) = "Country code associated with this address (&#92;'US&#92;' or &#92;'USA&#92;' for United States, for instance)."];</code>
     */
    public Builder setCountryBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      country_ = value;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.geo.Address)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.geo.Address)
  private static final io.opencannabis.schema.geo.Address DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.geo.Address();
  }

  public static io.opencannabis.schema.geo.Address getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Address>
      PARSER = new com.google.protobuf.AbstractParser<Address>() {
    public Address parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Address(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Address> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Address> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.geo.Address getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

