/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: geo/Location.proto

package io.opencannabis.schema.geo;

/**
 * <pre>
 * Specifies a distance between two locations.
 * </pre>
 *
 * Protobuf type {@code opencannabis.geo.Distance}
 */
public  final class Distance extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.geo.Distance)
    DistanceOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Distance.newBuilder() to construct.
  private Distance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Distance() {
    estimate_ = false;
    unit_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Distance(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {

            estimate_ = input.readBool();
            break;
          }
          case 18: {
            io.opencannabis.schema.geo.LocationAccuracy.Builder subBuilder = null;
            if (accuracy_ != null) {
              subBuilder = accuracy_.toBuilder();
            }
            accuracy_ = input.readMessage(io.opencannabis.schema.geo.LocationAccuracy.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(accuracy_);
              accuracy_ = subBuilder.buildPartial();
            }

            break;
          }
          case 24: {
            int rawValue = input.readEnum();

            unit_ = rawValue;
            break;
          }
          case 34: {
            io.opencannabis.schema.geo.Location.Builder subBuilder = null;
            if (start_ != null) {
              subBuilder = start_.toBuilder();
            }
            start_ = input.readMessage(io.opencannabis.schema.geo.Location.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(start_);
              start_ = subBuilder.buildPartial();
            }

            break;
          }
          case 42: {
            io.opencannabis.schema.geo.Location.Builder subBuilder = null;
            if (end_ != null) {
              subBuilder = end_.toBuilder();
            }
            end_ = input.readMessage(io.opencannabis.schema.geo.Location.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(end_);
              end_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.geo.LocationOuterClass.internal_static_opencannabis_geo_Distance_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.geo.LocationOuterClass.internal_static_opencannabis_geo_Distance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.geo.Distance.class, io.opencannabis.schema.geo.Distance.Builder.class);
  }

  public static final int ESTIMATE_FIELD_NUMBER = 1;
  private boolean estimate_;
  /**
   * <pre>
   * Specifies whether this distance is an estimate.
   * </pre>
   *
   * <code>bool estimate = 1 [(.gen_bq_schema.description) = "Specifies whether this distance is an estimate."];</code>
   */
  public boolean getEstimate() {
    return estimate_;
  }

  public static final int ACCURACY_FIELD_NUMBER = 2;
  private io.opencannabis.schema.geo.LocationAccuracy accuracy_;
  /**
   * <pre>
   * Specifies the accuracy estimate for the distance values, if known.
   * </pre>
   *
   * <code>.opencannabis.geo.LocationAccuracy accuracy = 2 [(.gen_bq_schema.description) = "Specifies the accuracy estimate for the distance values, if known."];</code>
   */
  public boolean hasAccuracy() {
    return accuracy_ != null;
  }
  /**
   * <pre>
   * Specifies the accuracy estimate for the distance values, if known.
   * </pre>
   *
   * <code>.opencannabis.geo.LocationAccuracy accuracy = 2 [(.gen_bq_schema.description) = "Specifies the accuracy estimate for the distance values, if known."];</code>
   */
  public io.opencannabis.schema.geo.LocationAccuracy getAccuracy() {
    return accuracy_ == null ? io.opencannabis.schema.geo.LocationAccuracy.getDefaultInstance() : accuracy_;
  }
  /**
   * <pre>
   * Specifies the accuracy estimate for the distance values, if known.
   * </pre>
   *
   * <code>.opencannabis.geo.LocationAccuracy accuracy = 2 [(.gen_bq_schema.description) = "Specifies the accuracy estimate for the distance values, if known."];</code>
   */
  public io.opencannabis.schema.geo.LocationAccuracyOrBuilder getAccuracyOrBuilder() {
    return getAccuracy();
  }

  public static final int UNIT_FIELD_NUMBER = 3;
  private int unit_;
  /**
   * <pre>
   * Specifies the unit of measurement for a location accuracy estimate.
   * </pre>
   *
   * <code>.opencannabis.geo.DistanceUnit unit = 3 [(.gen_bq_schema.description) = "Specifies whether this distance is an estimate."];</code>
   */
  public int getUnitValue() {
    return unit_;
  }
  /**
   * <pre>
   * Specifies the unit of measurement for a location accuracy estimate.
   * </pre>
   *
   * <code>.opencannabis.geo.DistanceUnit unit = 3 [(.gen_bq_schema.description) = "Specifies whether this distance is an estimate."];</code>
   */
  public io.opencannabis.schema.geo.DistanceUnit getUnit() {
    io.opencannabis.schema.geo.DistanceUnit result = io.opencannabis.schema.geo.DistanceUnit.valueOf(unit_);
    return result == null ? io.opencannabis.schema.geo.DistanceUnit.UNRECOGNIZED : result;
  }

  public static final int START_FIELD_NUMBER = 4;
  private io.opencannabis.schema.geo.Location start_;
  /**
   * <pre>
   * Specifies the starting location for a distance span.
   * </pre>
   *
   * <code>.opencannabis.geo.Location start = 4 [(.gen_bq_schema.description) = "Specifies the starting location for a distance span."];</code>
   */
  public boolean hasStart() {
    return start_ != null;
  }
  /**
   * <pre>
   * Specifies the starting location for a distance span.
   * </pre>
   *
   * <code>.opencannabis.geo.Location start = 4 [(.gen_bq_schema.description) = "Specifies the starting location for a distance span."];</code>
   */
  public io.opencannabis.schema.geo.Location getStart() {
    return start_ == null ? io.opencannabis.schema.geo.Location.getDefaultInstance() : start_;
  }
  /**
   * <pre>
   * Specifies the starting location for a distance span.
   * </pre>
   *
   * <code>.opencannabis.geo.Location start = 4 [(.gen_bq_schema.description) = "Specifies the starting location for a distance span."];</code>
   */
  public io.opencannabis.schema.geo.LocationOrBuilder getStartOrBuilder() {
    return getStart();
  }

  public static final int END_FIELD_NUMBER = 5;
  private io.opencannabis.schema.geo.Location end_;
  /**
   * <pre>
   * Specifies the terminating location for a distance span.
   * </pre>
   *
   * <code>.opencannabis.geo.Location end = 5 [(.gen_bq_schema.description) = "Specifies the terminating location for a distance span."];</code>
   */
  public boolean hasEnd() {
    return end_ != null;
  }
  /**
   * <pre>
   * Specifies the terminating location for a distance span.
   * </pre>
   *
   * <code>.opencannabis.geo.Location end = 5 [(.gen_bq_schema.description) = "Specifies the terminating location for a distance span."];</code>
   */
  public io.opencannabis.schema.geo.Location getEnd() {
    return end_ == null ? io.opencannabis.schema.geo.Location.getDefaultInstance() : end_;
  }
  /**
   * <pre>
   * Specifies the terminating location for a distance span.
   * </pre>
   *
   * <code>.opencannabis.geo.Location end = 5 [(.gen_bq_schema.description) = "Specifies the terminating location for a distance span."];</code>
   */
  public io.opencannabis.schema.geo.LocationOrBuilder getEndOrBuilder() {
    return getEnd();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (estimate_ != false) {
      output.writeBool(1, estimate_);
    }
    if (accuracy_ != null) {
      output.writeMessage(2, getAccuracy());
    }
    if (unit_ != io.opencannabis.schema.geo.DistanceUnit.METERS.getNumber()) {
      output.writeEnum(3, unit_);
    }
    if (start_ != null) {
      output.writeMessage(4, getStart());
    }
    if (end_ != null) {
      output.writeMessage(5, getEnd());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (estimate_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(1, estimate_);
    }
    if (accuracy_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getAccuracy());
    }
    if (unit_ != io.opencannabis.schema.geo.DistanceUnit.METERS.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, unit_);
    }
    if (start_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getStart());
    }
    if (end_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getEnd());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.geo.Distance)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.geo.Distance other = (io.opencannabis.schema.geo.Distance) obj;

    boolean result = true;
    result = result && (getEstimate()
        == other.getEstimate());
    result = result && (hasAccuracy() == other.hasAccuracy());
    if (hasAccuracy()) {
      result = result && getAccuracy()
          .equals(other.getAccuracy());
    }
    result = result && unit_ == other.unit_;
    result = result && (hasStart() == other.hasStart());
    if (hasStart()) {
      result = result && getStart()
          .equals(other.getStart());
    }
    result = result && (hasEnd() == other.hasEnd());
    if (hasEnd()) {
      result = result && getEnd()
          .equals(other.getEnd());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ESTIMATE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getEstimate());
    if (hasAccuracy()) {
      hash = (37 * hash) + ACCURACY_FIELD_NUMBER;
      hash = (53 * hash) + getAccuracy().hashCode();
    }
    hash = (37 * hash) + UNIT_FIELD_NUMBER;
    hash = (53 * hash) + unit_;
    if (hasStart()) {
      hash = (37 * hash) + START_FIELD_NUMBER;
      hash = (53 * hash) + getStart().hashCode();
    }
    if (hasEnd()) {
      hash = (37 * hash) + END_FIELD_NUMBER;
      hash = (53 * hash) + getEnd().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.geo.Distance parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.geo.Distance parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Distance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.geo.Distance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Distance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.geo.Distance parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Distance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.geo.Distance parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Distance parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.geo.Distance parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Distance parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.geo.Distance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.geo.Distance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a distance between two locations.
   * </pre>
   *
   * Protobuf type {@code opencannabis.geo.Distance}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.geo.Distance)
      io.opencannabis.schema.geo.DistanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.geo.LocationOuterClass.internal_static_opencannabis_geo_Distance_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.geo.LocationOuterClass.internal_static_opencannabis_geo_Distance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.geo.Distance.class, io.opencannabis.schema.geo.Distance.Builder.class);
    }

    // Construct using io.opencannabis.schema.geo.Distance.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      estimate_ = false;

      if (accuracyBuilder_ == null) {
        accuracy_ = null;
      } else {
        accuracy_ = null;
        accuracyBuilder_ = null;
      }
      unit_ = 0;

      if (startBuilder_ == null) {
        start_ = null;
      } else {
        start_ = null;
        startBuilder_ = null;
      }
      if (endBuilder_ == null) {
        end_ = null;
      } else {
        end_ = null;
        endBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.geo.LocationOuterClass.internal_static_opencannabis_geo_Distance_descriptor;
    }

    public io.opencannabis.schema.geo.Distance getDefaultInstanceForType() {
      return io.opencannabis.schema.geo.Distance.getDefaultInstance();
    }

    public io.opencannabis.schema.geo.Distance build() {
      io.opencannabis.schema.geo.Distance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.geo.Distance buildPartial() {
      io.opencannabis.schema.geo.Distance result = new io.opencannabis.schema.geo.Distance(this);
      result.estimate_ = estimate_;
      if (accuracyBuilder_ == null) {
        result.accuracy_ = accuracy_;
      } else {
        result.accuracy_ = accuracyBuilder_.build();
      }
      result.unit_ = unit_;
      if (startBuilder_ == null) {
        result.start_ = start_;
      } else {
        result.start_ = startBuilder_.build();
      }
      if (endBuilder_ == null) {
        result.end_ = end_;
      } else {
        result.end_ = endBuilder_.build();
      }
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.geo.Distance) {
        return mergeFrom((io.opencannabis.schema.geo.Distance)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.geo.Distance other) {
      if (other == io.opencannabis.schema.geo.Distance.getDefaultInstance()) return this;
      if (other.getEstimate() != false) {
        setEstimate(other.getEstimate());
      }
      if (other.hasAccuracy()) {
        mergeAccuracy(other.getAccuracy());
      }
      if (other.unit_ != 0) {
        setUnitValue(other.getUnitValue());
      }
      if (other.hasStart()) {
        mergeStart(other.getStart());
      }
      if (other.hasEnd()) {
        mergeEnd(other.getEnd());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.geo.Distance parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.geo.Distance) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private boolean estimate_ ;
    /**
     * <pre>
     * Specifies whether this distance is an estimate.
     * </pre>
     *
     * <code>bool estimate = 1 [(.gen_bq_schema.description) = "Specifies whether this distance is an estimate."];</code>
     */
    public boolean getEstimate() {
      return estimate_;
    }
    /**
     * <pre>
     * Specifies whether this distance is an estimate.
     * </pre>
     *
     * <code>bool estimate = 1 [(.gen_bq_schema.description) = "Specifies whether this distance is an estimate."];</code>
     */
    public Builder setEstimate(boolean value) {
      
      estimate_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies whether this distance is an estimate.
     * </pre>
     *
     * <code>bool estimate = 1 [(.gen_bq_schema.description) = "Specifies whether this distance is an estimate."];</code>
     */
    public Builder clearEstimate() {
      
      estimate_ = false;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.geo.LocationAccuracy accuracy_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.LocationAccuracy, io.opencannabis.schema.geo.LocationAccuracy.Builder, io.opencannabis.schema.geo.LocationAccuracyOrBuilder> accuracyBuilder_;
    /**
     * <pre>
     * Specifies the accuracy estimate for the distance values, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 2 [(.gen_bq_schema.description) = "Specifies the accuracy estimate for the distance values, if known."];</code>
     */
    public boolean hasAccuracy() {
      return accuracyBuilder_ != null || accuracy_ != null;
    }
    /**
     * <pre>
     * Specifies the accuracy estimate for the distance values, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 2 [(.gen_bq_schema.description) = "Specifies the accuracy estimate for the distance values, if known."];</code>
     */
    public io.opencannabis.schema.geo.LocationAccuracy getAccuracy() {
      if (accuracyBuilder_ == null) {
        return accuracy_ == null ? io.opencannabis.schema.geo.LocationAccuracy.getDefaultInstance() : accuracy_;
      } else {
        return accuracyBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies the accuracy estimate for the distance values, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 2 [(.gen_bq_schema.description) = "Specifies the accuracy estimate for the distance values, if known."];</code>
     */
    public Builder setAccuracy(io.opencannabis.schema.geo.LocationAccuracy value) {
      if (accuracyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accuracy_ = value;
        onChanged();
      } else {
        accuracyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the accuracy estimate for the distance values, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 2 [(.gen_bq_schema.description) = "Specifies the accuracy estimate for the distance values, if known."];</code>
     */
    public Builder setAccuracy(
        io.opencannabis.schema.geo.LocationAccuracy.Builder builderForValue) {
      if (accuracyBuilder_ == null) {
        accuracy_ = builderForValue.build();
        onChanged();
      } else {
        accuracyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the accuracy estimate for the distance values, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 2 [(.gen_bq_schema.description) = "Specifies the accuracy estimate for the distance values, if known."];</code>
     */
    public Builder mergeAccuracy(io.opencannabis.schema.geo.LocationAccuracy value) {
      if (accuracyBuilder_ == null) {
        if (accuracy_ != null) {
          accuracy_ =
            io.opencannabis.schema.geo.LocationAccuracy.newBuilder(accuracy_).mergeFrom(value).buildPartial();
        } else {
          accuracy_ = value;
        }
        onChanged();
      } else {
        accuracyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the accuracy estimate for the distance values, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 2 [(.gen_bq_schema.description) = "Specifies the accuracy estimate for the distance values, if known."];</code>
     */
    public Builder clearAccuracy() {
      if (accuracyBuilder_ == null) {
        accuracy_ = null;
        onChanged();
      } else {
        accuracy_ = null;
        accuracyBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the accuracy estimate for the distance values, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 2 [(.gen_bq_schema.description) = "Specifies the accuracy estimate for the distance values, if known."];</code>
     */
    public io.opencannabis.schema.geo.LocationAccuracy.Builder getAccuracyBuilder() {
      
      onChanged();
      return getAccuracyFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies the accuracy estimate for the distance values, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 2 [(.gen_bq_schema.description) = "Specifies the accuracy estimate for the distance values, if known."];</code>
     */
    public io.opencannabis.schema.geo.LocationAccuracyOrBuilder getAccuracyOrBuilder() {
      if (accuracyBuilder_ != null) {
        return accuracyBuilder_.getMessageOrBuilder();
      } else {
        return accuracy_ == null ?
            io.opencannabis.schema.geo.LocationAccuracy.getDefaultInstance() : accuracy_;
      }
    }
    /**
     * <pre>
     * Specifies the accuracy estimate for the distance values, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 2 [(.gen_bq_schema.description) = "Specifies the accuracy estimate for the distance values, if known."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.LocationAccuracy, io.opencannabis.schema.geo.LocationAccuracy.Builder, io.opencannabis.schema.geo.LocationAccuracyOrBuilder> 
        getAccuracyFieldBuilder() {
      if (accuracyBuilder_ == null) {
        accuracyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.geo.LocationAccuracy, io.opencannabis.schema.geo.LocationAccuracy.Builder, io.opencannabis.schema.geo.LocationAccuracyOrBuilder>(
                getAccuracy(),
                getParentForChildren(),
                isClean());
        accuracy_ = null;
      }
      return accuracyBuilder_;
    }

    private int unit_ = 0;
    /**
     * <pre>
     * Specifies the unit of measurement for a location accuracy estimate.
     * </pre>
     *
     * <code>.opencannabis.geo.DistanceUnit unit = 3 [(.gen_bq_schema.description) = "Specifies whether this distance is an estimate."];</code>
     */
    public int getUnitValue() {
      return unit_;
    }
    /**
     * <pre>
     * Specifies the unit of measurement for a location accuracy estimate.
     * </pre>
     *
     * <code>.opencannabis.geo.DistanceUnit unit = 3 [(.gen_bq_schema.description) = "Specifies whether this distance is an estimate."];</code>
     */
    public Builder setUnitValue(int value) {
      unit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the unit of measurement for a location accuracy estimate.
     * </pre>
     *
     * <code>.opencannabis.geo.DistanceUnit unit = 3 [(.gen_bq_schema.description) = "Specifies whether this distance is an estimate."];</code>
     */
    public io.opencannabis.schema.geo.DistanceUnit getUnit() {
      io.opencannabis.schema.geo.DistanceUnit result = io.opencannabis.schema.geo.DistanceUnit.valueOf(unit_);
      return result == null ? io.opencannabis.schema.geo.DistanceUnit.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies the unit of measurement for a location accuracy estimate.
     * </pre>
     *
     * <code>.opencannabis.geo.DistanceUnit unit = 3 [(.gen_bq_schema.description) = "Specifies whether this distance is an estimate."];</code>
     */
    public Builder setUnit(io.opencannabis.schema.geo.DistanceUnit value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      unit_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the unit of measurement for a location accuracy estimate.
     * </pre>
     *
     * <code>.opencannabis.geo.DistanceUnit unit = 3 [(.gen_bq_schema.description) = "Specifies whether this distance is an estimate."];</code>
     */
    public Builder clearUnit() {
      
      unit_ = 0;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.geo.Location start_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.Location, io.opencannabis.schema.geo.Location.Builder, io.opencannabis.schema.geo.LocationOrBuilder> startBuilder_;
    /**
     * <pre>
     * Specifies the starting location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location start = 4 [(.gen_bq_schema.description) = "Specifies the starting location for a distance span."];</code>
     */
    public boolean hasStart() {
      return startBuilder_ != null || start_ != null;
    }
    /**
     * <pre>
     * Specifies the starting location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location start = 4 [(.gen_bq_schema.description) = "Specifies the starting location for a distance span."];</code>
     */
    public io.opencannabis.schema.geo.Location getStart() {
      if (startBuilder_ == null) {
        return start_ == null ? io.opencannabis.schema.geo.Location.getDefaultInstance() : start_;
      } else {
        return startBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies the starting location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location start = 4 [(.gen_bq_schema.description) = "Specifies the starting location for a distance span."];</code>
     */
    public Builder setStart(io.opencannabis.schema.geo.Location value) {
      if (startBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        start_ = value;
        onChanged();
      } else {
        startBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the starting location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location start = 4 [(.gen_bq_schema.description) = "Specifies the starting location for a distance span."];</code>
     */
    public Builder setStart(
        io.opencannabis.schema.geo.Location.Builder builderForValue) {
      if (startBuilder_ == null) {
        start_ = builderForValue.build();
        onChanged();
      } else {
        startBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the starting location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location start = 4 [(.gen_bq_schema.description) = "Specifies the starting location for a distance span."];</code>
     */
    public Builder mergeStart(io.opencannabis.schema.geo.Location value) {
      if (startBuilder_ == null) {
        if (start_ != null) {
          start_ =
            io.opencannabis.schema.geo.Location.newBuilder(start_).mergeFrom(value).buildPartial();
        } else {
          start_ = value;
        }
        onChanged();
      } else {
        startBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the starting location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location start = 4 [(.gen_bq_schema.description) = "Specifies the starting location for a distance span."];</code>
     */
    public Builder clearStart() {
      if (startBuilder_ == null) {
        start_ = null;
        onChanged();
      } else {
        start_ = null;
        startBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the starting location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location start = 4 [(.gen_bq_schema.description) = "Specifies the starting location for a distance span."];</code>
     */
    public io.opencannabis.schema.geo.Location.Builder getStartBuilder() {
      
      onChanged();
      return getStartFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies the starting location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location start = 4 [(.gen_bq_schema.description) = "Specifies the starting location for a distance span."];</code>
     */
    public io.opencannabis.schema.geo.LocationOrBuilder getStartOrBuilder() {
      if (startBuilder_ != null) {
        return startBuilder_.getMessageOrBuilder();
      } else {
        return start_ == null ?
            io.opencannabis.schema.geo.Location.getDefaultInstance() : start_;
      }
    }
    /**
     * <pre>
     * Specifies the starting location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location start = 4 [(.gen_bq_schema.description) = "Specifies the starting location for a distance span."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.Location, io.opencannabis.schema.geo.Location.Builder, io.opencannabis.schema.geo.LocationOrBuilder> 
        getStartFieldBuilder() {
      if (startBuilder_ == null) {
        startBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.geo.Location, io.opencannabis.schema.geo.Location.Builder, io.opencannabis.schema.geo.LocationOrBuilder>(
                getStart(),
                getParentForChildren(),
                isClean());
        start_ = null;
      }
      return startBuilder_;
    }

    private io.opencannabis.schema.geo.Location end_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.Location, io.opencannabis.schema.geo.Location.Builder, io.opencannabis.schema.geo.LocationOrBuilder> endBuilder_;
    /**
     * <pre>
     * Specifies the terminating location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location end = 5 [(.gen_bq_schema.description) = "Specifies the terminating location for a distance span."];</code>
     */
    public boolean hasEnd() {
      return endBuilder_ != null || end_ != null;
    }
    /**
     * <pre>
     * Specifies the terminating location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location end = 5 [(.gen_bq_schema.description) = "Specifies the terminating location for a distance span."];</code>
     */
    public io.opencannabis.schema.geo.Location getEnd() {
      if (endBuilder_ == null) {
        return end_ == null ? io.opencannabis.schema.geo.Location.getDefaultInstance() : end_;
      } else {
        return endBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies the terminating location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location end = 5 [(.gen_bq_schema.description) = "Specifies the terminating location for a distance span."];</code>
     */
    public Builder setEnd(io.opencannabis.schema.geo.Location value) {
      if (endBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        end_ = value;
        onChanged();
      } else {
        endBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the terminating location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location end = 5 [(.gen_bq_schema.description) = "Specifies the terminating location for a distance span."];</code>
     */
    public Builder setEnd(
        io.opencannabis.schema.geo.Location.Builder builderForValue) {
      if (endBuilder_ == null) {
        end_ = builderForValue.build();
        onChanged();
      } else {
        endBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the terminating location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location end = 5 [(.gen_bq_schema.description) = "Specifies the terminating location for a distance span."];</code>
     */
    public Builder mergeEnd(io.opencannabis.schema.geo.Location value) {
      if (endBuilder_ == null) {
        if (end_ != null) {
          end_ =
            io.opencannabis.schema.geo.Location.newBuilder(end_).mergeFrom(value).buildPartial();
        } else {
          end_ = value;
        }
        onChanged();
      } else {
        endBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the terminating location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location end = 5 [(.gen_bq_schema.description) = "Specifies the terminating location for a distance span."];</code>
     */
    public Builder clearEnd() {
      if (endBuilder_ == null) {
        end_ = null;
        onChanged();
      } else {
        end_ = null;
        endBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the terminating location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location end = 5 [(.gen_bq_schema.description) = "Specifies the terminating location for a distance span."];</code>
     */
    public io.opencannabis.schema.geo.Location.Builder getEndBuilder() {
      
      onChanged();
      return getEndFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies the terminating location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location end = 5 [(.gen_bq_schema.description) = "Specifies the terminating location for a distance span."];</code>
     */
    public io.opencannabis.schema.geo.LocationOrBuilder getEndOrBuilder() {
      if (endBuilder_ != null) {
        return endBuilder_.getMessageOrBuilder();
      } else {
        return end_ == null ?
            io.opencannabis.schema.geo.Location.getDefaultInstance() : end_;
      }
    }
    /**
     * <pre>
     * Specifies the terminating location for a distance span.
     * </pre>
     *
     * <code>.opencannabis.geo.Location end = 5 [(.gen_bq_schema.description) = "Specifies the terminating location for a distance span."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.Location, io.opencannabis.schema.geo.Location.Builder, io.opencannabis.schema.geo.LocationOrBuilder> 
        getEndFieldBuilder() {
      if (endBuilder_ == null) {
        endBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.geo.Location, io.opencannabis.schema.geo.Location.Builder, io.opencannabis.schema.geo.LocationOrBuilder>(
                getEnd(),
                getParentForChildren(),
                isClean());
        end_ = null;
      }
      return endBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.geo.Distance)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.geo.Distance)
  private static final io.opencannabis.schema.geo.Distance DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.geo.Distance();
  }

  public static io.opencannabis.schema.geo.Distance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Distance>
      PARSER = new com.google.protobuf.AbstractParser<Distance>() {
    public Distance parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Distance(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Distance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Distance> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.geo.Distance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

