/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: geo/Location.proto

package io.opencannabis.schema.geo;

/**
 * <pre>
 * Represents a physically addressable location in the real world.
 * </pre>
 *
 * Protobuf type {@code opencannabis.geo.Location}
 */
public  final class Location extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.geo.Location)
    LocationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Location.newBuilder() to construct.
  private Location(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Location() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Location(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            io.opencannabis.schema.content.Name.Builder subBuilder = null;
            if (name_ != null) {
              subBuilder = name_.toBuilder();
            }
            name_ = input.readMessage(io.opencannabis.schema.content.Name.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(name_);
              name_ = subBuilder.buildPartial();
            }

            break;
          }
          case 18: {
            io.opencannabis.schema.geo.Address.Builder subBuilder = null;
            if (address_ != null) {
              subBuilder = address_.toBuilder();
            }
            address_ = input.readMessage(io.opencannabis.schema.geo.Address.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(address_);
              address_ = subBuilder.buildPartial();
            }

            break;
          }
          case 26: {
            io.opencannabis.schema.geo.Point.Builder subBuilder = null;
            if (point_ != null) {
              subBuilder = point_.toBuilder();
            }
            point_ = input.readMessage(io.opencannabis.schema.geo.Point.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(point_);
              point_ = subBuilder.buildPartial();
            }

            break;
          }
          case 34: {
            io.opencannabis.schema.geo.LocationAccuracy.Builder subBuilder = null;
            if (accuracy_ != null) {
              subBuilder = accuracy_.toBuilder();
            }
            accuracy_ = input.readMessage(io.opencannabis.schema.geo.LocationAccuracy.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(accuracy_);
              accuracy_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.geo.LocationOuterClass.internal_static_opencannabis_geo_Location_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.geo.LocationOuterClass.internal_static_opencannabis_geo_Location_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.geo.Location.class, io.opencannabis.schema.geo.Location.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private io.opencannabis.schema.content.Name name_;
  /**
   * <pre>
   * Name for this location, if applicable.
   * </pre>
   *
   * <code>.opencannabis.content.Name name = 1 [(.gen_bq_schema.description) = "Name for this location, if applicable."];</code>
   */
  public boolean hasName() {
    return name_ != null;
  }
  /**
   * <pre>
   * Name for this location, if applicable.
   * </pre>
   *
   * <code>.opencannabis.content.Name name = 1 [(.gen_bq_schema.description) = "Name for this location, if applicable."];</code>
   */
  public io.opencannabis.schema.content.Name getName() {
    return name_ == null ? io.opencannabis.schema.content.Name.getDefaultInstance() : name_;
  }
  /**
   * <pre>
   * Name for this location, if applicable.
   * </pre>
   *
   * <code>.opencannabis.content.Name name = 1 [(.gen_bq_schema.description) = "Name for this location, if applicable."];</code>
   */
  public io.opencannabis.schema.content.NameOrBuilder getNameOrBuilder() {
    return getName();
  }

  public static final int ADDRESS_FIELD_NUMBER = 2;
  private io.opencannabis.schema.geo.Address address_;
  /**
   * <pre>
   * Address for this location, if applicable.
   * </pre>
   *
   * <code>.opencannabis.geo.Address address = 2 [(.gen_bq_schema.description) = "Address for this location, if applicable."];</code>
   */
  public boolean hasAddress() {
    return address_ != null;
  }
  /**
   * <pre>
   * Address for this location, if applicable.
   * </pre>
   *
   * <code>.opencannabis.geo.Address address = 2 [(.gen_bq_schema.description) = "Address for this location, if applicable."];</code>
   */
  public io.opencannabis.schema.geo.Address getAddress() {
    return address_ == null ? io.opencannabis.schema.geo.Address.getDefaultInstance() : address_;
  }
  /**
   * <pre>
   * Address for this location, if applicable.
   * </pre>
   *
   * <code>.opencannabis.geo.Address address = 2 [(.gen_bq_schema.description) = "Address for this location, if applicable."];</code>
   */
  public io.opencannabis.schema.geo.AddressOrBuilder getAddressOrBuilder() {
    return getAddress();
  }

  public static final int POINT_FIELD_NUMBER = 3;
  private io.opencannabis.schema.geo.Point point_;
  /**
   * <pre>
   * Geopoint (latitude/longitude) for this location.
   * </pre>
   *
   * <code>.opencannabis.geo.Point point = 3 [(.gen_bq_schema.description) = "Geopoint (latitude/longitude) for this location."];</code>
   */
  public boolean hasPoint() {
    return point_ != null;
  }
  /**
   * <pre>
   * Geopoint (latitude/longitude) for this location.
   * </pre>
   *
   * <code>.opencannabis.geo.Point point = 3 [(.gen_bq_schema.description) = "Geopoint (latitude/longitude) for this location."];</code>
   */
  public io.opencannabis.schema.geo.Point getPoint() {
    return point_ == null ? io.opencannabis.schema.geo.Point.getDefaultInstance() : point_;
  }
  /**
   * <pre>
   * Geopoint (latitude/longitude) for this location.
   * </pre>
   *
   * <code>.opencannabis.geo.Point point = 3 [(.gen_bq_schema.description) = "Geopoint (latitude/longitude) for this location."];</code>
   */
  public io.opencannabis.schema.geo.PointOrBuilder getPointOrBuilder() {
    return getPoint();
  }

  public static final int ACCURACY_FIELD_NUMBER = 4;
  private io.opencannabis.schema.geo.LocationAccuracy accuracy_;
  /**
   * <pre>
   * Specifies the accuracy estimate, if known.
   * </pre>
   *
   * <code>.opencannabis.geo.LocationAccuracy accuracy = 4 [(.gen_bq_schema.description) = "Specifies the accuracy estimate, if known."];</code>
   */
  public boolean hasAccuracy() {
    return accuracy_ != null;
  }
  /**
   * <pre>
   * Specifies the accuracy estimate, if known.
   * </pre>
   *
   * <code>.opencannabis.geo.LocationAccuracy accuracy = 4 [(.gen_bq_schema.description) = "Specifies the accuracy estimate, if known."];</code>
   */
  public io.opencannabis.schema.geo.LocationAccuracy getAccuracy() {
    return accuracy_ == null ? io.opencannabis.schema.geo.LocationAccuracy.getDefaultInstance() : accuracy_;
  }
  /**
   * <pre>
   * Specifies the accuracy estimate, if known.
   * </pre>
   *
   * <code>.opencannabis.geo.LocationAccuracy accuracy = 4 [(.gen_bq_schema.description) = "Specifies the accuracy estimate, if known."];</code>
   */
  public io.opencannabis.schema.geo.LocationAccuracyOrBuilder getAccuracyOrBuilder() {
    return getAccuracy();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (name_ != null) {
      output.writeMessage(1, getName());
    }
    if (address_ != null) {
      output.writeMessage(2, getAddress());
    }
    if (point_ != null) {
      output.writeMessage(3, getPoint());
    }
    if (accuracy_ != null) {
      output.writeMessage(4, getAccuracy());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (name_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getName());
    }
    if (address_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getAddress());
    }
    if (point_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getPoint());
    }
    if (accuracy_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getAccuracy());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.geo.Location)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.geo.Location other = (io.opencannabis.schema.geo.Location) obj;

    boolean result = true;
    result = result && (hasName() == other.hasName());
    if (hasName()) {
      result = result && getName()
          .equals(other.getName());
    }
    result = result && (hasAddress() == other.hasAddress());
    if (hasAddress()) {
      result = result && getAddress()
          .equals(other.getAddress());
    }
    result = result && (hasPoint() == other.hasPoint());
    if (hasPoint()) {
      result = result && getPoint()
          .equals(other.getPoint());
    }
    result = result && (hasAccuracy() == other.hasAccuracy());
    if (hasAccuracy()) {
      result = result && getAccuracy()
          .equals(other.getAccuracy());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasAddress()) {
      hash = (37 * hash) + ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getAddress().hashCode();
    }
    if (hasPoint()) {
      hash = (37 * hash) + POINT_FIELD_NUMBER;
      hash = (53 * hash) + getPoint().hashCode();
    }
    if (hasAccuracy()) {
      hash = (37 * hash) + ACCURACY_FIELD_NUMBER;
      hash = (53 * hash) + getAccuracy().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.geo.Location parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.geo.Location parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Location parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.geo.Location parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Location parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.geo.Location parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Location parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.geo.Location parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Location parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.geo.Location parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Location parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.geo.Location parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.geo.Location prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents a physically addressable location in the real world.
   * </pre>
   *
   * Protobuf type {@code opencannabis.geo.Location}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.geo.Location)
      io.opencannabis.schema.geo.LocationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.geo.LocationOuterClass.internal_static_opencannabis_geo_Location_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.geo.LocationOuterClass.internal_static_opencannabis_geo_Location_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.geo.Location.class, io.opencannabis.schema.geo.Location.Builder.class);
    }

    // Construct using io.opencannabis.schema.geo.Location.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      if (nameBuilder_ == null) {
        name_ = null;
      } else {
        name_ = null;
        nameBuilder_ = null;
      }
      if (addressBuilder_ == null) {
        address_ = null;
      } else {
        address_ = null;
        addressBuilder_ = null;
      }
      if (pointBuilder_ == null) {
        point_ = null;
      } else {
        point_ = null;
        pointBuilder_ = null;
      }
      if (accuracyBuilder_ == null) {
        accuracy_ = null;
      } else {
        accuracy_ = null;
        accuracyBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.geo.LocationOuterClass.internal_static_opencannabis_geo_Location_descriptor;
    }

    public io.opencannabis.schema.geo.Location getDefaultInstanceForType() {
      return io.opencannabis.schema.geo.Location.getDefaultInstance();
    }

    public io.opencannabis.schema.geo.Location build() {
      io.opencannabis.schema.geo.Location result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.geo.Location buildPartial() {
      io.opencannabis.schema.geo.Location result = new io.opencannabis.schema.geo.Location(this);
      if (nameBuilder_ == null) {
        result.name_ = name_;
      } else {
        result.name_ = nameBuilder_.build();
      }
      if (addressBuilder_ == null) {
        result.address_ = address_;
      } else {
        result.address_ = addressBuilder_.build();
      }
      if (pointBuilder_ == null) {
        result.point_ = point_;
      } else {
        result.point_ = pointBuilder_.build();
      }
      if (accuracyBuilder_ == null) {
        result.accuracy_ = accuracy_;
      } else {
        result.accuracy_ = accuracyBuilder_.build();
      }
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.geo.Location) {
        return mergeFrom((io.opencannabis.schema.geo.Location)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.geo.Location other) {
      if (other == io.opencannabis.schema.geo.Location.getDefaultInstance()) return this;
      if (other.hasName()) {
        mergeName(other.getName());
      }
      if (other.hasAddress()) {
        mergeAddress(other.getAddress());
      }
      if (other.hasPoint()) {
        mergePoint(other.getPoint());
      }
      if (other.hasAccuracy()) {
        mergeAccuracy(other.getAccuracy());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.geo.Location parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.geo.Location) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private io.opencannabis.schema.content.Name name_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.Name, io.opencannabis.schema.content.Name.Builder, io.opencannabis.schema.content.NameOrBuilder> nameBuilder_;
    /**
     * <pre>
     * Name for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1 [(.gen_bq_schema.description) = "Name for this location, if applicable."];</code>
     */
    public boolean hasName() {
      return nameBuilder_ != null || name_ != null;
    }
    /**
     * <pre>
     * Name for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1 [(.gen_bq_schema.description) = "Name for this location, if applicable."];</code>
     */
    public io.opencannabis.schema.content.Name getName() {
      if (nameBuilder_ == null) {
        return name_ == null ? io.opencannabis.schema.content.Name.getDefaultInstance() : name_;
      } else {
        return nameBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Name for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1 [(.gen_bq_schema.description) = "Name for this location, if applicable."];</code>
     */
    public Builder setName(io.opencannabis.schema.content.Name value) {
      if (nameBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        onChanged();
      } else {
        nameBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Name for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1 [(.gen_bq_schema.description) = "Name for this location, if applicable."];</code>
     */
    public Builder setName(
        io.opencannabis.schema.content.Name.Builder builderForValue) {
      if (nameBuilder_ == null) {
        name_ = builderForValue.build();
        onChanged();
      } else {
        nameBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Name for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1 [(.gen_bq_schema.description) = "Name for this location, if applicable."];</code>
     */
    public Builder mergeName(io.opencannabis.schema.content.Name value) {
      if (nameBuilder_ == null) {
        if (name_ != null) {
          name_ =
            io.opencannabis.schema.content.Name.newBuilder(name_).mergeFrom(value).buildPartial();
        } else {
          name_ = value;
        }
        onChanged();
      } else {
        nameBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Name for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1 [(.gen_bq_schema.description) = "Name for this location, if applicable."];</code>
     */
    public Builder clearName() {
      if (nameBuilder_ == null) {
        name_ = null;
        onChanged();
      } else {
        name_ = null;
        nameBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Name for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1 [(.gen_bq_schema.description) = "Name for this location, if applicable."];</code>
     */
    public io.opencannabis.schema.content.Name.Builder getNameBuilder() {
      
      onChanged();
      return getNameFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Name for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1 [(.gen_bq_schema.description) = "Name for this location, if applicable."];</code>
     */
    public io.opencannabis.schema.content.NameOrBuilder getNameOrBuilder() {
      if (nameBuilder_ != null) {
        return nameBuilder_.getMessageOrBuilder();
      } else {
        return name_ == null ?
            io.opencannabis.schema.content.Name.getDefaultInstance() : name_;
      }
    }
    /**
     * <pre>
     * Name for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1 [(.gen_bq_schema.description) = "Name for this location, if applicable."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.Name, io.opencannabis.schema.content.Name.Builder, io.opencannabis.schema.content.NameOrBuilder> 
        getNameFieldBuilder() {
      if (nameBuilder_ == null) {
        nameBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.content.Name, io.opencannabis.schema.content.Name.Builder, io.opencannabis.schema.content.NameOrBuilder>(
                getName(),
                getParentForChildren(),
                isClean());
        name_ = null;
      }
      return nameBuilder_;
    }

    private io.opencannabis.schema.geo.Address address_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.Address, io.opencannabis.schema.geo.Address.Builder, io.opencannabis.schema.geo.AddressOrBuilder> addressBuilder_;
    /**
     * <pre>
     * Address for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.geo.Address address = 2 [(.gen_bq_schema.description) = "Address for this location, if applicable."];</code>
     */
    public boolean hasAddress() {
      return addressBuilder_ != null || address_ != null;
    }
    /**
     * <pre>
     * Address for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.geo.Address address = 2 [(.gen_bq_schema.description) = "Address for this location, if applicable."];</code>
     */
    public io.opencannabis.schema.geo.Address getAddress() {
      if (addressBuilder_ == null) {
        return address_ == null ? io.opencannabis.schema.geo.Address.getDefaultInstance() : address_;
      } else {
        return addressBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Address for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.geo.Address address = 2 [(.gen_bq_schema.description) = "Address for this location, if applicable."];</code>
     */
    public Builder setAddress(io.opencannabis.schema.geo.Address value) {
      if (addressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        address_ = value;
        onChanged();
      } else {
        addressBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Address for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.geo.Address address = 2 [(.gen_bq_schema.description) = "Address for this location, if applicable."];</code>
     */
    public Builder setAddress(
        io.opencannabis.schema.geo.Address.Builder builderForValue) {
      if (addressBuilder_ == null) {
        address_ = builderForValue.build();
        onChanged();
      } else {
        addressBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Address for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.geo.Address address = 2 [(.gen_bq_schema.description) = "Address for this location, if applicable."];</code>
     */
    public Builder mergeAddress(io.opencannabis.schema.geo.Address value) {
      if (addressBuilder_ == null) {
        if (address_ != null) {
          address_ =
            io.opencannabis.schema.geo.Address.newBuilder(address_).mergeFrom(value).buildPartial();
        } else {
          address_ = value;
        }
        onChanged();
      } else {
        addressBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Address for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.geo.Address address = 2 [(.gen_bq_schema.description) = "Address for this location, if applicable."];</code>
     */
    public Builder clearAddress() {
      if (addressBuilder_ == null) {
        address_ = null;
        onChanged();
      } else {
        address_ = null;
        addressBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Address for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.geo.Address address = 2 [(.gen_bq_schema.description) = "Address for this location, if applicable."];</code>
     */
    public io.opencannabis.schema.geo.Address.Builder getAddressBuilder() {
      
      onChanged();
      return getAddressFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Address for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.geo.Address address = 2 [(.gen_bq_schema.description) = "Address for this location, if applicable."];</code>
     */
    public io.opencannabis.schema.geo.AddressOrBuilder getAddressOrBuilder() {
      if (addressBuilder_ != null) {
        return addressBuilder_.getMessageOrBuilder();
      } else {
        return address_ == null ?
            io.opencannabis.schema.geo.Address.getDefaultInstance() : address_;
      }
    }
    /**
     * <pre>
     * Address for this location, if applicable.
     * </pre>
     *
     * <code>.opencannabis.geo.Address address = 2 [(.gen_bq_schema.description) = "Address for this location, if applicable."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.Address, io.opencannabis.schema.geo.Address.Builder, io.opencannabis.schema.geo.AddressOrBuilder> 
        getAddressFieldBuilder() {
      if (addressBuilder_ == null) {
        addressBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.geo.Address, io.opencannabis.schema.geo.Address.Builder, io.opencannabis.schema.geo.AddressOrBuilder>(
                getAddress(),
                getParentForChildren(),
                isClean());
        address_ = null;
      }
      return addressBuilder_;
    }

    private io.opencannabis.schema.geo.Point point_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.Point, io.opencannabis.schema.geo.Point.Builder, io.opencannabis.schema.geo.PointOrBuilder> pointBuilder_;
    /**
     * <pre>
     * Geopoint (latitude/longitude) for this location.
     * </pre>
     *
     * <code>.opencannabis.geo.Point point = 3 [(.gen_bq_schema.description) = "Geopoint (latitude/longitude) for this location."];</code>
     */
    public boolean hasPoint() {
      return pointBuilder_ != null || point_ != null;
    }
    /**
     * <pre>
     * Geopoint (latitude/longitude) for this location.
     * </pre>
     *
     * <code>.opencannabis.geo.Point point = 3 [(.gen_bq_schema.description) = "Geopoint (latitude/longitude) for this location."];</code>
     */
    public io.opencannabis.schema.geo.Point getPoint() {
      if (pointBuilder_ == null) {
        return point_ == null ? io.opencannabis.schema.geo.Point.getDefaultInstance() : point_;
      } else {
        return pointBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Geopoint (latitude/longitude) for this location.
     * </pre>
     *
     * <code>.opencannabis.geo.Point point = 3 [(.gen_bq_schema.description) = "Geopoint (latitude/longitude) for this location."];</code>
     */
    public Builder setPoint(io.opencannabis.schema.geo.Point value) {
      if (pointBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        point_ = value;
        onChanged();
      } else {
        pointBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Geopoint (latitude/longitude) for this location.
     * </pre>
     *
     * <code>.opencannabis.geo.Point point = 3 [(.gen_bq_schema.description) = "Geopoint (latitude/longitude) for this location."];</code>
     */
    public Builder setPoint(
        io.opencannabis.schema.geo.Point.Builder builderForValue) {
      if (pointBuilder_ == null) {
        point_ = builderForValue.build();
        onChanged();
      } else {
        pointBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Geopoint (latitude/longitude) for this location.
     * </pre>
     *
     * <code>.opencannabis.geo.Point point = 3 [(.gen_bq_schema.description) = "Geopoint (latitude/longitude) for this location."];</code>
     */
    public Builder mergePoint(io.opencannabis.schema.geo.Point value) {
      if (pointBuilder_ == null) {
        if (point_ != null) {
          point_ =
            io.opencannabis.schema.geo.Point.newBuilder(point_).mergeFrom(value).buildPartial();
        } else {
          point_ = value;
        }
        onChanged();
      } else {
        pointBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Geopoint (latitude/longitude) for this location.
     * </pre>
     *
     * <code>.opencannabis.geo.Point point = 3 [(.gen_bq_schema.description) = "Geopoint (latitude/longitude) for this location."];</code>
     */
    public Builder clearPoint() {
      if (pointBuilder_ == null) {
        point_ = null;
        onChanged();
      } else {
        point_ = null;
        pointBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Geopoint (latitude/longitude) for this location.
     * </pre>
     *
     * <code>.opencannabis.geo.Point point = 3 [(.gen_bq_schema.description) = "Geopoint (latitude/longitude) for this location."];</code>
     */
    public io.opencannabis.schema.geo.Point.Builder getPointBuilder() {
      
      onChanged();
      return getPointFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Geopoint (latitude/longitude) for this location.
     * </pre>
     *
     * <code>.opencannabis.geo.Point point = 3 [(.gen_bq_schema.description) = "Geopoint (latitude/longitude) for this location."];</code>
     */
    public io.opencannabis.schema.geo.PointOrBuilder getPointOrBuilder() {
      if (pointBuilder_ != null) {
        return pointBuilder_.getMessageOrBuilder();
      } else {
        return point_ == null ?
            io.opencannabis.schema.geo.Point.getDefaultInstance() : point_;
      }
    }
    /**
     * <pre>
     * Geopoint (latitude/longitude) for this location.
     * </pre>
     *
     * <code>.opencannabis.geo.Point point = 3 [(.gen_bq_schema.description) = "Geopoint (latitude/longitude) for this location."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.Point, io.opencannabis.schema.geo.Point.Builder, io.opencannabis.schema.geo.PointOrBuilder> 
        getPointFieldBuilder() {
      if (pointBuilder_ == null) {
        pointBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.geo.Point, io.opencannabis.schema.geo.Point.Builder, io.opencannabis.schema.geo.PointOrBuilder>(
                getPoint(),
                getParentForChildren(),
                isClean());
        point_ = null;
      }
      return pointBuilder_;
    }

    private io.opencannabis.schema.geo.LocationAccuracy accuracy_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.LocationAccuracy, io.opencannabis.schema.geo.LocationAccuracy.Builder, io.opencannabis.schema.geo.LocationAccuracyOrBuilder> accuracyBuilder_;
    /**
     * <pre>
     * Specifies the accuracy estimate, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 4 [(.gen_bq_schema.description) = "Specifies the accuracy estimate, if known."];</code>
     */
    public boolean hasAccuracy() {
      return accuracyBuilder_ != null || accuracy_ != null;
    }
    /**
     * <pre>
     * Specifies the accuracy estimate, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 4 [(.gen_bq_schema.description) = "Specifies the accuracy estimate, if known."];</code>
     */
    public io.opencannabis.schema.geo.LocationAccuracy getAccuracy() {
      if (accuracyBuilder_ == null) {
        return accuracy_ == null ? io.opencannabis.schema.geo.LocationAccuracy.getDefaultInstance() : accuracy_;
      } else {
        return accuracyBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies the accuracy estimate, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 4 [(.gen_bq_schema.description) = "Specifies the accuracy estimate, if known."];</code>
     */
    public Builder setAccuracy(io.opencannabis.schema.geo.LocationAccuracy value) {
      if (accuracyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accuracy_ = value;
        onChanged();
      } else {
        accuracyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the accuracy estimate, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 4 [(.gen_bq_schema.description) = "Specifies the accuracy estimate, if known."];</code>
     */
    public Builder setAccuracy(
        io.opencannabis.schema.geo.LocationAccuracy.Builder builderForValue) {
      if (accuracyBuilder_ == null) {
        accuracy_ = builderForValue.build();
        onChanged();
      } else {
        accuracyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the accuracy estimate, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 4 [(.gen_bq_schema.description) = "Specifies the accuracy estimate, if known."];</code>
     */
    public Builder mergeAccuracy(io.opencannabis.schema.geo.LocationAccuracy value) {
      if (accuracyBuilder_ == null) {
        if (accuracy_ != null) {
          accuracy_ =
            io.opencannabis.schema.geo.LocationAccuracy.newBuilder(accuracy_).mergeFrom(value).buildPartial();
        } else {
          accuracy_ = value;
        }
        onChanged();
      } else {
        accuracyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the accuracy estimate, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 4 [(.gen_bq_schema.description) = "Specifies the accuracy estimate, if known."];</code>
     */
    public Builder clearAccuracy() {
      if (accuracyBuilder_ == null) {
        accuracy_ = null;
        onChanged();
      } else {
        accuracy_ = null;
        accuracyBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the accuracy estimate, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 4 [(.gen_bq_schema.description) = "Specifies the accuracy estimate, if known."];</code>
     */
    public io.opencannabis.schema.geo.LocationAccuracy.Builder getAccuracyBuilder() {
      
      onChanged();
      return getAccuracyFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies the accuracy estimate, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 4 [(.gen_bq_schema.description) = "Specifies the accuracy estimate, if known."];</code>
     */
    public io.opencannabis.schema.geo.LocationAccuracyOrBuilder getAccuracyOrBuilder() {
      if (accuracyBuilder_ != null) {
        return accuracyBuilder_.getMessageOrBuilder();
      } else {
        return accuracy_ == null ?
            io.opencannabis.schema.geo.LocationAccuracy.getDefaultInstance() : accuracy_;
      }
    }
    /**
     * <pre>
     * Specifies the accuracy estimate, if known.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 4 [(.gen_bq_schema.description) = "Specifies the accuracy estimate, if known."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.LocationAccuracy, io.opencannabis.schema.geo.LocationAccuracy.Builder, io.opencannabis.schema.geo.LocationAccuracyOrBuilder> 
        getAccuracyFieldBuilder() {
      if (accuracyBuilder_ == null) {
        accuracyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.geo.LocationAccuracy, io.opencannabis.schema.geo.LocationAccuracy.Builder, io.opencannabis.schema.geo.LocationAccuracyOrBuilder>(
                getAccuracy(),
                getParentForChildren(),
                isClean());
        accuracy_ = null;
      }
      return accuracyBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.geo.Location)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.geo.Location)
  private static final io.opencannabis.schema.geo.Location DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.geo.Location();
  }

  public static io.opencannabis.schema.geo.Location getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Location>
      PARSER = new com.google.protobuf.AbstractParser<Location>() {
    public Location parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Location(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Location> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Location> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.geo.Location getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

