/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: geo/Point.proto

package io.opencannabis.schema.geo;

/**
 * <pre>
 * Specifies a specific point on the earth, via a standard set of latitude/longitude coordinates, an elevation, and
 * optionally an accuracy rating. Accuracy and elevation are interpreted in 'feet' by default.
 * </pre>
 *
 * Protobuf type {@code opencannabis.geo.Point}
 */
public  final class Point extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.geo.Point)
    PointOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Point.newBuilder() to construct.
  private Point(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Point() {
    latitude_ = 0D;
    longitude_ = 0D;
    elevation_ = 0D;
    accuracy_ = 0D;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Point(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 9: {

            latitude_ = input.readDouble();
            break;
          }
          case 17: {

            longitude_ = input.readDouble();
            break;
          }
          case 25: {

            elevation_ = input.readDouble();
            break;
          }
          case 33: {

            accuracy_ = input.readDouble();
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.geo.PointOuterClass.internal_static_opencannabis_geo_Point_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.geo.PointOuterClass.internal_static_opencannabis_geo_Point_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.geo.Point.class, io.opencannabis.schema.geo.Point.Builder.class);
  }

  public static final int LATITUDE_FIELD_NUMBER = 1;
  private double latitude_;
  /**
   * <pre>
   * Latitude value of this point.
   * </pre>
   *
   * <code>double latitude = 1 [(.gen_bq_schema.description) = "Latitude value of this point."];</code>
   */
  public double getLatitude() {
    return latitude_;
  }

  public static final int LONGITUDE_FIELD_NUMBER = 2;
  private double longitude_;
  /**
   * <pre>
   * Longitude value of this point.
   * </pre>
   *
   * <code>double longitude = 2 [(.gen_bq_schema.description) = "Longitude value of this point."];</code>
   */
  public double getLongitude() {
    return longitude_;
  }

  public static final int ELEVATION_FIELD_NUMBER = 3;
  private double elevation_;
  /**
   * <pre>
   * Elevation of this point, if any.
   * </pre>
   *
   * <code>double elevation = 3 [(.gen_bq_schema.description) = "Elevation of this point, if any."];</code>
   */
  public double getElevation() {
    return elevation_;
  }

  public static final int ACCURACY_FIELD_NUMBER = 4;
  private double accuracy_;
  /**
   * <pre>
   * Accuracy rating attached to this point, if any.
   * </pre>
   *
   * <code>double accuracy = 4 [(.gen_bq_schema.description) = "Accuracy rating attached to this point, if any."];</code>
   */
  public double getAccuracy() {
    return accuracy_;
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (latitude_ != 0D) {
      output.writeDouble(1, latitude_);
    }
    if (longitude_ != 0D) {
      output.writeDouble(2, longitude_);
    }
    if (elevation_ != 0D) {
      output.writeDouble(3, elevation_);
    }
    if (accuracy_ != 0D) {
      output.writeDouble(4, accuracy_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (latitude_ != 0D) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(1, latitude_);
    }
    if (longitude_ != 0D) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(2, longitude_);
    }
    if (elevation_ != 0D) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(3, elevation_);
    }
    if (accuracy_ != 0D) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(4, accuracy_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.geo.Point)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.geo.Point other = (io.opencannabis.schema.geo.Point) obj;

    boolean result = true;
    result = result && (
        java.lang.Double.doubleToLongBits(getLatitude())
        == java.lang.Double.doubleToLongBits(
            other.getLatitude()));
    result = result && (
        java.lang.Double.doubleToLongBits(getLongitude())
        == java.lang.Double.doubleToLongBits(
            other.getLongitude()));
    result = result && (
        java.lang.Double.doubleToLongBits(getElevation())
        == java.lang.Double.doubleToLongBits(
            other.getElevation()));
    result = result && (
        java.lang.Double.doubleToLongBits(getAccuracy())
        == java.lang.Double.doubleToLongBits(
            other.getAccuracy()));
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LATITUDE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        java.lang.Double.doubleToLongBits(getLatitude()));
    hash = (37 * hash) + LONGITUDE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        java.lang.Double.doubleToLongBits(getLongitude()));
    hash = (37 * hash) + ELEVATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        java.lang.Double.doubleToLongBits(getElevation()));
    hash = (37 * hash) + ACCURACY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        java.lang.Double.doubleToLongBits(getAccuracy()));
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.geo.Point parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.geo.Point parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Point parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.geo.Point parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Point parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.geo.Point parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Point parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.geo.Point parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Point parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.geo.Point parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.geo.Point parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.geo.Point parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.geo.Point prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a specific point on the earth, via a standard set of latitude/longitude coordinates, an elevation, and
   * optionally an accuracy rating. Accuracy and elevation are interpreted in 'feet' by default.
   * </pre>
   *
   * Protobuf type {@code opencannabis.geo.Point}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.geo.Point)
      io.opencannabis.schema.geo.PointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.geo.PointOuterClass.internal_static_opencannabis_geo_Point_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.geo.PointOuterClass.internal_static_opencannabis_geo_Point_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.geo.Point.class, io.opencannabis.schema.geo.Point.Builder.class);
    }

    // Construct using io.opencannabis.schema.geo.Point.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      latitude_ = 0D;

      longitude_ = 0D;

      elevation_ = 0D;

      accuracy_ = 0D;

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.geo.PointOuterClass.internal_static_opencannabis_geo_Point_descriptor;
    }

    public io.opencannabis.schema.geo.Point getDefaultInstanceForType() {
      return io.opencannabis.schema.geo.Point.getDefaultInstance();
    }

    public io.opencannabis.schema.geo.Point build() {
      io.opencannabis.schema.geo.Point result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.geo.Point buildPartial() {
      io.opencannabis.schema.geo.Point result = new io.opencannabis.schema.geo.Point(this);
      result.latitude_ = latitude_;
      result.longitude_ = longitude_;
      result.elevation_ = elevation_;
      result.accuracy_ = accuracy_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.geo.Point) {
        return mergeFrom((io.opencannabis.schema.geo.Point)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.geo.Point other) {
      if (other == io.opencannabis.schema.geo.Point.getDefaultInstance()) return this;
      if (other.getLatitude() != 0D) {
        setLatitude(other.getLatitude());
      }
      if (other.getLongitude() != 0D) {
        setLongitude(other.getLongitude());
      }
      if (other.getElevation() != 0D) {
        setElevation(other.getElevation());
      }
      if (other.getAccuracy() != 0D) {
        setAccuracy(other.getAccuracy());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.geo.Point parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.geo.Point) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private double latitude_ ;
    /**
     * <pre>
     * Latitude value of this point.
     * </pre>
     *
     * <code>double latitude = 1 [(.gen_bq_schema.description) = "Latitude value of this point."];</code>
     */
    public double getLatitude() {
      return latitude_;
    }
    /**
     * <pre>
     * Latitude value of this point.
     * </pre>
     *
     * <code>double latitude = 1 [(.gen_bq_schema.description) = "Latitude value of this point."];</code>
     */
    public Builder setLatitude(double value) {
      
      latitude_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Latitude value of this point.
     * </pre>
     *
     * <code>double latitude = 1 [(.gen_bq_schema.description) = "Latitude value of this point."];</code>
     */
    public Builder clearLatitude() {
      
      latitude_ = 0D;
      onChanged();
      return this;
    }

    private double longitude_ ;
    /**
     * <pre>
     * Longitude value of this point.
     * </pre>
     *
     * <code>double longitude = 2 [(.gen_bq_schema.description) = "Longitude value of this point."];</code>
     */
    public double getLongitude() {
      return longitude_;
    }
    /**
     * <pre>
     * Longitude value of this point.
     * </pre>
     *
     * <code>double longitude = 2 [(.gen_bq_schema.description) = "Longitude value of this point."];</code>
     */
    public Builder setLongitude(double value) {
      
      longitude_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Longitude value of this point.
     * </pre>
     *
     * <code>double longitude = 2 [(.gen_bq_schema.description) = "Longitude value of this point."];</code>
     */
    public Builder clearLongitude() {
      
      longitude_ = 0D;
      onChanged();
      return this;
    }

    private double elevation_ ;
    /**
     * <pre>
     * Elevation of this point, if any.
     * </pre>
     *
     * <code>double elevation = 3 [(.gen_bq_schema.description) = "Elevation of this point, if any."];</code>
     */
    public double getElevation() {
      return elevation_;
    }
    /**
     * <pre>
     * Elevation of this point, if any.
     * </pre>
     *
     * <code>double elevation = 3 [(.gen_bq_schema.description) = "Elevation of this point, if any."];</code>
     */
    public Builder setElevation(double value) {
      
      elevation_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Elevation of this point, if any.
     * </pre>
     *
     * <code>double elevation = 3 [(.gen_bq_schema.description) = "Elevation of this point, if any."];</code>
     */
    public Builder clearElevation() {
      
      elevation_ = 0D;
      onChanged();
      return this;
    }

    private double accuracy_ ;
    /**
     * <pre>
     * Accuracy rating attached to this point, if any.
     * </pre>
     *
     * <code>double accuracy = 4 [(.gen_bq_schema.description) = "Accuracy rating attached to this point, if any."];</code>
     */
    public double getAccuracy() {
      return accuracy_;
    }
    /**
     * <pre>
     * Accuracy rating attached to this point, if any.
     * </pre>
     *
     * <code>double accuracy = 4 [(.gen_bq_schema.description) = "Accuracy rating attached to this point, if any."];</code>
     */
    public Builder setAccuracy(double value) {
      
      accuracy_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Accuracy rating attached to this point, if any.
     * </pre>
     *
     * <code>double accuracy = 4 [(.gen_bq_schema.description) = "Accuracy rating attached to this point, if any."];</code>
     */
    public Builder clearAccuracy() {
      
      accuracy_ = 0D;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.geo.Point)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.geo.Point)
  private static final io.opencannabis.schema.geo.Point DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.geo.Point();
  }

  public static io.opencannabis.schema.geo.Point getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Point>
      PARSER = new com.google.protobuf.AbstractParser<Point>() {
    public Point parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Point(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Point> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Point> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.geo.Point getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

