/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: geo/USState.proto

package io.opencannabis.schema.geo.usa;

/**
 * <pre>
 * Enumerates United States member states and territories by their full name and abbreviation.
 * </pre>
 *
 * Protobuf enum {@code opencannabis.geo.usa.USState}
 */
public enum USState
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * Default: Unspecified.
   * </pre>
   *
   * <code>UNSPECIFIED = 0;</code>
   */
  UNSPECIFIED(0, 0),
  /**
   * <pre>
   * State of Alabama.
   * </pre>
   *
   * <code>AL = 1;</code>
   */
  AL(1, 1),
  /**
   * <pre>
   * State of Alaska.
   * </pre>
   *
   * <code>AK = 2;</code>
   */
  AK(3, 2),
  /**
   * <pre>
   * State of Arizona.
   * </pre>
   *
   * <code>AZ = 3;</code>
   */
  AZ(5, 3),
  /**
   * <pre>
   * State of Arkansas.
   * </pre>
   *
   * <code>AR = 4;</code>
   */
  AR(7, 4),
  /**
   * <pre>
   * State of California.
   * </pre>
   *
   * <code>CA = 5;</code>
   */
  CA(9, 5),
  /**
   * <pre>
   * State of Colorado.
   * </pre>
   *
   * <code>CO = 6;</code>
   */
  CO(11, 6),
  /**
   * <pre>
   * State of Connecticut.
   * </pre>
   *
   * <code>CT = 7;</code>
   */
  CT(13, 7),
  /**
   * <pre>
   * State of Delaware.
   * </pre>
   *
   * <code>DE = 8;</code>
   */
  DE(15, 8),
  /**
   * <pre>
   * Washington, District of Columbia (DC).
   * </pre>
   *
   * <code>DC = 9;</code>
   */
  DC(17, 9),
  /**
   * <pre>
   * State of Florida.
   * </pre>
   *
   * <code>FL = 10;</code>
   */
  FL(19, 10),
  /**
   * <pre>
   * State of Georgia.
   * </pre>
   *
   * <code>GA = 11;</code>
   */
  GA(21, 11),
  /**
   * <pre>
   * State of Hawaii.
   * </pre>
   *
   * <code>HI = 12;</code>
   */
  HI(23, 12),
  /**
   * <pre>
   * State of Idaho.
   * </pre>
   *
   * <code>ID = 13;</code>
   */
  ID(25, 13),
  /**
   * <pre>
   * State of Illinois.
   * </pre>
   *
   * <code>IL = 14;</code>
   */
  IL(27, 14),
  /**
   * <pre>
   * State of Indiana.
   * </pre>
   *
   * <code>IN = 15;</code>
   */
  IN(29, 15),
  /**
   * <pre>
   * State of Iowa.
   * </pre>
   *
   * <code>IA = 16;</code>
   */
  IA(31, 16),
  /**
   * <pre>
   * State of Kansas.
   * </pre>
   *
   * <code>KS = 17;</code>
   */
  KS(33, 17),
  /**
   * <pre>
   * State of Kentucky.
   * </pre>
   *
   * <code>KY = 18;</code>
   */
  KY(35, 18),
  /**
   * <pre>
   * State of Loisiana.
   * </pre>
   *
   * <code>LA = 19;</code>
   */
  LA(37, 19),
  /**
   * <pre>
   * State of Maine.
   * </pre>
   *
   * <code>ME = 20;</code>
   */
  ME(39, 20),
  /**
   * <pre>
   * State of Maryland.
   * </pre>
   *
   * <code>MD = 21;</code>
   */
  MD(41, 21),
  /**
   * <pre>
   * State of Massachusetts.
   * </pre>
   *
   * <code>MA = 22;</code>
   */
  MA(43, 22),
  /**
   * <pre>
   * State of Michigan.
   * </pre>
   *
   * <code>MI = 23;</code>
   */
  MI(45, 23),
  /**
   * <pre>
   * State of Minnesota.
   * </pre>
   *
   * <code>MN = 24;</code>
   */
  MN(47, 24),
  /**
   * <pre>
   * State of Mississippi.
   * </pre>
   *
   * <code>MS = 25;</code>
   */
  MS(49, 25),
  /**
   * <pre>
   * State of Missouri.
   * </pre>
   *
   * <code>MO = 26;</code>
   */
  MO(51, 26),
  /**
   * <pre>
   * State of Montana.
   * </pre>
   *
   * <code>MT = 27;</code>
   */
  MT(53, 27),
  /**
   * <pre>
   * State of Nebraska.
   * </pre>
   *
   * <code>NE = 28;</code>
   */
  NE(55, 28),
  /**
   * <pre>
   * State of Nevada.
   * </pre>
   *
   * <code>NV = 29;</code>
   */
  NV(57, 29),
  /**
   * <pre>
   * State of New Hampshire.
   * </pre>
   *
   * <code>NH = 30;</code>
   */
  NH(59, 30),
  /**
   * <pre>
   * State of New Jersey.
   * </pre>
   *
   * <code>NJ = 31;</code>
   */
  NJ(61, 31),
  /**
   * <pre>
   * State of New Mexico.
   * </pre>
   *
   * <code>NM = 32;</code>
   */
  NM(63, 32),
  /**
   * <pre>
   * State of New York.
   * </pre>
   *
   * <code>NY = 33;</code>
   */
  NY(65, 33),
  /**
   * <pre>
   * State of North Carolina.
   * </pre>
   *
   * <code>NC = 34;</code>
   */
  NC(67, 34),
  /**
   * <pre>
   * State of North Dakota.
   * </pre>
   *
   * <code>ND = 35;</code>
   */
  ND(69, 35),
  /**
   * <pre>
   * State of Ohio.
   * </pre>
   *
   * <code>OH = 36;</code>
   */
  OH(71, 36),
  /**
   * <pre>
   * State of Oklahoma.
   * </pre>
   *
   * <code>OK = 37;</code>
   */
  OK(73, 37),
  /**
   * <pre>
   * State of Oregon.
   * </pre>
   *
   * <code>OR = 38;</code>
   */
  OR(75, 38),
  /**
   * <pre>
   * State of Pennsylvania.
   * </pre>
   *
   * <code>PA = 39;</code>
   */
  PA(77, 39),
  /**
   * <pre>
   * State of Rhode Island.
   * </pre>
   *
   * <code>RI = 40;</code>
   */
  RI(79, 40),
  /**
   * <pre>
   * State of South Carolina.
   * </pre>
   *
   * <code>SC = 41;</code>
   */
  SC(81, 41),
  /**
   * <pre>
   * State of South Dakota.
   * </pre>
   *
   * <code>SD = 42;</code>
   */
  SD(83, 42),
  /**
   * <pre>
   * State of Tennessee.
   * </pre>
   *
   * <code>TN = 43;</code>
   */
  TN(85, 43),
  /**
   * <pre>
   * State of Texas.
   * </pre>
   *
   * <code>TX = 44;</code>
   */
  TX(87, 44),
  /**
   * <pre>
   * State of Utah.
   * </pre>
   *
   * <code>UT = 45;</code>
   */
  UT(89, 45),
  /**
   * <pre>
   * State of Vermont.
   * </pre>
   *
   * <code>VT = 46;</code>
   */
  VT(91, 46),
  /**
   * <pre>
   * State of Virginia.
   * </pre>
   *
   * <code>VA = 47;</code>
   */
  VA(93, 47),
  /**
   * <pre>
   * State of Washington.
   * </pre>
   *
   * <code>WA = 48;</code>
   */
  WA(95, 48),
  /**
   * <pre>
   * State of West Virginia.
   * </pre>
   *
   * <code>WV = 49;</code>
   */
  WV(97, 49),
  /**
   * <pre>
   * State of Wisconsin.
   * </pre>
   *
   * <code>WI = 50;</code>
   */
  WI(99, 50),
  /**
   * <pre>
   * State of Wyoming.
   * </pre>
   *
   * <code>WYOMING = 51;</code>
   */
  WYOMING(101, 51),
  UNRECOGNIZED(-1, -1),
  ;

  /**
   * <code>ALABAMA = 1;</code>
   */
  public static final USState ALABAMA = AL;
  /**
   * <code>ALASKA = 2;</code>
   */
  public static final USState ALASKA = AK;
  /**
   * <code>ARIZONA = 3;</code>
   */
  public static final USState ARIZONA = AZ;
  /**
   * <code>ARKANSAS = 4;</code>
   */
  public static final USState ARKANSAS = AR;
  /**
   * <code>CALIFORNIA = 5;</code>
   */
  public static final USState CALIFORNIA = CA;
  /**
   * <code>COLORADO = 6;</code>
   */
  public static final USState COLORADO = CO;
  /**
   * <code>CONNECTICUT = 7;</code>
   */
  public static final USState CONNECTICUT = CT;
  /**
   * <code>Delaware = 8;</code>
   */
  public static final USState Delaware = DE;
  /**
   * <code>DISTRICT_OF_COLUMBIA = 9;</code>
   */
  public static final USState DISTRICT_OF_COLUMBIA = DC;
  /**
   * <code>FLORIDA = 10;</code>
   */
  public static final USState FLORIDA = FL;
  /**
   * <code>GEORGIA = 11;</code>
   */
  public static final USState GEORGIA = GA;
  /**
   * <code>HAWAII = 12;</code>
   */
  public static final USState HAWAII = HI;
  /**
   * <code>IDAHO = 13;</code>
   */
  public static final USState IDAHO = ID;
  /**
   * <code>ILLINOIS = 14;</code>
   */
  public static final USState ILLINOIS = IL;
  /**
   * <code>INDIANA = 15;</code>
   */
  public static final USState INDIANA = IN;
  /**
   * <code>IOWA = 16;</code>
   */
  public static final USState IOWA = IA;
  /**
   * <code>KANSAS = 17;</code>
   */
  public static final USState KANSAS = KS;
  /**
   * <code>KENTUCKY = 18;</code>
   */
  public static final USState KENTUCKY = KY;
  /**
   * <code>LOISIANA = 19;</code>
   */
  public static final USState LOISIANA = LA;
  /**
   * <code>MAINE = 20;</code>
   */
  public static final USState MAINE = ME;
  /**
   * <code>MARYLAND = 21;</code>
   */
  public static final USState MARYLAND = MD;
  /**
   * <code>MASSACHUSETTS = 22;</code>
   */
  public static final USState MASSACHUSETTS = MA;
  /**
   * <code>MICHIGAN = 23;</code>
   */
  public static final USState MICHIGAN = MI;
  /**
   * <code>MINNESOTA = 24;</code>
   */
  public static final USState MINNESOTA = MN;
  /**
   * <code>MISSISSIPPI = 25;</code>
   */
  public static final USState MISSISSIPPI = MS;
  /**
   * <code>MISSOURI = 26;</code>
   */
  public static final USState MISSOURI = MO;
  /**
   * <code>MONTANA = 27;</code>
   */
  public static final USState MONTANA = MT;
  /**
   * <code>NEBRASKA = 28;</code>
   */
  public static final USState NEBRASKA = NE;
  /**
   * <code>NEVADA = 29;</code>
   */
  public static final USState NEVADA = NV;
  /**
   * <code>NEW_HAMPSHIRE = 30;</code>
   */
  public static final USState NEW_HAMPSHIRE = NH;
  /**
   * <code>NEW_JERSEY = 31;</code>
   */
  public static final USState NEW_JERSEY = NJ;
  /**
   * <code>NEW_MEXICO = 32;</code>
   */
  public static final USState NEW_MEXICO = NM;
  /**
   * <code>NEW_YORK = 33;</code>
   */
  public static final USState NEW_YORK = NY;
  /**
   * <code>NORTH_CAROLINA = 34;</code>
   */
  public static final USState NORTH_CAROLINA = NC;
  /**
   * <code>NORTH_DAKOTA = 35;</code>
   */
  public static final USState NORTH_DAKOTA = ND;
  /**
   * <code>OHIO = 36;</code>
   */
  public static final USState OHIO = OH;
  /**
   * <code>OKLAHOMA = 37;</code>
   */
  public static final USState OKLAHOMA = OK;
  /**
   * <code>OREGON = 38;</code>
   */
  public static final USState OREGON = OR;
  /**
   * <code>PENNSYLVANIA = 39;</code>
   */
  public static final USState PENNSYLVANIA = PA;
  /**
   * <code>RHODE_ISLAND = 40;</code>
   */
  public static final USState RHODE_ISLAND = RI;
  /**
   * <code>SOUTH_CAROLINA = 41;</code>
   */
  public static final USState SOUTH_CAROLINA = SC;
  /**
   * <code>SOUTH_DAKOTA = 42;</code>
   */
  public static final USState SOUTH_DAKOTA = SD;
  /**
   * <code>TENNESSEE = 43;</code>
   */
  public static final USState TENNESSEE = TN;
  /**
   * <code>TEXAS = 44;</code>
   */
  public static final USState TEXAS = TX;
  /**
   * <code>UTAH = 45;</code>
   */
  public static final USState UTAH = UT;
  /**
   * <code>VERMONT = 46;</code>
   */
  public static final USState VERMONT = VT;
  /**
   * <code>VIRGINIA = 47;</code>
   */
  public static final USState VIRGINIA = VA;
  /**
   * <code>WASHINGTON = 48;</code>
   */
  public static final USState WASHINGTON = WA;
  /**
   * <code>WEST_VIRGINIA = 49;</code>
   */
  public static final USState WEST_VIRGINIA = WV;
  /**
   * <code>WISCONSIN = 50;</code>
   */
  public static final USState WISCONSIN = WI;
  /**
   * <code>WY = 51;</code>
   */
  public static final USState WY = WYOMING;
  /**
   * <pre>
   * Default: Unspecified.
   * </pre>
   *
   * <code>UNSPECIFIED = 0;</code>
   */
  public static final int UNSPECIFIED_VALUE = 0;
  /**
   * <pre>
   * State of Alabama.
   * </pre>
   *
   * <code>AL = 1;</code>
   */
  public static final int AL_VALUE = 1;
  /**
   * <code>ALABAMA = 1;</code>
   */
  public static final int ALABAMA_VALUE = 1;
  /**
   * <pre>
   * State of Alaska.
   * </pre>
   *
   * <code>AK = 2;</code>
   */
  public static final int AK_VALUE = 2;
  /**
   * <code>ALASKA = 2;</code>
   */
  public static final int ALASKA_VALUE = 2;
  /**
   * <pre>
   * State of Arizona.
   * </pre>
   *
   * <code>AZ = 3;</code>
   */
  public static final int AZ_VALUE = 3;
  /**
   * <code>ARIZONA = 3;</code>
   */
  public static final int ARIZONA_VALUE = 3;
  /**
   * <pre>
   * State of Arkansas.
   * </pre>
   *
   * <code>AR = 4;</code>
   */
  public static final int AR_VALUE = 4;
  /**
   * <code>ARKANSAS = 4;</code>
   */
  public static final int ARKANSAS_VALUE = 4;
  /**
   * <pre>
   * State of California.
   * </pre>
   *
   * <code>CA = 5;</code>
   */
  public static final int CA_VALUE = 5;
  /**
   * <code>CALIFORNIA = 5;</code>
   */
  public static final int CALIFORNIA_VALUE = 5;
  /**
   * <pre>
   * State of Colorado.
   * </pre>
   *
   * <code>CO = 6;</code>
   */
  public static final int CO_VALUE = 6;
  /**
   * <code>COLORADO = 6;</code>
   */
  public static final int COLORADO_VALUE = 6;
  /**
   * <pre>
   * State of Connecticut.
   * </pre>
   *
   * <code>CT = 7;</code>
   */
  public static final int CT_VALUE = 7;
  /**
   * <code>CONNECTICUT = 7;</code>
   */
  public static final int CONNECTICUT_VALUE = 7;
  /**
   * <pre>
   * State of Delaware.
   * </pre>
   *
   * <code>DE = 8;</code>
   */
  public static final int DE_VALUE = 8;
  /**
   * <code>Delaware = 8;</code>
   */
  public static final int Delaware_VALUE = 8;
  /**
   * <pre>
   * Washington, District of Columbia (DC).
   * </pre>
   *
   * <code>DC = 9;</code>
   */
  public static final int DC_VALUE = 9;
  /**
   * <code>DISTRICT_OF_COLUMBIA = 9;</code>
   */
  public static final int DISTRICT_OF_COLUMBIA_VALUE = 9;
  /**
   * <pre>
   * State of Florida.
   * </pre>
   *
   * <code>FL = 10;</code>
   */
  public static final int FL_VALUE = 10;
  /**
   * <code>FLORIDA = 10;</code>
   */
  public static final int FLORIDA_VALUE = 10;
  /**
   * <pre>
   * State of Georgia.
   * </pre>
   *
   * <code>GA = 11;</code>
   */
  public static final int GA_VALUE = 11;
  /**
   * <code>GEORGIA = 11;</code>
   */
  public static final int GEORGIA_VALUE = 11;
  /**
   * <pre>
   * State of Hawaii.
   * </pre>
   *
   * <code>HI = 12;</code>
   */
  public static final int HI_VALUE = 12;
  /**
   * <code>HAWAII = 12;</code>
   */
  public static final int HAWAII_VALUE = 12;
  /**
   * <pre>
   * State of Idaho.
   * </pre>
   *
   * <code>ID = 13;</code>
   */
  public static final int ID_VALUE = 13;
  /**
   * <code>IDAHO = 13;</code>
   */
  public static final int IDAHO_VALUE = 13;
  /**
   * <pre>
   * State of Illinois.
   * </pre>
   *
   * <code>IL = 14;</code>
   */
  public static final int IL_VALUE = 14;
  /**
   * <code>ILLINOIS = 14;</code>
   */
  public static final int ILLINOIS_VALUE = 14;
  /**
   * <pre>
   * State of Indiana.
   * </pre>
   *
   * <code>IN = 15;</code>
   */
  public static final int IN_VALUE = 15;
  /**
   * <code>INDIANA = 15;</code>
   */
  public static final int INDIANA_VALUE = 15;
  /**
   * <pre>
   * State of Iowa.
   * </pre>
   *
   * <code>IA = 16;</code>
   */
  public static final int IA_VALUE = 16;
  /**
   * <code>IOWA = 16;</code>
   */
  public static final int IOWA_VALUE = 16;
  /**
   * <pre>
   * State of Kansas.
   * </pre>
   *
   * <code>KS = 17;</code>
   */
  public static final int KS_VALUE = 17;
  /**
   * <code>KANSAS = 17;</code>
   */
  public static final int KANSAS_VALUE = 17;
  /**
   * <pre>
   * State of Kentucky.
   * </pre>
   *
   * <code>KY = 18;</code>
   */
  public static final int KY_VALUE = 18;
  /**
   * <code>KENTUCKY = 18;</code>
   */
  public static final int KENTUCKY_VALUE = 18;
  /**
   * <pre>
   * State of Loisiana.
   * </pre>
   *
   * <code>LA = 19;</code>
   */
  public static final int LA_VALUE = 19;
  /**
   * <code>LOISIANA = 19;</code>
   */
  public static final int LOISIANA_VALUE = 19;
  /**
   * <pre>
   * State of Maine.
   * </pre>
   *
   * <code>ME = 20;</code>
   */
  public static final int ME_VALUE = 20;
  /**
   * <code>MAINE = 20;</code>
   */
  public static final int MAINE_VALUE = 20;
  /**
   * <pre>
   * State of Maryland.
   * </pre>
   *
   * <code>MD = 21;</code>
   */
  public static final int MD_VALUE = 21;
  /**
   * <code>MARYLAND = 21;</code>
   */
  public static final int MARYLAND_VALUE = 21;
  /**
   * <pre>
   * State of Massachusetts.
   * </pre>
   *
   * <code>MA = 22;</code>
   */
  public static final int MA_VALUE = 22;
  /**
   * <code>MASSACHUSETTS = 22;</code>
   */
  public static final int MASSACHUSETTS_VALUE = 22;
  /**
   * <pre>
   * State of Michigan.
   * </pre>
   *
   * <code>MI = 23;</code>
   */
  public static final int MI_VALUE = 23;
  /**
   * <code>MICHIGAN = 23;</code>
   */
  public static final int MICHIGAN_VALUE = 23;
  /**
   * <pre>
   * State of Minnesota.
   * </pre>
   *
   * <code>MN = 24;</code>
   */
  public static final int MN_VALUE = 24;
  /**
   * <code>MINNESOTA = 24;</code>
   */
  public static final int MINNESOTA_VALUE = 24;
  /**
   * <pre>
   * State of Mississippi.
   * </pre>
   *
   * <code>MS = 25;</code>
   */
  public static final int MS_VALUE = 25;
  /**
   * <code>MISSISSIPPI = 25;</code>
   */
  public static final int MISSISSIPPI_VALUE = 25;
  /**
   * <pre>
   * State of Missouri.
   * </pre>
   *
   * <code>MO = 26;</code>
   */
  public static final int MO_VALUE = 26;
  /**
   * <code>MISSOURI = 26;</code>
   */
  public static final int MISSOURI_VALUE = 26;
  /**
   * <pre>
   * State of Montana.
   * </pre>
   *
   * <code>MT = 27;</code>
   */
  public static final int MT_VALUE = 27;
  /**
   * <code>MONTANA = 27;</code>
   */
  public static final int MONTANA_VALUE = 27;
  /**
   * <pre>
   * State of Nebraska.
   * </pre>
   *
   * <code>NE = 28;</code>
   */
  public static final int NE_VALUE = 28;
  /**
   * <code>NEBRASKA = 28;</code>
   */
  public static final int NEBRASKA_VALUE = 28;
  /**
   * <pre>
   * State of Nevada.
   * </pre>
   *
   * <code>NV = 29;</code>
   */
  public static final int NV_VALUE = 29;
  /**
   * <code>NEVADA = 29;</code>
   */
  public static final int NEVADA_VALUE = 29;
  /**
   * <pre>
   * State of New Hampshire.
   * </pre>
   *
   * <code>NH = 30;</code>
   */
  public static final int NH_VALUE = 30;
  /**
   * <code>NEW_HAMPSHIRE = 30;</code>
   */
  public static final int NEW_HAMPSHIRE_VALUE = 30;
  /**
   * <pre>
   * State of New Jersey.
   * </pre>
   *
   * <code>NJ = 31;</code>
   */
  public static final int NJ_VALUE = 31;
  /**
   * <code>NEW_JERSEY = 31;</code>
   */
  public static final int NEW_JERSEY_VALUE = 31;
  /**
   * <pre>
   * State of New Mexico.
   * </pre>
   *
   * <code>NM = 32;</code>
   */
  public static final int NM_VALUE = 32;
  /**
   * <code>NEW_MEXICO = 32;</code>
   */
  public static final int NEW_MEXICO_VALUE = 32;
  /**
   * <pre>
   * State of New York.
   * </pre>
   *
   * <code>NY = 33;</code>
   */
  public static final int NY_VALUE = 33;
  /**
   * <code>NEW_YORK = 33;</code>
   */
  public static final int NEW_YORK_VALUE = 33;
  /**
   * <pre>
   * State of North Carolina.
   * </pre>
   *
   * <code>NC = 34;</code>
   */
  public static final int NC_VALUE = 34;
  /**
   * <code>NORTH_CAROLINA = 34;</code>
   */
  public static final int NORTH_CAROLINA_VALUE = 34;
  /**
   * <pre>
   * State of North Dakota.
   * </pre>
   *
   * <code>ND = 35;</code>
   */
  public static final int ND_VALUE = 35;
  /**
   * <code>NORTH_DAKOTA = 35;</code>
   */
  public static final int NORTH_DAKOTA_VALUE = 35;
  /**
   * <pre>
   * State of Ohio.
   * </pre>
   *
   * <code>OH = 36;</code>
   */
  public static final int OH_VALUE = 36;
  /**
   * <code>OHIO = 36;</code>
   */
  public static final int OHIO_VALUE = 36;
  /**
   * <pre>
   * State of Oklahoma.
   * </pre>
   *
   * <code>OK = 37;</code>
   */
  public static final int OK_VALUE = 37;
  /**
   * <code>OKLAHOMA = 37;</code>
   */
  public static final int OKLAHOMA_VALUE = 37;
  /**
   * <pre>
   * State of Oregon.
   * </pre>
   *
   * <code>OR = 38;</code>
   */
  public static final int OR_VALUE = 38;
  /**
   * <code>OREGON = 38;</code>
   */
  public static final int OREGON_VALUE = 38;
  /**
   * <pre>
   * State of Pennsylvania.
   * </pre>
   *
   * <code>PA = 39;</code>
   */
  public static final int PA_VALUE = 39;
  /**
   * <code>PENNSYLVANIA = 39;</code>
   */
  public static final int PENNSYLVANIA_VALUE = 39;
  /**
   * <pre>
   * State of Rhode Island.
   * </pre>
   *
   * <code>RI = 40;</code>
   */
  public static final int RI_VALUE = 40;
  /**
   * <code>RHODE_ISLAND = 40;</code>
   */
  public static final int RHODE_ISLAND_VALUE = 40;
  /**
   * <pre>
   * State of South Carolina.
   * </pre>
   *
   * <code>SC = 41;</code>
   */
  public static final int SC_VALUE = 41;
  /**
   * <code>SOUTH_CAROLINA = 41;</code>
   */
  public static final int SOUTH_CAROLINA_VALUE = 41;
  /**
   * <pre>
   * State of South Dakota.
   * </pre>
   *
   * <code>SD = 42;</code>
   */
  public static final int SD_VALUE = 42;
  /**
   * <code>SOUTH_DAKOTA = 42;</code>
   */
  public static final int SOUTH_DAKOTA_VALUE = 42;
  /**
   * <pre>
   * State of Tennessee.
   * </pre>
   *
   * <code>TN = 43;</code>
   */
  public static final int TN_VALUE = 43;
  /**
   * <code>TENNESSEE = 43;</code>
   */
  public static final int TENNESSEE_VALUE = 43;
  /**
   * <pre>
   * State of Texas.
   * </pre>
   *
   * <code>TX = 44;</code>
   */
  public static final int TX_VALUE = 44;
  /**
   * <code>TEXAS = 44;</code>
   */
  public static final int TEXAS_VALUE = 44;
  /**
   * <pre>
   * State of Utah.
   * </pre>
   *
   * <code>UT = 45;</code>
   */
  public static final int UT_VALUE = 45;
  /**
   * <code>UTAH = 45;</code>
   */
  public static final int UTAH_VALUE = 45;
  /**
   * <pre>
   * State of Vermont.
   * </pre>
   *
   * <code>VT = 46;</code>
   */
  public static final int VT_VALUE = 46;
  /**
   * <code>VERMONT = 46;</code>
   */
  public static final int VERMONT_VALUE = 46;
  /**
   * <pre>
   * State of Virginia.
   * </pre>
   *
   * <code>VA = 47;</code>
   */
  public static final int VA_VALUE = 47;
  /**
   * <code>VIRGINIA = 47;</code>
   */
  public static final int VIRGINIA_VALUE = 47;
  /**
   * <pre>
   * State of Washington.
   * </pre>
   *
   * <code>WA = 48;</code>
   */
  public static final int WA_VALUE = 48;
  /**
   * <code>WASHINGTON = 48;</code>
   */
  public static final int WASHINGTON_VALUE = 48;
  /**
   * <pre>
   * State of West Virginia.
   * </pre>
   *
   * <code>WV = 49;</code>
   */
  public static final int WV_VALUE = 49;
  /**
   * <code>WEST_VIRGINIA = 49;</code>
   */
  public static final int WEST_VIRGINIA_VALUE = 49;
  /**
   * <pre>
   * State of Wisconsin.
   * </pre>
   *
   * <code>WI = 50;</code>
   */
  public static final int WI_VALUE = 50;
  /**
   * <code>WISCONSIN = 50;</code>
   */
  public static final int WISCONSIN_VALUE = 50;
  /**
   * <pre>
   * State of Wyoming.
   * </pre>
   *
   * <code>WYOMING = 51;</code>
   */
  public static final int WYOMING_VALUE = 51;
  /**
   * <code>WY = 51;</code>
   */
  public static final int WY_VALUE = 51;


  public final int getNumber() {
    if (index == -1) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static USState valueOf(int value) {
    return forNumber(value);
  }

  public static USState forNumber(int value) {
    switch (value) {
      case 0: return UNSPECIFIED;
      case 1: return AL;
      case 2: return AK;
      case 3: return AZ;
      case 4: return AR;
      case 5: return CA;
      case 6: return CO;
      case 7: return CT;
      case 8: return DE;
      case 9: return DC;
      case 10: return FL;
      case 11: return GA;
      case 12: return HI;
      case 13: return ID;
      case 14: return IL;
      case 15: return IN;
      case 16: return IA;
      case 17: return KS;
      case 18: return KY;
      case 19: return LA;
      case 20: return ME;
      case 21: return MD;
      case 22: return MA;
      case 23: return MI;
      case 24: return MN;
      case 25: return MS;
      case 26: return MO;
      case 27: return MT;
      case 28: return NE;
      case 29: return NV;
      case 30: return NH;
      case 31: return NJ;
      case 32: return NM;
      case 33: return NY;
      case 34: return NC;
      case 35: return ND;
      case 36: return OH;
      case 37: return OK;
      case 38: return OR;
      case 39: return PA;
      case 40: return RI;
      case 41: return SC;
      case 42: return SD;
      case 43: return TN;
      case 44: return TX;
      case 45: return UT;
      case 46: return VT;
      case 47: return VA;
      case 48: return WA;
      case 49: return WV;
      case 50: return WI;
      case 51: return WYOMING;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<USState>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      USState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<USState>() {
          public USState findValueByNumber(int number) {
            return USState.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(index);
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.opencannabis.schema.geo.usa.USStateOuterClass.getDescriptor().getEnumTypes().get(0);
  }

  private static final USState[] VALUES = {
    UNSPECIFIED, AL, ALABAMA, AK, ALASKA, AZ, ARIZONA, AR, ARKANSAS, CA, CALIFORNIA, CO, COLORADO, CT, CONNECTICUT, DE, Delaware, DC, DISTRICT_OF_COLUMBIA, FL, FLORIDA, GA, GEORGIA, HI, HAWAII, ID, IDAHO, IL, ILLINOIS, IN, INDIANA, IA, IOWA, KS, KANSAS, KY, KENTUCKY, LA, LOISIANA, ME, MAINE, MD, MARYLAND, MA, MASSACHUSETTS, MI, MICHIGAN, MN, MINNESOTA, MS, MISSISSIPPI, MO, MISSOURI, MT, MONTANA, NE, NEBRASKA, NV, NEVADA, NH, NEW_HAMPSHIRE, NJ, NEW_JERSEY, NM, NEW_MEXICO, NY, NEW_YORK, NC, NORTH_CAROLINA, ND, NORTH_DAKOTA, OH, OHIO, OK, OKLAHOMA, OR, OREGON, PA, PENNSYLVANIA, RI, RHODE_ISLAND, SC, SOUTH_CAROLINA, SD, SOUTH_DAKOTA, TN, TENNESSEE, TX, TEXAS, UT, UTAH, VT, VERMONT, VA, VIRGINIA, WA, WASHINGTON, WV, WEST_VIRGINIA, WI, WISCONSIN, WYOMING, WY, 
  };

  public static USState valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int index;
  private final int value;

  private USState(int index, int value) {
    this.index = index;
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:opencannabis.geo.usa.USState)
}

