/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: media/MediaOrientation.proto

package io.opencannabis.schema.media;

/**
 * <pre>
 * Orientation status of a piece of media. Provided by camera operations on mobile devices,
 * in some cases, and also stored along with media sometimes.
 * </pre>
 *
 * Protobuf enum {@code opencannabis.media.MediaOrientation}
 */
public enum MediaOrientation
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * Media is oriented 'up'.
   * </pre>
   *
   * <code>UP = 0;</code>
   */
  UP(0),
  /**
   * <pre>
   * Media is oriented 'down'.
   * </pre>
   *
   * <code>DOWN = 1;</code>
   */
  DOWN(1),
  /**
   * <pre>
   * Media is oriented 'left'.
   * </pre>
   *
   * <code>LEFT = 2;</code>
   */
  LEFT(2),
  /**
   * <pre>
   * Media is oriented 'right'.
   * </pre>
   *
   * <code>RIGHT = 3;</code>
   */
  RIGHT(3),
  /**
   * <pre>
   * Media is oriented 'up,' and mirrored.
   * </pre>
   *
   * <code>UP_MIRRORED = 4;</code>
   */
  UP_MIRRORED(4),
  /**
   * <pre>
   * Media is oriented 'down,' and mirrored.
   * </pre>
   *
   * <code>DOWN_MIRRORED = 5;</code>
   */
  DOWN_MIRRORED(5),
  /**
   * <pre>
   * Media is oriented 'left,' and mirrored.
   * </pre>
   *
   * <code>LEFT_MIRRORED = 6;</code>
   */
  LEFT_MIRRORED(6),
  /**
   * <pre>
   * Media is oriented 'right,' and mirrored.
   * </pre>
   *
   * <code>RIGHT_MIRRORED = 7;</code>
   */
  RIGHT_MIRRORED(7),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * Media is oriented 'up'.
   * </pre>
   *
   * <code>UP = 0;</code>
   */
  public static final int UP_VALUE = 0;
  /**
   * <pre>
   * Media is oriented 'down'.
   * </pre>
   *
   * <code>DOWN = 1;</code>
   */
  public static final int DOWN_VALUE = 1;
  /**
   * <pre>
   * Media is oriented 'left'.
   * </pre>
   *
   * <code>LEFT = 2;</code>
   */
  public static final int LEFT_VALUE = 2;
  /**
   * <pre>
   * Media is oriented 'right'.
   * </pre>
   *
   * <code>RIGHT = 3;</code>
   */
  public static final int RIGHT_VALUE = 3;
  /**
   * <pre>
   * Media is oriented 'up,' and mirrored.
   * </pre>
   *
   * <code>UP_MIRRORED = 4;</code>
   */
  public static final int UP_MIRRORED_VALUE = 4;
  /**
   * <pre>
   * Media is oriented 'down,' and mirrored.
   * </pre>
   *
   * <code>DOWN_MIRRORED = 5;</code>
   */
  public static final int DOWN_MIRRORED_VALUE = 5;
  /**
   * <pre>
   * Media is oriented 'left,' and mirrored.
   * </pre>
   *
   * <code>LEFT_MIRRORED = 6;</code>
   */
  public static final int LEFT_MIRRORED_VALUE = 6;
  /**
   * <pre>
   * Media is oriented 'right,' and mirrored.
   * </pre>
   *
   * <code>RIGHT_MIRRORED = 7;</code>
   */
  public static final int RIGHT_MIRRORED_VALUE = 7;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static MediaOrientation valueOf(int value) {
    return forNumber(value);
  }

  public static MediaOrientation forNumber(int value) {
    switch (value) {
      case 0: return UP;
      case 1: return DOWN;
      case 2: return LEFT;
      case 3: return RIGHT;
      case 4: return UP_MIRRORED;
      case 5: return DOWN_MIRRORED;
      case 6: return LEFT_MIRRORED;
      case 7: return RIGHT_MIRRORED;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<MediaOrientation>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      MediaOrientation> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MediaOrientation>() {
          public MediaOrientation findValueByNumber(int number) {
            return MediaOrientation.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.opencannabis.schema.media.MediaOrientationOuterClass.getDescriptor().getEnumTypes().get(0);
  }

  private static final MediaOrientation[] VALUES = values();

  public static MediaOrientation valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private MediaOrientation(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:opencannabis.media.MediaOrientation)
}

