/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: media/MediaType.proto

package io.opencannabis.schema.media;

/**
 * <pre>
 * Specifies the type of media being attached or described.
 * </pre>
 *
 * Protobuf type {@code opencannabis.media.MediaType}
 */
public  final class MediaType extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.media.MediaType)
    MediaTypeOrBuilder {
private static final long serialVersionUID = 0L;
  // Use MediaType.newBuilder() to construct.
  private MediaType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private MediaType() {
    kind_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private MediaType(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();

            kind_ = rawValue;
            break;
          }
          case 810: {
            io.opencannabis.schema.media.ImageType.Builder subBuilder = null;
            if (contentCase_ == 101) {
              subBuilder = ((io.opencannabis.schema.media.ImageType) content_).toBuilder();
            }
            content_ =
                input.readMessage(io.opencannabis.schema.media.ImageType.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.opencannabis.schema.media.ImageType) content_);
              content_ = subBuilder.buildPartial();
            }
            contentCase_ = 101;
            break;
          }
          case 1610: {
            io.opencannabis.schema.media.DocumentType.Builder subBuilder = null;
            if (contentCase_ == 201) {
              subBuilder = ((io.opencannabis.schema.media.DocumentType) content_).toBuilder();
            }
            content_ =
                input.readMessage(io.opencannabis.schema.media.DocumentType.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.opencannabis.schema.media.DocumentType) content_);
              content_ = subBuilder.buildPartial();
            }
            contentCase_ = 201;
            break;
          }
          case 2410: {
            io.opencannabis.schema.media.VideoType.Builder subBuilder = null;
            if (contentCase_ == 301) {
              subBuilder = ((io.opencannabis.schema.media.VideoType) content_).toBuilder();
            }
            content_ =
                input.readMessage(io.opencannabis.schema.media.VideoType.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.opencannabis.schema.media.VideoType) content_);
              content_ = subBuilder.buildPartial();
            }
            contentCase_ = 301;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.media.MediaItemType.internal_static_opencannabis_media_MediaType_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.media.MediaItemType.internal_static_opencannabis_media_MediaType_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.media.MediaType.class, io.opencannabis.schema.media.MediaType.Builder.class);
  }

  /**
   * <pre>
   * Enumerates, in generic terms, the kinds of media that can be attached or described.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.media.MediaType.Kind}
   */
  public enum Kind
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Web link, or URI.
     * </pre>
     *
     * <code>LINK = 0;</code>
     */
    LINK(0),
    /**
     * <pre>
     * Image or photograph.
     * </pre>
     *
     * <code>IMAGE = 1;</code>
     */
    IMAGE(1),
    /**
     * <pre>
     * Document or text data.
     * </pre>
     *
     * <code>DOCUMENT = 2;</code>
     */
    DOCUMENT(2),
    /**
     * <pre>
     * Video data.
     * </pre>
     *
     * <code>VIDEO = 3;</code>
     */
    VIDEO(3),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Web link, or URI.
     * </pre>
     *
     * <code>LINK = 0;</code>
     */
    public static final int LINK_VALUE = 0;
    /**
     * <pre>
     * Image or photograph.
     * </pre>
     *
     * <code>IMAGE = 1;</code>
     */
    public static final int IMAGE_VALUE = 1;
    /**
     * <pre>
     * Document or text data.
     * </pre>
     *
     * <code>DOCUMENT = 2;</code>
     */
    public static final int DOCUMENT_VALUE = 2;
    /**
     * <pre>
     * Video data.
     * </pre>
     *
     * <code>VIDEO = 3;</code>
     */
    public static final int VIDEO_VALUE = 3;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Kind valueOf(int value) {
      return forNumber(value);
    }

    public static Kind forNumber(int value) {
      switch (value) {
        case 0: return LINK;
        case 1: return IMAGE;
        case 2: return DOCUMENT;
        case 3: return VIDEO;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Kind>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Kind> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Kind>() {
            public Kind findValueByNumber(int number) {
              return Kind.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.media.MediaType.getDescriptor().getEnumTypes().get(0);
    }

    private static final Kind[] VALUES = values();

    public static Kind valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Kind(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.media.MediaType.Kind)
  }

  private int contentCase_ = 0;
  private java.lang.Object content_;
  public enum ContentCase
      implements com.google.protobuf.Internal.EnumLite {
    IMAGE_TYPE(101),
    DOCUMENT_TYPE(201),
    VIDEO_TYPE(301),
    CONTENT_NOT_SET(0);
    private final int value;
    private ContentCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ContentCase valueOf(int value) {
      return forNumber(value);
    }

    public static ContentCase forNumber(int value) {
      switch (value) {
        case 101: return IMAGE_TYPE;
        case 201: return DOCUMENT_TYPE;
        case 301: return VIDEO_TYPE;
        case 0: return CONTENT_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public ContentCase
  getContentCase() {
    return ContentCase.forNumber(
        contentCase_);
  }

  public static final int KIND_FIELD_NUMBER = 1;
  private int kind_;
  /**
   * <pre>
   * Specifies the generic kind of media being described or attached.
   * </pre>
   *
   * <code>.opencannabis.media.MediaType.Kind kind = 1 [(.gen_bq_schema.description) = "Specifies the generic kind of media being described or attached."];</code>
   */
  public int getKindValue() {
    return kind_;
  }
  /**
   * <pre>
   * Specifies the generic kind of media being described or attached.
   * </pre>
   *
   * <code>.opencannabis.media.MediaType.Kind kind = 1 [(.gen_bq_schema.description) = "Specifies the generic kind of media being described or attached."];</code>
   */
  public io.opencannabis.schema.media.MediaType.Kind getKind() {
    io.opencannabis.schema.media.MediaType.Kind result = io.opencannabis.schema.media.MediaType.Kind.valueOf(kind_);
    return result == null ? io.opencannabis.schema.media.MediaType.Kind.UNRECOGNIZED : result;
  }

  public static final int IMAGE_TYPE_FIELD_NUMBER = 101;
  /**
   * <pre>
   * Specifies content for an image-based media item.
   * </pre>
   *
   * <code>.opencannabis.media.ImageType image_type = 101 [(.gen_bq_schema.description) = "Specifies content for an image-based media item."];</code>
   */
  public boolean hasImageType() {
    return contentCase_ == 101;
  }
  /**
   * <pre>
   * Specifies content for an image-based media item.
   * </pre>
   *
   * <code>.opencannabis.media.ImageType image_type = 101 [(.gen_bq_schema.description) = "Specifies content for an image-based media item."];</code>
   */
  public io.opencannabis.schema.media.ImageType getImageType() {
    if (contentCase_ == 101) {
       return (io.opencannabis.schema.media.ImageType) content_;
    }
    return io.opencannabis.schema.media.ImageType.getDefaultInstance();
  }
  /**
   * <pre>
   * Specifies content for an image-based media item.
   * </pre>
   *
   * <code>.opencannabis.media.ImageType image_type = 101 [(.gen_bq_schema.description) = "Specifies content for an image-based media item."];</code>
   */
  public io.opencannabis.schema.media.ImageTypeOrBuilder getImageTypeOrBuilder() {
    if (contentCase_ == 101) {
       return (io.opencannabis.schema.media.ImageType) content_;
    }
    return io.opencannabis.schema.media.ImageType.getDefaultInstance();
  }

  public static final int DOCUMENT_TYPE_FIELD_NUMBER = 201;
  /**
   * <pre>
   * Specifies content for a document-based media item.
   * </pre>
   *
   * <code>.opencannabis.media.DocumentType document_type = 201 [(.gen_bq_schema.description) = "Specifies content for a document-based media item."];</code>
   */
  public boolean hasDocumentType() {
    return contentCase_ == 201;
  }
  /**
   * <pre>
   * Specifies content for a document-based media item.
   * </pre>
   *
   * <code>.opencannabis.media.DocumentType document_type = 201 [(.gen_bq_schema.description) = "Specifies content for a document-based media item."];</code>
   */
  public io.opencannabis.schema.media.DocumentType getDocumentType() {
    if (contentCase_ == 201) {
       return (io.opencannabis.schema.media.DocumentType) content_;
    }
    return io.opencannabis.schema.media.DocumentType.getDefaultInstance();
  }
  /**
   * <pre>
   * Specifies content for a document-based media item.
   * </pre>
   *
   * <code>.opencannabis.media.DocumentType document_type = 201 [(.gen_bq_schema.description) = "Specifies content for a document-based media item."];</code>
   */
  public io.opencannabis.schema.media.DocumentTypeOrBuilder getDocumentTypeOrBuilder() {
    if (contentCase_ == 201) {
       return (io.opencannabis.schema.media.DocumentType) content_;
    }
    return io.opencannabis.schema.media.DocumentType.getDefaultInstance();
  }

  public static final int VIDEO_TYPE_FIELD_NUMBER = 301;
  /**
   * <pre>
   * Specifies content for a video-based media item.
   * </pre>
   *
   * <code>.opencannabis.media.VideoType video_type = 301 [(.gen_bq_schema.description) = "Specifies content for a video-based media item."];</code>
   */
  public boolean hasVideoType() {
    return contentCase_ == 301;
  }
  /**
   * <pre>
   * Specifies content for a video-based media item.
   * </pre>
   *
   * <code>.opencannabis.media.VideoType video_type = 301 [(.gen_bq_schema.description) = "Specifies content for a video-based media item."];</code>
   */
  public io.opencannabis.schema.media.VideoType getVideoType() {
    if (contentCase_ == 301) {
       return (io.opencannabis.schema.media.VideoType) content_;
    }
    return io.opencannabis.schema.media.VideoType.getDefaultInstance();
  }
  /**
   * <pre>
   * Specifies content for a video-based media item.
   * </pre>
   *
   * <code>.opencannabis.media.VideoType video_type = 301 [(.gen_bq_schema.description) = "Specifies content for a video-based media item."];</code>
   */
  public io.opencannabis.schema.media.VideoTypeOrBuilder getVideoTypeOrBuilder() {
    if (contentCase_ == 301) {
       return (io.opencannabis.schema.media.VideoType) content_;
    }
    return io.opencannabis.schema.media.VideoType.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (kind_ != io.opencannabis.schema.media.MediaType.Kind.LINK.getNumber()) {
      output.writeEnum(1, kind_);
    }
    if (contentCase_ == 101) {
      output.writeMessage(101, (io.opencannabis.schema.media.ImageType) content_);
    }
    if (contentCase_ == 201) {
      output.writeMessage(201, (io.opencannabis.schema.media.DocumentType) content_);
    }
    if (contentCase_ == 301) {
      output.writeMessage(301, (io.opencannabis.schema.media.VideoType) content_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (kind_ != io.opencannabis.schema.media.MediaType.Kind.LINK.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, kind_);
    }
    if (contentCase_ == 101) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(101, (io.opencannabis.schema.media.ImageType) content_);
    }
    if (contentCase_ == 201) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(201, (io.opencannabis.schema.media.DocumentType) content_);
    }
    if (contentCase_ == 301) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(301, (io.opencannabis.schema.media.VideoType) content_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.media.MediaType)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.media.MediaType other = (io.opencannabis.schema.media.MediaType) obj;

    boolean result = true;
    result = result && kind_ == other.kind_;
    result = result && getContentCase().equals(
        other.getContentCase());
    if (!result) return false;
    switch (contentCase_) {
      case 101:
        result = result && getImageType()
            .equals(other.getImageType());
        break;
      case 201:
        result = result && getDocumentType()
            .equals(other.getDocumentType());
        break;
      case 301:
        result = result && getVideoType()
            .equals(other.getVideoType());
        break;
      case 0:
      default:
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + KIND_FIELD_NUMBER;
    hash = (53 * hash) + kind_;
    switch (contentCase_) {
      case 101:
        hash = (37 * hash) + IMAGE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getImageType().hashCode();
        break;
      case 201:
        hash = (37 * hash) + DOCUMENT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentType().hashCode();
        break;
      case 301:
        hash = (37 * hash) + VIDEO_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getVideoType().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.media.MediaType parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.media.MediaType parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.media.MediaType parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.media.MediaType parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.media.MediaType parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.media.MediaType parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.media.MediaType parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.media.MediaType parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.media.MediaType parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.media.MediaType parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.media.MediaType parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.media.MediaType parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.media.MediaType prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies the type of media being attached or described.
   * </pre>
   *
   * Protobuf type {@code opencannabis.media.MediaType}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.media.MediaType)
      io.opencannabis.schema.media.MediaTypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.media.MediaItemType.internal_static_opencannabis_media_MediaType_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.media.MediaItemType.internal_static_opencannabis_media_MediaType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.media.MediaType.class, io.opencannabis.schema.media.MediaType.Builder.class);
    }

    // Construct using io.opencannabis.schema.media.MediaType.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      kind_ = 0;

      contentCase_ = 0;
      content_ = null;
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.media.MediaItemType.internal_static_opencannabis_media_MediaType_descriptor;
    }

    public io.opencannabis.schema.media.MediaType getDefaultInstanceForType() {
      return io.opencannabis.schema.media.MediaType.getDefaultInstance();
    }

    public io.opencannabis.schema.media.MediaType build() {
      io.opencannabis.schema.media.MediaType result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.media.MediaType buildPartial() {
      io.opencannabis.schema.media.MediaType result = new io.opencannabis.schema.media.MediaType(this);
      result.kind_ = kind_;
      if (contentCase_ == 101) {
        if (imageTypeBuilder_ == null) {
          result.content_ = content_;
        } else {
          result.content_ = imageTypeBuilder_.build();
        }
      }
      if (contentCase_ == 201) {
        if (documentTypeBuilder_ == null) {
          result.content_ = content_;
        } else {
          result.content_ = documentTypeBuilder_.build();
        }
      }
      if (contentCase_ == 301) {
        if (videoTypeBuilder_ == null) {
          result.content_ = content_;
        } else {
          result.content_ = videoTypeBuilder_.build();
        }
      }
      result.contentCase_ = contentCase_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.media.MediaType) {
        return mergeFrom((io.opencannabis.schema.media.MediaType)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.media.MediaType other) {
      if (other == io.opencannabis.schema.media.MediaType.getDefaultInstance()) return this;
      if (other.kind_ != 0) {
        setKindValue(other.getKindValue());
      }
      switch (other.getContentCase()) {
        case IMAGE_TYPE: {
          mergeImageType(other.getImageType());
          break;
        }
        case DOCUMENT_TYPE: {
          mergeDocumentType(other.getDocumentType());
          break;
        }
        case VIDEO_TYPE: {
          mergeVideoType(other.getVideoType());
          break;
        }
        case CONTENT_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.media.MediaType parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.media.MediaType) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int contentCase_ = 0;
    private java.lang.Object content_;
    public ContentCase
        getContentCase() {
      return ContentCase.forNumber(
          contentCase_);
    }

    public Builder clearContent() {
      contentCase_ = 0;
      content_ = null;
      onChanged();
      return this;
    }


    private int kind_ = 0;
    /**
     * <pre>
     * Specifies the generic kind of media being described or attached.
     * </pre>
     *
     * <code>.opencannabis.media.MediaType.Kind kind = 1 [(.gen_bq_schema.description) = "Specifies the generic kind of media being described or attached."];</code>
     */
    public int getKindValue() {
      return kind_;
    }
    /**
     * <pre>
     * Specifies the generic kind of media being described or attached.
     * </pre>
     *
     * <code>.opencannabis.media.MediaType.Kind kind = 1 [(.gen_bq_schema.description) = "Specifies the generic kind of media being described or attached."];</code>
     */
    public Builder setKindValue(int value) {
      kind_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the generic kind of media being described or attached.
     * </pre>
     *
     * <code>.opencannabis.media.MediaType.Kind kind = 1 [(.gen_bq_schema.description) = "Specifies the generic kind of media being described or attached."];</code>
     */
    public io.opencannabis.schema.media.MediaType.Kind getKind() {
      io.opencannabis.schema.media.MediaType.Kind result = io.opencannabis.schema.media.MediaType.Kind.valueOf(kind_);
      return result == null ? io.opencannabis.schema.media.MediaType.Kind.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies the generic kind of media being described or attached.
     * </pre>
     *
     * <code>.opencannabis.media.MediaType.Kind kind = 1 [(.gen_bq_schema.description) = "Specifies the generic kind of media being described or attached."];</code>
     */
    public Builder setKind(io.opencannabis.schema.media.MediaType.Kind value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      kind_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the generic kind of media being described or attached.
     * </pre>
     *
     * <code>.opencannabis.media.MediaType.Kind kind = 1 [(.gen_bq_schema.description) = "Specifies the generic kind of media being described or attached."];</code>
     */
    public Builder clearKind() {
      
      kind_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.media.ImageType, io.opencannabis.schema.media.ImageType.Builder, io.opencannabis.schema.media.ImageTypeOrBuilder> imageTypeBuilder_;
    /**
     * <pre>
     * Specifies content for an image-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.ImageType image_type = 101 [(.gen_bq_schema.description) = "Specifies content for an image-based media item."];</code>
     */
    public boolean hasImageType() {
      return contentCase_ == 101;
    }
    /**
     * <pre>
     * Specifies content for an image-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.ImageType image_type = 101 [(.gen_bq_schema.description) = "Specifies content for an image-based media item."];</code>
     */
    public io.opencannabis.schema.media.ImageType getImageType() {
      if (imageTypeBuilder_ == null) {
        if (contentCase_ == 101) {
          return (io.opencannabis.schema.media.ImageType) content_;
        }
        return io.opencannabis.schema.media.ImageType.getDefaultInstance();
      } else {
        if (contentCase_ == 101) {
          return imageTypeBuilder_.getMessage();
        }
        return io.opencannabis.schema.media.ImageType.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specifies content for an image-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.ImageType image_type = 101 [(.gen_bq_schema.description) = "Specifies content for an image-based media item."];</code>
     */
    public Builder setImageType(io.opencannabis.schema.media.ImageType value) {
      if (imageTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
        onChanged();
      } else {
        imageTypeBuilder_.setMessage(value);
      }
      contentCase_ = 101;
      return this;
    }
    /**
     * <pre>
     * Specifies content for an image-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.ImageType image_type = 101 [(.gen_bq_schema.description) = "Specifies content for an image-based media item."];</code>
     */
    public Builder setImageType(
        io.opencannabis.schema.media.ImageType.Builder builderForValue) {
      if (imageTypeBuilder_ == null) {
        content_ = builderForValue.build();
        onChanged();
      } else {
        imageTypeBuilder_.setMessage(builderForValue.build());
      }
      contentCase_ = 101;
      return this;
    }
    /**
     * <pre>
     * Specifies content for an image-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.ImageType image_type = 101 [(.gen_bq_schema.description) = "Specifies content for an image-based media item."];</code>
     */
    public Builder mergeImageType(io.opencannabis.schema.media.ImageType value) {
      if (imageTypeBuilder_ == null) {
        if (contentCase_ == 101 &&
            content_ != io.opencannabis.schema.media.ImageType.getDefaultInstance()) {
          content_ = io.opencannabis.schema.media.ImageType.newBuilder((io.opencannabis.schema.media.ImageType) content_)
              .mergeFrom(value).buildPartial();
        } else {
          content_ = value;
        }
        onChanged();
      } else {
        if (contentCase_ == 101) {
          imageTypeBuilder_.mergeFrom(value);
        }
        imageTypeBuilder_.setMessage(value);
      }
      contentCase_ = 101;
      return this;
    }
    /**
     * <pre>
     * Specifies content for an image-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.ImageType image_type = 101 [(.gen_bq_schema.description) = "Specifies content for an image-based media item."];</code>
     */
    public Builder clearImageType() {
      if (imageTypeBuilder_ == null) {
        if (contentCase_ == 101) {
          contentCase_ = 0;
          content_ = null;
          onChanged();
        }
      } else {
        if (contentCase_ == 101) {
          contentCase_ = 0;
          content_ = null;
        }
        imageTypeBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specifies content for an image-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.ImageType image_type = 101 [(.gen_bq_schema.description) = "Specifies content for an image-based media item."];</code>
     */
    public io.opencannabis.schema.media.ImageType.Builder getImageTypeBuilder() {
      return getImageTypeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies content for an image-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.ImageType image_type = 101 [(.gen_bq_schema.description) = "Specifies content for an image-based media item."];</code>
     */
    public io.opencannabis.schema.media.ImageTypeOrBuilder getImageTypeOrBuilder() {
      if ((contentCase_ == 101) && (imageTypeBuilder_ != null)) {
        return imageTypeBuilder_.getMessageOrBuilder();
      } else {
        if (contentCase_ == 101) {
          return (io.opencannabis.schema.media.ImageType) content_;
        }
        return io.opencannabis.schema.media.ImageType.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specifies content for an image-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.ImageType image_type = 101 [(.gen_bq_schema.description) = "Specifies content for an image-based media item."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.media.ImageType, io.opencannabis.schema.media.ImageType.Builder, io.opencannabis.schema.media.ImageTypeOrBuilder> 
        getImageTypeFieldBuilder() {
      if (imageTypeBuilder_ == null) {
        if (!(contentCase_ == 101)) {
          content_ = io.opencannabis.schema.media.ImageType.getDefaultInstance();
        }
        imageTypeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.media.ImageType, io.opencannabis.schema.media.ImageType.Builder, io.opencannabis.schema.media.ImageTypeOrBuilder>(
                (io.opencannabis.schema.media.ImageType) content_,
                getParentForChildren(),
                isClean());
        content_ = null;
      }
      contentCase_ = 101;
      onChanged();;
      return imageTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.media.DocumentType, io.opencannabis.schema.media.DocumentType.Builder, io.opencannabis.schema.media.DocumentTypeOrBuilder> documentTypeBuilder_;
    /**
     * <pre>
     * Specifies content for a document-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.DocumentType document_type = 201 [(.gen_bq_schema.description) = "Specifies content for a document-based media item."];</code>
     */
    public boolean hasDocumentType() {
      return contentCase_ == 201;
    }
    /**
     * <pre>
     * Specifies content for a document-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.DocumentType document_type = 201 [(.gen_bq_schema.description) = "Specifies content for a document-based media item."];</code>
     */
    public io.opencannabis.schema.media.DocumentType getDocumentType() {
      if (documentTypeBuilder_ == null) {
        if (contentCase_ == 201) {
          return (io.opencannabis.schema.media.DocumentType) content_;
        }
        return io.opencannabis.schema.media.DocumentType.getDefaultInstance();
      } else {
        if (contentCase_ == 201) {
          return documentTypeBuilder_.getMessage();
        }
        return io.opencannabis.schema.media.DocumentType.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specifies content for a document-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.DocumentType document_type = 201 [(.gen_bq_schema.description) = "Specifies content for a document-based media item."];</code>
     */
    public Builder setDocumentType(io.opencannabis.schema.media.DocumentType value) {
      if (documentTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
        onChanged();
      } else {
        documentTypeBuilder_.setMessage(value);
      }
      contentCase_ = 201;
      return this;
    }
    /**
     * <pre>
     * Specifies content for a document-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.DocumentType document_type = 201 [(.gen_bq_schema.description) = "Specifies content for a document-based media item."];</code>
     */
    public Builder setDocumentType(
        io.opencannabis.schema.media.DocumentType.Builder builderForValue) {
      if (documentTypeBuilder_ == null) {
        content_ = builderForValue.build();
        onChanged();
      } else {
        documentTypeBuilder_.setMessage(builderForValue.build());
      }
      contentCase_ = 201;
      return this;
    }
    /**
     * <pre>
     * Specifies content for a document-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.DocumentType document_type = 201 [(.gen_bq_schema.description) = "Specifies content for a document-based media item."];</code>
     */
    public Builder mergeDocumentType(io.opencannabis.schema.media.DocumentType value) {
      if (documentTypeBuilder_ == null) {
        if (contentCase_ == 201 &&
            content_ != io.opencannabis.schema.media.DocumentType.getDefaultInstance()) {
          content_ = io.opencannabis.schema.media.DocumentType.newBuilder((io.opencannabis.schema.media.DocumentType) content_)
              .mergeFrom(value).buildPartial();
        } else {
          content_ = value;
        }
        onChanged();
      } else {
        if (contentCase_ == 201) {
          documentTypeBuilder_.mergeFrom(value);
        }
        documentTypeBuilder_.setMessage(value);
      }
      contentCase_ = 201;
      return this;
    }
    /**
     * <pre>
     * Specifies content for a document-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.DocumentType document_type = 201 [(.gen_bq_schema.description) = "Specifies content for a document-based media item."];</code>
     */
    public Builder clearDocumentType() {
      if (documentTypeBuilder_ == null) {
        if (contentCase_ == 201) {
          contentCase_ = 0;
          content_ = null;
          onChanged();
        }
      } else {
        if (contentCase_ == 201) {
          contentCase_ = 0;
          content_ = null;
        }
        documentTypeBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specifies content for a document-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.DocumentType document_type = 201 [(.gen_bq_schema.description) = "Specifies content for a document-based media item."];</code>
     */
    public io.opencannabis.schema.media.DocumentType.Builder getDocumentTypeBuilder() {
      return getDocumentTypeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies content for a document-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.DocumentType document_type = 201 [(.gen_bq_schema.description) = "Specifies content for a document-based media item."];</code>
     */
    public io.opencannabis.schema.media.DocumentTypeOrBuilder getDocumentTypeOrBuilder() {
      if ((contentCase_ == 201) && (documentTypeBuilder_ != null)) {
        return documentTypeBuilder_.getMessageOrBuilder();
      } else {
        if (contentCase_ == 201) {
          return (io.opencannabis.schema.media.DocumentType) content_;
        }
        return io.opencannabis.schema.media.DocumentType.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specifies content for a document-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.DocumentType document_type = 201 [(.gen_bq_schema.description) = "Specifies content for a document-based media item."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.media.DocumentType, io.opencannabis.schema.media.DocumentType.Builder, io.opencannabis.schema.media.DocumentTypeOrBuilder> 
        getDocumentTypeFieldBuilder() {
      if (documentTypeBuilder_ == null) {
        if (!(contentCase_ == 201)) {
          content_ = io.opencannabis.schema.media.DocumentType.getDefaultInstance();
        }
        documentTypeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.media.DocumentType, io.opencannabis.schema.media.DocumentType.Builder, io.opencannabis.schema.media.DocumentTypeOrBuilder>(
                (io.opencannabis.schema.media.DocumentType) content_,
                getParentForChildren(),
                isClean());
        content_ = null;
      }
      contentCase_ = 201;
      onChanged();;
      return documentTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.media.VideoType, io.opencannabis.schema.media.VideoType.Builder, io.opencannabis.schema.media.VideoTypeOrBuilder> videoTypeBuilder_;
    /**
     * <pre>
     * Specifies content for a video-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.VideoType video_type = 301 [(.gen_bq_schema.description) = "Specifies content for a video-based media item."];</code>
     */
    public boolean hasVideoType() {
      return contentCase_ == 301;
    }
    /**
     * <pre>
     * Specifies content for a video-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.VideoType video_type = 301 [(.gen_bq_schema.description) = "Specifies content for a video-based media item."];</code>
     */
    public io.opencannabis.schema.media.VideoType getVideoType() {
      if (videoTypeBuilder_ == null) {
        if (contentCase_ == 301) {
          return (io.opencannabis.schema.media.VideoType) content_;
        }
        return io.opencannabis.schema.media.VideoType.getDefaultInstance();
      } else {
        if (contentCase_ == 301) {
          return videoTypeBuilder_.getMessage();
        }
        return io.opencannabis.schema.media.VideoType.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specifies content for a video-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.VideoType video_type = 301 [(.gen_bq_schema.description) = "Specifies content for a video-based media item."];</code>
     */
    public Builder setVideoType(io.opencannabis.schema.media.VideoType value) {
      if (videoTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
        onChanged();
      } else {
        videoTypeBuilder_.setMessage(value);
      }
      contentCase_ = 301;
      return this;
    }
    /**
     * <pre>
     * Specifies content for a video-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.VideoType video_type = 301 [(.gen_bq_schema.description) = "Specifies content for a video-based media item."];</code>
     */
    public Builder setVideoType(
        io.opencannabis.schema.media.VideoType.Builder builderForValue) {
      if (videoTypeBuilder_ == null) {
        content_ = builderForValue.build();
        onChanged();
      } else {
        videoTypeBuilder_.setMessage(builderForValue.build());
      }
      contentCase_ = 301;
      return this;
    }
    /**
     * <pre>
     * Specifies content for a video-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.VideoType video_type = 301 [(.gen_bq_schema.description) = "Specifies content for a video-based media item."];</code>
     */
    public Builder mergeVideoType(io.opencannabis.schema.media.VideoType value) {
      if (videoTypeBuilder_ == null) {
        if (contentCase_ == 301 &&
            content_ != io.opencannabis.schema.media.VideoType.getDefaultInstance()) {
          content_ = io.opencannabis.schema.media.VideoType.newBuilder((io.opencannabis.schema.media.VideoType) content_)
              .mergeFrom(value).buildPartial();
        } else {
          content_ = value;
        }
        onChanged();
      } else {
        if (contentCase_ == 301) {
          videoTypeBuilder_.mergeFrom(value);
        }
        videoTypeBuilder_.setMessage(value);
      }
      contentCase_ = 301;
      return this;
    }
    /**
     * <pre>
     * Specifies content for a video-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.VideoType video_type = 301 [(.gen_bq_schema.description) = "Specifies content for a video-based media item."];</code>
     */
    public Builder clearVideoType() {
      if (videoTypeBuilder_ == null) {
        if (contentCase_ == 301) {
          contentCase_ = 0;
          content_ = null;
          onChanged();
        }
      } else {
        if (contentCase_ == 301) {
          contentCase_ = 0;
          content_ = null;
        }
        videoTypeBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specifies content for a video-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.VideoType video_type = 301 [(.gen_bq_schema.description) = "Specifies content for a video-based media item."];</code>
     */
    public io.opencannabis.schema.media.VideoType.Builder getVideoTypeBuilder() {
      return getVideoTypeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies content for a video-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.VideoType video_type = 301 [(.gen_bq_schema.description) = "Specifies content for a video-based media item."];</code>
     */
    public io.opencannabis.schema.media.VideoTypeOrBuilder getVideoTypeOrBuilder() {
      if ((contentCase_ == 301) && (videoTypeBuilder_ != null)) {
        return videoTypeBuilder_.getMessageOrBuilder();
      } else {
        if (contentCase_ == 301) {
          return (io.opencannabis.schema.media.VideoType) content_;
        }
        return io.opencannabis.schema.media.VideoType.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specifies content for a video-based media item.
     * </pre>
     *
     * <code>.opencannabis.media.VideoType video_type = 301 [(.gen_bq_schema.description) = "Specifies content for a video-based media item."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.media.VideoType, io.opencannabis.schema.media.VideoType.Builder, io.opencannabis.schema.media.VideoTypeOrBuilder> 
        getVideoTypeFieldBuilder() {
      if (videoTypeBuilder_ == null) {
        if (!(contentCase_ == 301)) {
          content_ = io.opencannabis.schema.media.VideoType.getDefaultInstance();
        }
        videoTypeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.media.VideoType, io.opencannabis.schema.media.VideoType.Builder, io.opencannabis.schema.media.VideoTypeOrBuilder>(
                (io.opencannabis.schema.media.VideoType) content_,
                getParentForChildren(),
                isClean());
        content_ = null;
      }
      contentCase_ = 301;
      onChanged();;
      return videoTypeBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.media.MediaType)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.media.MediaType)
  private static final io.opencannabis.schema.media.MediaType DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.media.MediaType();
  }

  public static io.opencannabis.schema.media.MediaType getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MediaType>
      PARSER = new com.google.protobuf.AbstractParser<MediaType>() {
    public MediaType parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new MediaType(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<MediaType> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MediaType> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.media.MediaType getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

