/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: products/menu/Menu.proto

package io.opencannabis.schema.menu;

/**
 * <pre>
 * Specifies settings used to generate a menu, or used as input when generating menus.
 * </pre>
 *
 * Protobuf type {@code opencannabis.products.menu.MenuSettings}
 */
public  final class MenuSettings extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.products.menu.MenuSettings)
    MenuSettingsOrBuilder {
private static final long serialVersionUID = 0L;
  // Use MenuSettings.newBuilder() to construct.
  private MenuSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private MenuSettings() {
    full_ = false;
    keysOnly_ = false;
    section_ = java.util.Collections.emptyList();
    availableSection_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private MenuSettings(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {

            full_ = input.readBool();
            break;
          }
          case 16: {

            keysOnly_ = input.readBool();
            break;
          }
          case 26: {
            io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder subBuilder = null;
            if (snapshot_ != null) {
              subBuilder = snapshot_.toBuilder();
            }
            snapshot_ = input.readMessage(io.opencannabis.schema.crypto.primitives.integrity.Hash.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(snapshot_);
              snapshot_ = subBuilder.buildPartial();
            }

            break;
          }
          case 34: {
            io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder subBuilder = null;
            if (fingerprint_ != null) {
              subBuilder = fingerprint_.toBuilder();
            }
            fingerprint_ = input.readMessage(io.opencannabis.schema.crypto.primitives.integrity.Hash.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(fingerprint_);
              fingerprint_ = subBuilder.buildPartial();
            }

            break;
          }
          case 40: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
              section_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000010;
            }
            section_.add(rawValue);
            break;
          }
          case 42: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                section_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000010;
              }
              section_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
          case 48: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
              availableSection_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000020;
            }
            availableSection_.add(rawValue);
            break;
          }
          case 50: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                availableSection_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000020;
              }
              availableSection_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
        section_ = java.util.Collections.unmodifiableList(section_);
      }
      if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
        availableSection_ = java.util.Collections.unmodifiableList(availableSection_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_MenuSettings_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_MenuSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.menu.MenuSettings.class, io.opencannabis.schema.menu.MenuSettings.Builder.class);
  }

  private int bitField0_;
  public static final int FULL_FIELD_NUMBER = 1;
  private boolean full_;
  /**
   * <pre>
   * Flag indicating a full menu, including hidden/out-of-stock items.
   * </pre>
   *
   * <code>bool full = 1;</code>
   */
  public boolean getFull() {
    return full_;
  }

  public static final int KEYS_ONLY_FIELD_NUMBER = 2;
  private boolean keysOnly_;
  /**
   * <pre>
   * Only include menu keys, no detail data.
   * </pre>
   *
   * <code>bool keys_only = 2;</code>
   */
  public boolean getKeysOnly() {
    return keysOnly_;
  }

  public static final int SNAPSHOT_FIELD_NUMBER = 3;
  private io.opencannabis.schema.crypto.primitives.integrity.Hash snapshot_;
  /**
   * <pre>
   * Don't return the menu if it's identical to this fingerprint.
   * </pre>
   *
   * <code>.opencannabis.crypto.primitives.integrity.Hash snapshot = 3;</code>
   */
  public boolean hasSnapshot() {
    return snapshot_ != null;
  }
  /**
   * <pre>
   * Don't return the menu if it's identical to this fingerprint.
   * </pre>
   *
   * <code>.opencannabis.crypto.primitives.integrity.Hash snapshot = 3;</code>
   */
  public io.opencannabis.schema.crypto.primitives.integrity.Hash getSnapshot() {
    return snapshot_ == null ? io.opencannabis.schema.crypto.primitives.integrity.Hash.getDefaultInstance() : snapshot_;
  }
  /**
   * <pre>
   * Don't return the menu if it's identical to this fingerprint.
   * </pre>
   *
   * <code>.opencannabis.crypto.primitives.integrity.Hash snapshot = 3;</code>
   */
  public io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder getSnapshotOrBuilder() {
    return getSnapshot();
  }

  public static final int FINGERPRINT_FIELD_NUMBER = 4;
  private io.opencannabis.schema.crypto.primitives.integrity.Hash fingerprint_;
  /**
   * <pre>
   * Bloom filter to consider when returning or processing menu items.
   * </pre>
   *
   * <code>.opencannabis.crypto.primitives.integrity.Hash fingerprint = 4;</code>
   */
  public boolean hasFingerprint() {
    return fingerprint_ != null;
  }
  /**
   * <pre>
   * Bloom filter to consider when returning or processing menu items.
   * </pre>
   *
   * <code>.opencannabis.crypto.primitives.integrity.Hash fingerprint = 4;</code>
   */
  public io.opencannabis.schema.crypto.primitives.integrity.Hash getFingerprint() {
    return fingerprint_ == null ? io.opencannabis.schema.crypto.primitives.integrity.Hash.getDefaultInstance() : fingerprint_;
  }
  /**
   * <pre>
   * Bloom filter to consider when returning or processing menu items.
   * </pre>
   *
   * <code>.opencannabis.crypto.primitives.integrity.Hash fingerprint = 4;</code>
   */
  public io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder getFingerprintOrBuilder() {
    return getFingerprint();
  }

  public static final int SECTION_FIELD_NUMBER = 5;
  private java.util.List<java.lang.Integer> section_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.opencannabis.schema.menu.section.Section> section_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.opencannabis.schema.menu.section.Section>() {
            public io.opencannabis.schema.menu.section.Section convert(java.lang.Integer from) {
              io.opencannabis.schema.menu.section.Section result = io.opencannabis.schema.menu.section.Section.valueOf(from);
              return result == null ? io.opencannabis.schema.menu.section.Section.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Sections to include in the menu. If unspecified, include all sections.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
   */
  public java.util.List<io.opencannabis.schema.menu.section.Section> getSectionList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.opencannabis.schema.menu.section.Section>(section_, section_converter_);
  }
  /**
   * <pre>
   * Sections to include in the menu. If unspecified, include all sections.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
   */
  public int getSectionCount() {
    return section_.size();
  }
  /**
   * <pre>
   * Sections to include in the menu. If unspecified, include all sections.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
   */
  public io.opencannabis.schema.menu.section.Section getSection(int index) {
    return section_converter_.convert(section_.get(index));
  }
  /**
   * <pre>
   * Sections to include in the menu. If unspecified, include all sections.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
   */
  public java.util.List<java.lang.Integer>
  getSectionValueList() {
    return section_;
  }
  /**
   * <pre>
   * Sections to include in the menu. If unspecified, include all sections.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
   */
  public int getSectionValue(int index) {
    return section_.get(index);
  }
  private int sectionMemoizedSerializedSize;

  public static final int AVAILABLE_SECTION_FIELD_NUMBER = 6;
  private java.util.List<java.lang.Integer> availableSection_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.opencannabis.schema.menu.section.Section> availableSection_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.opencannabis.schema.menu.section.Section>() {
            public io.opencannabis.schema.menu.section.Section convert(java.lang.Integer from) {
              io.opencannabis.schema.menu.section.Section result = io.opencannabis.schema.menu.section.Section.valueOf(from);
              return result == null ? io.opencannabis.schema.menu.section.Section.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Hint for other available sections. Included on a sectioned menu payload with only one section.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
   */
  public java.util.List<io.opencannabis.schema.menu.section.Section> getAvailableSectionList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.opencannabis.schema.menu.section.Section>(availableSection_, availableSection_converter_);
  }
  /**
   * <pre>
   * Hint for other available sections. Included on a sectioned menu payload with only one section.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
   */
  public int getAvailableSectionCount() {
    return availableSection_.size();
  }
  /**
   * <pre>
   * Hint for other available sections. Included on a sectioned menu payload with only one section.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
   */
  public io.opencannabis.schema.menu.section.Section getAvailableSection(int index) {
    return availableSection_converter_.convert(availableSection_.get(index));
  }
  /**
   * <pre>
   * Hint for other available sections. Included on a sectioned menu payload with only one section.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
   */
  public java.util.List<java.lang.Integer>
  getAvailableSectionValueList() {
    return availableSection_;
  }
  /**
   * <pre>
   * Hint for other available sections. Included on a sectioned menu payload with only one section.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
   */
  public int getAvailableSectionValue(int index) {
    return availableSection_.get(index);
  }
  private int availableSectionMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (full_ != false) {
      output.writeBool(1, full_);
    }
    if (keysOnly_ != false) {
      output.writeBool(2, keysOnly_);
    }
    if (snapshot_ != null) {
      output.writeMessage(3, getSnapshot());
    }
    if (fingerprint_ != null) {
      output.writeMessage(4, getFingerprint());
    }
    if (getSectionList().size() > 0) {
      output.writeUInt32NoTag(42);
      output.writeUInt32NoTag(sectionMemoizedSerializedSize);
    }
    for (int i = 0; i < section_.size(); i++) {
      output.writeEnumNoTag(section_.get(i));
    }
    if (getAvailableSectionList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(availableSectionMemoizedSerializedSize);
    }
    for (int i = 0; i < availableSection_.size(); i++) {
      output.writeEnumNoTag(availableSection_.get(i));
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (full_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(1, full_);
    }
    if (keysOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(2, keysOnly_);
    }
    if (snapshot_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getSnapshot());
    }
    if (fingerprint_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getFingerprint());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < section_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(section_.get(i));
      }
      size += dataSize;
      if (!getSectionList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }sectionMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < availableSection_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(availableSection_.get(i));
      }
      size += dataSize;
      if (!getAvailableSectionList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }availableSectionMemoizedSerializedSize = dataSize;
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.menu.MenuSettings)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.menu.MenuSettings other = (io.opencannabis.schema.menu.MenuSettings) obj;

    boolean result = true;
    result = result && (getFull()
        == other.getFull());
    result = result && (getKeysOnly()
        == other.getKeysOnly());
    result = result && (hasSnapshot() == other.hasSnapshot());
    if (hasSnapshot()) {
      result = result && getSnapshot()
          .equals(other.getSnapshot());
    }
    result = result && (hasFingerprint() == other.hasFingerprint());
    if (hasFingerprint()) {
      result = result && getFingerprint()
          .equals(other.getFingerprint());
    }
    result = result && section_.equals(other.section_);
    result = result && availableSection_.equals(other.availableSection_);
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FULL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getFull());
    hash = (37 * hash) + KEYS_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getKeysOnly());
    if (hasSnapshot()) {
      hash = (37 * hash) + SNAPSHOT_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshot().hashCode();
    }
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (getSectionCount() > 0) {
      hash = (37 * hash) + SECTION_FIELD_NUMBER;
      hash = (53 * hash) + section_.hashCode();
    }
    if (getAvailableSectionCount() > 0) {
      hash = (37 * hash) + AVAILABLE_SECTION_FIELD_NUMBER;
      hash = (53 * hash) + availableSection_.hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.menu.MenuSettings parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.menu.MenuSettings parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.MenuSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.menu.MenuSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.MenuSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.menu.MenuSettings parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.MenuSettings parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.menu.MenuSettings parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.MenuSettings parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.menu.MenuSettings parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.MenuSettings parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.menu.MenuSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.menu.MenuSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies settings used to generate a menu, or used as input when generating menus.
   * </pre>
   *
   * Protobuf type {@code opencannabis.products.menu.MenuSettings}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.products.menu.MenuSettings)
      io.opencannabis.schema.menu.MenuSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_MenuSettings_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_MenuSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.menu.MenuSettings.class, io.opencannabis.schema.menu.MenuSettings.Builder.class);
    }

    // Construct using io.opencannabis.schema.menu.MenuSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      full_ = false;

      keysOnly_ = false;

      if (snapshotBuilder_ == null) {
        snapshot_ = null;
      } else {
        snapshot_ = null;
        snapshotBuilder_ = null;
      }
      if (fingerprintBuilder_ == null) {
        fingerprint_ = null;
      } else {
        fingerprint_ = null;
        fingerprintBuilder_ = null;
      }
      section_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      availableSection_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_MenuSettings_descriptor;
    }

    public io.opencannabis.schema.menu.MenuSettings getDefaultInstanceForType() {
      return io.opencannabis.schema.menu.MenuSettings.getDefaultInstance();
    }

    public io.opencannabis.schema.menu.MenuSettings build() {
      io.opencannabis.schema.menu.MenuSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.menu.MenuSettings buildPartial() {
      io.opencannabis.schema.menu.MenuSettings result = new io.opencannabis.schema.menu.MenuSettings(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.full_ = full_;
      result.keysOnly_ = keysOnly_;
      if (snapshotBuilder_ == null) {
        result.snapshot_ = snapshot_;
      } else {
        result.snapshot_ = snapshotBuilder_.build();
      }
      if (fingerprintBuilder_ == null) {
        result.fingerprint_ = fingerprint_;
      } else {
        result.fingerprint_ = fingerprintBuilder_.build();
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        section_ = java.util.Collections.unmodifiableList(section_);
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.section_ = section_;
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        availableSection_ = java.util.Collections.unmodifiableList(availableSection_);
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.availableSection_ = availableSection_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.menu.MenuSettings) {
        return mergeFrom((io.opencannabis.schema.menu.MenuSettings)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.menu.MenuSettings other) {
      if (other == io.opencannabis.schema.menu.MenuSettings.getDefaultInstance()) return this;
      if (other.getFull() != false) {
        setFull(other.getFull());
      }
      if (other.getKeysOnly() != false) {
        setKeysOnly(other.getKeysOnly());
      }
      if (other.hasSnapshot()) {
        mergeSnapshot(other.getSnapshot());
      }
      if (other.hasFingerprint()) {
        mergeFingerprint(other.getFingerprint());
      }
      if (!other.section_.isEmpty()) {
        if (section_.isEmpty()) {
          section_ = other.section_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureSectionIsMutable();
          section_.addAll(other.section_);
        }
        onChanged();
      }
      if (!other.availableSection_.isEmpty()) {
        if (availableSection_.isEmpty()) {
          availableSection_ = other.availableSection_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureAvailableSectionIsMutable();
          availableSection_.addAll(other.availableSection_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.menu.MenuSettings parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.menu.MenuSettings) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private boolean full_ ;
    /**
     * <pre>
     * Flag indicating a full menu, including hidden/out-of-stock items.
     * </pre>
     *
     * <code>bool full = 1;</code>
     */
    public boolean getFull() {
      return full_;
    }
    /**
     * <pre>
     * Flag indicating a full menu, including hidden/out-of-stock items.
     * </pre>
     *
     * <code>bool full = 1;</code>
     */
    public Builder setFull(boolean value) {
      
      full_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Flag indicating a full menu, including hidden/out-of-stock items.
     * </pre>
     *
     * <code>bool full = 1;</code>
     */
    public Builder clearFull() {
      
      full_ = false;
      onChanged();
      return this;
    }

    private boolean keysOnly_ ;
    /**
     * <pre>
     * Only include menu keys, no detail data.
     * </pre>
     *
     * <code>bool keys_only = 2;</code>
     */
    public boolean getKeysOnly() {
      return keysOnly_;
    }
    /**
     * <pre>
     * Only include menu keys, no detail data.
     * </pre>
     *
     * <code>bool keys_only = 2;</code>
     */
    public Builder setKeysOnly(boolean value) {
      
      keysOnly_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Only include menu keys, no detail data.
     * </pre>
     *
     * <code>bool keys_only = 2;</code>
     */
    public Builder clearKeysOnly() {
      
      keysOnly_ = false;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.crypto.primitives.integrity.Hash snapshot_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.crypto.primitives.integrity.Hash, io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder, io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder> snapshotBuilder_;
    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash snapshot = 3;</code>
     */
    public boolean hasSnapshot() {
      return snapshotBuilder_ != null || snapshot_ != null;
    }
    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash snapshot = 3;</code>
     */
    public io.opencannabis.schema.crypto.primitives.integrity.Hash getSnapshot() {
      if (snapshotBuilder_ == null) {
        return snapshot_ == null ? io.opencannabis.schema.crypto.primitives.integrity.Hash.getDefaultInstance() : snapshot_;
      } else {
        return snapshotBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash snapshot = 3;</code>
     */
    public Builder setSnapshot(io.opencannabis.schema.crypto.primitives.integrity.Hash value) {
      if (snapshotBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snapshot_ = value;
        onChanged();
      } else {
        snapshotBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash snapshot = 3;</code>
     */
    public Builder setSnapshot(
        io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder builderForValue) {
      if (snapshotBuilder_ == null) {
        snapshot_ = builderForValue.build();
        onChanged();
      } else {
        snapshotBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash snapshot = 3;</code>
     */
    public Builder mergeSnapshot(io.opencannabis.schema.crypto.primitives.integrity.Hash value) {
      if (snapshotBuilder_ == null) {
        if (snapshot_ != null) {
          snapshot_ =
            io.opencannabis.schema.crypto.primitives.integrity.Hash.newBuilder(snapshot_).mergeFrom(value).buildPartial();
        } else {
          snapshot_ = value;
        }
        onChanged();
      } else {
        snapshotBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash snapshot = 3;</code>
     */
    public Builder clearSnapshot() {
      if (snapshotBuilder_ == null) {
        snapshot_ = null;
        onChanged();
      } else {
        snapshot_ = null;
        snapshotBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash snapshot = 3;</code>
     */
    public io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder getSnapshotBuilder() {
      
      onChanged();
      return getSnapshotFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash snapshot = 3;</code>
     */
    public io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder getSnapshotOrBuilder() {
      if (snapshotBuilder_ != null) {
        return snapshotBuilder_.getMessageOrBuilder();
      } else {
        return snapshot_ == null ?
            io.opencannabis.schema.crypto.primitives.integrity.Hash.getDefaultInstance() : snapshot_;
      }
    }
    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash snapshot = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.crypto.primitives.integrity.Hash, io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder, io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder> 
        getSnapshotFieldBuilder() {
      if (snapshotBuilder_ == null) {
        snapshotBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.crypto.primitives.integrity.Hash, io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder, io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder>(
                getSnapshot(),
                getParentForChildren(),
                isClean());
        snapshot_ = null;
      }
      return snapshotBuilder_;
    }

    private io.opencannabis.schema.crypto.primitives.integrity.Hash fingerprint_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.crypto.primitives.integrity.Hash, io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder, io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder> fingerprintBuilder_;
    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash fingerprint = 4;</code>
     */
    public boolean hasFingerprint() {
      return fingerprintBuilder_ != null || fingerprint_ != null;
    }
    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash fingerprint = 4;</code>
     */
    public io.opencannabis.schema.crypto.primitives.integrity.Hash getFingerprint() {
      if (fingerprintBuilder_ == null) {
        return fingerprint_ == null ? io.opencannabis.schema.crypto.primitives.integrity.Hash.getDefaultInstance() : fingerprint_;
      } else {
        return fingerprintBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash fingerprint = 4;</code>
     */
    public Builder setFingerprint(io.opencannabis.schema.crypto.primitives.integrity.Hash value) {
      if (fingerprintBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fingerprint_ = value;
        onChanged();
      } else {
        fingerprintBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash fingerprint = 4;</code>
     */
    public Builder setFingerprint(
        io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder builderForValue) {
      if (fingerprintBuilder_ == null) {
        fingerprint_ = builderForValue.build();
        onChanged();
      } else {
        fingerprintBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash fingerprint = 4;</code>
     */
    public Builder mergeFingerprint(io.opencannabis.schema.crypto.primitives.integrity.Hash value) {
      if (fingerprintBuilder_ == null) {
        if (fingerprint_ != null) {
          fingerprint_ =
            io.opencannabis.schema.crypto.primitives.integrity.Hash.newBuilder(fingerprint_).mergeFrom(value).buildPartial();
        } else {
          fingerprint_ = value;
        }
        onChanged();
      } else {
        fingerprintBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash fingerprint = 4;</code>
     */
    public Builder clearFingerprint() {
      if (fingerprintBuilder_ == null) {
        fingerprint_ = null;
        onChanged();
      } else {
        fingerprint_ = null;
        fingerprintBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash fingerprint = 4;</code>
     */
    public io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder getFingerprintBuilder() {
      
      onChanged();
      return getFingerprintFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash fingerprint = 4;</code>
     */
    public io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder getFingerprintOrBuilder() {
      if (fingerprintBuilder_ != null) {
        return fingerprintBuilder_.getMessageOrBuilder();
      } else {
        return fingerprint_ == null ?
            io.opencannabis.schema.crypto.primitives.integrity.Hash.getDefaultInstance() : fingerprint_;
      }
    }
    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash fingerprint = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.crypto.primitives.integrity.Hash, io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder, io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder> 
        getFingerprintFieldBuilder() {
      if (fingerprintBuilder_ == null) {
        fingerprintBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.crypto.primitives.integrity.Hash, io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder, io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder>(
                getFingerprint(),
                getParentForChildren(),
                isClean());
        fingerprint_ = null;
      }
      return fingerprintBuilder_;
    }

    private java.util.List<java.lang.Integer> section_ =
      java.util.Collections.emptyList();
    private void ensureSectionIsMutable() {
      if (!((bitField0_ & 0x00000010) == 0x00000010)) {
        section_ = new java.util.ArrayList<java.lang.Integer>(section_);
        bitField0_ |= 0x00000010;
      }
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
     */
    public java.util.List<io.opencannabis.schema.menu.section.Section> getSectionList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.menu.section.Section>(section_, section_converter_);
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
     */
    public int getSectionCount() {
      return section_.size();
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
     */
    public io.opencannabis.schema.menu.section.Section getSection(int index) {
      return section_converter_.convert(section_.get(index));
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
     */
    public Builder setSection(
        int index, io.opencannabis.schema.menu.section.Section value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSectionIsMutable();
      section_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
     */
    public Builder addSection(io.opencannabis.schema.menu.section.Section value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSectionIsMutable();
      section_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
     */
    public Builder addAllSection(
        java.lang.Iterable<? extends io.opencannabis.schema.menu.section.Section> values) {
      ensureSectionIsMutable();
      for (io.opencannabis.schema.menu.section.Section value : values) {
        section_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
     */
    public Builder clearSection() {
      section_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
     */
    public java.util.List<java.lang.Integer>
    getSectionValueList() {
      return java.util.Collections.unmodifiableList(section_);
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
     */
    public int getSectionValue(int index) {
      return section_.get(index);
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
     */
    public Builder setSectionValue(
        int index, int value) {
      ensureSectionIsMutable();
      section_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
     */
    public Builder addSectionValue(int value) {
      ensureSectionIsMutable();
      section_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 5;</code>
     */
    public Builder addAllSectionValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureSectionIsMutable();
      for (int value : values) {
        section_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> availableSection_ =
      java.util.Collections.emptyList();
    private void ensureAvailableSectionIsMutable() {
      if (!((bitField0_ & 0x00000020) == 0x00000020)) {
        availableSection_ = new java.util.ArrayList<java.lang.Integer>(availableSection_);
        bitField0_ |= 0x00000020;
      }
    }
    /**
     * <pre>
     * Hint for other available sections. Included on a sectioned menu payload with only one section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
     */
    public java.util.List<io.opencannabis.schema.menu.section.Section> getAvailableSectionList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.menu.section.Section>(availableSection_, availableSection_converter_);
    }
    /**
     * <pre>
     * Hint for other available sections. Included on a sectioned menu payload with only one section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
     */
    public int getAvailableSectionCount() {
      return availableSection_.size();
    }
    /**
     * <pre>
     * Hint for other available sections. Included on a sectioned menu payload with only one section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
     */
    public io.opencannabis.schema.menu.section.Section getAvailableSection(int index) {
      return availableSection_converter_.convert(availableSection_.get(index));
    }
    /**
     * <pre>
     * Hint for other available sections. Included on a sectioned menu payload with only one section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
     */
    public Builder setAvailableSection(
        int index, io.opencannabis.schema.menu.section.Section value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAvailableSectionIsMutable();
      availableSection_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Hint for other available sections. Included on a sectioned menu payload with only one section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
     */
    public Builder addAvailableSection(io.opencannabis.schema.menu.section.Section value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAvailableSectionIsMutable();
      availableSection_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Hint for other available sections. Included on a sectioned menu payload with only one section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
     */
    public Builder addAllAvailableSection(
        java.lang.Iterable<? extends io.opencannabis.schema.menu.section.Section> values) {
      ensureAvailableSectionIsMutable();
      for (io.opencannabis.schema.menu.section.Section value : values) {
        availableSection_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Hint for other available sections. Included on a sectioned menu payload with only one section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
     */
    public Builder clearAvailableSection() {
      availableSection_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Hint for other available sections. Included on a sectioned menu payload with only one section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
     */
    public java.util.List<java.lang.Integer>
    getAvailableSectionValueList() {
      return java.util.Collections.unmodifiableList(availableSection_);
    }
    /**
     * <pre>
     * Hint for other available sections. Included on a sectioned menu payload with only one section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
     */
    public int getAvailableSectionValue(int index) {
      return availableSection_.get(index);
    }
    /**
     * <pre>
     * Hint for other available sections. Included on a sectioned menu payload with only one section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
     */
    public Builder setAvailableSectionValue(
        int index, int value) {
      ensureAvailableSectionIsMutable();
      availableSection_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Hint for other available sections. Included on a sectioned menu payload with only one section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
     */
    public Builder addAvailableSectionValue(int value) {
      ensureAvailableSectionIsMutable();
      availableSection_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Hint for other available sections. Included on a sectioned menu payload with only one section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section available_section = 6;</code>
     */
    public Builder addAllAvailableSectionValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureAvailableSectionIsMutable();
      for (int value : values) {
        availableSection_.add(value);
      }
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.products.menu.MenuSettings)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.products.menu.MenuSettings)
  private static final io.opencannabis.schema.menu.MenuSettings DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.menu.MenuSettings();
  }

  public static io.opencannabis.schema.menu.MenuSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MenuSettings>
      PARSER = new com.google.protobuf.AbstractParser<MenuSettings>() {
    public MenuSettings parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new MenuSettings(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<MenuSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MenuSettings> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.menu.MenuSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

