/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: products/menu/Menu.proto

package io.opencannabis.schema.menu;

/**
 * <pre>
 * Specifies metadata for a package of menu data.
 * </pre>
 *
 * Protobuf type {@code opencannabis.products.menu.Metadata}
 */
public  final class Metadata extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.products.menu.Metadata)
    MetadataOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Metadata.newBuilder() to construct.
  private Metadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Metadata() {
    scope_ = "";
    version_ = 0L;
    status_ = 0;
    flags_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Metadata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            scope_ = s;
            break;
          }
          case 16: {

            version_ = input.readUInt64();
            break;
          }
          case 24: {
            int rawValue = input.readEnum();

            status_ = rawValue;
            break;
          }
          case 32: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
              flags_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000008;
            }
            flags_.add(rawValue);
            break;
          }
          case 34: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                flags_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000008;
              }
              flags_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
          case 42: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (published_ != null) {
              subBuilder = published_.toBuilder();
            }
            published_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(published_);
              published_ = subBuilder.buildPartial();
            }

            break;
          }
          case 50: {
            io.opencannabis.schema.menu.MenuSettings.Builder subBuilder = null;
            if (settings_ != null) {
              subBuilder = settings_.toBuilder();
            }
            settings_ = input.readMessage(io.opencannabis.schema.menu.MenuSettings.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(settings_);
              settings_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
        flags_ = java.util.Collections.unmodifiableList(flags_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_Metadata_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_Metadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.menu.Metadata.class, io.opencannabis.schema.menu.Metadata.Builder.class);
  }

  private int bitField0_;
  public static final int SCOPE_FIELD_NUMBER = 1;
  private volatile java.lang.Object scope_;
  /**
   * <pre>
   * Partner location that owns this menu data.
   * </pre>
   *
   * <code>string scope = 1;</code>
   */
  public java.lang.String getScope() {
    java.lang.Object ref = scope_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      scope_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Partner location that owns this menu data.
   * </pre>
   *
   * <code>string scope = 1;</code>
   */
  public com.google.protobuf.ByteString
      getScopeBytes() {
    java.lang.Object ref = scope_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      scope_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_FIELD_NUMBER = 2;
  private long version_;
  /**
   * <pre>
   * Version number, or publish timestamp, of this data.
   * </pre>
   *
   * <code>uint64 version = 2;</code>
   */
  public long getVersion() {
    return version_;
  }

  public static final int STATUS_FIELD_NUMBER = 3;
  private int status_;
  /**
   * <pre>
   * Status of this menu data.
   * </pre>
   *
   * <code>.opencannabis.products.menu.Status status = 3;</code>
   */
  public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * Status of this menu data.
   * </pre>
   *
   * <code>.opencannabis.products.menu.Status status = 3;</code>
   */
  public io.opencannabis.schema.menu.Status getStatus() {
    io.opencannabis.schema.menu.Status result = io.opencannabis.schema.menu.Status.valueOf(status_);
    return result == null ? io.opencannabis.schema.menu.Status.UNRECOGNIZED : result;
  }

  public static final int FLAGS_FIELD_NUMBER = 4;
  private java.util.List<java.lang.Integer> flags_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.opencannabis.schema.menu.Flag> flags_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.opencannabis.schema.menu.Flag>() {
            public io.opencannabis.schema.menu.Flag convert(java.lang.Integer from) {
              io.opencannabis.schema.menu.Flag result = io.opencannabis.schema.menu.Flag.valueOf(from);
              return result == null ? io.opencannabis.schema.menu.Flag.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Flags attached to this menu data.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
   */
  public java.util.List<io.opencannabis.schema.menu.Flag> getFlagsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.opencannabis.schema.menu.Flag>(flags_, flags_converter_);
  }
  /**
   * <pre>
   * Flags attached to this menu data.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
   */
  public int getFlagsCount() {
    return flags_.size();
  }
  /**
   * <pre>
   * Flags attached to this menu data.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
   */
  public io.opencannabis.schema.menu.Flag getFlags(int index) {
    return flags_converter_.convert(flags_.get(index));
  }
  /**
   * <pre>
   * Flags attached to this menu data.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
   */
  public java.util.List<java.lang.Integer>
  getFlagsValueList() {
    return flags_;
  }
  /**
   * <pre>
   * Flags attached to this menu data.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
   */
  public int getFlagsValue(int index) {
    return flags_.get(index);
  }
  private int flagsMemoizedSerializedSize;

  public static final int PUBLISHED_FIELD_NUMBER = 5;
  private io.opencannabis.schema.temporal.Instant published_;
  /**
   * <pre>
   * When this menu data was published.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant published = 5;</code>
   */
  public boolean hasPublished() {
    return published_ != null;
  }
  /**
   * <pre>
   * When this menu data was published.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant published = 5;</code>
   */
  public io.opencannabis.schema.temporal.Instant getPublished() {
    return published_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : published_;
  }
  /**
   * <pre>
   * When this menu data was published.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant published = 5;</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getPublishedOrBuilder() {
    return getPublished();
  }

  public static final int SETTINGS_FIELD_NUMBER = 6;
  private io.opencannabis.schema.menu.MenuSettings settings_;
  /**
   * <pre>
   * Settings that produced this menu data.
   * </pre>
   *
   * <code>.opencannabis.products.menu.MenuSettings settings = 6;</code>
   */
  public boolean hasSettings() {
    return settings_ != null;
  }
  /**
   * <pre>
   * Settings that produced this menu data.
   * </pre>
   *
   * <code>.opencannabis.products.menu.MenuSettings settings = 6;</code>
   */
  public io.opencannabis.schema.menu.MenuSettings getSettings() {
    return settings_ == null ? io.opencannabis.schema.menu.MenuSettings.getDefaultInstance() : settings_;
  }
  /**
   * <pre>
   * Settings that produced this menu data.
   * </pre>
   *
   * <code>.opencannabis.products.menu.MenuSettings settings = 6;</code>
   */
  public io.opencannabis.schema.menu.MenuSettingsOrBuilder getSettingsOrBuilder() {
    return getSettings();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (!getScopeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, scope_);
    }
    if (version_ != 0L) {
      output.writeUInt64(2, version_);
    }
    if (status_ != io.opencannabis.schema.menu.Status.UNPUBLISHED.getNumber()) {
      output.writeEnum(3, status_);
    }
    if (getFlagsList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(flagsMemoizedSerializedSize);
    }
    for (int i = 0; i < flags_.size(); i++) {
      output.writeEnumNoTag(flags_.get(i));
    }
    if (published_ != null) {
      output.writeMessage(5, getPublished());
    }
    if (settings_ != null) {
      output.writeMessage(6, getSettings());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getScopeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, scope_);
    }
    if (version_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt64Size(2, version_);
    }
    if (status_ != io.opencannabis.schema.menu.Status.UNPUBLISHED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, status_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < flags_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(flags_.get(i));
      }
      size += dataSize;
      if (!getFlagsList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }flagsMemoizedSerializedSize = dataSize;
    }
    if (published_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getPublished());
    }
    if (settings_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getSettings());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.menu.Metadata)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.menu.Metadata other = (io.opencannabis.schema.menu.Metadata) obj;

    boolean result = true;
    result = result && getScope()
        .equals(other.getScope());
    result = result && (getVersion()
        == other.getVersion());
    result = result && status_ == other.status_;
    result = result && flags_.equals(other.flags_);
    result = result && (hasPublished() == other.hasPublished());
    if (hasPublished()) {
      result = result && getPublished()
          .equals(other.getPublished());
    }
    result = result && (hasSettings() == other.hasSettings());
    if (hasSettings()) {
      result = result && getSettings()
          .equals(other.getSettings());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SCOPE_FIELD_NUMBER;
    hash = (53 * hash) + getScope().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getVersion());
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    if (getFlagsCount() > 0) {
      hash = (37 * hash) + FLAGS_FIELD_NUMBER;
      hash = (53 * hash) + flags_.hashCode();
    }
    if (hasPublished()) {
      hash = (37 * hash) + PUBLISHED_FIELD_NUMBER;
      hash = (53 * hash) + getPublished().hashCode();
    }
    if (hasSettings()) {
      hash = (37 * hash) + SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSettings().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.menu.Metadata parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.menu.Metadata parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.Metadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.menu.Metadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.Metadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.menu.Metadata parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.Metadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.menu.Metadata parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.Metadata parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.menu.Metadata parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.Metadata parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.menu.Metadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.menu.Metadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies metadata for a package of menu data.
   * </pre>
   *
   * Protobuf type {@code opencannabis.products.menu.Metadata}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.products.menu.Metadata)
      io.opencannabis.schema.menu.MetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_Metadata_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_Metadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.menu.Metadata.class, io.opencannabis.schema.menu.Metadata.Builder.class);
    }

    // Construct using io.opencannabis.schema.menu.Metadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      scope_ = "";

      version_ = 0L;

      status_ = 0;

      flags_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      if (publishedBuilder_ == null) {
        published_ = null;
      } else {
        published_ = null;
        publishedBuilder_ = null;
      }
      if (settingsBuilder_ == null) {
        settings_ = null;
      } else {
        settings_ = null;
        settingsBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_Metadata_descriptor;
    }

    public io.opencannabis.schema.menu.Metadata getDefaultInstanceForType() {
      return io.opencannabis.schema.menu.Metadata.getDefaultInstance();
    }

    public io.opencannabis.schema.menu.Metadata build() {
      io.opencannabis.schema.menu.Metadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.menu.Metadata buildPartial() {
      io.opencannabis.schema.menu.Metadata result = new io.opencannabis.schema.menu.Metadata(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.scope_ = scope_;
      result.version_ = version_;
      result.status_ = status_;
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        flags_ = java.util.Collections.unmodifiableList(flags_);
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.flags_ = flags_;
      if (publishedBuilder_ == null) {
        result.published_ = published_;
      } else {
        result.published_ = publishedBuilder_.build();
      }
      if (settingsBuilder_ == null) {
        result.settings_ = settings_;
      } else {
        result.settings_ = settingsBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.menu.Metadata) {
        return mergeFrom((io.opencannabis.schema.menu.Metadata)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.menu.Metadata other) {
      if (other == io.opencannabis.schema.menu.Metadata.getDefaultInstance()) return this;
      if (!other.getScope().isEmpty()) {
        scope_ = other.scope_;
        onChanged();
      }
      if (other.getVersion() != 0L) {
        setVersion(other.getVersion());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (!other.flags_.isEmpty()) {
        if (flags_.isEmpty()) {
          flags_ = other.flags_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureFlagsIsMutable();
          flags_.addAll(other.flags_);
        }
        onChanged();
      }
      if (other.hasPublished()) {
        mergePublished(other.getPublished());
      }
      if (other.hasSettings()) {
        mergeSettings(other.getSettings());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.menu.Metadata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.menu.Metadata) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object scope_ = "";
    /**
     * <pre>
     * Partner location that owns this menu data.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public java.lang.String getScope() {
      java.lang.Object ref = scope_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        scope_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Partner location that owns this menu data.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public com.google.protobuf.ByteString
        getScopeBytes() {
      java.lang.Object ref = scope_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        scope_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Partner location that owns this menu data.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public Builder setScope(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      scope_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Partner location that owns this menu data.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public Builder clearScope() {
      
      scope_ = getDefaultInstance().getScope();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Partner location that owns this menu data.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public Builder setScopeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      scope_ = value;
      onChanged();
      return this;
    }

    private long version_ ;
    /**
     * <pre>
     * Version number, or publish timestamp, of this data.
     * </pre>
     *
     * <code>uint64 version = 2;</code>
     */
    public long getVersion() {
      return version_;
    }
    /**
     * <pre>
     * Version number, or publish timestamp, of this data.
     * </pre>
     *
     * <code>uint64 version = 2;</code>
     */
    public Builder setVersion(long value) {
      
      version_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Version number, or publish timestamp, of this data.
     * </pre>
     *
     * <code>uint64 version = 2;</code>
     */
    public Builder clearVersion() {
      
      version_ = 0L;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * Status of this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.Status status = 3;</code>
     */
    public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Status of this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.Status status = 3;</code>
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Status of this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.Status status = 3;</code>
     */
    public io.opencannabis.schema.menu.Status getStatus() {
      io.opencannabis.schema.menu.Status result = io.opencannabis.schema.menu.Status.valueOf(status_);
      return result == null ? io.opencannabis.schema.menu.Status.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Status of this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.Status status = 3;</code>
     */
    public Builder setStatus(io.opencannabis.schema.menu.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Status of this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.Status status = 3;</code>
     */
    public Builder clearStatus() {
      
      status_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> flags_ =
      java.util.Collections.emptyList();
    private void ensureFlagsIsMutable() {
      if (!((bitField0_ & 0x00000008) == 0x00000008)) {
        flags_ = new java.util.ArrayList<java.lang.Integer>(flags_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     * <pre>
     * Flags attached to this menu data.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
     */
    public java.util.List<io.opencannabis.schema.menu.Flag> getFlagsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.menu.Flag>(flags_, flags_converter_);
    }
    /**
     * <pre>
     * Flags attached to this menu data.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
     */
    public int getFlagsCount() {
      return flags_.size();
    }
    /**
     * <pre>
     * Flags attached to this menu data.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
     */
    public io.opencannabis.schema.menu.Flag getFlags(int index) {
      return flags_converter_.convert(flags_.get(index));
    }
    /**
     * <pre>
     * Flags attached to this menu data.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
     */
    public Builder setFlags(
        int index, io.opencannabis.schema.menu.Flag value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFlagsIsMutable();
      flags_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Flags attached to this menu data.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
     */
    public Builder addFlags(io.opencannabis.schema.menu.Flag value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFlagsIsMutable();
      flags_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Flags attached to this menu data.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
     */
    public Builder addAllFlags(
        java.lang.Iterable<? extends io.opencannabis.schema.menu.Flag> values) {
      ensureFlagsIsMutable();
      for (io.opencannabis.schema.menu.Flag value : values) {
        flags_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Flags attached to this menu data.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
     */
    public Builder clearFlags() {
      flags_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Flags attached to this menu data.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
     */
    public java.util.List<java.lang.Integer>
    getFlagsValueList() {
      return java.util.Collections.unmodifiableList(flags_);
    }
    /**
     * <pre>
     * Flags attached to this menu data.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
     */
    public int getFlagsValue(int index) {
      return flags_.get(index);
    }
    /**
     * <pre>
     * Flags attached to this menu data.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
     */
    public Builder setFlagsValue(
        int index, int value) {
      ensureFlagsIsMutable();
      flags_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Flags attached to this menu data.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
     */
    public Builder addFlagsValue(int value) {
      ensureFlagsIsMutable();
      flags_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Flags attached to this menu data.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.Flag flags = 4;</code>
     */
    public Builder addAllFlagsValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureFlagsIsMutable();
      for (int value : values) {
        flags_.add(value);
      }
      onChanged();
      return this;
    }

    private io.opencannabis.schema.temporal.Instant published_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> publishedBuilder_;
    /**
     * <pre>
     * When this menu data was published.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 5;</code>
     */
    public boolean hasPublished() {
      return publishedBuilder_ != null || published_ != null;
    }
    /**
     * <pre>
     * When this menu data was published.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 5;</code>
     */
    public io.opencannabis.schema.temporal.Instant getPublished() {
      if (publishedBuilder_ == null) {
        return published_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : published_;
      } else {
        return publishedBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * When this menu data was published.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 5;</code>
     */
    public Builder setPublished(io.opencannabis.schema.temporal.Instant value) {
      if (publishedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        published_ = value;
        onChanged();
      } else {
        publishedBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * When this menu data was published.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 5;</code>
     */
    public Builder setPublished(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (publishedBuilder_ == null) {
        published_ = builderForValue.build();
        onChanged();
      } else {
        publishedBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * When this menu data was published.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 5;</code>
     */
    public Builder mergePublished(io.opencannabis.schema.temporal.Instant value) {
      if (publishedBuilder_ == null) {
        if (published_ != null) {
          published_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(published_).mergeFrom(value).buildPartial();
        } else {
          published_ = value;
        }
        onChanged();
      } else {
        publishedBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * When this menu data was published.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 5;</code>
     */
    public Builder clearPublished() {
      if (publishedBuilder_ == null) {
        published_ = null;
        onChanged();
      } else {
        published_ = null;
        publishedBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * When this menu data was published.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 5;</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getPublishedBuilder() {
      
      onChanged();
      return getPublishedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * When this menu data was published.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 5;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getPublishedOrBuilder() {
      if (publishedBuilder_ != null) {
        return publishedBuilder_.getMessageOrBuilder();
      } else {
        return published_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : published_;
      }
    }
    /**
     * <pre>
     * When this menu data was published.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getPublishedFieldBuilder() {
      if (publishedBuilder_ == null) {
        publishedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getPublished(),
                getParentForChildren(),
                isClean());
        published_ = null;
      }
      return publishedBuilder_;
    }

    private io.opencannabis.schema.menu.MenuSettings settings_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.menu.MenuSettings, io.opencannabis.schema.menu.MenuSettings.Builder, io.opencannabis.schema.menu.MenuSettingsOrBuilder> settingsBuilder_;
    /**
     * <pre>
     * Settings that produced this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.MenuSettings settings = 6;</code>
     */
    public boolean hasSettings() {
      return settingsBuilder_ != null || settings_ != null;
    }
    /**
     * <pre>
     * Settings that produced this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.MenuSettings settings = 6;</code>
     */
    public io.opencannabis.schema.menu.MenuSettings getSettings() {
      if (settingsBuilder_ == null) {
        return settings_ == null ? io.opencannabis.schema.menu.MenuSettings.getDefaultInstance() : settings_;
      } else {
        return settingsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Settings that produced this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.MenuSettings settings = 6;</code>
     */
    public Builder setSettings(io.opencannabis.schema.menu.MenuSettings value) {
      if (settingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        settings_ = value;
        onChanged();
      } else {
        settingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Settings that produced this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.MenuSettings settings = 6;</code>
     */
    public Builder setSettings(
        io.opencannabis.schema.menu.MenuSettings.Builder builderForValue) {
      if (settingsBuilder_ == null) {
        settings_ = builderForValue.build();
        onChanged();
      } else {
        settingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Settings that produced this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.MenuSettings settings = 6;</code>
     */
    public Builder mergeSettings(io.opencannabis.schema.menu.MenuSettings value) {
      if (settingsBuilder_ == null) {
        if (settings_ != null) {
          settings_ =
            io.opencannabis.schema.menu.MenuSettings.newBuilder(settings_).mergeFrom(value).buildPartial();
        } else {
          settings_ = value;
        }
        onChanged();
      } else {
        settingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Settings that produced this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.MenuSettings settings = 6;</code>
     */
    public Builder clearSettings() {
      if (settingsBuilder_ == null) {
        settings_ = null;
        onChanged();
      } else {
        settings_ = null;
        settingsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Settings that produced this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.MenuSettings settings = 6;</code>
     */
    public io.opencannabis.schema.menu.MenuSettings.Builder getSettingsBuilder() {
      
      onChanged();
      return getSettingsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Settings that produced this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.MenuSettings settings = 6;</code>
     */
    public io.opencannabis.schema.menu.MenuSettingsOrBuilder getSettingsOrBuilder() {
      if (settingsBuilder_ != null) {
        return settingsBuilder_.getMessageOrBuilder();
      } else {
        return settings_ == null ?
            io.opencannabis.schema.menu.MenuSettings.getDefaultInstance() : settings_;
      }
    }
    /**
     * <pre>
     * Settings that produced this menu data.
     * </pre>
     *
     * <code>.opencannabis.products.menu.MenuSettings settings = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.menu.MenuSettings, io.opencannabis.schema.menu.MenuSettings.Builder, io.opencannabis.schema.menu.MenuSettingsOrBuilder> 
        getSettingsFieldBuilder() {
      if (settingsBuilder_ == null) {
        settingsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.menu.MenuSettings, io.opencannabis.schema.menu.MenuSettings.Builder, io.opencannabis.schema.menu.MenuSettingsOrBuilder>(
                getSettings(),
                getParentForChildren(),
                isClean());
        settings_ = null;
      }
      return settingsBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.products.menu.Metadata)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.products.menu.Metadata)
  private static final io.opencannabis.schema.menu.Metadata DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.menu.Metadata();
  }

  public static io.opencannabis.schema.menu.Metadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Metadata>
      PARSER = new com.google.protobuf.AbstractParser<Metadata>() {
    public Metadata parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Metadata(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Metadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Metadata> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.menu.Metadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

