/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: products/menu/Menu.proto

package io.opencannabis.schema.menu;

/**
 * <pre>
 * Specifies an inner menu payload which contains mapped data, where each map key is a section name, lowercased, and
 * each map value is itself a product, and each map is addressed at a typed property name.
 * </pre>
 *
 * Protobuf type {@code opencannabis.products.menu.StaticMenu}
 */
public  final class StaticMenu extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.products.menu.StaticMenu)
    StaticMenuOrBuilder {
private static final long serialVersionUID = 0L;
  // Use StaticMenu.newBuilder() to construct.
  private StaticMenu(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private StaticMenu() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private StaticMenu(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
              apothecary_ = com.google.protobuf.MapField.newMapField(
                  ApothecaryDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000001;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary>
            apothecary__ = input.readMessage(
                ApothecaryDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            apothecary_.getMutableMap().put(
                apothecary__.getKey(), apothecary__.getValue());
            break;
          }
          case 18: {
            if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
              cartridges_ = com.google.protobuf.MapField.newMapField(
                  CartridgesDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000002;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge>
            cartridges__ = input.readMessage(
                CartridgesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            cartridges_.getMutableMap().put(
                cartridges__.getKey(), cartridges__.getValue());
            break;
          }
          case 26: {
            if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
              edibles_ = com.google.protobuf.MapField.newMapField(
                  EdiblesDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000004;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible>
            edibles__ = input.readMessage(
                EdiblesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            edibles_.getMutableMap().put(
                edibles__.getKey(), edibles__.getValue());
            break;
          }
          case 34: {
            if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
              extracts_ = com.google.protobuf.MapField.newMapField(
                  ExtractsDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000008;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract>
            extracts__ = input.readMessage(
                ExtractsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            extracts_.getMutableMap().put(
                extracts__.getKey(), extracts__.getValue());
            break;
          }
          case 42: {
            if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
              flowers_ = com.google.protobuf.MapField.newMapField(
                  FlowersDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000010;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower>
            flowers__ = input.readMessage(
                FlowersDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            flowers_.getMutableMap().put(
                flowers__.getKey(), flowers__.getValue());
            break;
          }
          case 50: {
            if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
              merchandise_ = com.google.protobuf.MapField.newMapField(
                  MerchandiseDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000020;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise>
            merchandise__ = input.readMessage(
                MerchandiseDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            merchandise_.getMutableMap().put(
                merchandise__.getKey(), merchandise__.getValue());
            break;
          }
          case 58: {
            if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
              plants_ = com.google.protobuf.MapField.newMapField(
                  PlantsDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000040;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant>
            plants__ = input.readMessage(
                PlantsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            plants_.getMutableMap().put(
                plants__.getKey(), plants__.getValue());
            break;
          }
          case 66: {
            if (!((mutable_bitField0_ & 0x00000080) == 0x00000080)) {
              prerolls_ = com.google.protobuf.MapField.newMapField(
                  PrerollsDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000080;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll>
            prerolls__ = input.readMessage(
                PrerollsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            prerolls_.getMutableMap().put(
                prerolls__.getKey(), prerolls__.getValue());
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 1:
        return internalGetApothecary();
      case 2:
        return internalGetCartridges();
      case 3:
        return internalGetEdibles();
      case 4:
        return internalGetExtracts();
      case 5:
        return internalGetFlowers();
      case 6:
        return internalGetMerchandise();
      case 7:
        return internalGetPlants();
      case 8:
        return internalGetPrerolls();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.menu.StaticMenu.class, io.opencannabis.schema.menu.StaticMenu.Builder.class);
  }

  public static final int APOTHECARY_FIELD_NUMBER = 1;
  private static final class ApothecaryDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary>newDefaultInstance(
                io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_ApothecaryEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.opencannabis.schema.product.ApothecaryProduct.Apothecary.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> apothecary_;
  private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary>
  internalGetApothecary() {
    if (apothecary_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ApothecaryDefaultEntryHolder.defaultEntry);
    }
    return apothecary_;
  }

  public int getApothecaryCount() {
    return internalGetApothecary().getMap().size();
  }
  /**
   * <pre>
   * Specifies APOTHECARY products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Apothecary&gt; apothecary = 1;</code>
   */

  public boolean containsApothecary(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetApothecary().getMap().containsKey(key);
  }
  /**
   * Use {@link #getApothecaryMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> getApothecary() {
    return getApothecaryMap();
  }
  /**
   * <pre>
   * Specifies APOTHECARY products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Apothecary&gt; apothecary = 1;</code>
   */

  public java.util.Map<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> getApothecaryMap() {
    return internalGetApothecary().getMap();
  }
  /**
   * <pre>
   * Specifies APOTHECARY products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Apothecary&gt; apothecary = 1;</code>
   */

  public io.opencannabis.schema.product.ApothecaryProduct.Apothecary getApothecaryOrDefault(
      java.lang.String key,
      io.opencannabis.schema.product.ApothecaryProduct.Apothecary defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> map =
        internalGetApothecary().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Specifies APOTHECARY products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Apothecary&gt; apothecary = 1;</code>
   */

  public io.opencannabis.schema.product.ApothecaryProduct.Apothecary getApothecaryOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> map =
        internalGetApothecary().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CARTRIDGES_FIELD_NUMBER = 2;
  private static final class CartridgesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge>newDefaultInstance(
                io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_CartridgesEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.opencannabis.schema.product.CartridgeProduct.Cartridge.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> cartridges_;
  private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge>
  internalGetCartridges() {
    if (cartridges_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          CartridgesDefaultEntryHolder.defaultEntry);
    }
    return cartridges_;
  }

  public int getCartridgesCount() {
    return internalGetCartridges().getMap().size();
  }
  /**
   * <pre>
   * Specifies CARTRIDGE products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Cartridge&gt; cartridges = 2;</code>
   */

  public boolean containsCartridges(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetCartridges().getMap().containsKey(key);
  }
  /**
   * Use {@link #getCartridgesMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> getCartridges() {
    return getCartridgesMap();
  }
  /**
   * <pre>
   * Specifies CARTRIDGE products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Cartridge&gt; cartridges = 2;</code>
   */

  public java.util.Map<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> getCartridgesMap() {
    return internalGetCartridges().getMap();
  }
  /**
   * <pre>
   * Specifies CARTRIDGE products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Cartridge&gt; cartridges = 2;</code>
   */

  public io.opencannabis.schema.product.CartridgeProduct.Cartridge getCartridgesOrDefault(
      java.lang.String key,
      io.opencannabis.schema.product.CartridgeProduct.Cartridge defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> map =
        internalGetCartridges().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Specifies CARTRIDGE products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Cartridge&gt; cartridges = 2;</code>
   */

  public io.opencannabis.schema.product.CartridgeProduct.Cartridge getCartridgesOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> map =
        internalGetCartridges().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int EDIBLES_FIELD_NUMBER = 3;
  private static final class EdiblesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible>newDefaultInstance(
                io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_EdiblesEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.opencannabis.schema.product.EdibleProduct.Edible.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> edibles_;
  private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible>
  internalGetEdibles() {
    if (edibles_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          EdiblesDefaultEntryHolder.defaultEntry);
    }
    return edibles_;
  }

  public int getEdiblesCount() {
    return internalGetEdibles().getMap().size();
  }
  /**
   * <pre>
   * Specifies EDIBLE products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Edible&gt; edibles = 3;</code>
   */

  public boolean containsEdibles(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetEdibles().getMap().containsKey(key);
  }
  /**
   * Use {@link #getEdiblesMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> getEdibles() {
    return getEdiblesMap();
  }
  /**
   * <pre>
   * Specifies EDIBLE products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Edible&gt; edibles = 3;</code>
   */

  public java.util.Map<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> getEdiblesMap() {
    return internalGetEdibles().getMap();
  }
  /**
   * <pre>
   * Specifies EDIBLE products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Edible&gt; edibles = 3;</code>
   */

  public io.opencannabis.schema.product.EdibleProduct.Edible getEdiblesOrDefault(
      java.lang.String key,
      io.opencannabis.schema.product.EdibleProduct.Edible defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> map =
        internalGetEdibles().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Specifies EDIBLE products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Edible&gt; edibles = 3;</code>
   */

  public io.opencannabis.schema.product.EdibleProduct.Edible getEdiblesOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> map =
        internalGetEdibles().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int EXTRACTS_FIELD_NUMBER = 4;
  private static final class ExtractsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract>newDefaultInstance(
                io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_ExtractsEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.opencannabis.schema.product.ExtractProduct.Extract.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> extracts_;
  private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract>
  internalGetExtracts() {
    if (extracts_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ExtractsDefaultEntryHolder.defaultEntry);
    }
    return extracts_;
  }

  public int getExtractsCount() {
    return internalGetExtracts().getMap().size();
  }
  /**
   * <pre>
   * Specifies EXTRACT products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Extract&gt; extracts = 4;</code>
   */

  public boolean containsExtracts(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetExtracts().getMap().containsKey(key);
  }
  /**
   * Use {@link #getExtractsMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> getExtracts() {
    return getExtractsMap();
  }
  /**
   * <pre>
   * Specifies EXTRACT products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Extract&gt; extracts = 4;</code>
   */

  public java.util.Map<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> getExtractsMap() {
    return internalGetExtracts().getMap();
  }
  /**
   * <pre>
   * Specifies EXTRACT products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Extract&gt; extracts = 4;</code>
   */

  public io.opencannabis.schema.product.ExtractProduct.Extract getExtractsOrDefault(
      java.lang.String key,
      io.opencannabis.schema.product.ExtractProduct.Extract defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> map =
        internalGetExtracts().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Specifies EXTRACT products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Extract&gt; extracts = 4;</code>
   */

  public io.opencannabis.schema.product.ExtractProduct.Extract getExtractsOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> map =
        internalGetExtracts().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FLOWERS_FIELD_NUMBER = 5;
  private static final class FlowersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower>newDefaultInstance(
                io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_FlowersEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.opencannabis.schema.product.FlowerProduct.Flower.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> flowers_;
  private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower>
  internalGetFlowers() {
    if (flowers_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          FlowersDefaultEntryHolder.defaultEntry);
    }
    return flowers_;
  }

  public int getFlowersCount() {
    return internalGetFlowers().getMap().size();
  }
  /**
   * <pre>
   * Specifies FLOWER products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Flower&gt; flowers = 5;</code>
   */

  public boolean containsFlowers(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetFlowers().getMap().containsKey(key);
  }
  /**
   * Use {@link #getFlowersMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> getFlowers() {
    return getFlowersMap();
  }
  /**
   * <pre>
   * Specifies FLOWER products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Flower&gt; flowers = 5;</code>
   */

  public java.util.Map<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> getFlowersMap() {
    return internalGetFlowers().getMap();
  }
  /**
   * <pre>
   * Specifies FLOWER products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Flower&gt; flowers = 5;</code>
   */

  public io.opencannabis.schema.product.FlowerProduct.Flower getFlowersOrDefault(
      java.lang.String key,
      io.opencannabis.schema.product.FlowerProduct.Flower defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> map =
        internalGetFlowers().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Specifies FLOWER products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Flower&gt; flowers = 5;</code>
   */

  public io.opencannabis.schema.product.FlowerProduct.Flower getFlowersOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> map =
        internalGetFlowers().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MERCHANDISE_FIELD_NUMBER = 6;
  private static final class MerchandiseDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise>newDefaultInstance(
                io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_MerchandiseEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.opencannabis.schema.product.MerchandiseProduct.Merchandise.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> merchandise_;
  private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise>
  internalGetMerchandise() {
    if (merchandise_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          MerchandiseDefaultEntryHolder.defaultEntry);
    }
    return merchandise_;
  }

  public int getMerchandiseCount() {
    return internalGetMerchandise().getMap().size();
  }
  /**
   * <pre>
   * Specifies MERCHANDISE products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Merchandise&gt; merchandise = 6;</code>
   */

  public boolean containsMerchandise(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetMerchandise().getMap().containsKey(key);
  }
  /**
   * Use {@link #getMerchandiseMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> getMerchandise() {
    return getMerchandiseMap();
  }
  /**
   * <pre>
   * Specifies MERCHANDISE products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Merchandise&gt; merchandise = 6;</code>
   */

  public java.util.Map<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> getMerchandiseMap() {
    return internalGetMerchandise().getMap();
  }
  /**
   * <pre>
   * Specifies MERCHANDISE products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Merchandise&gt; merchandise = 6;</code>
   */

  public io.opencannabis.schema.product.MerchandiseProduct.Merchandise getMerchandiseOrDefault(
      java.lang.String key,
      io.opencannabis.schema.product.MerchandiseProduct.Merchandise defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> map =
        internalGetMerchandise().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Specifies MERCHANDISE products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Merchandise&gt; merchandise = 6;</code>
   */

  public io.opencannabis.schema.product.MerchandiseProduct.Merchandise getMerchandiseOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> map =
        internalGetMerchandise().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PLANTS_FIELD_NUMBER = 7;
  private static final class PlantsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant>newDefaultInstance(
                io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_PlantsEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.opencannabis.schema.product.PlantProduct.Plant.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> plants_;
  private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant>
  internalGetPlants() {
    if (plants_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          PlantsDefaultEntryHolder.defaultEntry);
    }
    return plants_;
  }

  public int getPlantsCount() {
    return internalGetPlants().getMap().size();
  }
  /**
   * <pre>
   * Specifies PLANT products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Plant&gt; plants = 7;</code>
   */

  public boolean containsPlants(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetPlants().getMap().containsKey(key);
  }
  /**
   * Use {@link #getPlantsMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> getPlants() {
    return getPlantsMap();
  }
  /**
   * <pre>
   * Specifies PLANT products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Plant&gt; plants = 7;</code>
   */

  public java.util.Map<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> getPlantsMap() {
    return internalGetPlants().getMap();
  }
  /**
   * <pre>
   * Specifies PLANT products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Plant&gt; plants = 7;</code>
   */

  public io.opencannabis.schema.product.PlantProduct.Plant getPlantsOrDefault(
      java.lang.String key,
      io.opencannabis.schema.product.PlantProduct.Plant defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> map =
        internalGetPlants().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Specifies PLANT products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Plant&gt; plants = 7;</code>
   */

  public io.opencannabis.schema.product.PlantProduct.Plant getPlantsOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> map =
        internalGetPlants().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PREROLLS_FIELD_NUMBER = 8;
  private static final class PrerollsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll>newDefaultInstance(
                io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_PrerollsEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.opencannabis.schema.product.PrerollProduct.Preroll.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> prerolls_;
  private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll>
  internalGetPrerolls() {
    if (prerolls_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          PrerollsDefaultEntryHolder.defaultEntry);
    }
    return prerolls_;
  }

  public int getPrerollsCount() {
    return internalGetPrerolls().getMap().size();
  }
  /**
   * <pre>
   * Specifies PREROLL products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Preroll&gt; prerolls = 8;</code>
   */

  public boolean containsPrerolls(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetPrerolls().getMap().containsKey(key);
  }
  /**
   * Use {@link #getPrerollsMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> getPrerolls() {
    return getPrerollsMap();
  }
  /**
   * <pre>
   * Specifies PREROLL products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Preroll&gt; prerolls = 8;</code>
   */

  public java.util.Map<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> getPrerollsMap() {
    return internalGetPrerolls().getMap();
  }
  /**
   * <pre>
   * Specifies PREROLL products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Preroll&gt; prerolls = 8;</code>
   */

  public io.opencannabis.schema.product.PrerollProduct.Preroll getPrerollsOrDefault(
      java.lang.String key,
      io.opencannabis.schema.product.PrerollProduct.Preroll defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> map =
        internalGetPrerolls().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Specifies PREROLL products attached to this menu.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.products.Preroll&gt; prerolls = 8;</code>
   */

  public io.opencannabis.schema.product.PrerollProduct.Preroll getPrerollsOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> map =
        internalGetPrerolls().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetApothecary(),
        ApothecaryDefaultEntryHolder.defaultEntry,
        1);
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetCartridges(),
        CartridgesDefaultEntryHolder.defaultEntry,
        2);
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetEdibles(),
        EdiblesDefaultEntryHolder.defaultEntry,
        3);
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetExtracts(),
        ExtractsDefaultEntryHolder.defaultEntry,
        4);
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetFlowers(),
        FlowersDefaultEntryHolder.defaultEntry,
        5);
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetMerchandise(),
        MerchandiseDefaultEntryHolder.defaultEntry,
        6);
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetPlants(),
        PlantsDefaultEntryHolder.defaultEntry,
        7);
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetPrerolls(),
        PrerollsDefaultEntryHolder.defaultEntry,
        8);
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> entry
         : internalGetApothecary().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary>
      apothecary__ = ApothecaryDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, apothecary__);
    }
    for (java.util.Map.Entry<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> entry
         : internalGetCartridges().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge>
      cartridges__ = CartridgesDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, cartridges__);
    }
    for (java.util.Map.Entry<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> entry
         : internalGetEdibles().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible>
      edibles__ = EdiblesDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, edibles__);
    }
    for (java.util.Map.Entry<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> entry
         : internalGetExtracts().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract>
      extracts__ = ExtractsDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, extracts__);
    }
    for (java.util.Map.Entry<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> entry
         : internalGetFlowers().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower>
      flowers__ = FlowersDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, flowers__);
    }
    for (java.util.Map.Entry<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> entry
         : internalGetMerchandise().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise>
      merchandise__ = MerchandiseDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, merchandise__);
    }
    for (java.util.Map.Entry<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> entry
         : internalGetPlants().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant>
      plants__ = PlantsDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, plants__);
    }
    for (java.util.Map.Entry<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> entry
         : internalGetPrerolls().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll>
      prerolls__ = PrerollsDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, prerolls__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.menu.StaticMenu)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.menu.StaticMenu other = (io.opencannabis.schema.menu.StaticMenu) obj;

    boolean result = true;
    result = result && internalGetApothecary().equals(
        other.internalGetApothecary());
    result = result && internalGetCartridges().equals(
        other.internalGetCartridges());
    result = result && internalGetEdibles().equals(
        other.internalGetEdibles());
    result = result && internalGetExtracts().equals(
        other.internalGetExtracts());
    result = result && internalGetFlowers().equals(
        other.internalGetFlowers());
    result = result && internalGetMerchandise().equals(
        other.internalGetMerchandise());
    result = result && internalGetPlants().equals(
        other.internalGetPlants());
    result = result && internalGetPrerolls().equals(
        other.internalGetPrerolls());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetApothecary().getMap().isEmpty()) {
      hash = (37 * hash) + APOTHECARY_FIELD_NUMBER;
      hash = (53 * hash) + internalGetApothecary().hashCode();
    }
    if (!internalGetCartridges().getMap().isEmpty()) {
      hash = (37 * hash) + CARTRIDGES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetCartridges().hashCode();
    }
    if (!internalGetEdibles().getMap().isEmpty()) {
      hash = (37 * hash) + EDIBLES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetEdibles().hashCode();
    }
    if (!internalGetExtracts().getMap().isEmpty()) {
      hash = (37 * hash) + EXTRACTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetExtracts().hashCode();
    }
    if (!internalGetFlowers().getMap().isEmpty()) {
      hash = (37 * hash) + FLOWERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetFlowers().hashCode();
    }
    if (!internalGetMerchandise().getMap().isEmpty()) {
      hash = (37 * hash) + MERCHANDISE_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMerchandise().hashCode();
    }
    if (!internalGetPlants().getMap().isEmpty()) {
      hash = (37 * hash) + PLANTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPlants().hashCode();
    }
    if (!internalGetPrerolls().getMap().isEmpty()) {
      hash = (37 * hash) + PREROLLS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPrerolls().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.menu.StaticMenu parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.menu.StaticMenu parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.StaticMenu parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.menu.StaticMenu parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.StaticMenu parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.menu.StaticMenu parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.StaticMenu parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.menu.StaticMenu parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.StaticMenu parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.menu.StaticMenu parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.StaticMenu parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.menu.StaticMenu parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.menu.StaticMenu prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an inner menu payload which contains mapped data, where each map key is a section name, lowercased, and
   * each map value is itself a product, and each map is addressed at a typed property name.
   * </pre>
   *
   * Protobuf type {@code opencannabis.products.menu.StaticMenu}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.products.menu.StaticMenu)
      io.opencannabis.schema.menu.StaticMenuOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 1:
          return internalGetApothecary();
        case 2:
          return internalGetCartridges();
        case 3:
          return internalGetEdibles();
        case 4:
          return internalGetExtracts();
        case 5:
          return internalGetFlowers();
        case 6:
          return internalGetMerchandise();
        case 7:
          return internalGetPlants();
        case 8:
          return internalGetPrerolls();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 1:
          return internalGetMutableApothecary();
        case 2:
          return internalGetMutableCartridges();
        case 3:
          return internalGetMutableEdibles();
        case 4:
          return internalGetMutableExtracts();
        case 5:
          return internalGetMutableFlowers();
        case 6:
          return internalGetMutableMerchandise();
        case 7:
          return internalGetMutablePlants();
        case 8:
          return internalGetMutablePrerolls();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.menu.StaticMenu.class, io.opencannabis.schema.menu.StaticMenu.Builder.class);
    }

    // Construct using io.opencannabis.schema.menu.StaticMenu.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      internalGetMutableApothecary().clear();
      internalGetMutableCartridges().clear();
      internalGetMutableEdibles().clear();
      internalGetMutableExtracts().clear();
      internalGetMutableFlowers().clear();
      internalGetMutableMerchandise().clear();
      internalGetMutablePlants().clear();
      internalGetMutablePrerolls().clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.menu.MenuOuterClass.internal_static_opencannabis_products_menu_StaticMenu_descriptor;
    }

    public io.opencannabis.schema.menu.StaticMenu getDefaultInstanceForType() {
      return io.opencannabis.schema.menu.StaticMenu.getDefaultInstance();
    }

    public io.opencannabis.schema.menu.StaticMenu build() {
      io.opencannabis.schema.menu.StaticMenu result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.menu.StaticMenu buildPartial() {
      io.opencannabis.schema.menu.StaticMenu result = new io.opencannabis.schema.menu.StaticMenu(this);
      int from_bitField0_ = bitField0_;
      result.apothecary_ = internalGetApothecary();
      result.apothecary_.makeImmutable();
      result.cartridges_ = internalGetCartridges();
      result.cartridges_.makeImmutable();
      result.edibles_ = internalGetEdibles();
      result.edibles_.makeImmutable();
      result.extracts_ = internalGetExtracts();
      result.extracts_.makeImmutable();
      result.flowers_ = internalGetFlowers();
      result.flowers_.makeImmutable();
      result.merchandise_ = internalGetMerchandise();
      result.merchandise_.makeImmutable();
      result.plants_ = internalGetPlants();
      result.plants_.makeImmutable();
      result.prerolls_ = internalGetPrerolls();
      result.prerolls_.makeImmutable();
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.menu.StaticMenu) {
        return mergeFrom((io.opencannabis.schema.menu.StaticMenu)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.menu.StaticMenu other) {
      if (other == io.opencannabis.schema.menu.StaticMenu.getDefaultInstance()) return this;
      internalGetMutableApothecary().mergeFrom(
          other.internalGetApothecary());
      internalGetMutableCartridges().mergeFrom(
          other.internalGetCartridges());
      internalGetMutableEdibles().mergeFrom(
          other.internalGetEdibles());
      internalGetMutableExtracts().mergeFrom(
          other.internalGetExtracts());
      internalGetMutableFlowers().mergeFrom(
          other.internalGetFlowers());
      internalGetMutableMerchandise().mergeFrom(
          other.internalGetMerchandise());
      internalGetMutablePlants().mergeFrom(
          other.internalGetPlants());
      internalGetMutablePrerolls().mergeFrom(
          other.internalGetPrerolls());
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.menu.StaticMenu parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.menu.StaticMenu) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private com.google.protobuf.MapField<
        java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> apothecary_;
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary>
    internalGetApothecary() {
      if (apothecary_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ApothecaryDefaultEntryHolder.defaultEntry);
      }
      return apothecary_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary>
    internalGetMutableApothecary() {
      onChanged();;
      if (apothecary_ == null) {
        apothecary_ = com.google.protobuf.MapField.newMapField(
            ApothecaryDefaultEntryHolder.defaultEntry);
      }
      if (!apothecary_.isMutable()) {
        apothecary_ = apothecary_.copy();
      }
      return apothecary_;
    }

    public int getApothecaryCount() {
      return internalGetApothecary().getMap().size();
    }
    /**
     * <pre>
     * Specifies APOTHECARY products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Apothecary&gt; apothecary = 1;</code>
     */

    public boolean containsApothecary(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetApothecary().getMap().containsKey(key);
    }
    /**
     * Use {@link #getApothecaryMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> getApothecary() {
      return getApothecaryMap();
    }
    /**
     * <pre>
     * Specifies APOTHECARY products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Apothecary&gt; apothecary = 1;</code>
     */

    public java.util.Map<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> getApothecaryMap() {
      return internalGetApothecary().getMap();
    }
    /**
     * <pre>
     * Specifies APOTHECARY products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Apothecary&gt; apothecary = 1;</code>
     */

    public io.opencannabis.schema.product.ApothecaryProduct.Apothecary getApothecaryOrDefault(
        java.lang.String key,
        io.opencannabis.schema.product.ApothecaryProduct.Apothecary defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> map =
          internalGetApothecary().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Specifies APOTHECARY products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Apothecary&gt; apothecary = 1;</code>
     */

    public io.opencannabis.schema.product.ApothecaryProduct.Apothecary getApothecaryOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> map =
          internalGetApothecary().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearApothecary() {
      internalGetMutableApothecary().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Specifies APOTHECARY products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Apothecary&gt; apothecary = 1;</code>
     */

    public Builder removeApothecary(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableApothecary().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary>
    getMutableApothecary() {
      return internalGetMutableApothecary().getMutableMap();
    }
    /**
     * <pre>
     * Specifies APOTHECARY products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Apothecary&gt; apothecary = 1;</code>
     */
    public Builder putApothecary(
        java.lang.String key,
        io.opencannabis.schema.product.ApothecaryProduct.Apothecary value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableApothecary().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Specifies APOTHECARY products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Apothecary&gt; apothecary = 1;</code>
     */

    public Builder putAllApothecary(
        java.util.Map<java.lang.String, io.opencannabis.schema.product.ApothecaryProduct.Apothecary> values) {
      internalGetMutableApothecary().getMutableMap()
          .putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> cartridges_;
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge>
    internalGetCartridges() {
      if (cartridges_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            CartridgesDefaultEntryHolder.defaultEntry);
      }
      return cartridges_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge>
    internalGetMutableCartridges() {
      onChanged();;
      if (cartridges_ == null) {
        cartridges_ = com.google.protobuf.MapField.newMapField(
            CartridgesDefaultEntryHolder.defaultEntry);
      }
      if (!cartridges_.isMutable()) {
        cartridges_ = cartridges_.copy();
      }
      return cartridges_;
    }

    public int getCartridgesCount() {
      return internalGetCartridges().getMap().size();
    }
    /**
     * <pre>
     * Specifies CARTRIDGE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Cartridge&gt; cartridges = 2;</code>
     */

    public boolean containsCartridges(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetCartridges().getMap().containsKey(key);
    }
    /**
     * Use {@link #getCartridgesMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> getCartridges() {
      return getCartridgesMap();
    }
    /**
     * <pre>
     * Specifies CARTRIDGE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Cartridge&gt; cartridges = 2;</code>
     */

    public java.util.Map<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> getCartridgesMap() {
      return internalGetCartridges().getMap();
    }
    /**
     * <pre>
     * Specifies CARTRIDGE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Cartridge&gt; cartridges = 2;</code>
     */

    public io.opencannabis.schema.product.CartridgeProduct.Cartridge getCartridgesOrDefault(
        java.lang.String key,
        io.opencannabis.schema.product.CartridgeProduct.Cartridge defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> map =
          internalGetCartridges().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Specifies CARTRIDGE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Cartridge&gt; cartridges = 2;</code>
     */

    public io.opencannabis.schema.product.CartridgeProduct.Cartridge getCartridgesOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> map =
          internalGetCartridges().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearCartridges() {
      internalGetMutableCartridges().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Specifies CARTRIDGE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Cartridge&gt; cartridges = 2;</code>
     */

    public Builder removeCartridges(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableCartridges().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge>
    getMutableCartridges() {
      return internalGetMutableCartridges().getMutableMap();
    }
    /**
     * <pre>
     * Specifies CARTRIDGE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Cartridge&gt; cartridges = 2;</code>
     */
    public Builder putCartridges(
        java.lang.String key,
        io.opencannabis.schema.product.CartridgeProduct.Cartridge value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableCartridges().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Specifies CARTRIDGE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Cartridge&gt; cartridges = 2;</code>
     */

    public Builder putAllCartridges(
        java.util.Map<java.lang.String, io.opencannabis.schema.product.CartridgeProduct.Cartridge> values) {
      internalGetMutableCartridges().getMutableMap()
          .putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> edibles_;
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible>
    internalGetEdibles() {
      if (edibles_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            EdiblesDefaultEntryHolder.defaultEntry);
      }
      return edibles_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible>
    internalGetMutableEdibles() {
      onChanged();;
      if (edibles_ == null) {
        edibles_ = com.google.protobuf.MapField.newMapField(
            EdiblesDefaultEntryHolder.defaultEntry);
      }
      if (!edibles_.isMutable()) {
        edibles_ = edibles_.copy();
      }
      return edibles_;
    }

    public int getEdiblesCount() {
      return internalGetEdibles().getMap().size();
    }
    /**
     * <pre>
     * Specifies EDIBLE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Edible&gt; edibles = 3;</code>
     */

    public boolean containsEdibles(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetEdibles().getMap().containsKey(key);
    }
    /**
     * Use {@link #getEdiblesMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> getEdibles() {
      return getEdiblesMap();
    }
    /**
     * <pre>
     * Specifies EDIBLE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Edible&gt; edibles = 3;</code>
     */

    public java.util.Map<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> getEdiblesMap() {
      return internalGetEdibles().getMap();
    }
    /**
     * <pre>
     * Specifies EDIBLE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Edible&gt; edibles = 3;</code>
     */

    public io.opencannabis.schema.product.EdibleProduct.Edible getEdiblesOrDefault(
        java.lang.String key,
        io.opencannabis.schema.product.EdibleProduct.Edible defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> map =
          internalGetEdibles().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Specifies EDIBLE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Edible&gt; edibles = 3;</code>
     */

    public io.opencannabis.schema.product.EdibleProduct.Edible getEdiblesOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> map =
          internalGetEdibles().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearEdibles() {
      internalGetMutableEdibles().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Specifies EDIBLE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Edible&gt; edibles = 3;</code>
     */

    public Builder removeEdibles(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableEdibles().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible>
    getMutableEdibles() {
      return internalGetMutableEdibles().getMutableMap();
    }
    /**
     * <pre>
     * Specifies EDIBLE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Edible&gt; edibles = 3;</code>
     */
    public Builder putEdibles(
        java.lang.String key,
        io.opencannabis.schema.product.EdibleProduct.Edible value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableEdibles().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Specifies EDIBLE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Edible&gt; edibles = 3;</code>
     */

    public Builder putAllEdibles(
        java.util.Map<java.lang.String, io.opencannabis.schema.product.EdibleProduct.Edible> values) {
      internalGetMutableEdibles().getMutableMap()
          .putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> extracts_;
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract>
    internalGetExtracts() {
      if (extracts_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ExtractsDefaultEntryHolder.defaultEntry);
      }
      return extracts_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract>
    internalGetMutableExtracts() {
      onChanged();;
      if (extracts_ == null) {
        extracts_ = com.google.protobuf.MapField.newMapField(
            ExtractsDefaultEntryHolder.defaultEntry);
      }
      if (!extracts_.isMutable()) {
        extracts_ = extracts_.copy();
      }
      return extracts_;
    }

    public int getExtractsCount() {
      return internalGetExtracts().getMap().size();
    }
    /**
     * <pre>
     * Specifies EXTRACT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Extract&gt; extracts = 4;</code>
     */

    public boolean containsExtracts(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetExtracts().getMap().containsKey(key);
    }
    /**
     * Use {@link #getExtractsMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> getExtracts() {
      return getExtractsMap();
    }
    /**
     * <pre>
     * Specifies EXTRACT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Extract&gt; extracts = 4;</code>
     */

    public java.util.Map<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> getExtractsMap() {
      return internalGetExtracts().getMap();
    }
    /**
     * <pre>
     * Specifies EXTRACT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Extract&gt; extracts = 4;</code>
     */

    public io.opencannabis.schema.product.ExtractProduct.Extract getExtractsOrDefault(
        java.lang.String key,
        io.opencannabis.schema.product.ExtractProduct.Extract defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> map =
          internalGetExtracts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Specifies EXTRACT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Extract&gt; extracts = 4;</code>
     */

    public io.opencannabis.schema.product.ExtractProduct.Extract getExtractsOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> map =
          internalGetExtracts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearExtracts() {
      internalGetMutableExtracts().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Specifies EXTRACT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Extract&gt; extracts = 4;</code>
     */

    public Builder removeExtracts(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableExtracts().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract>
    getMutableExtracts() {
      return internalGetMutableExtracts().getMutableMap();
    }
    /**
     * <pre>
     * Specifies EXTRACT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Extract&gt; extracts = 4;</code>
     */
    public Builder putExtracts(
        java.lang.String key,
        io.opencannabis.schema.product.ExtractProduct.Extract value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableExtracts().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Specifies EXTRACT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Extract&gt; extracts = 4;</code>
     */

    public Builder putAllExtracts(
        java.util.Map<java.lang.String, io.opencannabis.schema.product.ExtractProduct.Extract> values) {
      internalGetMutableExtracts().getMutableMap()
          .putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> flowers_;
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower>
    internalGetFlowers() {
      if (flowers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            FlowersDefaultEntryHolder.defaultEntry);
      }
      return flowers_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower>
    internalGetMutableFlowers() {
      onChanged();;
      if (flowers_ == null) {
        flowers_ = com.google.protobuf.MapField.newMapField(
            FlowersDefaultEntryHolder.defaultEntry);
      }
      if (!flowers_.isMutable()) {
        flowers_ = flowers_.copy();
      }
      return flowers_;
    }

    public int getFlowersCount() {
      return internalGetFlowers().getMap().size();
    }
    /**
     * <pre>
     * Specifies FLOWER products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Flower&gt; flowers = 5;</code>
     */

    public boolean containsFlowers(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetFlowers().getMap().containsKey(key);
    }
    /**
     * Use {@link #getFlowersMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> getFlowers() {
      return getFlowersMap();
    }
    /**
     * <pre>
     * Specifies FLOWER products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Flower&gt; flowers = 5;</code>
     */

    public java.util.Map<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> getFlowersMap() {
      return internalGetFlowers().getMap();
    }
    /**
     * <pre>
     * Specifies FLOWER products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Flower&gt; flowers = 5;</code>
     */

    public io.opencannabis.schema.product.FlowerProduct.Flower getFlowersOrDefault(
        java.lang.String key,
        io.opencannabis.schema.product.FlowerProduct.Flower defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> map =
          internalGetFlowers().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Specifies FLOWER products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Flower&gt; flowers = 5;</code>
     */

    public io.opencannabis.schema.product.FlowerProduct.Flower getFlowersOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> map =
          internalGetFlowers().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearFlowers() {
      internalGetMutableFlowers().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Specifies FLOWER products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Flower&gt; flowers = 5;</code>
     */

    public Builder removeFlowers(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableFlowers().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower>
    getMutableFlowers() {
      return internalGetMutableFlowers().getMutableMap();
    }
    /**
     * <pre>
     * Specifies FLOWER products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Flower&gt; flowers = 5;</code>
     */
    public Builder putFlowers(
        java.lang.String key,
        io.opencannabis.schema.product.FlowerProduct.Flower value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableFlowers().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Specifies FLOWER products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Flower&gt; flowers = 5;</code>
     */

    public Builder putAllFlowers(
        java.util.Map<java.lang.String, io.opencannabis.schema.product.FlowerProduct.Flower> values) {
      internalGetMutableFlowers().getMutableMap()
          .putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> merchandise_;
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise>
    internalGetMerchandise() {
      if (merchandise_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            MerchandiseDefaultEntryHolder.defaultEntry);
      }
      return merchandise_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise>
    internalGetMutableMerchandise() {
      onChanged();;
      if (merchandise_ == null) {
        merchandise_ = com.google.protobuf.MapField.newMapField(
            MerchandiseDefaultEntryHolder.defaultEntry);
      }
      if (!merchandise_.isMutable()) {
        merchandise_ = merchandise_.copy();
      }
      return merchandise_;
    }

    public int getMerchandiseCount() {
      return internalGetMerchandise().getMap().size();
    }
    /**
     * <pre>
     * Specifies MERCHANDISE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Merchandise&gt; merchandise = 6;</code>
     */

    public boolean containsMerchandise(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetMerchandise().getMap().containsKey(key);
    }
    /**
     * Use {@link #getMerchandiseMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> getMerchandise() {
      return getMerchandiseMap();
    }
    /**
     * <pre>
     * Specifies MERCHANDISE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Merchandise&gt; merchandise = 6;</code>
     */

    public java.util.Map<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> getMerchandiseMap() {
      return internalGetMerchandise().getMap();
    }
    /**
     * <pre>
     * Specifies MERCHANDISE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Merchandise&gt; merchandise = 6;</code>
     */

    public io.opencannabis.schema.product.MerchandiseProduct.Merchandise getMerchandiseOrDefault(
        java.lang.String key,
        io.opencannabis.schema.product.MerchandiseProduct.Merchandise defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> map =
          internalGetMerchandise().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Specifies MERCHANDISE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Merchandise&gt; merchandise = 6;</code>
     */

    public io.opencannabis.schema.product.MerchandiseProduct.Merchandise getMerchandiseOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> map =
          internalGetMerchandise().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMerchandise() {
      internalGetMutableMerchandise().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Specifies MERCHANDISE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Merchandise&gt; merchandise = 6;</code>
     */

    public Builder removeMerchandise(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableMerchandise().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise>
    getMutableMerchandise() {
      return internalGetMutableMerchandise().getMutableMap();
    }
    /**
     * <pre>
     * Specifies MERCHANDISE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Merchandise&gt; merchandise = 6;</code>
     */
    public Builder putMerchandise(
        java.lang.String key,
        io.opencannabis.schema.product.MerchandiseProduct.Merchandise value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableMerchandise().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Specifies MERCHANDISE products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Merchandise&gt; merchandise = 6;</code>
     */

    public Builder putAllMerchandise(
        java.util.Map<java.lang.String, io.opencannabis.schema.product.MerchandiseProduct.Merchandise> values) {
      internalGetMutableMerchandise().getMutableMap()
          .putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> plants_;
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant>
    internalGetPlants() {
      if (plants_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PlantsDefaultEntryHolder.defaultEntry);
      }
      return plants_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant>
    internalGetMutablePlants() {
      onChanged();;
      if (plants_ == null) {
        plants_ = com.google.protobuf.MapField.newMapField(
            PlantsDefaultEntryHolder.defaultEntry);
      }
      if (!plants_.isMutable()) {
        plants_ = plants_.copy();
      }
      return plants_;
    }

    public int getPlantsCount() {
      return internalGetPlants().getMap().size();
    }
    /**
     * <pre>
     * Specifies PLANT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Plant&gt; plants = 7;</code>
     */

    public boolean containsPlants(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetPlants().getMap().containsKey(key);
    }
    /**
     * Use {@link #getPlantsMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> getPlants() {
      return getPlantsMap();
    }
    /**
     * <pre>
     * Specifies PLANT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Plant&gt; plants = 7;</code>
     */

    public java.util.Map<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> getPlantsMap() {
      return internalGetPlants().getMap();
    }
    /**
     * <pre>
     * Specifies PLANT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Plant&gt; plants = 7;</code>
     */

    public io.opencannabis.schema.product.PlantProduct.Plant getPlantsOrDefault(
        java.lang.String key,
        io.opencannabis.schema.product.PlantProduct.Plant defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> map =
          internalGetPlants().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Specifies PLANT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Plant&gt; plants = 7;</code>
     */

    public io.opencannabis.schema.product.PlantProduct.Plant getPlantsOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> map =
          internalGetPlants().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearPlants() {
      internalGetMutablePlants().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Specifies PLANT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Plant&gt; plants = 7;</code>
     */

    public Builder removePlants(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutablePlants().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant>
    getMutablePlants() {
      return internalGetMutablePlants().getMutableMap();
    }
    /**
     * <pre>
     * Specifies PLANT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Plant&gt; plants = 7;</code>
     */
    public Builder putPlants(
        java.lang.String key,
        io.opencannabis.schema.product.PlantProduct.Plant value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutablePlants().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Specifies PLANT products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Plant&gt; plants = 7;</code>
     */

    public Builder putAllPlants(
        java.util.Map<java.lang.String, io.opencannabis.schema.product.PlantProduct.Plant> values) {
      internalGetMutablePlants().getMutableMap()
          .putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> prerolls_;
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll>
    internalGetPrerolls() {
      if (prerolls_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PrerollsDefaultEntryHolder.defaultEntry);
      }
      return prerolls_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll>
    internalGetMutablePrerolls() {
      onChanged();;
      if (prerolls_ == null) {
        prerolls_ = com.google.protobuf.MapField.newMapField(
            PrerollsDefaultEntryHolder.defaultEntry);
      }
      if (!prerolls_.isMutable()) {
        prerolls_ = prerolls_.copy();
      }
      return prerolls_;
    }

    public int getPrerollsCount() {
      return internalGetPrerolls().getMap().size();
    }
    /**
     * <pre>
     * Specifies PREROLL products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Preroll&gt; prerolls = 8;</code>
     */

    public boolean containsPrerolls(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetPrerolls().getMap().containsKey(key);
    }
    /**
     * Use {@link #getPrerollsMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> getPrerolls() {
      return getPrerollsMap();
    }
    /**
     * <pre>
     * Specifies PREROLL products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Preroll&gt; prerolls = 8;</code>
     */

    public java.util.Map<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> getPrerollsMap() {
      return internalGetPrerolls().getMap();
    }
    /**
     * <pre>
     * Specifies PREROLL products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Preroll&gt; prerolls = 8;</code>
     */

    public io.opencannabis.schema.product.PrerollProduct.Preroll getPrerollsOrDefault(
        java.lang.String key,
        io.opencannabis.schema.product.PrerollProduct.Preroll defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> map =
          internalGetPrerolls().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Specifies PREROLL products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Preroll&gt; prerolls = 8;</code>
     */

    public io.opencannabis.schema.product.PrerollProduct.Preroll getPrerollsOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> map =
          internalGetPrerolls().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearPrerolls() {
      internalGetMutablePrerolls().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Specifies PREROLL products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Preroll&gt; prerolls = 8;</code>
     */

    public Builder removePrerolls(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutablePrerolls().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll>
    getMutablePrerolls() {
      return internalGetMutablePrerolls().getMutableMap();
    }
    /**
     * <pre>
     * Specifies PREROLL products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Preroll&gt; prerolls = 8;</code>
     */
    public Builder putPrerolls(
        java.lang.String key,
        io.opencannabis.schema.product.PrerollProduct.Preroll value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutablePrerolls().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Specifies PREROLL products attached to this menu.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.products.Preroll&gt; prerolls = 8;</code>
     */

    public Builder putAllPrerolls(
        java.util.Map<java.lang.String, io.opencannabis.schema.product.PrerollProduct.Preroll> values) {
      internalGetMutablePrerolls().getMutableMap()
          .putAll(values);
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.products.menu.StaticMenu)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.products.menu.StaticMenu)
  private static final io.opencannabis.schema.menu.StaticMenu DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.menu.StaticMenu();
  }

  public static io.opencannabis.schema.menu.StaticMenu getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StaticMenu>
      PARSER = new com.google.protobuf.AbstractParser<StaticMenu>() {
    public StaticMenu parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new StaticMenu(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<StaticMenu> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StaticMenu> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.menu.StaticMenu getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

