/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: products/menu/Section.proto

package io.opencannabis.schema.menu.section;

/**
 * <pre>
 * Specifies a menu section, along with section configuration (settings and flags).
 * </pre>
 *
 * Protobuf type {@code opencannabis.products.menu.section.SectionSpec}
 */
public  final class SectionSpec extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.products.menu.section.SectionSpec)
    SectionSpecOrBuilder {
private static final long serialVersionUID = 0L;
  // Use SectionSpec.newBuilder() to construct.
  private SectionSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private SectionSpec() {
    flags_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private SectionSpec(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();
            specCase_ = 1;
            spec_ = rawValue;
            break;
          }
          case 18: {
            io.opencannabis.schema.menu.section.CustomSection.Builder subBuilder = null;
            if (specCase_ == 2) {
              subBuilder = ((io.opencannabis.schema.menu.section.CustomSection) spec_).toBuilder();
            }
            spec_ =
                input.readMessage(io.opencannabis.schema.menu.section.CustomSection.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.opencannabis.schema.menu.section.CustomSection) spec_);
              spec_ = subBuilder.buildPartial();
            }
            specCase_ = 2;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();
            specCase_ = 3;
            spec_ = s;
            break;
          }
          case 34: {
            io.opencannabis.schema.menu.section.SectionSettings.Builder subBuilder = null;
            if (settings_ != null) {
              subBuilder = settings_.toBuilder();
            }
            settings_ = input.readMessage(io.opencannabis.schema.menu.section.SectionSettings.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(settings_);
              settings_ = subBuilder.buildPartial();
            }

            break;
          }
          case 40: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
              flags_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000010;
            }
            flags_.add(rawValue);
            break;
          }
          case 42: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                flags_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000010;
              }
              flags_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
        flags_ = java.util.Collections.unmodifiableList(flags_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.menu.section.SectionOuterClass.internal_static_opencannabis_products_menu_section_SectionSpec_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.menu.section.SectionOuterClass.internal_static_opencannabis_products_menu_section_SectionSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.menu.section.SectionSpec.class, io.opencannabis.schema.menu.section.SectionSpec.Builder.class);
  }

  private int bitField0_;
  private int specCase_ = 0;
  private java.lang.Object spec_;
  public enum SpecCase
      implements com.google.protobuf.Internal.EnumLite {
    SECTION(1),
    CUSTOM_SECTION(2),
    NAME(3),
    SPEC_NOT_SET(0);
    private final int value;
    private SpecCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static SpecCase forNumber(int value) {
      switch (value) {
        case 1: return SECTION;
        case 2: return CUSTOM_SECTION;
        case 3: return NAME;
        case 0: return SPEC_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public SpecCase
  getSpecCase() {
    return SpecCase.forNumber(
        specCase_);
  }

  public static final int SECTION_FIELD_NUMBER = 1;
  /**
   * <pre>
   * Known and enumerated menu section.
   * </pre>
   *
   * <code>.opencannabis.products.menu.section.Section section = 1;</code>
   */
  public int getSectionValue() {
    if (specCase_ == 1) {
      return (java.lang.Integer) spec_;
    }
    return 0;
  }
  /**
   * <pre>
   * Known and enumerated menu section.
   * </pre>
   *
   * <code>.opencannabis.products.menu.section.Section section = 1;</code>
   */
  public io.opencannabis.schema.menu.section.Section getSection() {
    if (specCase_ == 1) {
      io.opencannabis.schema.menu.section.Section result = io.opencannabis.schema.menu.section.Section.valueOf(
          (java.lang.Integer) spec_);
      return result == null ? io.opencannabis.schema.menu.section.Section.UNRECOGNIZED : result;
    }
    return io.opencannabis.schema.menu.section.Section.UNSPECIFIED;
  }

  public static final int CUSTOM_SECTION_FIELD_NUMBER = 2;
  /**
   * <pre>
   * Custom, filter-based menu section.
   * </pre>
   *
   * <code>.opencannabis.products.menu.section.CustomSection custom_section = 2;</code>
   */
  public boolean hasCustomSection() {
    return specCase_ == 2;
  }
  /**
   * <pre>
   * Custom, filter-based menu section.
   * </pre>
   *
   * <code>.opencannabis.products.menu.section.CustomSection custom_section = 2;</code>
   */
  public io.opencannabis.schema.menu.section.CustomSection getCustomSection() {
    if (specCase_ == 2) {
       return (io.opencannabis.schema.menu.section.CustomSection) spec_;
    }
    return io.opencannabis.schema.menu.section.CustomSection.getDefaultInstance();
  }
  /**
   * <pre>
   * Custom, filter-based menu section.
   * </pre>
   *
   * <code>.opencannabis.products.menu.section.CustomSection custom_section = 2;</code>
   */
  public io.opencannabis.schema.menu.section.CustomSectionOrBuilder getCustomSectionOrBuilder() {
    if (specCase_ == 2) {
       return (io.opencannabis.schema.menu.section.CustomSection) spec_;
    }
    return io.opencannabis.schema.menu.section.CustomSection.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 3;
  /**
   * <pre>
   * Arbitrary name for other types of sections.
   * </pre>
   *
   * <code>string name = 3;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = "";
    if (specCase_ == 3) {
      ref = spec_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (specCase_ == 3) {
        spec_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Arbitrary name for other types of sections.
   * </pre>
   *
   * <code>string name = 3;</code>
   */
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = "";
    if (specCase_ == 3) {
      ref = spec_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (specCase_ == 3) {
        spec_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SETTINGS_FIELD_NUMBER = 4;
  private io.opencannabis.schema.menu.section.SectionSettings settings_;
  /**
   * <pre>
   * Settings to apply to the subject section.
   * </pre>
   *
   * <code>.opencannabis.products.menu.section.SectionSettings settings = 4;</code>
   */
  public boolean hasSettings() {
    return settings_ != null;
  }
  /**
   * <pre>
   * Settings to apply to the subject section.
   * </pre>
   *
   * <code>.opencannabis.products.menu.section.SectionSettings settings = 4;</code>
   */
  public io.opencannabis.schema.menu.section.SectionSettings getSettings() {
    return settings_ == null ? io.opencannabis.schema.menu.section.SectionSettings.getDefaultInstance() : settings_;
  }
  /**
   * <pre>
   * Settings to apply to the subject section.
   * </pre>
   *
   * <code>.opencannabis.products.menu.section.SectionSettings settings = 4;</code>
   */
  public io.opencannabis.schema.menu.section.SectionSettingsOrBuilder getSettingsOrBuilder() {
    return getSettings();
  }

  public static final int FLAGS_FIELD_NUMBER = 5;
  private java.util.List<java.lang.Integer> flags_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.opencannabis.schema.menu.section.SectionFlag> flags_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.opencannabis.schema.menu.section.SectionFlag>() {
            public io.opencannabis.schema.menu.section.SectionFlag convert(java.lang.Integer from) {
              io.opencannabis.schema.menu.section.SectionFlag result = io.opencannabis.schema.menu.section.SectionFlag.valueOf(from);
              return result == null ? io.opencannabis.schema.menu.section.SectionFlag.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Current set of flags to apply to the subject section.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
   */
  public java.util.List<io.opencannabis.schema.menu.section.SectionFlag> getFlagsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.opencannabis.schema.menu.section.SectionFlag>(flags_, flags_converter_);
  }
  /**
   * <pre>
   * Current set of flags to apply to the subject section.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
   */
  public int getFlagsCount() {
    return flags_.size();
  }
  /**
   * <pre>
   * Current set of flags to apply to the subject section.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
   */
  public io.opencannabis.schema.menu.section.SectionFlag getFlags(int index) {
    return flags_converter_.convert(flags_.get(index));
  }
  /**
   * <pre>
   * Current set of flags to apply to the subject section.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
   */
  public java.util.List<java.lang.Integer>
  getFlagsValueList() {
    return flags_;
  }
  /**
   * <pre>
   * Current set of flags to apply to the subject section.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
   */
  public int getFlagsValue(int index) {
    return flags_.get(index);
  }
  private int flagsMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (specCase_ == 1) {
      output.writeEnum(1, ((java.lang.Integer) spec_));
    }
    if (specCase_ == 2) {
      output.writeMessage(2, (io.opencannabis.schema.menu.section.CustomSection) spec_);
    }
    if (specCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, spec_);
    }
    if (settings_ != null) {
      output.writeMessage(4, getSettings());
    }
    if (getFlagsList().size() > 0) {
      output.writeUInt32NoTag(42);
      output.writeUInt32NoTag(flagsMemoizedSerializedSize);
    }
    for (int i = 0; i < flags_.size(); i++) {
      output.writeEnumNoTag(flags_.get(i));
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (specCase_ == 1) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, ((java.lang.Integer) spec_));
    }
    if (specCase_ == 2) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, (io.opencannabis.schema.menu.section.CustomSection) spec_);
    }
    if (specCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, spec_);
    }
    if (settings_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getSettings());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < flags_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(flags_.get(i));
      }
      size += dataSize;
      if (!getFlagsList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }flagsMemoizedSerializedSize = dataSize;
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.menu.section.SectionSpec)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.menu.section.SectionSpec other = (io.opencannabis.schema.menu.section.SectionSpec) obj;

    boolean result = true;
    result = result && (hasSettings() == other.hasSettings());
    if (hasSettings()) {
      result = result && getSettings()
          .equals(other.getSettings());
    }
    result = result && flags_.equals(other.flags_);
    result = result && getSpecCase().equals(
        other.getSpecCase());
    if (!result) return false;
    switch (specCase_) {
      case 1:
        result = result && getSectionValue()
            == other.getSectionValue();
        break;
      case 2:
        result = result && getCustomSection()
            .equals(other.getCustomSection());
        break;
      case 3:
        result = result && getName()
            .equals(other.getName());
        break;
      case 0:
      default:
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSettings()) {
      hash = (37 * hash) + SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSettings().hashCode();
    }
    if (getFlagsCount() > 0) {
      hash = (37 * hash) + FLAGS_FIELD_NUMBER;
      hash = (53 * hash) + flags_.hashCode();
    }
    switch (specCase_) {
      case 1:
        hash = (37 * hash) + SECTION_FIELD_NUMBER;
        hash = (53 * hash) + getSectionValue();
        break;
      case 2:
        hash = (37 * hash) + CUSTOM_SECTION_FIELD_NUMBER;
        hash = (53 * hash) + getCustomSection().hashCode();
        break;
      case 3:
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.menu.section.SectionSpec parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.menu.section.SectionSpec parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.section.SectionSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.menu.section.SectionSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.section.SectionSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.menu.section.SectionSpec parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.section.SectionSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.menu.section.SectionSpec parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.section.SectionSpec parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.menu.section.SectionSpec parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.menu.section.SectionSpec parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.menu.section.SectionSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.menu.section.SectionSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a menu section, along with section configuration (settings and flags).
   * </pre>
   *
   * Protobuf type {@code opencannabis.products.menu.section.SectionSpec}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.products.menu.section.SectionSpec)
      io.opencannabis.schema.menu.section.SectionSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.menu.section.SectionOuterClass.internal_static_opencannabis_products_menu_section_SectionSpec_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.menu.section.SectionOuterClass.internal_static_opencannabis_products_menu_section_SectionSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.menu.section.SectionSpec.class, io.opencannabis.schema.menu.section.SectionSpec.Builder.class);
    }

    // Construct using io.opencannabis.schema.menu.section.SectionSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      if (settingsBuilder_ == null) {
        settings_ = null;
      } else {
        settings_ = null;
        settingsBuilder_ = null;
      }
      flags_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      specCase_ = 0;
      spec_ = null;
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.menu.section.SectionOuterClass.internal_static_opencannabis_products_menu_section_SectionSpec_descriptor;
    }

    public io.opencannabis.schema.menu.section.SectionSpec getDefaultInstanceForType() {
      return io.opencannabis.schema.menu.section.SectionSpec.getDefaultInstance();
    }

    public io.opencannabis.schema.menu.section.SectionSpec build() {
      io.opencannabis.schema.menu.section.SectionSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.menu.section.SectionSpec buildPartial() {
      io.opencannabis.schema.menu.section.SectionSpec result = new io.opencannabis.schema.menu.section.SectionSpec(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (specCase_ == 1) {
        result.spec_ = spec_;
      }
      if (specCase_ == 2) {
        if (customSectionBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = customSectionBuilder_.build();
        }
      }
      if (specCase_ == 3) {
        result.spec_ = spec_;
      }
      if (settingsBuilder_ == null) {
        result.settings_ = settings_;
      } else {
        result.settings_ = settingsBuilder_.build();
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        flags_ = java.util.Collections.unmodifiableList(flags_);
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.flags_ = flags_;
      result.bitField0_ = to_bitField0_;
      result.specCase_ = specCase_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.menu.section.SectionSpec) {
        return mergeFrom((io.opencannabis.schema.menu.section.SectionSpec)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.menu.section.SectionSpec other) {
      if (other == io.opencannabis.schema.menu.section.SectionSpec.getDefaultInstance()) return this;
      if (other.hasSettings()) {
        mergeSettings(other.getSettings());
      }
      if (!other.flags_.isEmpty()) {
        if (flags_.isEmpty()) {
          flags_ = other.flags_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureFlagsIsMutable();
          flags_.addAll(other.flags_);
        }
        onChanged();
      }
      switch (other.getSpecCase()) {
        case SECTION: {
          setSectionValue(other.getSectionValue());
          break;
        }
        case CUSTOM_SECTION: {
          mergeCustomSection(other.getCustomSection());
          break;
        }
        case NAME: {
          specCase_ = 3;
          spec_ = other.spec_;
          onChanged();
          break;
        }
        case SPEC_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.menu.section.SectionSpec parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.menu.section.SectionSpec) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int specCase_ = 0;
    private java.lang.Object spec_;
    public SpecCase
        getSpecCase() {
      return SpecCase.forNumber(
          specCase_);
    }

    public Builder clearSpec() {
      specCase_ = 0;
      spec_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     * <pre>
     * Known and enumerated menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 1;</code>
     */
    public int getSectionValue() {
      if (specCase_ == 1) {
        return ((java.lang.Integer) spec_).intValue();
      }
      return 0;
    }
    /**
     * <pre>
     * Known and enumerated menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 1;</code>
     */
    public Builder setSectionValue(int value) {
      specCase_ = 1;
      spec_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Known and enumerated menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 1;</code>
     */
    public io.opencannabis.schema.menu.section.Section getSection() {
      if (specCase_ == 1) {
        io.opencannabis.schema.menu.section.Section result = io.opencannabis.schema.menu.section.Section.valueOf(
            (java.lang.Integer) spec_);
        return result == null ? io.opencannabis.schema.menu.section.Section.UNRECOGNIZED : result;
      }
      return io.opencannabis.schema.menu.section.Section.UNSPECIFIED;
    }
    /**
     * <pre>
     * Known and enumerated menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 1;</code>
     */
    public Builder setSection(io.opencannabis.schema.menu.section.Section value) {
      if (value == null) {
        throw new NullPointerException();
      }
      specCase_ = 1;
      spec_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Known and enumerated menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 1;</code>
     */
    public Builder clearSection() {
      if (specCase_ == 1) {
        specCase_ = 0;
        spec_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.menu.section.CustomSection, io.opencannabis.schema.menu.section.CustomSection.Builder, io.opencannabis.schema.menu.section.CustomSectionOrBuilder> customSectionBuilder_;
    /**
     * <pre>
     * Custom, filter-based menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.CustomSection custom_section = 2;</code>
     */
    public boolean hasCustomSection() {
      return specCase_ == 2;
    }
    /**
     * <pre>
     * Custom, filter-based menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.CustomSection custom_section = 2;</code>
     */
    public io.opencannabis.schema.menu.section.CustomSection getCustomSection() {
      if (customSectionBuilder_ == null) {
        if (specCase_ == 2) {
          return (io.opencannabis.schema.menu.section.CustomSection) spec_;
        }
        return io.opencannabis.schema.menu.section.CustomSection.getDefaultInstance();
      } else {
        if (specCase_ == 2) {
          return customSectionBuilder_.getMessage();
        }
        return io.opencannabis.schema.menu.section.CustomSection.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Custom, filter-based menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.CustomSection custom_section = 2;</code>
     */
    public Builder setCustomSection(io.opencannabis.schema.menu.section.CustomSection value) {
      if (customSectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spec_ = value;
        onChanged();
      } else {
        customSectionBuilder_.setMessage(value);
      }
      specCase_ = 2;
      return this;
    }
    /**
     * <pre>
     * Custom, filter-based menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.CustomSection custom_section = 2;</code>
     */
    public Builder setCustomSection(
        io.opencannabis.schema.menu.section.CustomSection.Builder builderForValue) {
      if (customSectionBuilder_ == null) {
        spec_ = builderForValue.build();
        onChanged();
      } else {
        customSectionBuilder_.setMessage(builderForValue.build());
      }
      specCase_ = 2;
      return this;
    }
    /**
     * <pre>
     * Custom, filter-based menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.CustomSection custom_section = 2;</code>
     */
    public Builder mergeCustomSection(io.opencannabis.schema.menu.section.CustomSection value) {
      if (customSectionBuilder_ == null) {
        if (specCase_ == 2 &&
            spec_ != io.opencannabis.schema.menu.section.CustomSection.getDefaultInstance()) {
          spec_ = io.opencannabis.schema.menu.section.CustomSection.newBuilder((io.opencannabis.schema.menu.section.CustomSection) spec_)
              .mergeFrom(value).buildPartial();
        } else {
          spec_ = value;
        }
        onChanged();
      } else {
        if (specCase_ == 2) {
          customSectionBuilder_.mergeFrom(value);
        }
        customSectionBuilder_.setMessage(value);
      }
      specCase_ = 2;
      return this;
    }
    /**
     * <pre>
     * Custom, filter-based menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.CustomSection custom_section = 2;</code>
     */
    public Builder clearCustomSection() {
      if (customSectionBuilder_ == null) {
        if (specCase_ == 2) {
          specCase_ = 0;
          spec_ = null;
          onChanged();
        }
      } else {
        if (specCase_ == 2) {
          specCase_ = 0;
          spec_ = null;
        }
        customSectionBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Custom, filter-based menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.CustomSection custom_section = 2;</code>
     */
    public io.opencannabis.schema.menu.section.CustomSection.Builder getCustomSectionBuilder() {
      return getCustomSectionFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Custom, filter-based menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.CustomSection custom_section = 2;</code>
     */
    public io.opencannabis.schema.menu.section.CustomSectionOrBuilder getCustomSectionOrBuilder() {
      if ((specCase_ == 2) && (customSectionBuilder_ != null)) {
        return customSectionBuilder_.getMessageOrBuilder();
      } else {
        if (specCase_ == 2) {
          return (io.opencannabis.schema.menu.section.CustomSection) spec_;
        }
        return io.opencannabis.schema.menu.section.CustomSection.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Custom, filter-based menu section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.CustomSection custom_section = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.menu.section.CustomSection, io.opencannabis.schema.menu.section.CustomSection.Builder, io.opencannabis.schema.menu.section.CustomSectionOrBuilder> 
        getCustomSectionFieldBuilder() {
      if (customSectionBuilder_ == null) {
        if (!(specCase_ == 2)) {
          spec_ = io.opencannabis.schema.menu.section.CustomSection.getDefaultInstance();
        }
        customSectionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.menu.section.CustomSection, io.opencannabis.schema.menu.section.CustomSection.Builder, io.opencannabis.schema.menu.section.CustomSectionOrBuilder>(
                (io.opencannabis.schema.menu.section.CustomSection) spec_,
                getParentForChildren(),
                isClean());
        spec_ = null;
      }
      specCase_ = 2;
      onChanged();;
      return customSectionBuilder_;
    }

    /**
     * <pre>
     * Arbitrary name for other types of sections.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = "";
      if (specCase_ == 3) {
        ref = spec_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (specCase_ == 3) {
          spec_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Arbitrary name for other types of sections.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = "";
      if (specCase_ == 3) {
        ref = spec_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (specCase_ == 3) {
          spec_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Arbitrary name for other types of sections.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  specCase_ = 3;
      spec_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Arbitrary name for other types of sections.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    public Builder clearName() {
      if (specCase_ == 3) {
        specCase_ = 0;
        spec_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Arbitrary name for other types of sections.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      specCase_ = 3;
      spec_ = value;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.menu.section.SectionSettings settings_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.menu.section.SectionSettings, io.opencannabis.schema.menu.section.SectionSettings.Builder, io.opencannabis.schema.menu.section.SectionSettingsOrBuilder> settingsBuilder_;
    /**
     * <pre>
     * Settings to apply to the subject section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSettings settings = 4;</code>
     */
    public boolean hasSettings() {
      return settingsBuilder_ != null || settings_ != null;
    }
    /**
     * <pre>
     * Settings to apply to the subject section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSettings settings = 4;</code>
     */
    public io.opencannabis.schema.menu.section.SectionSettings getSettings() {
      if (settingsBuilder_ == null) {
        return settings_ == null ? io.opencannabis.schema.menu.section.SectionSettings.getDefaultInstance() : settings_;
      } else {
        return settingsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Settings to apply to the subject section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSettings settings = 4;</code>
     */
    public Builder setSettings(io.opencannabis.schema.menu.section.SectionSettings value) {
      if (settingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        settings_ = value;
        onChanged();
      } else {
        settingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Settings to apply to the subject section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSettings settings = 4;</code>
     */
    public Builder setSettings(
        io.opencannabis.schema.menu.section.SectionSettings.Builder builderForValue) {
      if (settingsBuilder_ == null) {
        settings_ = builderForValue.build();
        onChanged();
      } else {
        settingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Settings to apply to the subject section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSettings settings = 4;</code>
     */
    public Builder mergeSettings(io.opencannabis.schema.menu.section.SectionSettings value) {
      if (settingsBuilder_ == null) {
        if (settings_ != null) {
          settings_ =
            io.opencannabis.schema.menu.section.SectionSettings.newBuilder(settings_).mergeFrom(value).buildPartial();
        } else {
          settings_ = value;
        }
        onChanged();
      } else {
        settingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Settings to apply to the subject section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSettings settings = 4;</code>
     */
    public Builder clearSettings() {
      if (settingsBuilder_ == null) {
        settings_ = null;
        onChanged();
      } else {
        settings_ = null;
        settingsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Settings to apply to the subject section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSettings settings = 4;</code>
     */
    public io.opencannabis.schema.menu.section.SectionSettings.Builder getSettingsBuilder() {
      
      onChanged();
      return getSettingsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Settings to apply to the subject section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSettings settings = 4;</code>
     */
    public io.opencannabis.schema.menu.section.SectionSettingsOrBuilder getSettingsOrBuilder() {
      if (settingsBuilder_ != null) {
        return settingsBuilder_.getMessageOrBuilder();
      } else {
        return settings_ == null ?
            io.opencannabis.schema.menu.section.SectionSettings.getDefaultInstance() : settings_;
      }
    }
    /**
     * <pre>
     * Settings to apply to the subject section.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSettings settings = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.menu.section.SectionSettings, io.opencannabis.schema.menu.section.SectionSettings.Builder, io.opencannabis.schema.menu.section.SectionSettingsOrBuilder> 
        getSettingsFieldBuilder() {
      if (settingsBuilder_ == null) {
        settingsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.menu.section.SectionSettings, io.opencannabis.schema.menu.section.SectionSettings.Builder, io.opencannabis.schema.menu.section.SectionSettingsOrBuilder>(
                getSettings(),
                getParentForChildren(),
                isClean());
        settings_ = null;
      }
      return settingsBuilder_;
    }

    private java.util.List<java.lang.Integer> flags_ =
      java.util.Collections.emptyList();
    private void ensureFlagsIsMutable() {
      if (!((bitField0_ & 0x00000010) == 0x00000010)) {
        flags_ = new java.util.ArrayList<java.lang.Integer>(flags_);
        bitField0_ |= 0x00000010;
      }
    }
    /**
     * <pre>
     * Current set of flags to apply to the subject section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
     */
    public java.util.List<io.opencannabis.schema.menu.section.SectionFlag> getFlagsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.menu.section.SectionFlag>(flags_, flags_converter_);
    }
    /**
     * <pre>
     * Current set of flags to apply to the subject section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
     */
    public int getFlagsCount() {
      return flags_.size();
    }
    /**
     * <pre>
     * Current set of flags to apply to the subject section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
     */
    public io.opencannabis.schema.menu.section.SectionFlag getFlags(int index) {
      return flags_converter_.convert(flags_.get(index));
    }
    /**
     * <pre>
     * Current set of flags to apply to the subject section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
     */
    public Builder setFlags(
        int index, io.opencannabis.schema.menu.section.SectionFlag value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFlagsIsMutable();
      flags_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Current set of flags to apply to the subject section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
     */
    public Builder addFlags(io.opencannabis.schema.menu.section.SectionFlag value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFlagsIsMutable();
      flags_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Current set of flags to apply to the subject section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
     */
    public Builder addAllFlags(
        java.lang.Iterable<? extends io.opencannabis.schema.menu.section.SectionFlag> values) {
      ensureFlagsIsMutable();
      for (io.opencannabis.schema.menu.section.SectionFlag value : values) {
        flags_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Current set of flags to apply to the subject section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
     */
    public Builder clearFlags() {
      flags_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Current set of flags to apply to the subject section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
     */
    public java.util.List<java.lang.Integer>
    getFlagsValueList() {
      return java.util.Collections.unmodifiableList(flags_);
    }
    /**
     * <pre>
     * Current set of flags to apply to the subject section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
     */
    public int getFlagsValue(int index) {
      return flags_.get(index);
    }
    /**
     * <pre>
     * Current set of flags to apply to the subject section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
     */
    public Builder setFlagsValue(
        int index, int value) {
      ensureFlagsIsMutable();
      flags_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Current set of flags to apply to the subject section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
     */
    public Builder addFlagsValue(int value) {
      ensureFlagsIsMutable();
      flags_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Current set of flags to apply to the subject section.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.SectionFlag flags = 5;</code>
     */
    public Builder addAllFlagsValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureFlagsIsMutable();
      for (int value : values) {
        flags_.add(value);
      }
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.products.menu.section.SectionSpec)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.products.menu.section.SectionSpec)
  private static final io.opencannabis.schema.menu.section.SectionSpec DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.menu.section.SectionSpec();
  }

  public static io.opencannabis.schema.menu.section.SectionSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SectionSpec>
      PARSER = new com.google.protobuf.AbstractParser<SectionSpec>() {
    public SectionSpec parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new SectionSpec(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<SectionSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SectionSpec> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.menu.section.SectionSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

