/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: person/Person.proto

package io.opencannabis.schema.person;

/**
 * <pre>
 * A person/patint and their name, legal name, nickname, etc.
 * </pre>
 *
 * Protobuf type {@code opencannabis.person.Person}
 */
public  final class Person extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.person.Person)
    PersonOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Person.newBuilder() to construct.
  private Person(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Person() {
    gender_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Person(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            io.opencannabis.schema.person.Name.Builder subBuilder = null;
            if (name_ != null) {
              subBuilder = name_.toBuilder();
            }
            name_ = input.readMessage(io.opencannabis.schema.person.Name.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(name_);
              name_ = subBuilder.buildPartial();
            }

            break;
          }
          case 18: {
            io.opencannabis.schema.person.Name.Builder subBuilder = null;
            if (legalName_ != null) {
              subBuilder = legalName_.toBuilder();
            }
            legalName_ = input.readMessage(io.opencannabis.schema.person.Name.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(legalName_);
              legalName_ = subBuilder.buildPartial();
            }

            break;
          }
          case 26: {
            io.opencannabis.schema.person.Name.Builder subBuilder = null;
            if (alternateName_ != null) {
              subBuilder = alternateName_.toBuilder();
            }
            alternateName_ = input.readMessage(io.opencannabis.schema.person.Name.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(alternateName_);
              alternateName_ = subBuilder.buildPartial();
            }

            break;
          }
          case 34: {
            io.opencannabis.schema.contact.ContactInfo.Builder subBuilder = null;
            if (contact_ != null) {
              subBuilder = contact_.toBuilder();
            }
            contact_ = input.readMessage(io.opencannabis.schema.contact.ContactInfo.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(contact_);
              contact_ = subBuilder.buildPartial();
            }

            break;
          }
          case 42: {
            io.opencannabis.schema.temporal.Date.Builder subBuilder = null;
            if (dateOfBirth_ != null) {
              subBuilder = dateOfBirth_.toBuilder();
            }
            dateOfBirth_ = input.readMessage(io.opencannabis.schema.temporal.Date.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(dateOfBirth_);
              dateOfBirth_ = subBuilder.buildPartial();
            }

            break;
          }
          case 48: {
            int rawValue = input.readEnum();

            gender_ = rawValue;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.person.PersonOuterClass.internal_static_opencannabis_person_Person_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.person.PersonOuterClass.internal_static_opencannabis_person_Person_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.person.Person.class, io.opencannabis.schema.person.Person.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private io.opencannabis.schema.person.Name name_;
  /**
   * <pre>
   * Person's primary name information.
   * </pre>
   *
   * <code>.opencannabis.person.Name name = 1 [(.gen_bq_schema.description) = "Person&#92;'s primary name information."];</code>
   */
  public boolean hasName() {
    return name_ != null;
  }
  /**
   * <pre>
   * Person's primary name information.
   * </pre>
   *
   * <code>.opencannabis.person.Name name = 1 [(.gen_bq_schema.description) = "Person&#92;'s primary name information."];</code>
   */
  public io.opencannabis.schema.person.Name getName() {
    return name_ == null ? io.opencannabis.schema.person.Name.getDefaultInstance() : name_;
  }
  /**
   * <pre>
   * Person's primary name information.
   * </pre>
   *
   * <code>.opencannabis.person.Name name = 1 [(.gen_bq_schema.description) = "Person&#92;'s primary name information."];</code>
   */
  public io.opencannabis.schema.person.NameOrBuilder getNameOrBuilder() {
    return getName();
  }

  public static final int LEGAL_NAME_FIELD_NUMBER = 2;
  private io.opencannabis.schema.person.Name legalName_;
  /**
   * <pre>
   * Person's legal name, if it differs from their primary name.
   * </pre>
   *
   * <code>.opencannabis.person.Name legal_name = 2 [(.gen_bq_schema.description) = "Person&#92;'s legal name, if it differs from their primary name."];</code>
   */
  public boolean hasLegalName() {
    return legalName_ != null;
  }
  /**
   * <pre>
   * Person's legal name, if it differs from their primary name.
   * </pre>
   *
   * <code>.opencannabis.person.Name legal_name = 2 [(.gen_bq_schema.description) = "Person&#92;'s legal name, if it differs from their primary name."];</code>
   */
  public io.opencannabis.schema.person.Name getLegalName() {
    return legalName_ == null ? io.opencannabis.schema.person.Name.getDefaultInstance() : legalName_;
  }
  /**
   * <pre>
   * Person's legal name, if it differs from their primary name.
   * </pre>
   *
   * <code>.opencannabis.person.Name legal_name = 2 [(.gen_bq_schema.description) = "Person&#92;'s legal name, if it differs from their primary name."];</code>
   */
  public io.opencannabis.schema.person.NameOrBuilder getLegalNameOrBuilder() {
    return getLegalName();
  }

  public static final int ALTERNATE_NAME_FIELD_NUMBER = 3;
  private io.opencannabis.schema.person.Name alternateName_;
  /**
   * <pre>
   * Person's optional alternate name.
   * </pre>
   *
   * <code>.opencannabis.person.Name alternate_name = 3 [(.gen_bq_schema.description) = "Person&#92;'s optional alternate name."];</code>
   */
  public boolean hasAlternateName() {
    return alternateName_ != null;
  }
  /**
   * <pre>
   * Person's optional alternate name.
   * </pre>
   *
   * <code>.opencannabis.person.Name alternate_name = 3 [(.gen_bq_schema.description) = "Person&#92;'s optional alternate name."];</code>
   */
  public io.opencannabis.schema.person.Name getAlternateName() {
    return alternateName_ == null ? io.opencannabis.schema.person.Name.getDefaultInstance() : alternateName_;
  }
  /**
   * <pre>
   * Person's optional alternate name.
   * </pre>
   *
   * <code>.opencannabis.person.Name alternate_name = 3 [(.gen_bq_schema.description) = "Person&#92;'s optional alternate name."];</code>
   */
  public io.opencannabis.schema.person.NameOrBuilder getAlternateNameOrBuilder() {
    return getAlternateName();
  }

  public static final int CONTACT_FIELD_NUMBER = 4;
  private io.opencannabis.schema.contact.ContactInfo contact_;
  /**
   * <pre>
   * Person's contact information.
   * </pre>
   *
   * <code>.opencannabis.contact.ContactInfo contact = 4 [(.gen_bq_schema.description) = "Person&#92;'s contact information."];</code>
   */
  public boolean hasContact() {
    return contact_ != null;
  }
  /**
   * <pre>
   * Person's contact information.
   * </pre>
   *
   * <code>.opencannabis.contact.ContactInfo contact = 4 [(.gen_bq_schema.description) = "Person&#92;'s contact information."];</code>
   */
  public io.opencannabis.schema.contact.ContactInfo getContact() {
    return contact_ == null ? io.opencannabis.schema.contact.ContactInfo.getDefaultInstance() : contact_;
  }
  /**
   * <pre>
   * Person's contact information.
   * </pre>
   *
   * <code>.opencannabis.contact.ContactInfo contact = 4 [(.gen_bq_schema.description) = "Person&#92;'s contact information."];</code>
   */
  public io.opencannabis.schema.contact.ContactInfoOrBuilder getContactOrBuilder() {
    return getContact();
  }

  public static final int DATE_OF_BIRTH_FIELD_NUMBER = 5;
  private io.opencannabis.schema.temporal.Date dateOfBirth_;
  /**
   * <pre>
   * Date of birth.
   * </pre>
   *
   * <code>.opencannabis.temporal.Date date_of_birth = 5 [(.gen_bq_schema.description) = "Date of birth."];</code>
   */
  public boolean hasDateOfBirth() {
    return dateOfBirth_ != null;
  }
  /**
   * <pre>
   * Date of birth.
   * </pre>
   *
   * <code>.opencannabis.temporal.Date date_of_birth = 5 [(.gen_bq_schema.description) = "Date of birth."];</code>
   */
  public io.opencannabis.schema.temporal.Date getDateOfBirth() {
    return dateOfBirth_ == null ? io.opencannabis.schema.temporal.Date.getDefaultInstance() : dateOfBirth_;
  }
  /**
   * <pre>
   * Date of birth.
   * </pre>
   *
   * <code>.opencannabis.temporal.Date date_of_birth = 5 [(.gen_bq_schema.description) = "Date of birth."];</code>
   */
  public io.opencannabis.schema.temporal.DateOrBuilder getDateOfBirthOrBuilder() {
    return getDateOfBirth();
  }

  public static final int GENDER_FIELD_NUMBER = 6;
  private int gender_;
  /**
   * <code>.opencannabis.person.Gender gender = 6 [(.gen_bq_schema.description) = "Gender."];</code>
   */
  public int getGenderValue() {
    return gender_;
  }
  /**
   * <code>.opencannabis.person.Gender gender = 6 [(.gen_bq_schema.description) = "Gender."];</code>
   */
  public io.opencannabis.schema.person.Gender getGender() {
    io.opencannabis.schema.person.Gender result = io.opencannabis.schema.person.Gender.valueOf(gender_);
    return result == null ? io.opencannabis.schema.person.Gender.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (name_ != null) {
      output.writeMessage(1, getName());
    }
    if (legalName_ != null) {
      output.writeMessage(2, getLegalName());
    }
    if (alternateName_ != null) {
      output.writeMessage(3, getAlternateName());
    }
    if (contact_ != null) {
      output.writeMessage(4, getContact());
    }
    if (dateOfBirth_ != null) {
      output.writeMessage(5, getDateOfBirth());
    }
    if (gender_ != io.opencannabis.schema.person.Gender.UNSPECIFIED.getNumber()) {
      output.writeEnum(6, gender_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (name_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getName());
    }
    if (legalName_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getLegalName());
    }
    if (alternateName_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getAlternateName());
    }
    if (contact_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getContact());
    }
    if (dateOfBirth_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getDateOfBirth());
    }
    if (gender_ != io.opencannabis.schema.person.Gender.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(6, gender_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.person.Person)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.person.Person other = (io.opencannabis.schema.person.Person) obj;

    boolean result = true;
    result = result && (hasName() == other.hasName());
    if (hasName()) {
      result = result && getName()
          .equals(other.getName());
    }
    result = result && (hasLegalName() == other.hasLegalName());
    if (hasLegalName()) {
      result = result && getLegalName()
          .equals(other.getLegalName());
    }
    result = result && (hasAlternateName() == other.hasAlternateName());
    if (hasAlternateName()) {
      result = result && getAlternateName()
          .equals(other.getAlternateName());
    }
    result = result && (hasContact() == other.hasContact());
    if (hasContact()) {
      result = result && getContact()
          .equals(other.getContact());
    }
    result = result && (hasDateOfBirth() == other.hasDateOfBirth());
    if (hasDateOfBirth()) {
      result = result && getDateOfBirth()
          .equals(other.getDateOfBirth());
    }
    result = result && gender_ == other.gender_;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasLegalName()) {
      hash = (37 * hash) + LEGAL_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getLegalName().hashCode();
    }
    if (hasAlternateName()) {
      hash = (37 * hash) + ALTERNATE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getAlternateName().hashCode();
    }
    if (hasContact()) {
      hash = (37 * hash) + CONTACT_FIELD_NUMBER;
      hash = (53 * hash) + getContact().hashCode();
    }
    if (hasDateOfBirth()) {
      hash = (37 * hash) + DATE_OF_BIRTH_FIELD_NUMBER;
      hash = (53 * hash) + getDateOfBirth().hashCode();
    }
    hash = (37 * hash) + GENDER_FIELD_NUMBER;
    hash = (53 * hash) + gender_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.person.Person parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.person.Person parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.person.Person parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.person.Person parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.person.Person parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.person.Person parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.person.Person parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.person.Person parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.person.Person parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.person.Person parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.person.Person parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.person.Person parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.person.Person prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A person/patint and their name, legal name, nickname, etc.
   * </pre>
   *
   * Protobuf type {@code opencannabis.person.Person}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.person.Person)
      io.opencannabis.schema.person.PersonOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.person.PersonOuterClass.internal_static_opencannabis_person_Person_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.person.PersonOuterClass.internal_static_opencannabis_person_Person_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.person.Person.class, io.opencannabis.schema.person.Person.Builder.class);
    }

    // Construct using io.opencannabis.schema.person.Person.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      if (nameBuilder_ == null) {
        name_ = null;
      } else {
        name_ = null;
        nameBuilder_ = null;
      }
      if (legalNameBuilder_ == null) {
        legalName_ = null;
      } else {
        legalName_ = null;
        legalNameBuilder_ = null;
      }
      if (alternateNameBuilder_ == null) {
        alternateName_ = null;
      } else {
        alternateName_ = null;
        alternateNameBuilder_ = null;
      }
      if (contactBuilder_ == null) {
        contact_ = null;
      } else {
        contact_ = null;
        contactBuilder_ = null;
      }
      if (dateOfBirthBuilder_ == null) {
        dateOfBirth_ = null;
      } else {
        dateOfBirth_ = null;
        dateOfBirthBuilder_ = null;
      }
      gender_ = 0;

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.person.PersonOuterClass.internal_static_opencannabis_person_Person_descriptor;
    }

    public io.opencannabis.schema.person.Person getDefaultInstanceForType() {
      return io.opencannabis.schema.person.Person.getDefaultInstance();
    }

    public io.opencannabis.schema.person.Person build() {
      io.opencannabis.schema.person.Person result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.person.Person buildPartial() {
      io.opencannabis.schema.person.Person result = new io.opencannabis.schema.person.Person(this);
      if (nameBuilder_ == null) {
        result.name_ = name_;
      } else {
        result.name_ = nameBuilder_.build();
      }
      if (legalNameBuilder_ == null) {
        result.legalName_ = legalName_;
      } else {
        result.legalName_ = legalNameBuilder_.build();
      }
      if (alternateNameBuilder_ == null) {
        result.alternateName_ = alternateName_;
      } else {
        result.alternateName_ = alternateNameBuilder_.build();
      }
      if (contactBuilder_ == null) {
        result.contact_ = contact_;
      } else {
        result.contact_ = contactBuilder_.build();
      }
      if (dateOfBirthBuilder_ == null) {
        result.dateOfBirth_ = dateOfBirth_;
      } else {
        result.dateOfBirth_ = dateOfBirthBuilder_.build();
      }
      result.gender_ = gender_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.person.Person) {
        return mergeFrom((io.opencannabis.schema.person.Person)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.person.Person other) {
      if (other == io.opencannabis.schema.person.Person.getDefaultInstance()) return this;
      if (other.hasName()) {
        mergeName(other.getName());
      }
      if (other.hasLegalName()) {
        mergeLegalName(other.getLegalName());
      }
      if (other.hasAlternateName()) {
        mergeAlternateName(other.getAlternateName());
      }
      if (other.hasContact()) {
        mergeContact(other.getContact());
      }
      if (other.hasDateOfBirth()) {
        mergeDateOfBirth(other.getDateOfBirth());
      }
      if (other.gender_ != 0) {
        setGenderValue(other.getGenderValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.person.Person parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.person.Person) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private io.opencannabis.schema.person.Name name_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.person.Name, io.opencannabis.schema.person.Name.Builder, io.opencannabis.schema.person.NameOrBuilder> nameBuilder_;
    /**
     * <pre>
     * Person's primary name information.
     * </pre>
     *
     * <code>.opencannabis.person.Name name = 1 [(.gen_bq_schema.description) = "Person&#92;'s primary name information."];</code>
     */
    public boolean hasName() {
      return nameBuilder_ != null || name_ != null;
    }
    /**
     * <pre>
     * Person's primary name information.
     * </pre>
     *
     * <code>.opencannabis.person.Name name = 1 [(.gen_bq_schema.description) = "Person&#92;'s primary name information."];</code>
     */
    public io.opencannabis.schema.person.Name getName() {
      if (nameBuilder_ == null) {
        return name_ == null ? io.opencannabis.schema.person.Name.getDefaultInstance() : name_;
      } else {
        return nameBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Person's primary name information.
     * </pre>
     *
     * <code>.opencannabis.person.Name name = 1 [(.gen_bq_schema.description) = "Person&#92;'s primary name information."];</code>
     */
    public Builder setName(io.opencannabis.schema.person.Name value) {
      if (nameBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        onChanged();
      } else {
        nameBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Person's primary name information.
     * </pre>
     *
     * <code>.opencannabis.person.Name name = 1 [(.gen_bq_schema.description) = "Person&#92;'s primary name information."];</code>
     */
    public Builder setName(
        io.opencannabis.schema.person.Name.Builder builderForValue) {
      if (nameBuilder_ == null) {
        name_ = builderForValue.build();
        onChanged();
      } else {
        nameBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Person's primary name information.
     * </pre>
     *
     * <code>.opencannabis.person.Name name = 1 [(.gen_bq_schema.description) = "Person&#92;'s primary name information."];</code>
     */
    public Builder mergeName(io.opencannabis.schema.person.Name value) {
      if (nameBuilder_ == null) {
        if (name_ != null) {
          name_ =
            io.opencannabis.schema.person.Name.newBuilder(name_).mergeFrom(value).buildPartial();
        } else {
          name_ = value;
        }
        onChanged();
      } else {
        nameBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Person's primary name information.
     * </pre>
     *
     * <code>.opencannabis.person.Name name = 1 [(.gen_bq_schema.description) = "Person&#92;'s primary name information."];</code>
     */
    public Builder clearName() {
      if (nameBuilder_ == null) {
        name_ = null;
        onChanged();
      } else {
        name_ = null;
        nameBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Person's primary name information.
     * </pre>
     *
     * <code>.opencannabis.person.Name name = 1 [(.gen_bq_schema.description) = "Person&#92;'s primary name information."];</code>
     */
    public io.opencannabis.schema.person.Name.Builder getNameBuilder() {
      
      onChanged();
      return getNameFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Person's primary name information.
     * </pre>
     *
     * <code>.opencannabis.person.Name name = 1 [(.gen_bq_schema.description) = "Person&#92;'s primary name information."];</code>
     */
    public io.opencannabis.schema.person.NameOrBuilder getNameOrBuilder() {
      if (nameBuilder_ != null) {
        return nameBuilder_.getMessageOrBuilder();
      } else {
        return name_ == null ?
            io.opencannabis.schema.person.Name.getDefaultInstance() : name_;
      }
    }
    /**
     * <pre>
     * Person's primary name information.
     * </pre>
     *
     * <code>.opencannabis.person.Name name = 1 [(.gen_bq_schema.description) = "Person&#92;'s primary name information."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.person.Name, io.opencannabis.schema.person.Name.Builder, io.opencannabis.schema.person.NameOrBuilder> 
        getNameFieldBuilder() {
      if (nameBuilder_ == null) {
        nameBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.person.Name, io.opencannabis.schema.person.Name.Builder, io.opencannabis.schema.person.NameOrBuilder>(
                getName(),
                getParentForChildren(),
                isClean());
        name_ = null;
      }
      return nameBuilder_;
    }

    private io.opencannabis.schema.person.Name legalName_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.person.Name, io.opencannabis.schema.person.Name.Builder, io.opencannabis.schema.person.NameOrBuilder> legalNameBuilder_;
    /**
     * <pre>
     * Person's legal name, if it differs from their primary name.
     * </pre>
     *
     * <code>.opencannabis.person.Name legal_name = 2 [(.gen_bq_schema.description) = "Person&#92;'s legal name, if it differs from their primary name."];</code>
     */
    public boolean hasLegalName() {
      return legalNameBuilder_ != null || legalName_ != null;
    }
    /**
     * <pre>
     * Person's legal name, if it differs from their primary name.
     * </pre>
     *
     * <code>.opencannabis.person.Name legal_name = 2 [(.gen_bq_schema.description) = "Person&#92;'s legal name, if it differs from their primary name."];</code>
     */
    public io.opencannabis.schema.person.Name getLegalName() {
      if (legalNameBuilder_ == null) {
        return legalName_ == null ? io.opencannabis.schema.person.Name.getDefaultInstance() : legalName_;
      } else {
        return legalNameBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Person's legal name, if it differs from their primary name.
     * </pre>
     *
     * <code>.opencannabis.person.Name legal_name = 2 [(.gen_bq_schema.description) = "Person&#92;'s legal name, if it differs from their primary name."];</code>
     */
    public Builder setLegalName(io.opencannabis.schema.person.Name value) {
      if (legalNameBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        legalName_ = value;
        onChanged();
      } else {
        legalNameBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Person's legal name, if it differs from their primary name.
     * </pre>
     *
     * <code>.opencannabis.person.Name legal_name = 2 [(.gen_bq_schema.description) = "Person&#92;'s legal name, if it differs from their primary name."];</code>
     */
    public Builder setLegalName(
        io.opencannabis.schema.person.Name.Builder builderForValue) {
      if (legalNameBuilder_ == null) {
        legalName_ = builderForValue.build();
        onChanged();
      } else {
        legalNameBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Person's legal name, if it differs from their primary name.
     * </pre>
     *
     * <code>.opencannabis.person.Name legal_name = 2 [(.gen_bq_schema.description) = "Person&#92;'s legal name, if it differs from their primary name."];</code>
     */
    public Builder mergeLegalName(io.opencannabis.schema.person.Name value) {
      if (legalNameBuilder_ == null) {
        if (legalName_ != null) {
          legalName_ =
            io.opencannabis.schema.person.Name.newBuilder(legalName_).mergeFrom(value).buildPartial();
        } else {
          legalName_ = value;
        }
        onChanged();
      } else {
        legalNameBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Person's legal name, if it differs from their primary name.
     * </pre>
     *
     * <code>.opencannabis.person.Name legal_name = 2 [(.gen_bq_schema.description) = "Person&#92;'s legal name, if it differs from their primary name."];</code>
     */
    public Builder clearLegalName() {
      if (legalNameBuilder_ == null) {
        legalName_ = null;
        onChanged();
      } else {
        legalName_ = null;
        legalNameBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Person's legal name, if it differs from their primary name.
     * </pre>
     *
     * <code>.opencannabis.person.Name legal_name = 2 [(.gen_bq_schema.description) = "Person&#92;'s legal name, if it differs from their primary name."];</code>
     */
    public io.opencannabis.schema.person.Name.Builder getLegalNameBuilder() {
      
      onChanged();
      return getLegalNameFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Person's legal name, if it differs from their primary name.
     * </pre>
     *
     * <code>.opencannabis.person.Name legal_name = 2 [(.gen_bq_schema.description) = "Person&#92;'s legal name, if it differs from their primary name."];</code>
     */
    public io.opencannabis.schema.person.NameOrBuilder getLegalNameOrBuilder() {
      if (legalNameBuilder_ != null) {
        return legalNameBuilder_.getMessageOrBuilder();
      } else {
        return legalName_ == null ?
            io.opencannabis.schema.person.Name.getDefaultInstance() : legalName_;
      }
    }
    /**
     * <pre>
     * Person's legal name, if it differs from their primary name.
     * </pre>
     *
     * <code>.opencannabis.person.Name legal_name = 2 [(.gen_bq_schema.description) = "Person&#92;'s legal name, if it differs from their primary name."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.person.Name, io.opencannabis.schema.person.Name.Builder, io.opencannabis.schema.person.NameOrBuilder> 
        getLegalNameFieldBuilder() {
      if (legalNameBuilder_ == null) {
        legalNameBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.person.Name, io.opencannabis.schema.person.Name.Builder, io.opencannabis.schema.person.NameOrBuilder>(
                getLegalName(),
                getParentForChildren(),
                isClean());
        legalName_ = null;
      }
      return legalNameBuilder_;
    }

    private io.opencannabis.schema.person.Name alternateName_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.person.Name, io.opencannabis.schema.person.Name.Builder, io.opencannabis.schema.person.NameOrBuilder> alternateNameBuilder_;
    /**
     * <pre>
     * Person's optional alternate name.
     * </pre>
     *
     * <code>.opencannabis.person.Name alternate_name = 3 [(.gen_bq_schema.description) = "Person&#92;'s optional alternate name."];</code>
     */
    public boolean hasAlternateName() {
      return alternateNameBuilder_ != null || alternateName_ != null;
    }
    /**
     * <pre>
     * Person's optional alternate name.
     * </pre>
     *
     * <code>.opencannabis.person.Name alternate_name = 3 [(.gen_bq_schema.description) = "Person&#92;'s optional alternate name."];</code>
     */
    public io.opencannabis.schema.person.Name getAlternateName() {
      if (alternateNameBuilder_ == null) {
        return alternateName_ == null ? io.opencannabis.schema.person.Name.getDefaultInstance() : alternateName_;
      } else {
        return alternateNameBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Person's optional alternate name.
     * </pre>
     *
     * <code>.opencannabis.person.Name alternate_name = 3 [(.gen_bq_schema.description) = "Person&#92;'s optional alternate name."];</code>
     */
    public Builder setAlternateName(io.opencannabis.schema.person.Name value) {
      if (alternateNameBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        alternateName_ = value;
        onChanged();
      } else {
        alternateNameBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Person's optional alternate name.
     * </pre>
     *
     * <code>.opencannabis.person.Name alternate_name = 3 [(.gen_bq_schema.description) = "Person&#92;'s optional alternate name."];</code>
     */
    public Builder setAlternateName(
        io.opencannabis.schema.person.Name.Builder builderForValue) {
      if (alternateNameBuilder_ == null) {
        alternateName_ = builderForValue.build();
        onChanged();
      } else {
        alternateNameBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Person's optional alternate name.
     * </pre>
     *
     * <code>.opencannabis.person.Name alternate_name = 3 [(.gen_bq_schema.description) = "Person&#92;'s optional alternate name."];</code>
     */
    public Builder mergeAlternateName(io.opencannabis.schema.person.Name value) {
      if (alternateNameBuilder_ == null) {
        if (alternateName_ != null) {
          alternateName_ =
            io.opencannabis.schema.person.Name.newBuilder(alternateName_).mergeFrom(value).buildPartial();
        } else {
          alternateName_ = value;
        }
        onChanged();
      } else {
        alternateNameBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Person's optional alternate name.
     * </pre>
     *
     * <code>.opencannabis.person.Name alternate_name = 3 [(.gen_bq_schema.description) = "Person&#92;'s optional alternate name."];</code>
     */
    public Builder clearAlternateName() {
      if (alternateNameBuilder_ == null) {
        alternateName_ = null;
        onChanged();
      } else {
        alternateName_ = null;
        alternateNameBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Person's optional alternate name.
     * </pre>
     *
     * <code>.opencannabis.person.Name alternate_name = 3 [(.gen_bq_schema.description) = "Person&#92;'s optional alternate name."];</code>
     */
    public io.opencannabis.schema.person.Name.Builder getAlternateNameBuilder() {
      
      onChanged();
      return getAlternateNameFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Person's optional alternate name.
     * </pre>
     *
     * <code>.opencannabis.person.Name alternate_name = 3 [(.gen_bq_schema.description) = "Person&#92;'s optional alternate name."];</code>
     */
    public io.opencannabis.schema.person.NameOrBuilder getAlternateNameOrBuilder() {
      if (alternateNameBuilder_ != null) {
        return alternateNameBuilder_.getMessageOrBuilder();
      } else {
        return alternateName_ == null ?
            io.opencannabis.schema.person.Name.getDefaultInstance() : alternateName_;
      }
    }
    /**
     * <pre>
     * Person's optional alternate name.
     * </pre>
     *
     * <code>.opencannabis.person.Name alternate_name = 3 [(.gen_bq_schema.description) = "Person&#92;'s optional alternate name."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.person.Name, io.opencannabis.schema.person.Name.Builder, io.opencannabis.schema.person.NameOrBuilder> 
        getAlternateNameFieldBuilder() {
      if (alternateNameBuilder_ == null) {
        alternateNameBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.person.Name, io.opencannabis.schema.person.Name.Builder, io.opencannabis.schema.person.NameOrBuilder>(
                getAlternateName(),
                getParentForChildren(),
                isClean());
        alternateName_ = null;
      }
      return alternateNameBuilder_;
    }

    private io.opencannabis.schema.contact.ContactInfo contact_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.contact.ContactInfo, io.opencannabis.schema.contact.ContactInfo.Builder, io.opencannabis.schema.contact.ContactInfoOrBuilder> contactBuilder_;
    /**
     * <pre>
     * Person's contact information.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 4 [(.gen_bq_schema.description) = "Person&#92;'s contact information."];</code>
     */
    public boolean hasContact() {
      return contactBuilder_ != null || contact_ != null;
    }
    /**
     * <pre>
     * Person's contact information.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 4 [(.gen_bq_schema.description) = "Person&#92;'s contact information."];</code>
     */
    public io.opencannabis.schema.contact.ContactInfo getContact() {
      if (contactBuilder_ == null) {
        return contact_ == null ? io.opencannabis.schema.contact.ContactInfo.getDefaultInstance() : contact_;
      } else {
        return contactBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Person's contact information.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 4 [(.gen_bq_schema.description) = "Person&#92;'s contact information."];</code>
     */
    public Builder setContact(io.opencannabis.schema.contact.ContactInfo value) {
      if (contactBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        contact_ = value;
        onChanged();
      } else {
        contactBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Person's contact information.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 4 [(.gen_bq_schema.description) = "Person&#92;'s contact information."];</code>
     */
    public Builder setContact(
        io.opencannabis.schema.contact.ContactInfo.Builder builderForValue) {
      if (contactBuilder_ == null) {
        contact_ = builderForValue.build();
        onChanged();
      } else {
        contactBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Person's contact information.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 4 [(.gen_bq_schema.description) = "Person&#92;'s contact information."];</code>
     */
    public Builder mergeContact(io.opencannabis.schema.contact.ContactInfo value) {
      if (contactBuilder_ == null) {
        if (contact_ != null) {
          contact_ =
            io.opencannabis.schema.contact.ContactInfo.newBuilder(contact_).mergeFrom(value).buildPartial();
        } else {
          contact_ = value;
        }
        onChanged();
      } else {
        contactBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Person's contact information.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 4 [(.gen_bq_schema.description) = "Person&#92;'s contact information."];</code>
     */
    public Builder clearContact() {
      if (contactBuilder_ == null) {
        contact_ = null;
        onChanged();
      } else {
        contact_ = null;
        contactBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Person's contact information.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 4 [(.gen_bq_schema.description) = "Person&#92;'s contact information."];</code>
     */
    public io.opencannabis.schema.contact.ContactInfo.Builder getContactBuilder() {
      
      onChanged();
      return getContactFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Person's contact information.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 4 [(.gen_bq_schema.description) = "Person&#92;'s contact information."];</code>
     */
    public io.opencannabis.schema.contact.ContactInfoOrBuilder getContactOrBuilder() {
      if (contactBuilder_ != null) {
        return contactBuilder_.getMessageOrBuilder();
      } else {
        return contact_ == null ?
            io.opencannabis.schema.contact.ContactInfo.getDefaultInstance() : contact_;
      }
    }
    /**
     * <pre>
     * Person's contact information.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 4 [(.gen_bq_schema.description) = "Person&#92;'s contact information."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.contact.ContactInfo, io.opencannabis.schema.contact.ContactInfo.Builder, io.opencannabis.schema.contact.ContactInfoOrBuilder> 
        getContactFieldBuilder() {
      if (contactBuilder_ == null) {
        contactBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.contact.ContactInfo, io.opencannabis.schema.contact.ContactInfo.Builder, io.opencannabis.schema.contact.ContactInfoOrBuilder>(
                getContact(),
                getParentForChildren(),
                isClean());
        contact_ = null;
      }
      return contactBuilder_;
    }

    private io.opencannabis.schema.temporal.Date dateOfBirth_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Date, io.opencannabis.schema.temporal.Date.Builder, io.opencannabis.schema.temporal.DateOrBuilder> dateOfBirthBuilder_;
    /**
     * <pre>
     * Date of birth.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date date_of_birth = 5 [(.gen_bq_schema.description) = "Date of birth."];</code>
     */
    public boolean hasDateOfBirth() {
      return dateOfBirthBuilder_ != null || dateOfBirth_ != null;
    }
    /**
     * <pre>
     * Date of birth.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date date_of_birth = 5 [(.gen_bq_schema.description) = "Date of birth."];</code>
     */
    public io.opencannabis.schema.temporal.Date getDateOfBirth() {
      if (dateOfBirthBuilder_ == null) {
        return dateOfBirth_ == null ? io.opencannabis.schema.temporal.Date.getDefaultInstance() : dateOfBirth_;
      } else {
        return dateOfBirthBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Date of birth.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date date_of_birth = 5 [(.gen_bq_schema.description) = "Date of birth."];</code>
     */
    public Builder setDateOfBirth(io.opencannabis.schema.temporal.Date value) {
      if (dateOfBirthBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dateOfBirth_ = value;
        onChanged();
      } else {
        dateOfBirthBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Date of birth.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date date_of_birth = 5 [(.gen_bq_schema.description) = "Date of birth."];</code>
     */
    public Builder setDateOfBirth(
        io.opencannabis.schema.temporal.Date.Builder builderForValue) {
      if (dateOfBirthBuilder_ == null) {
        dateOfBirth_ = builderForValue.build();
        onChanged();
      } else {
        dateOfBirthBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Date of birth.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date date_of_birth = 5 [(.gen_bq_schema.description) = "Date of birth."];</code>
     */
    public Builder mergeDateOfBirth(io.opencannabis.schema.temporal.Date value) {
      if (dateOfBirthBuilder_ == null) {
        if (dateOfBirth_ != null) {
          dateOfBirth_ =
            io.opencannabis.schema.temporal.Date.newBuilder(dateOfBirth_).mergeFrom(value).buildPartial();
        } else {
          dateOfBirth_ = value;
        }
        onChanged();
      } else {
        dateOfBirthBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Date of birth.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date date_of_birth = 5 [(.gen_bq_schema.description) = "Date of birth."];</code>
     */
    public Builder clearDateOfBirth() {
      if (dateOfBirthBuilder_ == null) {
        dateOfBirth_ = null;
        onChanged();
      } else {
        dateOfBirth_ = null;
        dateOfBirthBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Date of birth.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date date_of_birth = 5 [(.gen_bq_schema.description) = "Date of birth."];</code>
     */
    public io.opencannabis.schema.temporal.Date.Builder getDateOfBirthBuilder() {
      
      onChanged();
      return getDateOfBirthFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Date of birth.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date date_of_birth = 5 [(.gen_bq_schema.description) = "Date of birth."];</code>
     */
    public io.opencannabis.schema.temporal.DateOrBuilder getDateOfBirthOrBuilder() {
      if (dateOfBirthBuilder_ != null) {
        return dateOfBirthBuilder_.getMessageOrBuilder();
      } else {
        return dateOfBirth_ == null ?
            io.opencannabis.schema.temporal.Date.getDefaultInstance() : dateOfBirth_;
      }
    }
    /**
     * <pre>
     * Date of birth.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date date_of_birth = 5 [(.gen_bq_schema.description) = "Date of birth."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Date, io.opencannabis.schema.temporal.Date.Builder, io.opencannabis.schema.temporal.DateOrBuilder> 
        getDateOfBirthFieldBuilder() {
      if (dateOfBirthBuilder_ == null) {
        dateOfBirthBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Date, io.opencannabis.schema.temporal.Date.Builder, io.opencannabis.schema.temporal.DateOrBuilder>(
                getDateOfBirth(),
                getParentForChildren(),
                isClean());
        dateOfBirth_ = null;
      }
      return dateOfBirthBuilder_;
    }

    private int gender_ = 0;
    /**
     * <code>.opencannabis.person.Gender gender = 6 [(.gen_bq_schema.description) = "Gender."];</code>
     */
    public int getGenderValue() {
      return gender_;
    }
    /**
     * <code>.opencannabis.person.Gender gender = 6 [(.gen_bq_schema.description) = "Gender."];</code>
     */
    public Builder setGenderValue(int value) {
      gender_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>.opencannabis.person.Gender gender = 6 [(.gen_bq_schema.description) = "Gender."];</code>
     */
    public io.opencannabis.schema.person.Gender getGender() {
      io.opencannabis.schema.person.Gender result = io.opencannabis.schema.person.Gender.valueOf(gender_);
      return result == null ? io.opencannabis.schema.person.Gender.UNRECOGNIZED : result;
    }
    /**
     * <code>.opencannabis.person.Gender gender = 6 [(.gen_bq_schema.description) = "Gender."];</code>
     */
    public Builder setGender(io.opencannabis.schema.person.Gender value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      gender_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>.opencannabis.person.Gender gender = 6 [(.gen_bq_schema.description) = "Gender."];</code>
     */
    public Builder clearGender() {
      
      gender_ = 0;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.person.Person)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.person.Person)
  private static final io.opencannabis.schema.person.Person DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.person.Person();
  }

  public static io.opencannabis.schema.person.Person getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Person>
      PARSER = new com.google.protobuf.AbstractParser<Person>() {
    public Person parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Person(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Person> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Person> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.person.Person getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

