/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: products/distribution/DistributionChannel.proto

package io.opencannabis.schema.product;

public final class DistributionChannel {
  private DistributionChannel() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies kinds of channels that may be used or specified for product distribution policies.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.products.distribution.Channel}
   */
  public enum Channel
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown, unrecognized, or otherwise unspecified distribution channel.
     * </pre>
     *
     * <code>UNSPECIFIED_CHANNEL = 0;</code>
     */
    UNSPECIFIED_CHANNEL(0),
    /**
     * <pre>
     * Retail distribution channel, with direct sales to consumers.
     * </pre>
     *
     * <code>RETAIL = 1;</code>
     */
    RETAIL(1),
    /**
     * <pre>
     * Wholesale distribution channel, with sales to entities that re-sell.
     * </pre>
     *
     * <code>WHOLESALE = 2;</code>
     */
    WHOLESALE(2),
    /**
     * <pre>
     * Bulk distribution channel, with large-quantity sales to wholesalers, distributors or manufacturers.
     * </pre>
     *
     * <code>BULK = 3;</code>
     */
    BULK(3),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Unknown, unrecognized, or otherwise unspecified distribution channel.
     * </pre>
     *
     * <code>UNSPECIFIED_CHANNEL = 0;</code>
     */
    public static final int UNSPECIFIED_CHANNEL_VALUE = 0;
    /**
     * <pre>
     * Retail distribution channel, with direct sales to consumers.
     * </pre>
     *
     * <code>RETAIL = 1;</code>
     */
    public static final int RETAIL_VALUE = 1;
    /**
     * <pre>
     * Wholesale distribution channel, with sales to entities that re-sell.
     * </pre>
     *
     * <code>WHOLESALE = 2;</code>
     */
    public static final int WHOLESALE_VALUE = 2;
    /**
     * <pre>
     * Bulk distribution channel, with large-quantity sales to wholesalers, distributors or manufacturers.
     * </pre>
     *
     * <code>BULK = 3;</code>
     */
    public static final int BULK_VALUE = 3;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Channel valueOf(int value) {
      return forNumber(value);
    }

    public static Channel forNumber(int value) {
      switch (value) {
        case 0: return UNSPECIFIED_CHANNEL;
        case 1: return RETAIL;
        case 2: return WHOLESALE;
        case 3: return BULK;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Channel>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Channel> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Channel>() {
            public Channel findValueByNumber(int number) {
              return Channel.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.product.DistributionChannel.getDescriptor().getEnumTypes().get(0);
    }

    private static final Channel[] VALUES = values();

    public static Channel valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Channel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.products.distribution.Channel)
  }

  /**
   * <pre>
   * Specifies the supertypes of channels that may be used to categorize channels applied to product distribution
   * policies.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.products.distribution.ChannelType}
   */
  public enum ChannelType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown, unrecognized, or otherwise unspecified channel type.
     * </pre>
     *
     * <code>UNSPECIFIED_CHANNEL_TYPE = 0;</code>
     */
    UNSPECIFIED_CHANNEL_TYPE(0),
    /**
     * <pre>
     * Direct consumption of channel data, i.e., "direct retail" would be the standard retail dispensary.
     * </pre>
     *
     * <code>DIRECT = 1;</code>
     */
    DIRECT(1),
    /**
     * <pre>
     * Distribution through a second-party partner marketplace system. "Marketplace retail" would refer to digital or
     * physical aggregators or clearinghouses that work directly with consumers.
     * </pre>
     *
     * <code>MARKETPLACE = 2;</code>
     */
    MARKETPLACE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Unknown, unrecognized, or otherwise unspecified channel type.
     * </pre>
     *
     * <code>UNSPECIFIED_CHANNEL_TYPE = 0;</code>
     */
    public static final int UNSPECIFIED_CHANNEL_TYPE_VALUE = 0;
    /**
     * <pre>
     * Direct consumption of channel data, i.e., "direct retail" would be the standard retail dispensary.
     * </pre>
     *
     * <code>DIRECT = 1;</code>
     */
    public static final int DIRECT_VALUE = 1;
    /**
     * <pre>
     * Distribution through a second-party partner marketplace system. "Marketplace retail" would refer to digital or
     * physical aggregators or clearinghouses that work directly with consumers.
     * </pre>
     *
     * <code>MARKETPLACE = 2;</code>
     */
    public static final int MARKETPLACE_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ChannelType valueOf(int value) {
      return forNumber(value);
    }

    public static ChannelType forNumber(int value) {
      switch (value) {
        case 0: return UNSPECIFIED_CHANNEL_TYPE;
        case 1: return DIRECT;
        case 2: return MARKETPLACE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ChannelType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ChannelType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ChannelType>() {
            public ChannelType findValueByNumber(int number) {
              return ChannelType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.product.DistributionChannel.getDescriptor().getEnumTypes().get(1);
    }

    private static final ChannelType[] VALUES = values();

    public static ChannelType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ChannelType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.products.distribution.ChannelType)
  }

  public interface DistributionPolicyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.products.distribution.DistributionPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Whether this policy is enabled.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     */
    boolean getEnabled();

    /**
     * <pre>
     * Channel setting.
     * </pre>
     *
     * <code>.opencannabis.products.distribution.Channel channel = 2;</code>
     */
    int getChannelValue();
    /**
     * <pre>
     * Channel setting.
     * </pre>
     *
     * <code>.opencannabis.products.distribution.Channel channel = 2;</code>
     */
    io.opencannabis.schema.product.DistributionChannel.Channel getChannel();

    /**
     * <pre>
     * Channel distribution type.
     * </pre>
     *
     * <code>.opencannabis.products.distribution.ChannelType type = 3;</code>
     */
    int getTypeValue();
    /**
     * <pre>
     * Channel distribution type.
     * </pre>
     *
     * <code>.opencannabis.products.distribution.ChannelType type = 3;</code>
     */
    io.opencannabis.schema.product.DistributionChannel.ChannelType getType();

    /**
     * <pre>
     * The mere presence of a DistributionPolicy on a particular datapoint makes it eligible for distribution. This flag
     * may be set to suppress distribution of the datapoint temporarily or explicitly.
     * </pre>
     *
     * <code>bool suppress = 4;</code>
     */
    boolean getSuppress();
  }
  /**
   * <pre>
   * Specifies information required to note a channel and its settings for a given datapoint. Presence of this record
   * indicates an affirmative setting to distribute it to the specified channel, unless `suppress` is set.
   * </pre>
   *
   * Protobuf type {@code opencannabis.products.distribution.DistributionPolicy}
   */
  public  static final class DistributionPolicy extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.products.distribution.DistributionPolicy)
      DistributionPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use DistributionPolicy.newBuilder() to construct.
    private DistributionPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private DistributionPolicy() {
      enabled_ = false;
      channel_ = 0;
      type_ = 0;
      suppress_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private DistributionPolicy(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              enabled_ = input.readBool();
              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              channel_ = rawValue;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
            case 32: {

              suppress_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.product.DistributionChannel.internal_static_opencannabis_products_distribution_DistributionPolicy_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.product.DistributionChannel.internal_static_opencannabis_products_distribution_DistributionPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.class, io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.Builder.class);
    }

    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_;
    /**
     * <pre>
     * Whether this policy is enabled.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     */
    public boolean getEnabled() {
      return enabled_;
    }

    public static final int CHANNEL_FIELD_NUMBER = 2;
    private int channel_;
    /**
     * <pre>
     * Channel setting.
     * </pre>
     *
     * <code>.opencannabis.products.distribution.Channel channel = 2;</code>
     */
    public int getChannelValue() {
      return channel_;
    }
    /**
     * <pre>
     * Channel setting.
     * </pre>
     *
     * <code>.opencannabis.products.distribution.Channel channel = 2;</code>
     */
    public io.opencannabis.schema.product.DistributionChannel.Channel getChannel() {
      io.opencannabis.schema.product.DistributionChannel.Channel result = io.opencannabis.schema.product.DistributionChannel.Channel.valueOf(channel_);
      return result == null ? io.opencannabis.schema.product.DistributionChannel.Channel.UNRECOGNIZED : result;
    }

    public static final int TYPE_FIELD_NUMBER = 3;
    private int type_;
    /**
     * <pre>
     * Channel distribution type.
     * </pre>
     *
     * <code>.opencannabis.products.distribution.ChannelType type = 3;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Channel distribution type.
     * </pre>
     *
     * <code>.opencannabis.products.distribution.ChannelType type = 3;</code>
     */
    public io.opencannabis.schema.product.DistributionChannel.ChannelType getType() {
      io.opencannabis.schema.product.DistributionChannel.ChannelType result = io.opencannabis.schema.product.DistributionChannel.ChannelType.valueOf(type_);
      return result == null ? io.opencannabis.schema.product.DistributionChannel.ChannelType.UNRECOGNIZED : result;
    }

    public static final int SUPPRESS_FIELD_NUMBER = 4;
    private boolean suppress_;
    /**
     * <pre>
     * The mere presence of a DistributionPolicy on a particular datapoint makes it eligible for distribution. This flag
     * may be set to suppress distribution of the datapoint temporarily or explicitly.
     * </pre>
     *
     * <code>bool suppress = 4;</code>
     */
    public boolean getSuppress() {
      return suppress_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      if (channel_ != io.opencannabis.schema.product.DistributionChannel.Channel.UNSPECIFIED_CHANNEL.getNumber()) {
        output.writeEnum(2, channel_);
      }
      if (type_ != io.opencannabis.schema.product.DistributionChannel.ChannelType.UNSPECIFIED_CHANNEL_TYPE.getNumber()) {
        output.writeEnum(3, type_);
      }
      if (suppress_ != false) {
        output.writeBool(4, suppress_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, enabled_);
      }
      if (channel_ != io.opencannabis.schema.product.DistributionChannel.Channel.UNSPECIFIED_CHANNEL.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, channel_);
      }
      if (type_ != io.opencannabis.schema.product.DistributionChannel.ChannelType.UNSPECIFIED_CHANNEL_TYPE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, type_);
      }
      if (suppress_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(4, suppress_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.product.DistributionChannel.DistributionPolicy)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.product.DistributionChannel.DistributionPolicy other = (io.opencannabis.schema.product.DistributionChannel.DistributionPolicy) obj;

      boolean result = true;
      result = result && (getEnabled()
          == other.getEnabled());
      result = result && channel_ == other.channel_;
      result = result && type_ == other.type_;
      result = result && (getSuppress()
          == other.getSuppress());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getEnabled());
      hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + channel_;
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + SUPPRESS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getSuppress());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.product.DistributionChannel.DistributionPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies information required to note a channel and its settings for a given datapoint. Presence of this record
     * indicates an affirmative setting to distribute it to the specified channel, unless `suppress` is set.
     * </pre>
     *
     * Protobuf type {@code opencannabis.products.distribution.DistributionPolicy}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.products.distribution.DistributionPolicy)
        io.opencannabis.schema.product.DistributionChannel.DistributionPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.product.DistributionChannel.internal_static_opencannabis_products_distribution_DistributionPolicy_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.product.DistributionChannel.internal_static_opencannabis_products_distribution_DistributionPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.class, io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.Builder.class);
      }

      // Construct using io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        enabled_ = false;

        channel_ = 0;

        type_ = 0;

        suppress_ = false;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.product.DistributionChannel.internal_static_opencannabis_products_distribution_DistributionPolicy_descriptor;
      }

      public io.opencannabis.schema.product.DistributionChannel.DistributionPolicy getDefaultInstanceForType() {
        return io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.getDefaultInstance();
      }

      public io.opencannabis.schema.product.DistributionChannel.DistributionPolicy build() {
        io.opencannabis.schema.product.DistributionChannel.DistributionPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.product.DistributionChannel.DistributionPolicy buildPartial() {
        io.opencannabis.schema.product.DistributionChannel.DistributionPolicy result = new io.opencannabis.schema.product.DistributionChannel.DistributionPolicy(this);
        result.enabled_ = enabled_;
        result.channel_ = channel_;
        result.type_ = type_;
        result.suppress_ = suppress_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.product.DistributionChannel.DistributionPolicy) {
          return mergeFrom((io.opencannabis.schema.product.DistributionChannel.DistributionPolicy)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.product.DistributionChannel.DistributionPolicy other) {
        if (other == io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        if (other.channel_ != 0) {
          setChannelValue(other.getChannelValue());
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.getSuppress() != false) {
          setSuppress(other.getSuppress());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.product.DistributionChannel.DistributionPolicy parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.product.DistributionChannel.DistributionPolicy) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean enabled_ ;
      /**
       * <pre>
       * Whether this policy is enabled.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       */
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       * <pre>
       * Whether this policy is enabled.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       */
      public Builder setEnabled(boolean value) {
        
        enabled_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether this policy is enabled.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       */
      public Builder clearEnabled() {
        
        enabled_ = false;
        onChanged();
        return this;
      }

      private int channel_ = 0;
      /**
       * <pre>
       * Channel setting.
       * </pre>
       *
       * <code>.opencannabis.products.distribution.Channel channel = 2;</code>
       */
      public int getChannelValue() {
        return channel_;
      }
      /**
       * <pre>
       * Channel setting.
       * </pre>
       *
       * <code>.opencannabis.products.distribution.Channel channel = 2;</code>
       */
      public Builder setChannelValue(int value) {
        channel_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Channel setting.
       * </pre>
       *
       * <code>.opencannabis.products.distribution.Channel channel = 2;</code>
       */
      public io.opencannabis.schema.product.DistributionChannel.Channel getChannel() {
        io.opencannabis.schema.product.DistributionChannel.Channel result = io.opencannabis.schema.product.DistributionChannel.Channel.valueOf(channel_);
        return result == null ? io.opencannabis.schema.product.DistributionChannel.Channel.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Channel setting.
       * </pre>
       *
       * <code>.opencannabis.products.distribution.Channel channel = 2;</code>
       */
      public Builder setChannel(io.opencannabis.schema.product.DistributionChannel.Channel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        channel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Channel setting.
       * </pre>
       *
       * <code>.opencannabis.products.distribution.Channel channel = 2;</code>
       */
      public Builder clearChannel() {
        
        channel_ = 0;
        onChanged();
        return this;
      }

      private int type_ = 0;
      /**
       * <pre>
       * Channel distribution type.
       * </pre>
       *
       * <code>.opencannabis.products.distribution.ChannelType type = 3;</code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <pre>
       * Channel distribution type.
       * </pre>
       *
       * <code>.opencannabis.products.distribution.ChannelType type = 3;</code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Channel distribution type.
       * </pre>
       *
       * <code>.opencannabis.products.distribution.ChannelType type = 3;</code>
       */
      public io.opencannabis.schema.product.DistributionChannel.ChannelType getType() {
        io.opencannabis.schema.product.DistributionChannel.ChannelType result = io.opencannabis.schema.product.DistributionChannel.ChannelType.valueOf(type_);
        return result == null ? io.opencannabis.schema.product.DistributionChannel.ChannelType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Channel distribution type.
       * </pre>
       *
       * <code>.opencannabis.products.distribution.ChannelType type = 3;</code>
       */
      public Builder setType(io.opencannabis.schema.product.DistributionChannel.ChannelType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Channel distribution type.
       * </pre>
       *
       * <code>.opencannabis.products.distribution.ChannelType type = 3;</code>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }

      private boolean suppress_ ;
      /**
       * <pre>
       * The mere presence of a DistributionPolicy on a particular datapoint makes it eligible for distribution. This flag
       * may be set to suppress distribution of the datapoint temporarily or explicitly.
       * </pre>
       *
       * <code>bool suppress = 4;</code>
       */
      public boolean getSuppress() {
        return suppress_;
      }
      /**
       * <pre>
       * The mere presence of a DistributionPolicy on a particular datapoint makes it eligible for distribution. This flag
       * may be set to suppress distribution of the datapoint temporarily or explicitly.
       * </pre>
       *
       * <code>bool suppress = 4;</code>
       */
      public Builder setSuppress(boolean value) {
        
        suppress_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The mere presence of a DistributionPolicy on a particular datapoint makes it eligible for distribution. This flag
       * may be set to suppress distribution of the datapoint temporarily or explicitly.
       * </pre>
       *
       * <code>bool suppress = 4;</code>
       */
      public Builder clearSuppress() {
        
        suppress_ = false;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.products.distribution.DistributionPolicy)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.products.distribution.DistributionPolicy)
    private static final io.opencannabis.schema.product.DistributionChannel.DistributionPolicy DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.product.DistributionChannel.DistributionPolicy();
    }

    public static io.opencannabis.schema.product.DistributionChannel.DistributionPolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DistributionPolicy>
        PARSER = new com.google.protobuf.AbstractParser<DistributionPolicy>() {
      public DistributionPolicy parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new DistributionPolicy(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<DistributionPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DistributionPolicy> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.product.DistributionChannel.DistributionPolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_products_distribution_DistributionPolicy_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_products_distribution_DistributionPolicy_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n/products/distribution/DistributionChan" +
      "nel.proto\022\"opencannabis.products.distrib" +
      "ution\"\264\001\n\022DistributionPolicy\022\017\n\007enabled\030" +
      "\001 \001(\010\022<\n\007channel\030\002 \001(\0162+.opencannabis.pr" +
      "oducts.distribution.Channel\022=\n\004type\030\003 \001(" +
      "\0162/.opencannabis.products.distribution.C" +
      "hannelType\022\020\n\010suppress\030\004 \001(\010*G\n\007Channel\022" +
      "\027\n\023UNSPECIFIED_CHANNEL\020\000\022\n\n\006RETAIL\020\001\022\r\n\t" +
      "WHOLESALE\020\002\022\010\n\004BULK\020\003*H\n\013ChannelType\022\034\n\030" +
      "UNSPECIFIED_CHANNEL_TYPE\020\000\022\n\n\006DIRECT\020\001\022\017" +
      "\n\013MARKETPLACE\020\002B?\n\036io.opencannabis.schem" +
      "a.productB\023DistributionChannelH\001P\000\242\002\003OCS" +
      "b\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
        }, assigner);
    internal_static_opencannabis_products_distribution_DistributionPolicy_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_opencannabis_products_distribution_DistributionPolicy_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_products_distribution_DistributionPolicy_descriptor,
        new java.lang.String[] { "Enabled", "Channel", "Type", "Suppress", });
  }

  // @@protoc_insertion_point(outer_class_scope)
}
