/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: products/Edible.proto

package io.opencannabis.schema.product;

public final class EdibleProduct {
  private EdibleProduct() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies types of edible products that are known and considered sub-categories of the full 'edibles' menu section.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.products.EdibleType}
   */
  public enum EdibleType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown, unrecognized, or otherwise unspecified edible type.
     * </pre>
     *
     * <code>UNSPECIFIED_EDIBLE = 0;</code>
     */
    UNSPECIFIED_EDIBLE(0),
    /**
     * <pre>
     * Specifies chocolate products, including truffles, chocolate bars, and so on.
     * </pre>
     *
     * <code>CHOCOLATE = 1;</code>
     */
    CHOCOLATE(1),
    /**
     * <pre>
     * Specifies a baked good, such as a cookie, doughnut, brownie, pie, and so on.
     * </pre>
     *
     * <code>BAKED_GOOD = 2;</code>
     */
    BAKED_GOOD(2),
    /**
     * <pre>
     * Specifies generic candy items not otherwise specified.
     * </pre>
     *
     * <code>CANDY = 3;</code>
     */
    CANDY(3),
    /**
     * <pre>
     * Beverage/drink products.
     * </pre>
     *
     * <code>BEVERAGE = 4;</code>
     */
    BEVERAGE(4),
    /**
     * <pre>
     * Lozenge (hardened candy) products.
     * </pre>
     *
     * <code>LOZENGE = 5;</code>
     */
    LOZENGE(5),
    /**
     * <pre>
     * Sub-lingual, i.e. under-the-tongue, products.
     * </pre>
     *
     * <code>SUBLINGUAL = 6;</code>
     */
    SUBLINGUAL(6),
    /**
     * <pre>
     * Soft candies made of congealed sugar product.
     * </pre>
     *
     * <code>GUMMY = 7;</code>
     */
    GUMMY(7),
    /**
     * <pre>
     * Medicated butter pdocuts.
     * </pre>
     *
     * <code>BUTTER = 8;</code>
     */
    BUTTER(8),
    /**
     * <pre>
     * Cooking oil and other edible oils.
     * </pre>
     *
     * <code>OILS = 9;</code>
     */
    OILS(9),
    /**
     * <pre>
     * Cereals and related breakfast products.
     * </pre>
     *
     * <code>CEREAL = 10;</code>
     */
    CEREAL(10),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Unknown, unrecognized, or otherwise unspecified edible type.
     * </pre>
     *
     * <code>UNSPECIFIED_EDIBLE = 0;</code>
     */
    public static final int UNSPECIFIED_EDIBLE_VALUE = 0;
    /**
     * <pre>
     * Specifies chocolate products, including truffles, chocolate bars, and so on.
     * </pre>
     *
     * <code>CHOCOLATE = 1;</code>
     */
    public static final int CHOCOLATE_VALUE = 1;
    /**
     * <pre>
     * Specifies a baked good, such as a cookie, doughnut, brownie, pie, and so on.
     * </pre>
     *
     * <code>BAKED_GOOD = 2;</code>
     */
    public static final int BAKED_GOOD_VALUE = 2;
    /**
     * <pre>
     * Specifies generic candy items not otherwise specified.
     * </pre>
     *
     * <code>CANDY = 3;</code>
     */
    public static final int CANDY_VALUE = 3;
    /**
     * <pre>
     * Beverage/drink products.
     * </pre>
     *
     * <code>BEVERAGE = 4;</code>
     */
    public static final int BEVERAGE_VALUE = 4;
    /**
     * <pre>
     * Lozenge (hardened candy) products.
     * </pre>
     *
     * <code>LOZENGE = 5;</code>
     */
    public static final int LOZENGE_VALUE = 5;
    /**
     * <pre>
     * Sub-lingual, i.e. under-the-tongue, products.
     * </pre>
     *
     * <code>SUBLINGUAL = 6;</code>
     */
    public static final int SUBLINGUAL_VALUE = 6;
    /**
     * <pre>
     * Soft candies made of congealed sugar product.
     * </pre>
     *
     * <code>GUMMY = 7;</code>
     */
    public static final int GUMMY_VALUE = 7;
    /**
     * <pre>
     * Medicated butter pdocuts.
     * </pre>
     *
     * <code>BUTTER = 8;</code>
     */
    public static final int BUTTER_VALUE = 8;
    /**
     * <pre>
     * Cooking oil and other edible oils.
     * </pre>
     *
     * <code>OILS = 9;</code>
     */
    public static final int OILS_VALUE = 9;
    /**
     * <pre>
     * Cereals and related breakfast products.
     * </pre>
     *
     * <code>CEREAL = 10;</code>
     */
    public static final int CEREAL_VALUE = 10;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EdibleType valueOf(int value) {
      return forNumber(value);
    }

    public static EdibleType forNumber(int value) {
      switch (value) {
        case 0: return UNSPECIFIED_EDIBLE;
        case 1: return CHOCOLATE;
        case 2: return BAKED_GOOD;
        case 3: return CANDY;
        case 4: return BEVERAGE;
        case 5: return LOZENGE;
        case 6: return SUBLINGUAL;
        case 7: return GUMMY;
        case 8: return BUTTER;
        case 9: return OILS;
        case 10: return CEREAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EdibleType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        EdibleType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<EdibleType>() {
            public EdibleType findValueByNumber(int number) {
              return EdibleType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.product.EdibleProduct.getDescriptor().getEnumTypes().get(0);
    }

    private static final EdibleType[] VALUES = values();

    public static EdibleType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EdibleType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.products.EdibleType)
  }

  /**
   * <pre>
   * Flags that may be applied specifically to an edible product.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.products.EdibleFlag}
   */
  public enum EdibleFlag
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Special default flag indicating no flags.
     * </pre>
     *
     * <code>NO_EDIBLE_FLAG = 0;</code>
     */
    NO_EDIBLE_FLAG(0),
    /**
     * <pre>
     * Flag indicating this edible product is vegan.
     * </pre>
     *
     * <code>VEGAN = 1;</code>
     */
    VEGAN(1),
    /**
     * <pre>
     * Flag indicating this edible product is gluten free.
     * </pre>
     *
     * <code>GLUTEN_FREE = 2;</code>
     */
    GLUTEN_FREE(2),
    /**
     * <pre>
     * Flag indicating this edible product is sugar free.
     * </pre>
     *
     * <code>SUGAR_FREE = 3;</code>
     */
    SUGAR_FREE(3),
    /**
     * <pre>
     * Flag indicating this edible product is compliant with fair trade practices.
     * </pre>
     *
     * <code>FAIR_TRADE = 4;</code>
     */
    FAIR_TRADE(4),
    /**
     * <pre>
     * Flag indicating this edible product is considered organic.
     * </pre>
     *
     * <code>ORGANIC = 5;</code>
     */
    ORGANIC(5),
    /**
     * <pre>
     * Flag indicating this edible product was grown or cultivated or prepared locally.
     * </pre>
     *
     * <code>LOCAL = 6;</code>
     */
    LOCAL(6),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Special default flag indicating no flags.
     * </pre>
     *
     * <code>NO_EDIBLE_FLAG = 0;</code>
     */
    public static final int NO_EDIBLE_FLAG_VALUE = 0;
    /**
     * <pre>
     * Flag indicating this edible product is vegan.
     * </pre>
     *
     * <code>VEGAN = 1;</code>
     */
    public static final int VEGAN_VALUE = 1;
    /**
     * <pre>
     * Flag indicating this edible product is gluten free.
     * </pre>
     *
     * <code>GLUTEN_FREE = 2;</code>
     */
    public static final int GLUTEN_FREE_VALUE = 2;
    /**
     * <pre>
     * Flag indicating this edible product is sugar free.
     * </pre>
     *
     * <code>SUGAR_FREE = 3;</code>
     */
    public static final int SUGAR_FREE_VALUE = 3;
    /**
     * <pre>
     * Flag indicating this edible product is compliant with fair trade practices.
     * </pre>
     *
     * <code>FAIR_TRADE = 4;</code>
     */
    public static final int FAIR_TRADE_VALUE = 4;
    /**
     * <pre>
     * Flag indicating this edible product is considered organic.
     * </pre>
     *
     * <code>ORGANIC = 5;</code>
     */
    public static final int ORGANIC_VALUE = 5;
    /**
     * <pre>
     * Flag indicating this edible product was grown or cultivated or prepared locally.
     * </pre>
     *
     * <code>LOCAL = 6;</code>
     */
    public static final int LOCAL_VALUE = 6;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EdibleFlag valueOf(int value) {
      return forNumber(value);
    }

    public static EdibleFlag forNumber(int value) {
      switch (value) {
        case 0: return NO_EDIBLE_FLAG;
        case 1: return VEGAN;
        case 2: return GLUTEN_FREE;
        case 3: return SUGAR_FREE;
        case 4: return FAIR_TRADE;
        case 5: return ORGANIC;
        case 6: return LOCAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EdibleFlag>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        EdibleFlag> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<EdibleFlag>() {
            public EdibleFlag findValueByNumber(int number) {
              return EdibleFlag.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.product.EdibleProduct.getDescriptor().getEnumTypes().get(1);
    }

    private static final EdibleFlag[] VALUES = values();

    public static EdibleFlag valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EdibleFlag(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.products.EdibleFlag)
  }

  public interface EdibleIngredientOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.products.EdibleIngredient)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Human-friendly label for the ingredient.
     * </pre>
     *
     * <code>string label = 1;</code>
     */
    java.lang.String getLabel();
    /**
     * <pre>
     * Human-friendly label for the ingredient.
     * </pre>
     *
     * <code>string label = 1;</code>
     */
    com.google.protobuf.ByteString
        getLabelBytes();

    /**
     * <pre>
     * Human-friendly label describing the amount for this ingredient.
     * </pre>
     *
     * <code>string amount = 2;</code>
     */
    java.lang.String getAmount();
    /**
     * <pre>
     * Human-friendly label describing the amount for this ingredient.
     * </pre>
     *
     * <code>string amount = 2;</code>
     */
    com.google.protobuf.ByteString
        getAmountBytes();
  }
  /**
   * <pre>
   * Specifies an ingredient included in an edible.
   * </pre>
   *
   * Protobuf type {@code opencannabis.products.EdibleIngredient}
   */
  public  static final class EdibleIngredient extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.products.EdibleIngredient)
      EdibleIngredientOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use EdibleIngredient.newBuilder() to construct.
    private EdibleIngredient(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private EdibleIngredient() {
      label_ = "";
      amount_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private EdibleIngredient(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              label_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              amount_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.product.EdibleProduct.internal_static_opencannabis_products_EdibleIngredient_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.product.EdibleProduct.internal_static_opencannabis_products_EdibleIngredient_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.class, io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.Builder.class);
    }

    public static final int LABEL_FIELD_NUMBER = 1;
    private volatile java.lang.Object label_;
    /**
     * <pre>
     * Human-friendly label for the ingredient.
     * </pre>
     *
     * <code>string label = 1;</code>
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Human-friendly label for the ingredient.
     * </pre>
     *
     * <code>string label = 1;</code>
     */
    public com.google.protobuf.ByteString
        getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AMOUNT_FIELD_NUMBER = 2;
    private volatile java.lang.Object amount_;
    /**
     * <pre>
     * Human-friendly label describing the amount for this ingredient.
     * </pre>
     *
     * <code>string amount = 2;</code>
     */
    public java.lang.String getAmount() {
      java.lang.Object ref = amount_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        amount_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Human-friendly label describing the amount for this ingredient.
     * </pre>
     *
     * <code>string amount = 2;</code>
     */
    public com.google.protobuf.ByteString
        getAmountBytes() {
      java.lang.Object ref = amount_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        amount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getLabelBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, label_);
      }
      if (!getAmountBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, amount_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getLabelBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, label_);
      }
      if (!getAmountBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, amount_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.product.EdibleProduct.EdibleIngredient)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.product.EdibleProduct.EdibleIngredient other = (io.opencannabis.schema.product.EdibleProduct.EdibleIngredient) obj;

      boolean result = true;
      result = result && getLabel()
          .equals(other.getLabel());
      result = result && getAmount()
          .equals(other.getAmount());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getLabel().hashCode();
      hash = (37 * hash) + AMOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getAmount().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.product.EdibleProduct.EdibleIngredient prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies an ingredient included in an edible.
     * </pre>
     *
     * Protobuf type {@code opencannabis.products.EdibleIngredient}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.products.EdibleIngredient)
        io.opencannabis.schema.product.EdibleProduct.EdibleIngredientOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.product.EdibleProduct.internal_static_opencannabis_products_EdibleIngredient_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.product.EdibleProduct.internal_static_opencannabis_products_EdibleIngredient_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.class, io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.Builder.class);
      }

      // Construct using io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        label_ = "";

        amount_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.product.EdibleProduct.internal_static_opencannabis_products_EdibleIngredient_descriptor;
      }

      public io.opencannabis.schema.product.EdibleProduct.EdibleIngredient getDefaultInstanceForType() {
        return io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.getDefaultInstance();
      }

      public io.opencannabis.schema.product.EdibleProduct.EdibleIngredient build() {
        io.opencannabis.schema.product.EdibleProduct.EdibleIngredient result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.product.EdibleProduct.EdibleIngredient buildPartial() {
        io.opencannabis.schema.product.EdibleProduct.EdibleIngredient result = new io.opencannabis.schema.product.EdibleProduct.EdibleIngredient(this);
        result.label_ = label_;
        result.amount_ = amount_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.product.EdibleProduct.EdibleIngredient) {
          return mergeFrom((io.opencannabis.schema.product.EdibleProduct.EdibleIngredient)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.product.EdibleProduct.EdibleIngredient other) {
        if (other == io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.getDefaultInstance()) return this;
        if (!other.getLabel().isEmpty()) {
          label_ = other.label_;
          onChanged();
        }
        if (!other.getAmount().isEmpty()) {
          amount_ = other.amount_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.product.EdibleProduct.EdibleIngredient parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.product.EdibleProduct.EdibleIngredient) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object label_ = "";
      /**
       * <pre>
       * Human-friendly label for the ingredient.
       * </pre>
       *
       * <code>string label = 1;</code>
       */
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          label_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Human-friendly label for the ingredient.
       * </pre>
       *
       * <code>string label = 1;</code>
       */
      public com.google.protobuf.ByteString
          getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Human-friendly label for the ingredient.
       * </pre>
       *
       * <code>string label = 1;</code>
       */
      public Builder setLabel(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        label_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Human-friendly label for the ingredient.
       * </pre>
       *
       * <code>string label = 1;</code>
       */
      public Builder clearLabel() {
        
        label_ = getDefaultInstance().getLabel();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Human-friendly label for the ingredient.
       * </pre>
       *
       * <code>string label = 1;</code>
       */
      public Builder setLabelBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        label_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object amount_ = "";
      /**
       * <pre>
       * Human-friendly label describing the amount for this ingredient.
       * </pre>
       *
       * <code>string amount = 2;</code>
       */
      public java.lang.String getAmount() {
        java.lang.Object ref = amount_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          amount_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Human-friendly label describing the amount for this ingredient.
       * </pre>
       *
       * <code>string amount = 2;</code>
       */
      public com.google.protobuf.ByteString
          getAmountBytes() {
        java.lang.Object ref = amount_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          amount_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Human-friendly label describing the amount for this ingredient.
       * </pre>
       *
       * <code>string amount = 2;</code>
       */
      public Builder setAmount(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        amount_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Human-friendly label describing the amount for this ingredient.
       * </pre>
       *
       * <code>string amount = 2;</code>
       */
      public Builder clearAmount() {
        
        amount_ = getDefaultInstance().getAmount();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Human-friendly label describing the amount for this ingredient.
       * </pre>
       *
       * <code>string amount = 2;</code>
       */
      public Builder setAmountBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        amount_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.products.EdibleIngredient)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.products.EdibleIngredient)
    private static final io.opencannabis.schema.product.EdibleProduct.EdibleIngredient DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.product.EdibleProduct.EdibleIngredient();
    }

    public static io.opencannabis.schema.product.EdibleProduct.EdibleIngredient getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EdibleIngredient>
        PARSER = new com.google.protobuf.AbstractParser<EdibleIngredient>() {
      public EdibleIngredient parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new EdibleIngredient(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<EdibleIngredient> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EdibleIngredient> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.product.EdibleProduct.EdibleIngredient getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface EdibleOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.products.Edible)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Product key that uniquely identifies this edible item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    boolean hasKey();
    /**
     * <pre>
     * Product key that uniquely identifies this edible item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKey getKey();
    /**
     * <pre>
     * Product key that uniquely identifies this edible item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder();

    /**
     * <pre>
     * Specifies the subcategory of this edible product, if known and applicable.
     * </pre>
     *
     * <code>.opencannabis.products.EdibleType type = 2;</code>
     */
    int getTypeValue();
    /**
     * <pre>
     * Specifies the subcategory of this edible product, if known and applicable.
     * </pre>
     *
     * <code>.opencannabis.products.EdibleType type = 2;</code>
     */
    io.opencannabis.schema.product.EdibleProduct.EdibleType getType();

    /**
     * <pre>
     * Specifies flags attached to this edible product.
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
     */
    java.util.List<io.opencannabis.schema.product.EdibleProduct.EdibleFlag> getFlagsList();
    /**
     * <pre>
     * Specifies flags attached to this edible product.
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
     */
    int getFlagsCount();
    /**
     * <pre>
     * Specifies flags attached to this edible product.
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
     */
    io.opencannabis.schema.product.EdibleProduct.EdibleFlag getFlags(int index);
    /**
     * <pre>
     * Specifies flags attached to this edible product.
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
     */
    java.util.List<java.lang.Integer>
    getFlagsValueList();
    /**
     * <pre>
     * Specifies flags attached to this edible product.
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
     */
    int getFlagsValue(int index);

    /**
     * <pre>
     * Product content related to/about this edible item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    boolean hasProduct();
    /**
     * <pre>
     * Product content related to/about this edible item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    io.opencannabis.schema.content.ProductContent getProduct();
    /**
     * <pre>
     * Product content related to/about this edible item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder();

    /**
     * <pre>
     * Materials and handling information about this cartridge product.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 5;</code>
     */
    boolean hasMaterial();
    /**
     * <pre>
     * Materials and handling information about this cartridge product.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 5;</code>
     */
    io.opencannabis.schema.content.MaterialsData getMaterial();
    /**
     * <pre>
     * Materials and handling information about this cartridge product.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 5;</code>
     */
    io.opencannabis.schema.content.MaterialsDataOrBuilder getMaterialOrBuilder();

    /**
     * <pre>
     * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
     */
    java.util.List<io.opencannabis.schema.product.EdibleProduct.EdibleIngredient> 
        getIngredientsList();
    /**
     * <pre>
     * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
     */
    io.opencannabis.schema.product.EdibleProduct.EdibleIngredient getIngredients(int index);
    /**
     * <pre>
     * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
     */
    int getIngredientsCount();
    /**
     * <pre>
     * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
     */
    java.util.List<? extends io.opencannabis.schema.product.EdibleProduct.EdibleIngredientOrBuilder> 
        getIngredientsOrBuilderList();
    /**
     * <pre>
     * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
     */
    io.opencannabis.schema.product.EdibleProduct.EdibleIngredientOrBuilder getIngredientsOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Specifies an edible product that may be consumed as a food or beverage, that contains cannabis or cannabinoids in
   * some quantity.
   * </pre>
   *
   * Protobuf type {@code opencannabis.products.Edible}
   */
  public  static final class Edible extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.products.Edible)
      EdibleOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Edible.newBuilder() to construct.
    private Edible(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Edible() {
      type_ = 0;
      flags_ = java.util.Collections.emptyList();
      ingredients_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Edible(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.base.ProductKey.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(io.opencannabis.schema.base.ProductKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                flags_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000004;
              }
              flags_.add(rawValue);
              break;
            }
            case 26: {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while(input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                  flags_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000004;
                }
                flags_.add(rawValue);
              }
              input.popLimit(oldLimit);
              break;
            }
            case 34: {
              io.opencannabis.schema.content.ProductContent.Builder subBuilder = null;
              if (product_ != null) {
                subBuilder = product_.toBuilder();
              }
              product_ = input.readMessage(io.opencannabis.schema.content.ProductContent.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(product_);
                product_ = subBuilder.buildPartial();
              }

              break;
            }
            case 42: {
              io.opencannabis.schema.content.MaterialsData.Builder subBuilder = null;
              if (material_ != null) {
                subBuilder = material_.toBuilder();
              }
              material_ = input.readMessage(io.opencannabis.schema.content.MaterialsData.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(material_);
                material_ = subBuilder.buildPartial();
              }

              break;
            }
            case 50: {
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                ingredients_ = new java.util.ArrayList<io.opencannabis.schema.product.EdibleProduct.EdibleIngredient>();
                mutable_bitField0_ |= 0x00000020;
              }
              ingredients_.add(
                  input.readMessage(io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          flags_ = java.util.Collections.unmodifiableList(flags_);
        }
        if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
          ingredients_ = java.util.Collections.unmodifiableList(ingredients_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.product.EdibleProduct.internal_static_opencannabis_products_Edible_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.product.EdibleProduct.internal_static_opencannabis_products_Edible_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.product.EdibleProduct.Edible.class, io.opencannabis.schema.product.EdibleProduct.Edible.Builder.class);
    }

    private int bitField0_;
    public static final int KEY_FIELD_NUMBER = 1;
    private io.opencannabis.schema.base.ProductKey key_;
    /**
     * <pre>
     * Product key that uniquely identifies this edible item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <pre>
     * Product key that uniquely identifies this edible item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKey getKey() {
      return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
    }
    /**
     * <pre>
     * Product key that uniquely identifies this edible item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private int type_;
    /**
     * <pre>
     * Specifies the subcategory of this edible product, if known and applicable.
     * </pre>
     *
     * <code>.opencannabis.products.EdibleType type = 2;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Specifies the subcategory of this edible product, if known and applicable.
     * </pre>
     *
     * <code>.opencannabis.products.EdibleType type = 2;</code>
     */
    public io.opencannabis.schema.product.EdibleProduct.EdibleType getType() {
      io.opencannabis.schema.product.EdibleProduct.EdibleType result = io.opencannabis.schema.product.EdibleProduct.EdibleType.valueOf(type_);
      return result == null ? io.opencannabis.schema.product.EdibleProduct.EdibleType.UNRECOGNIZED : result;
    }

    public static final int FLAGS_FIELD_NUMBER = 3;
    private java.util.List<java.lang.Integer> flags_;
    private static final com.google.protobuf.Internal.ListAdapter.Converter<
        java.lang.Integer, io.opencannabis.schema.product.EdibleProduct.EdibleFlag> flags_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, io.opencannabis.schema.product.EdibleProduct.EdibleFlag>() {
              public io.opencannabis.schema.product.EdibleProduct.EdibleFlag convert(java.lang.Integer from) {
                io.opencannabis.schema.product.EdibleProduct.EdibleFlag result = io.opencannabis.schema.product.EdibleProduct.EdibleFlag.valueOf(from);
                return result == null ? io.opencannabis.schema.product.EdibleProduct.EdibleFlag.UNRECOGNIZED : result;
              }
            };
    /**
     * <pre>
     * Specifies flags attached to this edible product.
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
     */
    public java.util.List<io.opencannabis.schema.product.EdibleProduct.EdibleFlag> getFlagsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.product.EdibleProduct.EdibleFlag>(flags_, flags_converter_);
    }
    /**
     * <pre>
     * Specifies flags attached to this edible product.
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
     */
    public int getFlagsCount() {
      return flags_.size();
    }
    /**
     * <pre>
     * Specifies flags attached to this edible product.
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
     */
    public io.opencannabis.schema.product.EdibleProduct.EdibleFlag getFlags(int index) {
      return flags_converter_.convert(flags_.get(index));
    }
    /**
     * <pre>
     * Specifies flags attached to this edible product.
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
     */
    public java.util.List<java.lang.Integer>
    getFlagsValueList() {
      return flags_;
    }
    /**
     * <pre>
     * Specifies flags attached to this edible product.
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
     */
    public int getFlagsValue(int index) {
      return flags_.get(index);
    }
    private int flagsMemoizedSerializedSize;

    public static final int PRODUCT_FIELD_NUMBER = 4;
    private io.opencannabis.schema.content.ProductContent product_;
    /**
     * <pre>
     * Product content related to/about this edible item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    public boolean hasProduct() {
      return product_ != null;
    }
    /**
     * <pre>
     * Product content related to/about this edible item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    public io.opencannabis.schema.content.ProductContent getProduct() {
      return product_ == null ? io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
    }
    /**
     * <pre>
     * Product content related to/about this edible item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    public io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder() {
      return getProduct();
    }

    public static final int MATERIAL_FIELD_NUMBER = 5;
    private io.opencannabis.schema.content.MaterialsData material_;
    /**
     * <pre>
     * Materials and handling information about this cartridge product.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 5;</code>
     */
    public boolean hasMaterial() {
      return material_ != null;
    }
    /**
     * <pre>
     * Materials and handling information about this cartridge product.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 5;</code>
     */
    public io.opencannabis.schema.content.MaterialsData getMaterial() {
      return material_ == null ? io.opencannabis.schema.content.MaterialsData.getDefaultInstance() : material_;
    }
    /**
     * <pre>
     * Materials and handling information about this cartridge product.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 5;</code>
     */
    public io.opencannabis.schema.content.MaterialsDataOrBuilder getMaterialOrBuilder() {
      return getMaterial();
    }

    public static final int INGREDIENTS_FIELD_NUMBER = 6;
    private java.util.List<io.opencannabis.schema.product.EdibleProduct.EdibleIngredient> ingredients_;
    /**
     * <pre>
     * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
     */
    public java.util.List<io.opencannabis.schema.product.EdibleProduct.EdibleIngredient> getIngredientsList() {
      return ingredients_;
    }
    /**
     * <pre>
     * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.product.EdibleProduct.EdibleIngredientOrBuilder> 
        getIngredientsOrBuilderList() {
      return ingredients_;
    }
    /**
     * <pre>
     * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
     */
    public int getIngredientsCount() {
      return ingredients_.size();
    }
    /**
     * <pre>
     * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
     */
    public io.opencannabis.schema.product.EdibleProduct.EdibleIngredient getIngredients(int index) {
      return ingredients_.get(index);
    }
    /**
     * <pre>
     * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
     * </pre>
     *
     * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
     */
    public io.opencannabis.schema.product.EdibleProduct.EdibleIngredientOrBuilder getIngredientsOrBuilder(
        int index) {
      return ingredients_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (key_ != null) {
        output.writeMessage(1, getKey());
      }
      if (type_ != io.opencannabis.schema.product.EdibleProduct.EdibleType.UNSPECIFIED_EDIBLE.getNumber()) {
        output.writeEnum(2, type_);
      }
      if (getFlagsList().size() > 0) {
        output.writeUInt32NoTag(26);
        output.writeUInt32NoTag(flagsMemoizedSerializedSize);
      }
      for (int i = 0; i < flags_.size(); i++) {
        output.writeEnumNoTag(flags_.get(i));
      }
      if (product_ != null) {
        output.writeMessage(4, getProduct());
      }
      if (material_ != null) {
        output.writeMessage(5, getMaterial());
      }
      for (int i = 0; i < ingredients_.size(); i++) {
        output.writeMessage(6, ingredients_.get(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getKey());
      }
      if (type_ != io.opencannabis.schema.product.EdibleProduct.EdibleType.UNSPECIFIED_EDIBLE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, type_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < flags_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeEnumSizeNoTag(flags_.get(i));
        }
        size += dataSize;
        if (!getFlagsList().isEmpty()) {  size += 1;
          size += com.google.protobuf.CodedOutputStream
            .computeUInt32SizeNoTag(dataSize);
        }flagsMemoizedSerializedSize = dataSize;
      }
      if (product_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getProduct());
      }
      if (material_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getMaterial());
      }
      for (int i = 0; i < ingredients_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, ingredients_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.product.EdibleProduct.Edible)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.product.EdibleProduct.Edible other = (io.opencannabis.schema.product.EdibleProduct.Edible) obj;

      boolean result = true;
      result = result && (hasKey() == other.hasKey());
      if (hasKey()) {
        result = result && getKey()
            .equals(other.getKey());
      }
      result = result && type_ == other.type_;
      result = result && flags_.equals(other.flags_);
      result = result && (hasProduct() == other.hasProduct());
      if (hasProduct()) {
        result = result && getProduct()
            .equals(other.getProduct());
      }
      result = result && (hasMaterial() == other.hasMaterial());
      if (hasMaterial()) {
        result = result && getMaterial()
            .equals(other.getMaterial());
      }
      result = result && getIngredientsList()
          .equals(other.getIngredientsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      if (getFlagsCount() > 0) {
        hash = (37 * hash) + FLAGS_FIELD_NUMBER;
        hash = (53 * hash) + flags_.hashCode();
      }
      if (hasProduct()) {
        hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
        hash = (53 * hash) + getProduct().hashCode();
      }
      if (hasMaterial()) {
        hash = (37 * hash) + MATERIAL_FIELD_NUMBER;
        hash = (53 * hash) + getMaterial().hashCode();
      }
      if (getIngredientsCount() > 0) {
        hash = (37 * hash) + INGREDIENTS_FIELD_NUMBER;
        hash = (53 * hash) + getIngredientsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.product.EdibleProduct.Edible parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.EdibleProduct.Edible parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.EdibleProduct.Edible parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.EdibleProduct.Edible parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.EdibleProduct.Edible parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.EdibleProduct.Edible parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.EdibleProduct.Edible parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.EdibleProduct.Edible parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.EdibleProduct.Edible parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.EdibleProduct.Edible parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.EdibleProduct.Edible parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.EdibleProduct.Edible parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.product.EdibleProduct.Edible prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies an edible product that may be consumed as a food or beverage, that contains cannabis or cannabinoids in
     * some quantity.
     * </pre>
     *
     * Protobuf type {@code opencannabis.products.Edible}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.products.Edible)
        io.opencannabis.schema.product.EdibleProduct.EdibleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.product.EdibleProduct.internal_static_opencannabis_products_Edible_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.product.EdibleProduct.internal_static_opencannabis_products_Edible_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.product.EdibleProduct.Edible.class, io.opencannabis.schema.product.EdibleProduct.Edible.Builder.class);
      }

      // Construct using io.opencannabis.schema.product.EdibleProduct.Edible.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getIngredientsFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        type_ = 0;

        flags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        if (productBuilder_ == null) {
          product_ = null;
        } else {
          product_ = null;
          productBuilder_ = null;
        }
        if (materialBuilder_ == null) {
          material_ = null;
        } else {
          material_ = null;
          materialBuilder_ = null;
        }
        if (ingredientsBuilder_ == null) {
          ingredients_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ingredientsBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.product.EdibleProduct.internal_static_opencannabis_products_Edible_descriptor;
      }

      public io.opencannabis.schema.product.EdibleProduct.Edible getDefaultInstanceForType() {
        return io.opencannabis.schema.product.EdibleProduct.Edible.getDefaultInstance();
      }

      public io.opencannabis.schema.product.EdibleProduct.Edible build() {
        io.opencannabis.schema.product.EdibleProduct.Edible result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.product.EdibleProduct.Edible buildPartial() {
        io.opencannabis.schema.product.EdibleProduct.Edible result = new io.opencannabis.schema.product.EdibleProduct.Edible(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        result.type_ = type_;
        if (((bitField0_ & 0x00000004) == 0x00000004)) {
          flags_ = java.util.Collections.unmodifiableList(flags_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.flags_ = flags_;
        if (productBuilder_ == null) {
          result.product_ = product_;
        } else {
          result.product_ = productBuilder_.build();
        }
        if (materialBuilder_ == null) {
          result.material_ = material_;
        } else {
          result.material_ = materialBuilder_.build();
        }
        if (ingredientsBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020)) {
            ingredients_ = java.util.Collections.unmodifiableList(ingredients_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.ingredients_ = ingredients_;
        } else {
          result.ingredients_ = ingredientsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.product.EdibleProduct.Edible) {
          return mergeFrom((io.opencannabis.schema.product.EdibleProduct.Edible)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.product.EdibleProduct.Edible other) {
        if (other == io.opencannabis.schema.product.EdibleProduct.Edible.getDefaultInstance()) return this;
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (!other.flags_.isEmpty()) {
          if (flags_.isEmpty()) {
            flags_ = other.flags_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureFlagsIsMutable();
            flags_.addAll(other.flags_);
          }
          onChanged();
        }
        if (other.hasProduct()) {
          mergeProduct(other.getProduct());
        }
        if (other.hasMaterial()) {
          mergeMaterial(other.getMaterial());
        }
        if (ingredientsBuilder_ == null) {
          if (!other.ingredients_.isEmpty()) {
            if (ingredients_.isEmpty()) {
              ingredients_ = other.ingredients_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureIngredientsIsMutable();
              ingredients_.addAll(other.ingredients_);
            }
            onChanged();
          }
        } else {
          if (!other.ingredients_.isEmpty()) {
            if (ingredientsBuilder_.isEmpty()) {
              ingredientsBuilder_.dispose();
              ingredientsBuilder_ = null;
              ingredients_ = other.ingredients_;
              bitField0_ = (bitField0_ & ~0x00000020);
              ingredientsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getIngredientsFieldBuilder() : null;
            } else {
              ingredientsBuilder_.addAllMessages(other.ingredients_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.product.EdibleProduct.Edible parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.product.EdibleProduct.Edible) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private io.opencannabis.schema.base.ProductKey key_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> keyBuilder_;
      /**
       * <pre>
       * Product key that uniquely identifies this edible item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this edible item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Product key that uniquely identifies this edible item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this edible item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(
          io.opencannabis.schema.base.ProductKey.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this edible item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder mergeKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              io.opencannabis.schema.base.ProductKey.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this edible item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this edible item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Product key that uniquely identifies this edible item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        }
      }
      /**
       * <pre>
       * Product key that uniquely identifies this edible item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }

      private int type_ = 0;
      /**
       * <pre>
       * Specifies the subcategory of this edible product, if known and applicable.
       * </pre>
       *
       * <code>.opencannabis.products.EdibleType type = 2;</code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <pre>
       * Specifies the subcategory of this edible product, if known and applicable.
       * </pre>
       *
       * <code>.opencannabis.products.EdibleType type = 2;</code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the subcategory of this edible product, if known and applicable.
       * </pre>
       *
       * <code>.opencannabis.products.EdibleType type = 2;</code>
       */
      public io.opencannabis.schema.product.EdibleProduct.EdibleType getType() {
        io.opencannabis.schema.product.EdibleProduct.EdibleType result = io.opencannabis.schema.product.EdibleProduct.EdibleType.valueOf(type_);
        return result == null ? io.opencannabis.schema.product.EdibleProduct.EdibleType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Specifies the subcategory of this edible product, if known and applicable.
       * </pre>
       *
       * <code>.opencannabis.products.EdibleType type = 2;</code>
       */
      public Builder setType(io.opencannabis.schema.product.EdibleProduct.EdibleType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the subcategory of this edible product, if known and applicable.
       * </pre>
       *
       * <code>.opencannabis.products.EdibleType type = 2;</code>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> flags_ =
        java.util.Collections.emptyList();
      private void ensureFlagsIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          flags_ = new java.util.ArrayList<java.lang.Integer>(flags_);
          bitField0_ |= 0x00000004;
        }
      }
      /**
       * <pre>
       * Specifies flags attached to this edible product.
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
       */
      public java.util.List<io.opencannabis.schema.product.EdibleProduct.EdibleFlag> getFlagsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, io.opencannabis.schema.product.EdibleProduct.EdibleFlag>(flags_, flags_converter_);
      }
      /**
       * <pre>
       * Specifies flags attached to this edible product.
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
       */
      public int getFlagsCount() {
        return flags_.size();
      }
      /**
       * <pre>
       * Specifies flags attached to this edible product.
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
       */
      public io.opencannabis.schema.product.EdibleProduct.EdibleFlag getFlags(int index) {
        return flags_converter_.convert(flags_.get(index));
      }
      /**
       * <pre>
       * Specifies flags attached to this edible product.
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
       */
      public Builder setFlags(
          int index, io.opencannabis.schema.product.EdibleProduct.EdibleFlag value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlagsIsMutable();
        flags_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags attached to this edible product.
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
       */
      public Builder addFlags(io.opencannabis.schema.product.EdibleProduct.EdibleFlag value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlagsIsMutable();
        flags_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags attached to this edible product.
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
       */
      public Builder addAllFlags(
          java.lang.Iterable<? extends io.opencannabis.schema.product.EdibleProduct.EdibleFlag> values) {
        ensureFlagsIsMutable();
        for (io.opencannabis.schema.product.EdibleProduct.EdibleFlag value : values) {
          flags_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags attached to this edible product.
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
       */
      public Builder clearFlags() {
        flags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags attached to this edible product.
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
       */
      public java.util.List<java.lang.Integer>
      getFlagsValueList() {
        return java.util.Collections.unmodifiableList(flags_);
      }
      /**
       * <pre>
       * Specifies flags attached to this edible product.
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
       */
      public int getFlagsValue(int index) {
        return flags_.get(index);
      }
      /**
       * <pre>
       * Specifies flags attached to this edible product.
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
       */
      public Builder setFlagsValue(
          int index, int value) {
        ensureFlagsIsMutable();
        flags_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags attached to this edible product.
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
       */
      public Builder addFlagsValue(int value) {
        ensureFlagsIsMutable();
        flags_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags attached to this edible product.
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleFlag flags = 3;</code>
       */
      public Builder addAllFlagsValue(
          java.lang.Iterable<java.lang.Integer> values) {
        ensureFlagsIsMutable();
        for (int value : values) {
          flags_.add(value);
        }
        onChanged();
        return this;
      }

      private io.opencannabis.schema.content.ProductContent product_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder> productBuilder_;
      /**
       * <pre>
       * Product content related to/about this edible item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public boolean hasProduct() {
        return productBuilder_ != null || product_ != null;
      }
      /**
       * <pre>
       * Product content related to/about this edible item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public io.opencannabis.schema.content.ProductContent getProduct() {
        if (productBuilder_ == null) {
          return product_ == null ? io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
        } else {
          return productBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Product content related to/about this edible item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public Builder setProduct(io.opencannabis.schema.content.ProductContent value) {
        if (productBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          product_ = value;
          onChanged();
        } else {
          productBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product content related to/about this edible item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public Builder setProduct(
          io.opencannabis.schema.content.ProductContent.Builder builderForValue) {
        if (productBuilder_ == null) {
          product_ = builderForValue.build();
          onChanged();
        } else {
          productBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Product content related to/about this edible item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public Builder mergeProduct(io.opencannabis.schema.content.ProductContent value) {
        if (productBuilder_ == null) {
          if (product_ != null) {
            product_ =
              io.opencannabis.schema.content.ProductContent.newBuilder(product_).mergeFrom(value).buildPartial();
          } else {
            product_ = value;
          }
          onChanged();
        } else {
          productBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product content related to/about this edible item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public Builder clearProduct() {
        if (productBuilder_ == null) {
          product_ = null;
          onChanged();
        } else {
          product_ = null;
          productBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Product content related to/about this edible item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public io.opencannabis.schema.content.ProductContent.Builder getProductBuilder() {
        
        onChanged();
        return getProductFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Product content related to/about this edible item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder() {
        if (productBuilder_ != null) {
          return productBuilder_.getMessageOrBuilder();
        } else {
          return product_ == null ?
              io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
        }
      }
      /**
       * <pre>
       * Product content related to/about this edible item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder> 
          getProductFieldBuilder() {
        if (productBuilder_ == null) {
          productBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder>(
                  getProduct(),
                  getParentForChildren(),
                  isClean());
          product_ = null;
        }
        return productBuilder_;
      }

      private io.opencannabis.schema.content.MaterialsData material_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.MaterialsData, io.opencannabis.schema.content.MaterialsData.Builder, io.opencannabis.schema.content.MaterialsDataOrBuilder> materialBuilder_;
      /**
       * <pre>
       * Materials and handling information about this cartridge product.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public boolean hasMaterial() {
        return materialBuilder_ != null || material_ != null;
      }
      /**
       * <pre>
       * Materials and handling information about this cartridge product.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public io.opencannabis.schema.content.MaterialsData getMaterial() {
        if (materialBuilder_ == null) {
          return material_ == null ? io.opencannabis.schema.content.MaterialsData.getDefaultInstance() : material_;
        } else {
          return materialBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Materials and handling information about this cartridge product.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public Builder setMaterial(io.opencannabis.schema.content.MaterialsData value) {
        if (materialBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          material_ = value;
          onChanged();
        } else {
          materialBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Materials and handling information about this cartridge product.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public Builder setMaterial(
          io.opencannabis.schema.content.MaterialsData.Builder builderForValue) {
        if (materialBuilder_ == null) {
          material_ = builderForValue.build();
          onChanged();
        } else {
          materialBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Materials and handling information about this cartridge product.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public Builder mergeMaterial(io.opencannabis.schema.content.MaterialsData value) {
        if (materialBuilder_ == null) {
          if (material_ != null) {
            material_ =
              io.opencannabis.schema.content.MaterialsData.newBuilder(material_).mergeFrom(value).buildPartial();
          } else {
            material_ = value;
          }
          onChanged();
        } else {
          materialBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Materials and handling information about this cartridge product.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public Builder clearMaterial() {
        if (materialBuilder_ == null) {
          material_ = null;
          onChanged();
        } else {
          material_ = null;
          materialBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Materials and handling information about this cartridge product.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public io.opencannabis.schema.content.MaterialsData.Builder getMaterialBuilder() {
        
        onChanged();
        return getMaterialFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Materials and handling information about this cartridge product.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public io.opencannabis.schema.content.MaterialsDataOrBuilder getMaterialOrBuilder() {
        if (materialBuilder_ != null) {
          return materialBuilder_.getMessageOrBuilder();
        } else {
          return material_ == null ?
              io.opencannabis.schema.content.MaterialsData.getDefaultInstance() : material_;
        }
      }
      /**
       * <pre>
       * Materials and handling information about this cartridge product.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.MaterialsData, io.opencannabis.schema.content.MaterialsData.Builder, io.opencannabis.schema.content.MaterialsDataOrBuilder> 
          getMaterialFieldBuilder() {
        if (materialBuilder_ == null) {
          materialBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.content.MaterialsData, io.opencannabis.schema.content.MaterialsData.Builder, io.opencannabis.schema.content.MaterialsDataOrBuilder>(
                  getMaterial(),
                  getParentForChildren(),
                  isClean());
          material_ = null;
        }
        return materialBuilder_;
      }

      private java.util.List<io.opencannabis.schema.product.EdibleProduct.EdibleIngredient> ingredients_ =
        java.util.Collections.emptyList();
      private void ensureIngredientsIsMutable() {
        if (!((bitField0_ & 0x00000020) == 0x00000020)) {
          ingredients_ = new java.util.ArrayList<io.opencannabis.schema.product.EdibleProduct.EdibleIngredient>(ingredients_);
          bitField0_ |= 0x00000020;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.product.EdibleProduct.EdibleIngredient, io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.Builder, io.opencannabis.schema.product.EdibleProduct.EdibleIngredientOrBuilder> ingredientsBuilder_;

      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public java.util.List<io.opencannabis.schema.product.EdibleProduct.EdibleIngredient> getIngredientsList() {
        if (ingredientsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(ingredients_);
        } else {
          return ingredientsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public int getIngredientsCount() {
        if (ingredientsBuilder_ == null) {
          return ingredients_.size();
        } else {
          return ingredientsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public io.opencannabis.schema.product.EdibleProduct.EdibleIngredient getIngredients(int index) {
        if (ingredientsBuilder_ == null) {
          return ingredients_.get(index);
        } else {
          return ingredientsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public Builder setIngredients(
          int index, io.opencannabis.schema.product.EdibleProduct.EdibleIngredient value) {
        if (ingredientsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIngredientsIsMutable();
          ingredients_.set(index, value);
          onChanged();
        } else {
          ingredientsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public Builder setIngredients(
          int index, io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.Builder builderForValue) {
        if (ingredientsBuilder_ == null) {
          ensureIngredientsIsMutable();
          ingredients_.set(index, builderForValue.build());
          onChanged();
        } else {
          ingredientsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public Builder addIngredients(io.opencannabis.schema.product.EdibleProduct.EdibleIngredient value) {
        if (ingredientsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIngredientsIsMutable();
          ingredients_.add(value);
          onChanged();
        } else {
          ingredientsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public Builder addIngredients(
          int index, io.opencannabis.schema.product.EdibleProduct.EdibleIngredient value) {
        if (ingredientsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIngredientsIsMutable();
          ingredients_.add(index, value);
          onChanged();
        } else {
          ingredientsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public Builder addIngredients(
          io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.Builder builderForValue) {
        if (ingredientsBuilder_ == null) {
          ensureIngredientsIsMutable();
          ingredients_.add(builderForValue.build());
          onChanged();
        } else {
          ingredientsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public Builder addIngredients(
          int index, io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.Builder builderForValue) {
        if (ingredientsBuilder_ == null) {
          ensureIngredientsIsMutable();
          ingredients_.add(index, builderForValue.build());
          onChanged();
        } else {
          ingredientsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public Builder addAllIngredients(
          java.lang.Iterable<? extends io.opencannabis.schema.product.EdibleProduct.EdibleIngredient> values) {
        if (ingredientsBuilder_ == null) {
          ensureIngredientsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, ingredients_);
          onChanged();
        } else {
          ingredientsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public Builder clearIngredients() {
        if (ingredientsBuilder_ == null) {
          ingredients_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          ingredientsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public Builder removeIngredients(int index) {
        if (ingredientsBuilder_ == null) {
          ensureIngredientsIsMutable();
          ingredients_.remove(index);
          onChanged();
        } else {
          ingredientsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.Builder getIngredientsBuilder(
          int index) {
        return getIngredientsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public io.opencannabis.schema.product.EdibleProduct.EdibleIngredientOrBuilder getIngredientsOrBuilder(
          int index) {
        if (ingredientsBuilder_ == null) {
          return ingredients_.get(index);  } else {
          return ingredientsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public java.util.List<? extends io.opencannabis.schema.product.EdibleProduct.EdibleIngredientOrBuilder> 
           getIngredientsOrBuilderList() {
        if (ingredientsBuilder_ != null) {
          return ingredientsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(ingredients_);
        }
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.Builder addIngredientsBuilder() {
        return getIngredientsFieldBuilder().addBuilder(
            io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.getDefaultInstance());
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.Builder addIngredientsBuilder(
          int index) {
        return getIngredientsFieldBuilder().addBuilder(
            index, io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.getDefaultInstance());
      }
      /**
       * <pre>
       * Specifies the ingredients for a product, when/if it is composed of ingredients (i.e. edibles).
       * </pre>
       *
       * <code>repeated .opencannabis.products.EdibleIngredient ingredients = 6;</code>
       */
      public java.util.List<io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.Builder> 
           getIngredientsBuilderList() {
        return getIngredientsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.product.EdibleProduct.EdibleIngredient, io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.Builder, io.opencannabis.schema.product.EdibleProduct.EdibleIngredientOrBuilder> 
          getIngredientsFieldBuilder() {
        if (ingredientsBuilder_ == null) {
          ingredientsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.opencannabis.schema.product.EdibleProduct.EdibleIngredient, io.opencannabis.schema.product.EdibleProduct.EdibleIngredient.Builder, io.opencannabis.schema.product.EdibleProduct.EdibleIngredientOrBuilder>(
                  ingredients_,
                  ((bitField0_ & 0x00000020) == 0x00000020),
                  getParentForChildren(),
                  isClean());
          ingredients_ = null;
        }
        return ingredientsBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.products.Edible)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.products.Edible)
    private static final io.opencannabis.schema.product.EdibleProduct.Edible DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.product.EdibleProduct.Edible();
    }

    public static io.opencannabis.schema.product.EdibleProduct.Edible getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Edible>
        PARSER = new com.google.protobuf.AbstractParser<Edible>() {
      public Edible parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Edible(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Edible> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Edible> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.product.EdibleProduct.Edible getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_products_EdibleIngredient_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_products_EdibleIngredient_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_products_Edible_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_products_Edible_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\025products/Edible.proto\022\025opencannabis.pr" +
      "oducts\032\025base/ProductKey.proto\032\033content/M" +
      "aterialsData.proto\032\034content/ProductConte" +
      "nt.proto\"1\n\020EdibleIngredient\022\r\n\005label\030\001 " +
      "\001(\t\022\016\n\006amount\030\002 \001(\t\"\303\002\n\006Edible\022*\n\003key\030\001 " +
      "\001(\0132\035.opencannabis.base.ProductKey\022/\n\004ty" +
      "pe\030\002 \001(\0162!.opencannabis.products.EdibleT" +
      "ype\0220\n\005flags\030\003 \003(\0162!.opencannabis.produc" +
      "ts.EdibleFlag\0225\n\007product\030\004 \001(\0132$.opencan" +
      "nabis.content.ProductContent\0225\n\010material" +
      "\030\005 \001(\0132#.opencannabis.content.MaterialsD" +
      "ata\022<\n\013ingredients\030\006 \003(\0132\'.opencannabis." +
      "products.EdibleIngredient*\246\001\n\nEdibleType" +
      "\022\026\n\022UNSPECIFIED_EDIBLE\020\000\022\r\n\tCHOCOLATE\020\001\022" +
      "\016\n\nBAKED_GOOD\020\002\022\t\n\005CANDY\020\003\022\014\n\010BEVERAGE\020\004" +
      "\022\013\n\007LOZENGE\020\005\022\016\n\nSUBLINGUAL\020\006\022\t\n\005GUMMY\020\007" +
      "\022\n\n\006BUTTER\020\010\022\010\n\004OILS\020\t\022\n\n\006CEREAL\020\n*t\n\nEd" +
      "ibleFlag\022\022\n\016NO_EDIBLE_FLAG\020\000\022\t\n\005VEGAN\020\001\022" +
      "\017\n\013GLUTEN_FREE\020\002\022\016\n\nSUGAR_FREE\020\003\022\016\n\nFAIR" +
      "_TRADE\020\004\022\013\n\007ORGANIC\020\005\022\t\n\005LOCAL\020\006B9\n\036io.o" +
      "pencannabis.schema.productB\rEdibleProduc" +
      "tH\001P\000\242\002\003OCSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.base.BaseProductKey.getDescriptor(),
          io.opencannabis.schema.content.MaterialsContent.getDescriptor(),
          io.opencannabis.schema.content.AttachedContent.getDescriptor(),
        }, assigner);
    internal_static_opencannabis_products_EdibleIngredient_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_opencannabis_products_EdibleIngredient_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_products_EdibleIngredient_descriptor,
        new java.lang.String[] { "Label", "Amount", });
    internal_static_opencannabis_products_Edible_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_opencannabis_products_Edible_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_products_Edible_descriptor,
        new java.lang.String[] { "Key", "Type", "Flags", "Product", "Material", "Ingredients", });
    io.opencannabis.schema.base.BaseProductKey.getDescriptor();
    io.opencannabis.schema.content.MaterialsContent.getDescriptor();
    io.opencannabis.schema.content.AttachedContent.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
