/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: products/Extract.proto

package io.opencannabis.schema.product;

public final class ExtractProduct {
  private ExtractProduct() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Enumerates types of extracted oleoresin cannabis products that have known/specified subcategories.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.products.ExtractType}
   */
  public enum ExtractType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Uknown, unrecognized, or otherwise unspecified extract type.
     * </pre>
     *
     * <code>UNSPECIFIED_EXTRACT = 0;</code>
     */
    UNSPECIFIED_EXTRACT(0),
    /**
     * <pre>
     * Cannabis oil, usually in liquid form.
     * </pre>
     *
     * <code>OIL = 1;</code>
     */
    OIL(1),
    /**
     * <pre>
     * Cannabis wax - viscous semisolid forms of cannabis oil.
     * </pre>
     *
     * <code>WAX = 2;</code>
     */
    WAX(2),
    /**
     * <pre>
     * Clear, amber solid cannabis wax.
     * </pre>
     *
     * <code>SHATTER = 3;</code>
     */
    SHATTER(3),
    /**
     * <pre>
     * Particulate discharge from cannabis flowers that contains THC or other cannabinoids.
     * </pre>
     *
     * <code>KIEF = 4;</code>
     */
    KIEF(4),
    /**
     * <pre>
     * Fully extracted and concentrated cannabis resin.
     * </pre>
     *
     * <code>HASH = 5;</code>
     */
    HASH(5),
    /**
     * <pre>
     * Extracted cannabis that is kept at freezing temperatures, rather than dried.
     * </pre>
     *
     * <code>LIVE_RESIN = 6;</code>
     */
    LIVE_RESIN(6),
    /**
     * <pre>
     * Heated and terpene-vaporized live resin.
     * </pre>
     *
     * <code>ROSIN = 7;</code>
     */
    ROSIN(7),
    /**
     * <pre>
     * Similar process to shatter, but with higher-terpene output and a softer, cheese-like consistency.
     * </pre>
     *
     * <code>CRUMBLE = 8;</code>
     */
    CRUMBLE(8),
    /**
     * <pre>
     * THC distillate, often with extracted terpene content added.
     * </pre>
     *
     * <code>SAUCE = 9;</code>
     */
    SAUCE(9),
    /**
     * <pre>
     * Raw THC or terpene distillate, in dust or powder form.
     * </pre>
     *
     * <code>SUGAR = 10;</code>
     */
    SUGAR(10),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Uknown, unrecognized, or otherwise unspecified extract type.
     * </pre>
     *
     * <code>UNSPECIFIED_EXTRACT = 0;</code>
     */
    public static final int UNSPECIFIED_EXTRACT_VALUE = 0;
    /**
     * <pre>
     * Cannabis oil, usually in liquid form.
     * </pre>
     *
     * <code>OIL = 1;</code>
     */
    public static final int OIL_VALUE = 1;
    /**
     * <pre>
     * Cannabis wax - viscous semisolid forms of cannabis oil.
     * </pre>
     *
     * <code>WAX = 2;</code>
     */
    public static final int WAX_VALUE = 2;
    /**
     * <pre>
     * Clear, amber solid cannabis wax.
     * </pre>
     *
     * <code>SHATTER = 3;</code>
     */
    public static final int SHATTER_VALUE = 3;
    /**
     * <pre>
     * Particulate discharge from cannabis flowers that contains THC or other cannabinoids.
     * </pre>
     *
     * <code>KIEF = 4;</code>
     */
    public static final int KIEF_VALUE = 4;
    /**
     * <pre>
     * Fully extracted and concentrated cannabis resin.
     * </pre>
     *
     * <code>HASH = 5;</code>
     */
    public static final int HASH_VALUE = 5;
    /**
     * <pre>
     * Extracted cannabis that is kept at freezing temperatures, rather than dried.
     * </pre>
     *
     * <code>LIVE_RESIN = 6;</code>
     */
    public static final int LIVE_RESIN_VALUE = 6;
    /**
     * <pre>
     * Heated and terpene-vaporized live resin.
     * </pre>
     *
     * <code>ROSIN = 7;</code>
     */
    public static final int ROSIN_VALUE = 7;
    /**
     * <pre>
     * Similar process to shatter, but with higher-terpene output and a softer, cheese-like consistency.
     * </pre>
     *
     * <code>CRUMBLE = 8;</code>
     */
    public static final int CRUMBLE_VALUE = 8;
    /**
     * <pre>
     * THC distillate, often with extracted terpene content added.
     * </pre>
     *
     * <code>SAUCE = 9;</code>
     */
    public static final int SAUCE_VALUE = 9;
    /**
     * <pre>
     * Raw THC or terpene distillate, in dust or powder form.
     * </pre>
     *
     * <code>SUGAR = 10;</code>
     */
    public static final int SUGAR_VALUE = 10;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExtractType valueOf(int value) {
      return forNumber(value);
    }

    public static ExtractType forNumber(int value) {
      switch (value) {
        case 0: return UNSPECIFIED_EXTRACT;
        case 1: return OIL;
        case 2: return WAX;
        case 3: return SHATTER;
        case 4: return KIEF;
        case 5: return HASH;
        case 6: return LIVE_RESIN;
        case 7: return ROSIN;
        case 8: return CRUMBLE;
        case 9: return SAUCE;
        case 10: return SUGAR;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ExtractType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ExtractType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ExtractType>() {
            public ExtractType findValueByNumber(int number) {
              return ExtractType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.product.ExtractProduct.getDescriptor().getEnumTypes().get(0);
    }

    private static final ExtractType[] VALUES = values();

    public static ExtractType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ExtractType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.products.ExtractType)
  }

  /**
   * <pre>
   * Specifies flags that may specifically be applied to an extracted cannabis product.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.products.ExtractFlag}
   */
  public enum ExtractFlag
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Specifies that no flags are set.
     * </pre>
     *
     * <code>NO_EXTRACT_FLAGS = 0;</code>
     */
    NO_EXTRACT_FLAGS(0),
    /**
     * <pre>
     * Specifies that this extract was made with a solventless process.
     * </pre>
     *
     * <code>SOLVENTLESS = 1;</code>
     */
    SOLVENTLESS(1),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Specifies that no flags are set.
     * </pre>
     *
     * <code>NO_EXTRACT_FLAGS = 0;</code>
     */
    public static final int NO_EXTRACT_FLAGS_VALUE = 0;
    /**
     * <pre>
     * Specifies that this extract was made with a solventless process.
     * </pre>
     *
     * <code>SOLVENTLESS = 1;</code>
     */
    public static final int SOLVENTLESS_VALUE = 1;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExtractFlag valueOf(int value) {
      return forNumber(value);
    }

    public static ExtractFlag forNumber(int value) {
      switch (value) {
        case 0: return NO_EXTRACT_FLAGS;
        case 1: return SOLVENTLESS;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ExtractFlag>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ExtractFlag> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ExtractFlag>() {
            public ExtractFlag findValueByNumber(int number) {
              return ExtractFlag.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.product.ExtractProduct.getDescriptor().getEnumTypes().get(1);
    }

    private static final ExtractFlag[] VALUES = values();

    public static ExtractFlag valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ExtractFlag(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.products.ExtractFlag)
  }

  public interface ExtractOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.products.Extract)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Product key that uniquely identifies this cannabis extract item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    boolean hasKey();
    /**
     * <pre>
     * Product key that uniquely identifies this cannabis extract item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKey getKey();
    /**
     * <pre>
     * Product key that uniquely identifies this cannabis extract item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder();

    /**
     * <pre>
     * Specific type of extract being described.
     * </pre>
     *
     * <code>.opencannabis.products.ExtractType type = 2;</code>
     */
    int getTypeValue();
    /**
     * <pre>
     * Specific type of extract being described.
     * </pre>
     *
     * <code>.opencannabis.products.ExtractType type = 2;</code>
     */
    io.opencannabis.schema.product.ExtractProduct.ExtractType getType();

    /**
     * <pre>
     * Specifies flags that may specifically be applied to this extracted cannabis item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
     */
    java.util.List<io.opencannabis.schema.product.ExtractProduct.ExtractFlag> getFlagList();
    /**
     * <pre>
     * Specifies flags that may specifically be applied to this extracted cannabis item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
     */
    int getFlagCount();
    /**
     * <pre>
     * Specifies flags that may specifically be applied to this extracted cannabis item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
     */
    io.opencannabis.schema.product.ExtractProduct.ExtractFlag getFlag(int index);
    /**
     * <pre>
     * Specifies flags that may specifically be applied to this extracted cannabis item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
     */
    java.util.List<java.lang.Integer>
    getFlagValueList();
    /**
     * <pre>
     * Specifies flags that may specifically be applied to this extracted cannabis item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
     */
    int getFlagValue(int index);

    /**
     * <pre>
     * Flower that was used to produce this extract.
     * </pre>
     *
     * <code>.opencannabis.base.ProductReference flower = 4;</code>
     */
    boolean hasFlower();
    /**
     * <pre>
     * Flower that was used to produce this extract.
     * </pre>
     *
     * <code>.opencannabis.base.ProductReference flower = 4;</code>
     */
    io.opencannabis.schema.base.ProductReference getFlower();
    /**
     * <pre>
     * Flower that was used to produce this extract.
     * </pre>
     *
     * <code>.opencannabis.base.ProductReference flower = 4;</code>
     */
    io.opencannabis.schema.base.ProductReferenceOrBuilder getFlowerOrBuilder();

    /**
     * <pre>
     * Product content about this extracted cannabis item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 5;</code>
     */
    boolean hasProduct();
    /**
     * <pre>
     * Product content about this extracted cannabis item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 5;</code>
     */
    io.opencannabis.schema.content.ProductContent getProduct();
    /**
     * <pre>
     * Product content about this extracted cannabis item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 5;</code>
     */
    io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder();

    /**
     * <pre>
     * Materials and handling data attached to this extracted cannabis item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 6;</code>
     */
    boolean hasMaterial();
    /**
     * <pre>
     * Materials and handling data attached to this extracted cannabis item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 6;</code>
     */
    io.opencannabis.schema.content.MaterialsData getMaterial();
    /**
     * <pre>
     * Materials and handling data attached to this extracted cannabis item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 6;</code>
     */
    io.opencannabis.schema.content.MaterialsDataOrBuilder getMaterialOrBuilder();
  }
  /**
   * <pre>
   * Specifies an extracted cannabis product, whereby cannabis plant material has been reduced to a more potent and
   * concentrated form by some process.
   * </pre>
   *
   * Protobuf type {@code opencannabis.products.Extract}
   */
  public  static final class Extract extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.products.Extract)
      ExtractOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Extract.newBuilder() to construct.
    private Extract(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Extract() {
      type_ = 0;
      flag_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Extract(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.base.ProductKey.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(io.opencannabis.schema.base.ProductKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                flag_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000004;
              }
              flag_.add(rawValue);
              break;
            }
            case 26: {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while(input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                  flag_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000004;
                }
                flag_.add(rawValue);
              }
              input.popLimit(oldLimit);
              break;
            }
            case 34: {
              io.opencannabis.schema.base.ProductReference.Builder subBuilder = null;
              if (flower_ != null) {
                subBuilder = flower_.toBuilder();
              }
              flower_ = input.readMessage(io.opencannabis.schema.base.ProductReference.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(flower_);
                flower_ = subBuilder.buildPartial();
              }

              break;
            }
            case 42: {
              io.opencannabis.schema.content.ProductContent.Builder subBuilder = null;
              if (product_ != null) {
                subBuilder = product_.toBuilder();
              }
              product_ = input.readMessage(io.opencannabis.schema.content.ProductContent.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(product_);
                product_ = subBuilder.buildPartial();
              }

              break;
            }
            case 50: {
              io.opencannabis.schema.content.MaterialsData.Builder subBuilder = null;
              if (material_ != null) {
                subBuilder = material_.toBuilder();
              }
              material_ = input.readMessage(io.opencannabis.schema.content.MaterialsData.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(material_);
                material_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          flag_ = java.util.Collections.unmodifiableList(flag_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.product.ExtractProduct.internal_static_opencannabis_products_Extract_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.product.ExtractProduct.internal_static_opencannabis_products_Extract_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.product.ExtractProduct.Extract.class, io.opencannabis.schema.product.ExtractProduct.Extract.Builder.class);
    }

    private int bitField0_;
    public static final int KEY_FIELD_NUMBER = 1;
    private io.opencannabis.schema.base.ProductKey key_;
    /**
     * <pre>
     * Product key that uniquely identifies this cannabis extract item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <pre>
     * Product key that uniquely identifies this cannabis extract item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKey getKey() {
      return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
    }
    /**
     * <pre>
     * Product key that uniquely identifies this cannabis extract item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private int type_;
    /**
     * <pre>
     * Specific type of extract being described.
     * </pre>
     *
     * <code>.opencannabis.products.ExtractType type = 2;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Specific type of extract being described.
     * </pre>
     *
     * <code>.opencannabis.products.ExtractType type = 2;</code>
     */
    public io.opencannabis.schema.product.ExtractProduct.ExtractType getType() {
      io.opencannabis.schema.product.ExtractProduct.ExtractType result = io.opencannabis.schema.product.ExtractProduct.ExtractType.valueOf(type_);
      return result == null ? io.opencannabis.schema.product.ExtractProduct.ExtractType.UNRECOGNIZED : result;
    }

    public static final int FLAG_FIELD_NUMBER = 3;
    private java.util.List<java.lang.Integer> flag_;
    private static final com.google.protobuf.Internal.ListAdapter.Converter<
        java.lang.Integer, io.opencannabis.schema.product.ExtractProduct.ExtractFlag> flag_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, io.opencannabis.schema.product.ExtractProduct.ExtractFlag>() {
              public io.opencannabis.schema.product.ExtractProduct.ExtractFlag convert(java.lang.Integer from) {
                io.opencannabis.schema.product.ExtractProduct.ExtractFlag result = io.opencannabis.schema.product.ExtractProduct.ExtractFlag.valueOf(from);
                return result == null ? io.opencannabis.schema.product.ExtractProduct.ExtractFlag.UNRECOGNIZED : result;
              }
            };
    /**
     * <pre>
     * Specifies flags that may specifically be applied to this extracted cannabis item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
     */
    public java.util.List<io.opencannabis.schema.product.ExtractProduct.ExtractFlag> getFlagList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.product.ExtractProduct.ExtractFlag>(flag_, flag_converter_);
    }
    /**
     * <pre>
     * Specifies flags that may specifically be applied to this extracted cannabis item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
     */
    public int getFlagCount() {
      return flag_.size();
    }
    /**
     * <pre>
     * Specifies flags that may specifically be applied to this extracted cannabis item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
     */
    public io.opencannabis.schema.product.ExtractProduct.ExtractFlag getFlag(int index) {
      return flag_converter_.convert(flag_.get(index));
    }
    /**
     * <pre>
     * Specifies flags that may specifically be applied to this extracted cannabis item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
     */
    public java.util.List<java.lang.Integer>
    getFlagValueList() {
      return flag_;
    }
    /**
     * <pre>
     * Specifies flags that may specifically be applied to this extracted cannabis item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
     */
    public int getFlagValue(int index) {
      return flag_.get(index);
    }
    private int flagMemoizedSerializedSize;

    public static final int FLOWER_FIELD_NUMBER = 4;
    private io.opencannabis.schema.base.ProductReference flower_;
    /**
     * <pre>
     * Flower that was used to produce this extract.
     * </pre>
     *
     * <code>.opencannabis.base.ProductReference flower = 4;</code>
     */
    public boolean hasFlower() {
      return flower_ != null;
    }
    /**
     * <pre>
     * Flower that was used to produce this extract.
     * </pre>
     *
     * <code>.opencannabis.base.ProductReference flower = 4;</code>
     */
    public io.opencannabis.schema.base.ProductReference getFlower() {
      return flower_ == null ? io.opencannabis.schema.base.ProductReference.getDefaultInstance() : flower_;
    }
    /**
     * <pre>
     * Flower that was used to produce this extract.
     * </pre>
     *
     * <code>.opencannabis.base.ProductReference flower = 4;</code>
     */
    public io.opencannabis.schema.base.ProductReferenceOrBuilder getFlowerOrBuilder() {
      return getFlower();
    }

    public static final int PRODUCT_FIELD_NUMBER = 5;
    private io.opencannabis.schema.content.ProductContent product_;
    /**
     * <pre>
     * Product content about this extracted cannabis item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 5;</code>
     */
    public boolean hasProduct() {
      return product_ != null;
    }
    /**
     * <pre>
     * Product content about this extracted cannabis item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 5;</code>
     */
    public io.opencannabis.schema.content.ProductContent getProduct() {
      return product_ == null ? io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
    }
    /**
     * <pre>
     * Product content about this extracted cannabis item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 5;</code>
     */
    public io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder() {
      return getProduct();
    }

    public static final int MATERIAL_FIELD_NUMBER = 6;
    private io.opencannabis.schema.content.MaterialsData material_;
    /**
     * <pre>
     * Materials and handling data attached to this extracted cannabis item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 6;</code>
     */
    public boolean hasMaterial() {
      return material_ != null;
    }
    /**
     * <pre>
     * Materials and handling data attached to this extracted cannabis item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 6;</code>
     */
    public io.opencannabis.schema.content.MaterialsData getMaterial() {
      return material_ == null ? io.opencannabis.schema.content.MaterialsData.getDefaultInstance() : material_;
    }
    /**
     * <pre>
     * Materials and handling data attached to this extracted cannabis item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 6;</code>
     */
    public io.opencannabis.schema.content.MaterialsDataOrBuilder getMaterialOrBuilder() {
      return getMaterial();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (key_ != null) {
        output.writeMessage(1, getKey());
      }
      if (type_ != io.opencannabis.schema.product.ExtractProduct.ExtractType.UNSPECIFIED_EXTRACT.getNumber()) {
        output.writeEnum(2, type_);
      }
      if (getFlagList().size() > 0) {
        output.writeUInt32NoTag(26);
        output.writeUInt32NoTag(flagMemoizedSerializedSize);
      }
      for (int i = 0; i < flag_.size(); i++) {
        output.writeEnumNoTag(flag_.get(i));
      }
      if (flower_ != null) {
        output.writeMessage(4, getFlower());
      }
      if (product_ != null) {
        output.writeMessage(5, getProduct());
      }
      if (material_ != null) {
        output.writeMessage(6, getMaterial());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getKey());
      }
      if (type_ != io.opencannabis.schema.product.ExtractProduct.ExtractType.UNSPECIFIED_EXTRACT.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, type_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < flag_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeEnumSizeNoTag(flag_.get(i));
        }
        size += dataSize;
        if (!getFlagList().isEmpty()) {  size += 1;
          size += com.google.protobuf.CodedOutputStream
            .computeUInt32SizeNoTag(dataSize);
        }flagMemoizedSerializedSize = dataSize;
      }
      if (flower_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getFlower());
      }
      if (product_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getProduct());
      }
      if (material_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getMaterial());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.product.ExtractProduct.Extract)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.product.ExtractProduct.Extract other = (io.opencannabis.schema.product.ExtractProduct.Extract) obj;

      boolean result = true;
      result = result && (hasKey() == other.hasKey());
      if (hasKey()) {
        result = result && getKey()
            .equals(other.getKey());
      }
      result = result && type_ == other.type_;
      result = result && flag_.equals(other.flag_);
      result = result && (hasFlower() == other.hasFlower());
      if (hasFlower()) {
        result = result && getFlower()
            .equals(other.getFlower());
      }
      result = result && (hasProduct() == other.hasProduct());
      if (hasProduct()) {
        result = result && getProduct()
            .equals(other.getProduct());
      }
      result = result && (hasMaterial() == other.hasMaterial());
      if (hasMaterial()) {
        result = result && getMaterial()
            .equals(other.getMaterial());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      if (getFlagCount() > 0) {
        hash = (37 * hash) + FLAG_FIELD_NUMBER;
        hash = (53 * hash) + flag_.hashCode();
      }
      if (hasFlower()) {
        hash = (37 * hash) + FLOWER_FIELD_NUMBER;
        hash = (53 * hash) + getFlower().hashCode();
      }
      if (hasProduct()) {
        hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
        hash = (53 * hash) + getProduct().hashCode();
      }
      if (hasMaterial()) {
        hash = (37 * hash) + MATERIAL_FIELD_NUMBER;
        hash = (53 * hash) + getMaterial().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.product.ExtractProduct.Extract parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.ExtractProduct.Extract parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.ExtractProduct.Extract parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.ExtractProduct.Extract parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.ExtractProduct.Extract parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.ExtractProduct.Extract parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.ExtractProduct.Extract parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.ExtractProduct.Extract parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.ExtractProduct.Extract parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.ExtractProduct.Extract parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.ExtractProduct.Extract parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.ExtractProduct.Extract parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.product.ExtractProduct.Extract prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies an extracted cannabis product, whereby cannabis plant material has been reduced to a more potent and
     * concentrated form by some process.
     * </pre>
     *
     * Protobuf type {@code opencannabis.products.Extract}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.products.Extract)
        io.opencannabis.schema.product.ExtractProduct.ExtractOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.product.ExtractProduct.internal_static_opencannabis_products_Extract_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.product.ExtractProduct.internal_static_opencannabis_products_Extract_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.product.ExtractProduct.Extract.class, io.opencannabis.schema.product.ExtractProduct.Extract.Builder.class);
      }

      // Construct using io.opencannabis.schema.product.ExtractProduct.Extract.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        type_ = 0;

        flag_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        if (flowerBuilder_ == null) {
          flower_ = null;
        } else {
          flower_ = null;
          flowerBuilder_ = null;
        }
        if (productBuilder_ == null) {
          product_ = null;
        } else {
          product_ = null;
          productBuilder_ = null;
        }
        if (materialBuilder_ == null) {
          material_ = null;
        } else {
          material_ = null;
          materialBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.product.ExtractProduct.internal_static_opencannabis_products_Extract_descriptor;
      }

      public io.opencannabis.schema.product.ExtractProduct.Extract getDefaultInstanceForType() {
        return io.opencannabis.schema.product.ExtractProduct.Extract.getDefaultInstance();
      }

      public io.opencannabis.schema.product.ExtractProduct.Extract build() {
        io.opencannabis.schema.product.ExtractProduct.Extract result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.product.ExtractProduct.Extract buildPartial() {
        io.opencannabis.schema.product.ExtractProduct.Extract result = new io.opencannabis.schema.product.ExtractProduct.Extract(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        result.type_ = type_;
        if (((bitField0_ & 0x00000004) == 0x00000004)) {
          flag_ = java.util.Collections.unmodifiableList(flag_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.flag_ = flag_;
        if (flowerBuilder_ == null) {
          result.flower_ = flower_;
        } else {
          result.flower_ = flowerBuilder_.build();
        }
        if (productBuilder_ == null) {
          result.product_ = product_;
        } else {
          result.product_ = productBuilder_.build();
        }
        if (materialBuilder_ == null) {
          result.material_ = material_;
        } else {
          result.material_ = materialBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.product.ExtractProduct.Extract) {
          return mergeFrom((io.opencannabis.schema.product.ExtractProduct.Extract)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.product.ExtractProduct.Extract other) {
        if (other == io.opencannabis.schema.product.ExtractProduct.Extract.getDefaultInstance()) return this;
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (!other.flag_.isEmpty()) {
          if (flag_.isEmpty()) {
            flag_ = other.flag_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureFlagIsMutable();
            flag_.addAll(other.flag_);
          }
          onChanged();
        }
        if (other.hasFlower()) {
          mergeFlower(other.getFlower());
        }
        if (other.hasProduct()) {
          mergeProduct(other.getProduct());
        }
        if (other.hasMaterial()) {
          mergeMaterial(other.getMaterial());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.product.ExtractProduct.Extract parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.product.ExtractProduct.Extract) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private io.opencannabis.schema.base.ProductKey key_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> keyBuilder_;
      /**
       * <pre>
       * Product key that uniquely identifies this cannabis extract item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this cannabis extract item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Product key that uniquely identifies this cannabis extract item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this cannabis extract item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(
          io.opencannabis.schema.base.ProductKey.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this cannabis extract item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder mergeKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              io.opencannabis.schema.base.ProductKey.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this cannabis extract item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this cannabis extract item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Product key that uniquely identifies this cannabis extract item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        }
      }
      /**
       * <pre>
       * Product key that uniquely identifies this cannabis extract item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }

      private int type_ = 0;
      /**
       * <pre>
       * Specific type of extract being described.
       * </pre>
       *
       * <code>.opencannabis.products.ExtractType type = 2;</code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <pre>
       * Specific type of extract being described.
       * </pre>
       *
       * <code>.opencannabis.products.ExtractType type = 2;</code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specific type of extract being described.
       * </pre>
       *
       * <code>.opencannabis.products.ExtractType type = 2;</code>
       */
      public io.opencannabis.schema.product.ExtractProduct.ExtractType getType() {
        io.opencannabis.schema.product.ExtractProduct.ExtractType result = io.opencannabis.schema.product.ExtractProduct.ExtractType.valueOf(type_);
        return result == null ? io.opencannabis.schema.product.ExtractProduct.ExtractType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Specific type of extract being described.
       * </pre>
       *
       * <code>.opencannabis.products.ExtractType type = 2;</code>
       */
      public Builder setType(io.opencannabis.schema.product.ExtractProduct.ExtractType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specific type of extract being described.
       * </pre>
       *
       * <code>.opencannabis.products.ExtractType type = 2;</code>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> flag_ =
        java.util.Collections.emptyList();
      private void ensureFlagIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          flag_ = new java.util.ArrayList<java.lang.Integer>(flag_);
          bitField0_ |= 0x00000004;
        }
      }
      /**
       * <pre>
       * Specifies flags that may specifically be applied to this extracted cannabis item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
       */
      public java.util.List<io.opencannabis.schema.product.ExtractProduct.ExtractFlag> getFlagList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, io.opencannabis.schema.product.ExtractProduct.ExtractFlag>(flag_, flag_converter_);
      }
      /**
       * <pre>
       * Specifies flags that may specifically be applied to this extracted cannabis item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
       */
      public int getFlagCount() {
        return flag_.size();
      }
      /**
       * <pre>
       * Specifies flags that may specifically be applied to this extracted cannabis item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
       */
      public io.opencannabis.schema.product.ExtractProduct.ExtractFlag getFlag(int index) {
        return flag_converter_.convert(flag_.get(index));
      }
      /**
       * <pre>
       * Specifies flags that may specifically be applied to this extracted cannabis item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
       */
      public Builder setFlag(
          int index, io.opencannabis.schema.product.ExtractProduct.ExtractFlag value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlagIsMutable();
        flag_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags that may specifically be applied to this extracted cannabis item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
       */
      public Builder addFlag(io.opencannabis.schema.product.ExtractProduct.ExtractFlag value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlagIsMutable();
        flag_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags that may specifically be applied to this extracted cannabis item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
       */
      public Builder addAllFlag(
          java.lang.Iterable<? extends io.opencannabis.schema.product.ExtractProduct.ExtractFlag> values) {
        ensureFlagIsMutable();
        for (io.opencannabis.schema.product.ExtractProduct.ExtractFlag value : values) {
          flag_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags that may specifically be applied to this extracted cannabis item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
       */
      public Builder clearFlag() {
        flag_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags that may specifically be applied to this extracted cannabis item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
       */
      public java.util.List<java.lang.Integer>
      getFlagValueList() {
        return java.util.Collections.unmodifiableList(flag_);
      }
      /**
       * <pre>
       * Specifies flags that may specifically be applied to this extracted cannabis item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
       */
      public int getFlagValue(int index) {
        return flag_.get(index);
      }
      /**
       * <pre>
       * Specifies flags that may specifically be applied to this extracted cannabis item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
       */
      public Builder setFlagValue(
          int index, int value) {
        ensureFlagIsMutable();
        flag_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags that may specifically be applied to this extracted cannabis item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
       */
      public Builder addFlagValue(int value) {
        ensureFlagIsMutable();
        flag_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags that may specifically be applied to this extracted cannabis item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.ExtractFlag flag = 3;</code>
       */
      public Builder addAllFlagValue(
          java.lang.Iterable<java.lang.Integer> values) {
        ensureFlagIsMutable();
        for (int value : values) {
          flag_.add(value);
        }
        onChanged();
        return this;
      }

      private io.opencannabis.schema.base.ProductReference flower_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductReference, io.opencannabis.schema.base.ProductReference.Builder, io.opencannabis.schema.base.ProductReferenceOrBuilder> flowerBuilder_;
      /**
       * <pre>
       * Flower that was used to produce this extract.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 4;</code>
       */
      public boolean hasFlower() {
        return flowerBuilder_ != null || flower_ != null;
      }
      /**
       * <pre>
       * Flower that was used to produce this extract.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 4;</code>
       */
      public io.opencannabis.schema.base.ProductReference getFlower() {
        if (flowerBuilder_ == null) {
          return flower_ == null ? io.opencannabis.schema.base.ProductReference.getDefaultInstance() : flower_;
        } else {
          return flowerBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Flower that was used to produce this extract.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 4;</code>
       */
      public Builder setFlower(io.opencannabis.schema.base.ProductReference value) {
        if (flowerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          flower_ = value;
          onChanged();
        } else {
          flowerBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Flower that was used to produce this extract.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 4;</code>
       */
      public Builder setFlower(
          io.opencannabis.schema.base.ProductReference.Builder builderForValue) {
        if (flowerBuilder_ == null) {
          flower_ = builderForValue.build();
          onChanged();
        } else {
          flowerBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Flower that was used to produce this extract.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 4;</code>
       */
      public Builder mergeFlower(io.opencannabis.schema.base.ProductReference value) {
        if (flowerBuilder_ == null) {
          if (flower_ != null) {
            flower_ =
              io.opencannabis.schema.base.ProductReference.newBuilder(flower_).mergeFrom(value).buildPartial();
          } else {
            flower_ = value;
          }
          onChanged();
        } else {
          flowerBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Flower that was used to produce this extract.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 4;</code>
       */
      public Builder clearFlower() {
        if (flowerBuilder_ == null) {
          flower_ = null;
          onChanged();
        } else {
          flower_ = null;
          flowerBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Flower that was used to produce this extract.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 4;</code>
       */
      public io.opencannabis.schema.base.ProductReference.Builder getFlowerBuilder() {
        
        onChanged();
        return getFlowerFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Flower that was used to produce this extract.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 4;</code>
       */
      public io.opencannabis.schema.base.ProductReferenceOrBuilder getFlowerOrBuilder() {
        if (flowerBuilder_ != null) {
          return flowerBuilder_.getMessageOrBuilder();
        } else {
          return flower_ == null ?
              io.opencannabis.schema.base.ProductReference.getDefaultInstance() : flower_;
        }
      }
      /**
       * <pre>
       * Flower that was used to produce this extract.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductReference, io.opencannabis.schema.base.ProductReference.Builder, io.opencannabis.schema.base.ProductReferenceOrBuilder> 
          getFlowerFieldBuilder() {
        if (flowerBuilder_ == null) {
          flowerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductReference, io.opencannabis.schema.base.ProductReference.Builder, io.opencannabis.schema.base.ProductReferenceOrBuilder>(
                  getFlower(),
                  getParentForChildren(),
                  isClean());
          flower_ = null;
        }
        return flowerBuilder_;
      }

      private io.opencannabis.schema.content.ProductContent product_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder> productBuilder_;
      /**
       * <pre>
       * Product content about this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 5;</code>
       */
      public boolean hasProduct() {
        return productBuilder_ != null || product_ != null;
      }
      /**
       * <pre>
       * Product content about this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 5;</code>
       */
      public io.opencannabis.schema.content.ProductContent getProduct() {
        if (productBuilder_ == null) {
          return product_ == null ? io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
        } else {
          return productBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Product content about this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 5;</code>
       */
      public Builder setProduct(io.opencannabis.schema.content.ProductContent value) {
        if (productBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          product_ = value;
          onChanged();
        } else {
          productBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product content about this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 5;</code>
       */
      public Builder setProduct(
          io.opencannabis.schema.content.ProductContent.Builder builderForValue) {
        if (productBuilder_ == null) {
          product_ = builderForValue.build();
          onChanged();
        } else {
          productBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Product content about this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 5;</code>
       */
      public Builder mergeProduct(io.opencannabis.schema.content.ProductContent value) {
        if (productBuilder_ == null) {
          if (product_ != null) {
            product_ =
              io.opencannabis.schema.content.ProductContent.newBuilder(product_).mergeFrom(value).buildPartial();
          } else {
            product_ = value;
          }
          onChanged();
        } else {
          productBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product content about this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 5;</code>
       */
      public Builder clearProduct() {
        if (productBuilder_ == null) {
          product_ = null;
          onChanged();
        } else {
          product_ = null;
          productBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Product content about this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 5;</code>
       */
      public io.opencannabis.schema.content.ProductContent.Builder getProductBuilder() {
        
        onChanged();
        return getProductFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Product content about this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 5;</code>
       */
      public io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder() {
        if (productBuilder_ != null) {
          return productBuilder_.getMessageOrBuilder();
        } else {
          return product_ == null ?
              io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
        }
      }
      /**
       * <pre>
       * Product content about this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder> 
          getProductFieldBuilder() {
        if (productBuilder_ == null) {
          productBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder>(
                  getProduct(),
                  getParentForChildren(),
                  isClean());
          product_ = null;
        }
        return productBuilder_;
      }

      private io.opencannabis.schema.content.MaterialsData material_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.MaterialsData, io.opencannabis.schema.content.MaterialsData.Builder, io.opencannabis.schema.content.MaterialsDataOrBuilder> materialBuilder_;
      /**
       * <pre>
       * Materials and handling data attached to this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 6;</code>
       */
      public boolean hasMaterial() {
        return materialBuilder_ != null || material_ != null;
      }
      /**
       * <pre>
       * Materials and handling data attached to this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 6;</code>
       */
      public io.opencannabis.schema.content.MaterialsData getMaterial() {
        if (materialBuilder_ == null) {
          return material_ == null ? io.opencannabis.schema.content.MaterialsData.getDefaultInstance() : material_;
        } else {
          return materialBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Materials and handling data attached to this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 6;</code>
       */
      public Builder setMaterial(io.opencannabis.schema.content.MaterialsData value) {
        if (materialBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          material_ = value;
          onChanged();
        } else {
          materialBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Materials and handling data attached to this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 6;</code>
       */
      public Builder setMaterial(
          io.opencannabis.schema.content.MaterialsData.Builder builderForValue) {
        if (materialBuilder_ == null) {
          material_ = builderForValue.build();
          onChanged();
        } else {
          materialBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Materials and handling data attached to this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 6;</code>
       */
      public Builder mergeMaterial(io.opencannabis.schema.content.MaterialsData value) {
        if (materialBuilder_ == null) {
          if (material_ != null) {
            material_ =
              io.opencannabis.schema.content.MaterialsData.newBuilder(material_).mergeFrom(value).buildPartial();
          } else {
            material_ = value;
          }
          onChanged();
        } else {
          materialBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Materials and handling data attached to this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 6;</code>
       */
      public Builder clearMaterial() {
        if (materialBuilder_ == null) {
          material_ = null;
          onChanged();
        } else {
          material_ = null;
          materialBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Materials and handling data attached to this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 6;</code>
       */
      public io.opencannabis.schema.content.MaterialsData.Builder getMaterialBuilder() {
        
        onChanged();
        return getMaterialFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Materials and handling data attached to this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 6;</code>
       */
      public io.opencannabis.schema.content.MaterialsDataOrBuilder getMaterialOrBuilder() {
        if (materialBuilder_ != null) {
          return materialBuilder_.getMessageOrBuilder();
        } else {
          return material_ == null ?
              io.opencannabis.schema.content.MaterialsData.getDefaultInstance() : material_;
        }
      }
      /**
       * <pre>
       * Materials and handling data attached to this extracted cannabis item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.MaterialsData, io.opencannabis.schema.content.MaterialsData.Builder, io.opencannabis.schema.content.MaterialsDataOrBuilder> 
          getMaterialFieldBuilder() {
        if (materialBuilder_ == null) {
          materialBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.content.MaterialsData, io.opencannabis.schema.content.MaterialsData.Builder, io.opencannabis.schema.content.MaterialsDataOrBuilder>(
                  getMaterial(),
                  getParentForChildren(),
                  isClean());
          material_ = null;
        }
        return materialBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.products.Extract)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.products.Extract)
    private static final io.opencannabis.schema.product.ExtractProduct.Extract DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.product.ExtractProduct.Extract();
    }

    public static io.opencannabis.schema.product.ExtractProduct.Extract getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Extract>
        PARSER = new com.google.protobuf.AbstractParser<Extract>() {
      public Extract parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Extract(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Extract> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Extract> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.product.ExtractProduct.Extract getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_products_Extract_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_products_Extract_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\026products/Extract.proto\022\025opencannabis.p" +
      "roducts\032\025base/ProductKey.proto\032\033content/" +
      "MaterialsData.proto\032\034content/ProductCont" +
      "ent.proto\"\274\002\n\007Extract\022*\n\003key\030\001 \001(\0132\035.ope" +
      "ncannabis.base.ProductKey\0220\n\004type\030\002 \001(\0162" +
      "\".opencannabis.products.ExtractType\0220\n\004f" +
      "lag\030\003 \003(\0162\".opencannabis.products.Extrac" +
      "tFlag\0223\n\006flower\030\004 \001(\0132#.opencannabis.bas" +
      "e.ProductReference\0225\n\007product\030\005 \001(\0132$.op" +
      "encannabis.content.ProductContent\0225\n\010mat" +
      "erial\030\006 \001(\0132#.opencannabis.content.Mater" +
      "ialsData*\227\001\n\013ExtractType\022\027\n\023UNSPECIFIED_" +
      "EXTRACT\020\000\022\007\n\003OIL\020\001\022\007\n\003WAX\020\002\022\013\n\007SHATTER\020\003" +
      "\022\010\n\004KIEF\020\004\022\010\n\004HASH\020\005\022\016\n\nLIVE_RESIN\020\006\022\t\n\005" +
      "ROSIN\020\007\022\013\n\007CRUMBLE\020\010\022\t\n\005SAUCE\020\t\022\t\n\005SUGAR" +
      "\020\n*4\n\013ExtractFlag\022\024\n\020NO_EXTRACT_FLAGS\020\000\022" +
      "\017\n\013SOLVENTLESS\020\001B:\n\036io.opencannabis.sche" +
      "ma.productB\016ExtractProductH\001P\000\242\002\003OCSb\006pr" +
      "oto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.base.BaseProductKey.getDescriptor(),
          io.opencannabis.schema.content.MaterialsContent.getDescriptor(),
          io.opencannabis.schema.content.AttachedContent.getDescriptor(),
        }, assigner);
    internal_static_opencannabis_products_Extract_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_opencannabis_products_Extract_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_products_Extract_descriptor,
        new java.lang.String[] { "Key", "Type", "Flag", "Flower", "Product", "Material", });
    io.opencannabis.schema.base.BaseProductKey.getDescriptor();
    io.opencannabis.schema.content.MaterialsContent.getDescriptor();
    io.opencannabis.schema.content.AttachedContent.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
