/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: products/Merchandise.proto

package io.opencannabis.schema.product;

public final class MerchandiseProduct {
  private MerchandiseProduct() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies types of generic merchandise that may be carried on a dispensary menu.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.products.MerchandiseType}
   */
  public enum MerchandiseType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown, unrecognized, or otherwise unspecified merchandise subcategory.
     * </pre>
     *
     * <code>UNSPECIFIED_MERCHANDISE = 0;</code>
     */
    UNSPECIFIED_MERCHANDISE(0),
    /**
     * <pre>
     * Clothing - i.e. shirts, pants, hoodies, and other wearable textiles.
     * </pre>
     *
     * <code>CLOTHING = 1;</code>
     */
    CLOTHING(1),
    /**
     * <pre>
     * Cups, mugs, on up to pipes and bongs.
     * </pre>
     *
     * <code>GLASSWARE = 2;</code>
     */
    GLASSWARE(2),
    /**
     * <pre>
     * Containers for cannabis.
     * </pre>
     *
     * <code>CONTAINER = 3;</code>
     */
    CONTAINER(3),
    /**
     * <pre>
     * Tools to produce fire to consume cannabis.
     * </pre>
     *
     * <code>LIGHTER = 4;</code>
     */
    LIGHTER(4),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Unknown, unrecognized, or otherwise unspecified merchandise subcategory.
     * </pre>
     *
     * <code>UNSPECIFIED_MERCHANDISE = 0;</code>
     */
    public static final int UNSPECIFIED_MERCHANDISE_VALUE = 0;
    /**
     * <pre>
     * Clothing - i.e. shirts, pants, hoodies, and other wearable textiles.
     * </pre>
     *
     * <code>CLOTHING = 1;</code>
     */
    public static final int CLOTHING_VALUE = 1;
    /**
     * <pre>
     * Cups, mugs, on up to pipes and bongs.
     * </pre>
     *
     * <code>GLASSWARE = 2;</code>
     */
    public static final int GLASSWARE_VALUE = 2;
    /**
     * <pre>
     * Containers for cannabis.
     * </pre>
     *
     * <code>CONTAINER = 3;</code>
     */
    public static final int CONTAINER_VALUE = 3;
    /**
     * <pre>
     * Tools to produce fire to consume cannabis.
     * </pre>
     *
     * <code>LIGHTER = 4;</code>
     */
    public static final int LIGHTER_VALUE = 4;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MerchandiseType valueOf(int value) {
      return forNumber(value);
    }

    public static MerchandiseType forNumber(int value) {
      switch (value) {
        case 0: return UNSPECIFIED_MERCHANDISE;
        case 1: return CLOTHING;
        case 2: return GLASSWARE;
        case 3: return CONTAINER;
        case 4: return LIGHTER;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MerchandiseType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        MerchandiseType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<MerchandiseType>() {
            public MerchandiseType findValueByNumber(int number) {
              return MerchandiseType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.product.MerchandiseProduct.getDescriptor().getEnumTypes().get(0);
    }

    private static final MerchandiseType[] VALUES = values();

    public static MerchandiseType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MerchandiseType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.products.MerchandiseType)
  }

  /**
   * <pre>
   * Flags that may be applied specifically to merchandise items.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.products.MerchandiseFlag}
   */
  public enum MerchandiseFlag
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * No flags specified.
     * </pre>
     *
     * <code>NO_MERCHANDISE_FLAGS = 0;</code>
     */
    NO_MERCHANDISE_FLAGS(0),
    /**
     * <pre>
     * This item requires that a user have a valid medical recommendation for cannabis.
     * </pre>
     *
     * <code>MEDICAL_ONLY = 1;</code>
     */
    MEDICAL_ONLY(1),
    /**
     * <pre>
     * This item is branded for the partner and should be promoted as such.
     * </pre>
     *
     * <code>BRAND_SWAG = 2;</code>
     */
    BRAND_SWAG(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * No flags specified.
     * </pre>
     *
     * <code>NO_MERCHANDISE_FLAGS = 0;</code>
     */
    public static final int NO_MERCHANDISE_FLAGS_VALUE = 0;
    /**
     * <pre>
     * This item requires that a user have a valid medical recommendation for cannabis.
     * </pre>
     *
     * <code>MEDICAL_ONLY = 1;</code>
     */
    public static final int MEDICAL_ONLY_VALUE = 1;
    /**
     * <pre>
     * This item is branded for the partner and should be promoted as such.
     * </pre>
     *
     * <code>BRAND_SWAG = 2;</code>
     */
    public static final int BRAND_SWAG_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MerchandiseFlag valueOf(int value) {
      return forNumber(value);
    }

    public static MerchandiseFlag forNumber(int value) {
      switch (value) {
        case 0: return NO_MERCHANDISE_FLAGS;
        case 1: return MEDICAL_ONLY;
        case 2: return BRAND_SWAG;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MerchandiseFlag>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        MerchandiseFlag> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<MerchandiseFlag>() {
            public MerchandiseFlag findValueByNumber(int number) {
              return MerchandiseFlag.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.product.MerchandiseProduct.getDescriptor().getEnumTypes().get(1);
    }

    private static final MerchandiseFlag[] VALUES = values();

    public static MerchandiseFlag valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MerchandiseFlag(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.products.MerchandiseFlag)
  }

  public interface MerchandiseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.products.Merchandise)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Product key uniquely identifying this merchandise item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    boolean hasKey();
    /**
     * <pre>
     * Product key uniquely identifying this merchandise item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKey getKey();
    /**
     * <pre>
     * Product key uniquely identifying this merchandise item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder();

    /**
     * <pre>
     * Sub-category for this merchandise item, if known.
     * </pre>
     *
     * <code>.opencannabis.products.MerchandiseType type = 2;</code>
     */
    int getTypeValue();
    /**
     * <pre>
     * Sub-category for this merchandise item, if known.
     * </pre>
     *
     * <code>.opencannabis.products.MerchandiseType type = 2;</code>
     */
    io.opencannabis.schema.product.MerchandiseProduct.MerchandiseType getType();

    /**
     * <pre>
     * Flags for this merchandise item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
     */
    java.util.List<io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag> getFlagsList();
    /**
     * <pre>
     * Flags for this merchandise item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
     */
    int getFlagsCount();
    /**
     * <pre>
     * Flags for this merchandise item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
     */
    io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag getFlags(int index);
    /**
     * <pre>
     * Flags for this merchandise item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
     */
    java.util.List<java.lang.Integer>
    getFlagsValueList();
    /**
     * <pre>
     * Flags for this merchandise item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
     */
    int getFlagsValue(int index);

    /**
     * <pre>
     * Content about this merchandise item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    boolean hasProduct();
    /**
     * <pre>
     * Content about this merchandise item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    io.opencannabis.schema.content.ProductContent getProduct();
    /**
     * <pre>
     * Content about this merchandise item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder();
  }
  /**
   * <pre>
   * Specifies an item of merchandise, that does not contain cannabis, but is sold anyway by a dispensary, such as branded
   * clothing, containers, lighters, and other random stuff.
   * </pre>
   *
   * Protobuf type {@code opencannabis.products.Merchandise}
   */
  public  static final class Merchandise extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.products.Merchandise)
      MerchandiseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Merchandise.newBuilder() to construct.
    private Merchandise(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Merchandise() {
      type_ = 0;
      flags_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Merchandise(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.base.ProductKey.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(io.opencannabis.schema.base.ProductKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                flags_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000004;
              }
              flags_.add(rawValue);
              break;
            }
            case 26: {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while(input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                  flags_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000004;
                }
                flags_.add(rawValue);
              }
              input.popLimit(oldLimit);
              break;
            }
            case 34: {
              io.opencannabis.schema.content.ProductContent.Builder subBuilder = null;
              if (product_ != null) {
                subBuilder = product_.toBuilder();
              }
              product_ = input.readMessage(io.opencannabis.schema.content.ProductContent.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(product_);
                product_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          flags_ = java.util.Collections.unmodifiableList(flags_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.product.MerchandiseProduct.internal_static_opencannabis_products_Merchandise_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.product.MerchandiseProduct.internal_static_opencannabis_products_Merchandise_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.product.MerchandiseProduct.Merchandise.class, io.opencannabis.schema.product.MerchandiseProduct.Merchandise.Builder.class);
    }

    private int bitField0_;
    public static final int KEY_FIELD_NUMBER = 1;
    private io.opencannabis.schema.base.ProductKey key_;
    /**
     * <pre>
     * Product key uniquely identifying this merchandise item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <pre>
     * Product key uniquely identifying this merchandise item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKey getKey() {
      return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
    }
    /**
     * <pre>
     * Product key uniquely identifying this merchandise item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private int type_;
    /**
     * <pre>
     * Sub-category for this merchandise item, if known.
     * </pre>
     *
     * <code>.opencannabis.products.MerchandiseType type = 2;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Sub-category for this merchandise item, if known.
     * </pre>
     *
     * <code>.opencannabis.products.MerchandiseType type = 2;</code>
     */
    public io.opencannabis.schema.product.MerchandiseProduct.MerchandiseType getType() {
      io.opencannabis.schema.product.MerchandiseProduct.MerchandiseType result = io.opencannabis.schema.product.MerchandiseProduct.MerchandiseType.valueOf(type_);
      return result == null ? io.opencannabis.schema.product.MerchandiseProduct.MerchandiseType.UNRECOGNIZED : result;
    }

    public static final int FLAGS_FIELD_NUMBER = 3;
    private java.util.List<java.lang.Integer> flags_;
    private static final com.google.protobuf.Internal.ListAdapter.Converter<
        java.lang.Integer, io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag> flags_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag>() {
              public io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag convert(java.lang.Integer from) {
                io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag result = io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag.valueOf(from);
                return result == null ? io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag.UNRECOGNIZED : result;
              }
            };
    /**
     * <pre>
     * Flags for this merchandise item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
     */
    public java.util.List<io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag> getFlagsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag>(flags_, flags_converter_);
    }
    /**
     * <pre>
     * Flags for this merchandise item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
     */
    public int getFlagsCount() {
      return flags_.size();
    }
    /**
     * <pre>
     * Flags for this merchandise item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
     */
    public io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag getFlags(int index) {
      return flags_converter_.convert(flags_.get(index));
    }
    /**
     * <pre>
     * Flags for this merchandise item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
     */
    public java.util.List<java.lang.Integer>
    getFlagsValueList() {
      return flags_;
    }
    /**
     * <pre>
     * Flags for this merchandise item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
     */
    public int getFlagsValue(int index) {
      return flags_.get(index);
    }
    private int flagsMemoizedSerializedSize;

    public static final int PRODUCT_FIELD_NUMBER = 4;
    private io.opencannabis.schema.content.ProductContent product_;
    /**
     * <pre>
     * Content about this merchandise item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    public boolean hasProduct() {
      return product_ != null;
    }
    /**
     * <pre>
     * Content about this merchandise item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    public io.opencannabis.schema.content.ProductContent getProduct() {
      return product_ == null ? io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
    }
    /**
     * <pre>
     * Content about this merchandise item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    public io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder() {
      return getProduct();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (key_ != null) {
        output.writeMessage(1, getKey());
      }
      if (type_ != io.opencannabis.schema.product.MerchandiseProduct.MerchandiseType.UNSPECIFIED_MERCHANDISE.getNumber()) {
        output.writeEnum(2, type_);
      }
      if (getFlagsList().size() > 0) {
        output.writeUInt32NoTag(26);
        output.writeUInt32NoTag(flagsMemoizedSerializedSize);
      }
      for (int i = 0; i < flags_.size(); i++) {
        output.writeEnumNoTag(flags_.get(i));
      }
      if (product_ != null) {
        output.writeMessage(4, getProduct());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getKey());
      }
      if (type_ != io.opencannabis.schema.product.MerchandiseProduct.MerchandiseType.UNSPECIFIED_MERCHANDISE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, type_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < flags_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeEnumSizeNoTag(flags_.get(i));
        }
        size += dataSize;
        if (!getFlagsList().isEmpty()) {  size += 1;
          size += com.google.protobuf.CodedOutputStream
            .computeUInt32SizeNoTag(dataSize);
        }flagsMemoizedSerializedSize = dataSize;
      }
      if (product_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getProduct());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.product.MerchandiseProduct.Merchandise)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.product.MerchandiseProduct.Merchandise other = (io.opencannabis.schema.product.MerchandiseProduct.Merchandise) obj;

      boolean result = true;
      result = result && (hasKey() == other.hasKey());
      if (hasKey()) {
        result = result && getKey()
            .equals(other.getKey());
      }
      result = result && type_ == other.type_;
      result = result && flags_.equals(other.flags_);
      result = result && (hasProduct() == other.hasProduct());
      if (hasProduct()) {
        result = result && getProduct()
            .equals(other.getProduct());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      if (getFlagsCount() > 0) {
        hash = (37 * hash) + FLAGS_FIELD_NUMBER;
        hash = (53 * hash) + flags_.hashCode();
      }
      if (hasProduct()) {
        hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
        hash = (53 * hash) + getProduct().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.product.MerchandiseProduct.Merchandise prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies an item of merchandise, that does not contain cannabis, but is sold anyway by a dispensary, such as branded
     * clothing, containers, lighters, and other random stuff.
     * </pre>
     *
     * Protobuf type {@code opencannabis.products.Merchandise}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.products.Merchandise)
        io.opencannabis.schema.product.MerchandiseProduct.MerchandiseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.product.MerchandiseProduct.internal_static_opencannabis_products_Merchandise_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.product.MerchandiseProduct.internal_static_opencannabis_products_Merchandise_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.product.MerchandiseProduct.Merchandise.class, io.opencannabis.schema.product.MerchandiseProduct.Merchandise.Builder.class);
      }

      // Construct using io.opencannabis.schema.product.MerchandiseProduct.Merchandise.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        type_ = 0;

        flags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        if (productBuilder_ == null) {
          product_ = null;
        } else {
          product_ = null;
          productBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.product.MerchandiseProduct.internal_static_opencannabis_products_Merchandise_descriptor;
      }

      public io.opencannabis.schema.product.MerchandiseProduct.Merchandise getDefaultInstanceForType() {
        return io.opencannabis.schema.product.MerchandiseProduct.Merchandise.getDefaultInstance();
      }

      public io.opencannabis.schema.product.MerchandiseProduct.Merchandise build() {
        io.opencannabis.schema.product.MerchandiseProduct.Merchandise result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.product.MerchandiseProduct.Merchandise buildPartial() {
        io.opencannabis.schema.product.MerchandiseProduct.Merchandise result = new io.opencannabis.schema.product.MerchandiseProduct.Merchandise(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        result.type_ = type_;
        if (((bitField0_ & 0x00000004) == 0x00000004)) {
          flags_ = java.util.Collections.unmodifiableList(flags_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.flags_ = flags_;
        if (productBuilder_ == null) {
          result.product_ = product_;
        } else {
          result.product_ = productBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.product.MerchandiseProduct.Merchandise) {
          return mergeFrom((io.opencannabis.schema.product.MerchandiseProduct.Merchandise)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.product.MerchandiseProduct.Merchandise other) {
        if (other == io.opencannabis.schema.product.MerchandiseProduct.Merchandise.getDefaultInstance()) return this;
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (!other.flags_.isEmpty()) {
          if (flags_.isEmpty()) {
            flags_ = other.flags_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureFlagsIsMutable();
            flags_.addAll(other.flags_);
          }
          onChanged();
        }
        if (other.hasProduct()) {
          mergeProduct(other.getProduct());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.product.MerchandiseProduct.Merchandise parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.product.MerchandiseProduct.Merchandise) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private io.opencannabis.schema.base.ProductKey key_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> keyBuilder_;
      /**
       * <pre>
       * Product key uniquely identifying this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <pre>
       * Product key uniquely identifying this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Product key uniquely identifying this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key uniquely identifying this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(
          io.opencannabis.schema.base.ProductKey.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Product key uniquely identifying this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder mergeKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              io.opencannabis.schema.base.ProductKey.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key uniquely identifying this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Product key uniquely identifying this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Product key uniquely identifying this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        }
      }
      /**
       * <pre>
       * Product key uniquely identifying this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }

      private int type_ = 0;
      /**
       * <pre>
       * Sub-category for this merchandise item, if known.
       * </pre>
       *
       * <code>.opencannabis.products.MerchandiseType type = 2;</code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <pre>
       * Sub-category for this merchandise item, if known.
       * </pre>
       *
       * <code>.opencannabis.products.MerchandiseType type = 2;</code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Sub-category for this merchandise item, if known.
       * </pre>
       *
       * <code>.opencannabis.products.MerchandiseType type = 2;</code>
       */
      public io.opencannabis.schema.product.MerchandiseProduct.MerchandiseType getType() {
        io.opencannabis.schema.product.MerchandiseProduct.MerchandiseType result = io.opencannabis.schema.product.MerchandiseProduct.MerchandiseType.valueOf(type_);
        return result == null ? io.opencannabis.schema.product.MerchandiseProduct.MerchandiseType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Sub-category for this merchandise item, if known.
       * </pre>
       *
       * <code>.opencannabis.products.MerchandiseType type = 2;</code>
       */
      public Builder setType(io.opencannabis.schema.product.MerchandiseProduct.MerchandiseType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Sub-category for this merchandise item, if known.
       * </pre>
       *
       * <code>.opencannabis.products.MerchandiseType type = 2;</code>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> flags_ =
        java.util.Collections.emptyList();
      private void ensureFlagsIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          flags_ = new java.util.ArrayList<java.lang.Integer>(flags_);
          bitField0_ |= 0x00000004;
        }
      }
      /**
       * <pre>
       * Flags for this merchandise item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
       */
      public java.util.List<io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag> getFlagsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag>(flags_, flags_converter_);
      }
      /**
       * <pre>
       * Flags for this merchandise item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
       */
      public int getFlagsCount() {
        return flags_.size();
      }
      /**
       * <pre>
       * Flags for this merchandise item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
       */
      public io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag getFlags(int index) {
        return flags_converter_.convert(flags_.get(index));
      }
      /**
       * <pre>
       * Flags for this merchandise item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
       */
      public Builder setFlags(
          int index, io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlagsIsMutable();
        flags_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Flags for this merchandise item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
       */
      public Builder addFlags(io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlagsIsMutable();
        flags_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Flags for this merchandise item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
       */
      public Builder addAllFlags(
          java.lang.Iterable<? extends io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag> values) {
        ensureFlagsIsMutable();
        for (io.opencannabis.schema.product.MerchandiseProduct.MerchandiseFlag value : values) {
          flags_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Flags for this merchandise item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
       */
      public Builder clearFlags() {
        flags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Flags for this merchandise item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
       */
      public java.util.List<java.lang.Integer>
      getFlagsValueList() {
        return java.util.Collections.unmodifiableList(flags_);
      }
      /**
       * <pre>
       * Flags for this merchandise item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
       */
      public int getFlagsValue(int index) {
        return flags_.get(index);
      }
      /**
       * <pre>
       * Flags for this merchandise item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
       */
      public Builder setFlagsValue(
          int index, int value) {
        ensureFlagsIsMutable();
        flags_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Flags for this merchandise item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
       */
      public Builder addFlagsValue(int value) {
        ensureFlagsIsMutable();
        flags_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Flags for this merchandise item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.MerchandiseFlag flags = 3;</code>
       */
      public Builder addAllFlagsValue(
          java.lang.Iterable<java.lang.Integer> values) {
        ensureFlagsIsMutable();
        for (int value : values) {
          flags_.add(value);
        }
        onChanged();
        return this;
      }

      private io.opencannabis.schema.content.ProductContent product_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder> productBuilder_;
      /**
       * <pre>
       * Content about this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public boolean hasProduct() {
        return productBuilder_ != null || product_ != null;
      }
      /**
       * <pre>
       * Content about this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public io.opencannabis.schema.content.ProductContent getProduct() {
        if (productBuilder_ == null) {
          return product_ == null ? io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
        } else {
          return productBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Content about this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public Builder setProduct(io.opencannabis.schema.content.ProductContent value) {
        if (productBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          product_ = value;
          onChanged();
        } else {
          productBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Content about this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public Builder setProduct(
          io.opencannabis.schema.content.ProductContent.Builder builderForValue) {
        if (productBuilder_ == null) {
          product_ = builderForValue.build();
          onChanged();
        } else {
          productBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Content about this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public Builder mergeProduct(io.opencannabis.schema.content.ProductContent value) {
        if (productBuilder_ == null) {
          if (product_ != null) {
            product_ =
              io.opencannabis.schema.content.ProductContent.newBuilder(product_).mergeFrom(value).buildPartial();
          } else {
            product_ = value;
          }
          onChanged();
        } else {
          productBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Content about this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public Builder clearProduct() {
        if (productBuilder_ == null) {
          product_ = null;
          onChanged();
        } else {
          product_ = null;
          productBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Content about this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public io.opencannabis.schema.content.ProductContent.Builder getProductBuilder() {
        
        onChanged();
        return getProductFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Content about this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder() {
        if (productBuilder_ != null) {
          return productBuilder_.getMessageOrBuilder();
        } else {
          return product_ == null ?
              io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
        }
      }
      /**
       * <pre>
       * Content about this merchandise item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder> 
          getProductFieldBuilder() {
        if (productBuilder_ == null) {
          productBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder>(
                  getProduct(),
                  getParentForChildren(),
                  isClean());
          product_ = null;
        }
        return productBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.products.Merchandise)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.products.Merchandise)
    private static final io.opencannabis.schema.product.MerchandiseProduct.Merchandise DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.product.MerchandiseProduct.Merchandise();
    }

    public static io.opencannabis.schema.product.MerchandiseProduct.Merchandise getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Merchandise>
        PARSER = new com.google.protobuf.AbstractParser<Merchandise>() {
      public Merchandise parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Merchandise(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Merchandise> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Merchandise> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.product.MerchandiseProduct.Merchandise getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_products_Merchandise_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_products_Merchandise_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\032products/Merchandise.proto\022\025opencannab" +
      "is.products\032\025base/ProductKey.proto\032\034cont" +
      "ent/ProductContent.proto\"\335\001\n\013Merchandise" +
      "\022*\n\003key\030\001 \001(\0132\035.opencannabis.base.Produc" +
      "tKey\0224\n\004type\030\002 \001(\0162&.opencannabis.produc" +
      "ts.MerchandiseType\0225\n\005flags\030\003 \003(\0162&.open" +
      "cannabis.products.MerchandiseFlag\0225\n\007pro" +
      "duct\030\004 \001(\0132$.opencannabis.content.Produc" +
      "tContent*g\n\017MerchandiseType\022\033\n\027UNSPECIFI" +
      "ED_MERCHANDISE\020\000\022\014\n\010CLOTHING\020\001\022\r\n\tGLASSW" +
      "ARE\020\002\022\r\n\tCONTAINER\020\003\022\013\n\007LIGHTER\020\004*M\n\017Mer" +
      "chandiseFlag\022\030\n\024NO_MERCHANDISE_FLAGS\020\000\022\020" +
      "\n\014MEDICAL_ONLY\020\001\022\016\n\nBRAND_SWAG\020\002B>\n\036io.o" +
      "pencannabis.schema.productB\022MerchandiseP" +
      "roductH\001P\000\242\002\003OCSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.base.BaseProductKey.getDescriptor(),
          io.opencannabis.schema.content.AttachedContent.getDescriptor(),
        }, assigner);
    internal_static_opencannabis_products_Merchandise_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_opencannabis_products_Merchandise_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_products_Merchandise_descriptor,
        new java.lang.String[] { "Key", "Type", "Flags", "Product", });
    io.opencannabis.schema.base.BaseProductKey.getDescriptor();
    io.opencannabis.schema.content.AttachedContent.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
