/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: products/Plant.proto

package io.opencannabis.schema.product;

public final class PlantProduct {
  private PlantProduct() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Enumerates types or subcategories of plants that may be sold.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.products.PlantType}
   */
  public enum PlantType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown, unrecognized, or otherwise unspecified plant type.
     * </pre>
     *
     * <code>UNSPECIFIED_PLANT = 0;</code>
     */
    UNSPECIFIED_PLANT(0),
    /**
     * <pre>
     * Specifies a pack of seeds, or an individual seed.
     * </pre>
     *
     * <code>SEED = 1;</code>
     */
    SEED(1),
    /**
     * <pre>
     * Specifies a cloned plant that is grown to some point and then sold.
     * </pre>
     *
     * <code>CLONE = 2;</code>
     */
    CLONE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Unknown, unrecognized, or otherwise unspecified plant type.
     * </pre>
     *
     * <code>UNSPECIFIED_PLANT = 0;</code>
     */
    public static final int UNSPECIFIED_PLANT_VALUE = 0;
    /**
     * <pre>
     * Specifies a pack of seeds, or an individual seed.
     * </pre>
     *
     * <code>SEED = 1;</code>
     */
    public static final int SEED_VALUE = 1;
    /**
     * <pre>
     * Specifies a cloned plant that is grown to some point and then sold.
     * </pre>
     *
     * <code>CLONE = 2;</code>
     */
    public static final int CLONE_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PlantType valueOf(int value) {
      return forNumber(value);
    }

    public static PlantType forNumber(int value) {
      switch (value) {
        case 0: return UNSPECIFIED_PLANT;
        case 1: return SEED;
        case 2: return CLONE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PlantType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        PlantType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<PlantType>() {
            public PlantType findValueByNumber(int number) {
              return PlantType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.product.PlantProduct.getDescriptor().getEnumTypes().get(0);
    }

    private static final PlantType[] VALUES = values();

    public static PlantType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PlantType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.products.PlantType)
  }

  public interface PlantOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.products.Plant)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Product key uniquely identifying this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    boolean hasKey();
    /**
     * <pre>
     * Product key uniquely identifying this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKey getKey();
    /**
     * <pre>
     * Product key uniquely identifying this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder();

    /**
     * <pre>
     * Specific subcategory for this plant item.
     * </pre>
     *
     * <code>.opencannabis.products.PlantType type = 2;</code>
     */
    int getTypeValue();
    /**
     * <pre>
     * Specific subcategory for this plant item.
     * </pre>
     *
     * <code>.opencannabis.products.PlantType type = 2;</code>
     */
    io.opencannabis.schema.product.PlantProduct.PlantType getType();

    /**
     * <pre>
     * Menu products made from this raw plant product.
     * </pre>
     *
     * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
     */
    java.util.List<io.opencannabis.schema.base.ProductReference> 
        getOriginList();
    /**
     * <pre>
     * Menu products made from this raw plant product.
     * </pre>
     *
     * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
     */
    io.opencannabis.schema.base.ProductReference getOrigin(int index);
    /**
     * <pre>
     * Menu products made from this raw plant product.
     * </pre>
     *
     * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
     */
    int getOriginCount();
    /**
     * <pre>
     * Menu products made from this raw plant product.
     * </pre>
     *
     * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
     */
    java.util.List<? extends io.opencannabis.schema.base.ProductReferenceOrBuilder> 
        getOriginOrBuilderList();
    /**
     * <pre>
     * Menu products made from this raw plant product.
     * </pre>
     *
     * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
     */
    io.opencannabis.schema.base.ProductReferenceOrBuilder getOriginOrBuilder(
        int index);

    /**
     * <pre>
     * Product content attached to this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    boolean hasProduct();
    /**
     * <pre>
     * Product content attached to this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    io.opencannabis.schema.content.ProductContent getProduct();
    /**
     * <pre>
     * Product content attached to this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder();

    /**
     * <pre>
     * Handling and materials data regarding this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 5;</code>
     */
    boolean hasMaterial();
    /**
     * <pre>
     * Handling and materials data regarding this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 5;</code>
     */
    io.opencannabis.schema.content.MaterialsData getMaterial();
    /**
     * <pre>
     * Handling and materials data regarding this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 5;</code>
     */
    io.opencannabis.schema.content.MaterialsDataOrBuilder getMaterialOrBuilder();
  }
  /**
   * <pre>
   * Specifies a plant product, such as seeds, or clones, that are designed to be cultivated by the end user.
   * </pre>
   *
   * Protobuf type {@code opencannabis.products.Plant}
   */
  public  static final class Plant extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.products.Plant)
      PlantOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Plant.newBuilder() to construct.
    private Plant(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Plant() {
      type_ = 0;
      origin_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Plant(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.base.ProductKey.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(io.opencannabis.schema.base.ProductKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                origin_ = new java.util.ArrayList<io.opencannabis.schema.base.ProductReference>();
                mutable_bitField0_ |= 0x00000004;
              }
              origin_.add(
                  input.readMessage(io.opencannabis.schema.base.ProductReference.parser(), extensionRegistry));
              break;
            }
            case 34: {
              io.opencannabis.schema.content.ProductContent.Builder subBuilder = null;
              if (product_ != null) {
                subBuilder = product_.toBuilder();
              }
              product_ = input.readMessage(io.opencannabis.schema.content.ProductContent.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(product_);
                product_ = subBuilder.buildPartial();
              }

              break;
            }
            case 42: {
              io.opencannabis.schema.content.MaterialsData.Builder subBuilder = null;
              if (material_ != null) {
                subBuilder = material_.toBuilder();
              }
              material_ = input.readMessage(io.opencannabis.schema.content.MaterialsData.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(material_);
                material_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          origin_ = java.util.Collections.unmodifiableList(origin_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.product.PlantProduct.internal_static_opencannabis_products_Plant_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.product.PlantProduct.internal_static_opencannabis_products_Plant_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.product.PlantProduct.Plant.class, io.opencannabis.schema.product.PlantProduct.Plant.Builder.class);
    }

    private int bitField0_;
    public static final int KEY_FIELD_NUMBER = 1;
    private io.opencannabis.schema.base.ProductKey key_;
    /**
     * <pre>
     * Product key uniquely identifying this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <pre>
     * Product key uniquely identifying this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKey getKey() {
      return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
    }
    /**
     * <pre>
     * Product key uniquely identifying this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private int type_;
    /**
     * <pre>
     * Specific subcategory for this plant item.
     * </pre>
     *
     * <code>.opencannabis.products.PlantType type = 2;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Specific subcategory for this plant item.
     * </pre>
     *
     * <code>.opencannabis.products.PlantType type = 2;</code>
     */
    public io.opencannabis.schema.product.PlantProduct.PlantType getType() {
      io.opencannabis.schema.product.PlantProduct.PlantType result = io.opencannabis.schema.product.PlantProduct.PlantType.valueOf(type_);
      return result == null ? io.opencannabis.schema.product.PlantProduct.PlantType.UNRECOGNIZED : result;
    }

    public static final int ORIGIN_FIELD_NUMBER = 3;
    private java.util.List<io.opencannabis.schema.base.ProductReference> origin_;
    /**
     * <pre>
     * Menu products made from this raw plant product.
     * </pre>
     *
     * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
     */
    public java.util.List<io.opencannabis.schema.base.ProductReference> getOriginList() {
      return origin_;
    }
    /**
     * <pre>
     * Menu products made from this raw plant product.
     * </pre>
     *
     * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.base.ProductReferenceOrBuilder> 
        getOriginOrBuilderList() {
      return origin_;
    }
    /**
     * <pre>
     * Menu products made from this raw plant product.
     * </pre>
     *
     * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
     */
    public int getOriginCount() {
      return origin_.size();
    }
    /**
     * <pre>
     * Menu products made from this raw plant product.
     * </pre>
     *
     * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
     */
    public io.opencannabis.schema.base.ProductReference getOrigin(int index) {
      return origin_.get(index);
    }
    /**
     * <pre>
     * Menu products made from this raw plant product.
     * </pre>
     *
     * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
     */
    public io.opencannabis.schema.base.ProductReferenceOrBuilder getOriginOrBuilder(
        int index) {
      return origin_.get(index);
    }

    public static final int PRODUCT_FIELD_NUMBER = 4;
    private io.opencannabis.schema.content.ProductContent product_;
    /**
     * <pre>
     * Product content attached to this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    public boolean hasProduct() {
      return product_ != null;
    }
    /**
     * <pre>
     * Product content attached to this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    public io.opencannabis.schema.content.ProductContent getProduct() {
      return product_ == null ? io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
    }
    /**
     * <pre>
     * Product content attached to this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 4;</code>
     */
    public io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder() {
      return getProduct();
    }

    public static final int MATERIAL_FIELD_NUMBER = 5;
    private io.opencannabis.schema.content.MaterialsData material_;
    /**
     * <pre>
     * Handling and materials data regarding this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 5;</code>
     */
    public boolean hasMaterial() {
      return material_ != null;
    }
    /**
     * <pre>
     * Handling and materials data regarding this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 5;</code>
     */
    public io.opencannabis.schema.content.MaterialsData getMaterial() {
      return material_ == null ? io.opencannabis.schema.content.MaterialsData.getDefaultInstance() : material_;
    }
    /**
     * <pre>
     * Handling and materials data regarding this cannabis plant item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 5;</code>
     */
    public io.opencannabis.schema.content.MaterialsDataOrBuilder getMaterialOrBuilder() {
      return getMaterial();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (key_ != null) {
        output.writeMessage(1, getKey());
      }
      if (type_ != io.opencannabis.schema.product.PlantProduct.PlantType.UNSPECIFIED_PLANT.getNumber()) {
        output.writeEnum(2, type_);
      }
      for (int i = 0; i < origin_.size(); i++) {
        output.writeMessage(3, origin_.get(i));
      }
      if (product_ != null) {
        output.writeMessage(4, getProduct());
      }
      if (material_ != null) {
        output.writeMessage(5, getMaterial());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getKey());
      }
      if (type_ != io.opencannabis.schema.product.PlantProduct.PlantType.UNSPECIFIED_PLANT.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, type_);
      }
      for (int i = 0; i < origin_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, origin_.get(i));
      }
      if (product_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getProduct());
      }
      if (material_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getMaterial());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.product.PlantProduct.Plant)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.product.PlantProduct.Plant other = (io.opencannabis.schema.product.PlantProduct.Plant) obj;

      boolean result = true;
      result = result && (hasKey() == other.hasKey());
      if (hasKey()) {
        result = result && getKey()
            .equals(other.getKey());
      }
      result = result && type_ == other.type_;
      result = result && getOriginList()
          .equals(other.getOriginList());
      result = result && (hasProduct() == other.hasProduct());
      if (hasProduct()) {
        result = result && getProduct()
            .equals(other.getProduct());
      }
      result = result && (hasMaterial() == other.hasMaterial());
      if (hasMaterial()) {
        result = result && getMaterial()
            .equals(other.getMaterial());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      if (getOriginCount() > 0) {
        hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
        hash = (53 * hash) + getOriginList().hashCode();
      }
      if (hasProduct()) {
        hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
        hash = (53 * hash) + getProduct().hashCode();
      }
      if (hasMaterial()) {
        hash = (37 * hash) + MATERIAL_FIELD_NUMBER;
        hash = (53 * hash) + getMaterial().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.product.PlantProduct.Plant parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.PlantProduct.Plant parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.PlantProduct.Plant parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.PlantProduct.Plant parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.PlantProduct.Plant parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.PlantProduct.Plant parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.PlantProduct.Plant parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.PlantProduct.Plant parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.PlantProduct.Plant parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.PlantProduct.Plant parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.PlantProduct.Plant parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.PlantProduct.Plant parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.product.PlantProduct.Plant prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a plant product, such as seeds, or clones, that are designed to be cultivated by the end user.
     * </pre>
     *
     * Protobuf type {@code opencannabis.products.Plant}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.products.Plant)
        io.opencannabis.schema.product.PlantProduct.PlantOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.product.PlantProduct.internal_static_opencannabis_products_Plant_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.product.PlantProduct.internal_static_opencannabis_products_Plant_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.product.PlantProduct.Plant.class, io.opencannabis.schema.product.PlantProduct.Plant.Builder.class);
      }

      // Construct using io.opencannabis.schema.product.PlantProduct.Plant.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getOriginFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        type_ = 0;

        if (originBuilder_ == null) {
          origin_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          originBuilder_.clear();
        }
        if (productBuilder_ == null) {
          product_ = null;
        } else {
          product_ = null;
          productBuilder_ = null;
        }
        if (materialBuilder_ == null) {
          material_ = null;
        } else {
          material_ = null;
          materialBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.product.PlantProduct.internal_static_opencannabis_products_Plant_descriptor;
      }

      public io.opencannabis.schema.product.PlantProduct.Plant getDefaultInstanceForType() {
        return io.opencannabis.schema.product.PlantProduct.Plant.getDefaultInstance();
      }

      public io.opencannabis.schema.product.PlantProduct.Plant build() {
        io.opencannabis.schema.product.PlantProduct.Plant result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.product.PlantProduct.Plant buildPartial() {
        io.opencannabis.schema.product.PlantProduct.Plant result = new io.opencannabis.schema.product.PlantProduct.Plant(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        result.type_ = type_;
        if (originBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            origin_ = java.util.Collections.unmodifiableList(origin_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.origin_ = origin_;
        } else {
          result.origin_ = originBuilder_.build();
        }
        if (productBuilder_ == null) {
          result.product_ = product_;
        } else {
          result.product_ = productBuilder_.build();
        }
        if (materialBuilder_ == null) {
          result.material_ = material_;
        } else {
          result.material_ = materialBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.product.PlantProduct.Plant) {
          return mergeFrom((io.opencannabis.schema.product.PlantProduct.Plant)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.product.PlantProduct.Plant other) {
        if (other == io.opencannabis.schema.product.PlantProduct.Plant.getDefaultInstance()) return this;
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (originBuilder_ == null) {
          if (!other.origin_.isEmpty()) {
            if (origin_.isEmpty()) {
              origin_ = other.origin_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureOriginIsMutable();
              origin_.addAll(other.origin_);
            }
            onChanged();
          }
        } else {
          if (!other.origin_.isEmpty()) {
            if (originBuilder_.isEmpty()) {
              originBuilder_.dispose();
              originBuilder_ = null;
              origin_ = other.origin_;
              bitField0_ = (bitField0_ & ~0x00000004);
              originBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getOriginFieldBuilder() : null;
            } else {
              originBuilder_.addAllMessages(other.origin_);
            }
          }
        }
        if (other.hasProduct()) {
          mergeProduct(other.getProduct());
        }
        if (other.hasMaterial()) {
          mergeMaterial(other.getMaterial());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.product.PlantProduct.Plant parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.product.PlantProduct.Plant) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private io.opencannabis.schema.base.ProductKey key_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> keyBuilder_;
      /**
       * <pre>
       * Product key uniquely identifying this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <pre>
       * Product key uniquely identifying this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Product key uniquely identifying this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key uniquely identifying this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(
          io.opencannabis.schema.base.ProductKey.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Product key uniquely identifying this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder mergeKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              io.opencannabis.schema.base.ProductKey.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key uniquely identifying this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Product key uniquely identifying this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Product key uniquely identifying this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        }
      }
      /**
       * <pre>
       * Product key uniquely identifying this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }

      private int type_ = 0;
      /**
       * <pre>
       * Specific subcategory for this plant item.
       * </pre>
       *
       * <code>.opencannabis.products.PlantType type = 2;</code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <pre>
       * Specific subcategory for this plant item.
       * </pre>
       *
       * <code>.opencannabis.products.PlantType type = 2;</code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specific subcategory for this plant item.
       * </pre>
       *
       * <code>.opencannabis.products.PlantType type = 2;</code>
       */
      public io.opencannabis.schema.product.PlantProduct.PlantType getType() {
        io.opencannabis.schema.product.PlantProduct.PlantType result = io.opencannabis.schema.product.PlantProduct.PlantType.valueOf(type_);
        return result == null ? io.opencannabis.schema.product.PlantProduct.PlantType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Specific subcategory for this plant item.
       * </pre>
       *
       * <code>.opencannabis.products.PlantType type = 2;</code>
       */
      public Builder setType(io.opencannabis.schema.product.PlantProduct.PlantType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specific subcategory for this plant item.
       * </pre>
       *
       * <code>.opencannabis.products.PlantType type = 2;</code>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<io.opencannabis.schema.base.ProductReference> origin_ =
        java.util.Collections.emptyList();
      private void ensureOriginIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          origin_ = new java.util.ArrayList<io.opencannabis.schema.base.ProductReference>(origin_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.base.ProductReference, io.opencannabis.schema.base.ProductReference.Builder, io.opencannabis.schema.base.ProductReferenceOrBuilder> originBuilder_;

      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public java.util.List<io.opencannabis.schema.base.ProductReference> getOriginList() {
        if (originBuilder_ == null) {
          return java.util.Collections.unmodifiableList(origin_);
        } else {
          return originBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public int getOriginCount() {
        if (originBuilder_ == null) {
          return origin_.size();
        } else {
          return originBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public io.opencannabis.schema.base.ProductReference getOrigin(int index) {
        if (originBuilder_ == null) {
          return origin_.get(index);
        } else {
          return originBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public Builder setOrigin(
          int index, io.opencannabis.schema.base.ProductReference value) {
        if (originBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOriginIsMutable();
          origin_.set(index, value);
          onChanged();
        } else {
          originBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public Builder setOrigin(
          int index, io.opencannabis.schema.base.ProductReference.Builder builderForValue) {
        if (originBuilder_ == null) {
          ensureOriginIsMutable();
          origin_.set(index, builderForValue.build());
          onChanged();
        } else {
          originBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public Builder addOrigin(io.opencannabis.schema.base.ProductReference value) {
        if (originBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOriginIsMutable();
          origin_.add(value);
          onChanged();
        } else {
          originBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public Builder addOrigin(
          int index, io.opencannabis.schema.base.ProductReference value) {
        if (originBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOriginIsMutable();
          origin_.add(index, value);
          onChanged();
        } else {
          originBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public Builder addOrigin(
          io.opencannabis.schema.base.ProductReference.Builder builderForValue) {
        if (originBuilder_ == null) {
          ensureOriginIsMutable();
          origin_.add(builderForValue.build());
          onChanged();
        } else {
          originBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public Builder addOrigin(
          int index, io.opencannabis.schema.base.ProductReference.Builder builderForValue) {
        if (originBuilder_ == null) {
          ensureOriginIsMutable();
          origin_.add(index, builderForValue.build());
          onChanged();
        } else {
          originBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public Builder addAllOrigin(
          java.lang.Iterable<? extends io.opencannabis.schema.base.ProductReference> values) {
        if (originBuilder_ == null) {
          ensureOriginIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, origin_);
          onChanged();
        } else {
          originBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public Builder clearOrigin() {
        if (originBuilder_ == null) {
          origin_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          originBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public Builder removeOrigin(int index) {
        if (originBuilder_ == null) {
          ensureOriginIsMutable();
          origin_.remove(index);
          onChanged();
        } else {
          originBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public io.opencannabis.schema.base.ProductReference.Builder getOriginBuilder(
          int index) {
        return getOriginFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public io.opencannabis.schema.base.ProductReferenceOrBuilder getOriginOrBuilder(
          int index) {
        if (originBuilder_ == null) {
          return origin_.get(index);  } else {
          return originBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public java.util.List<? extends io.opencannabis.schema.base.ProductReferenceOrBuilder> 
           getOriginOrBuilderList() {
        if (originBuilder_ != null) {
          return originBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(origin_);
        }
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public io.opencannabis.schema.base.ProductReference.Builder addOriginBuilder() {
        return getOriginFieldBuilder().addBuilder(
            io.opencannabis.schema.base.ProductReference.getDefaultInstance());
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public io.opencannabis.schema.base.ProductReference.Builder addOriginBuilder(
          int index) {
        return getOriginFieldBuilder().addBuilder(
            index, io.opencannabis.schema.base.ProductReference.getDefaultInstance());
      }
      /**
       * <pre>
       * Menu products made from this raw plant product.
       * </pre>
       *
       * <code>repeated .opencannabis.base.ProductReference origin = 3;</code>
       */
      public java.util.List<io.opencannabis.schema.base.ProductReference.Builder> 
           getOriginBuilderList() {
        return getOriginFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.base.ProductReference, io.opencannabis.schema.base.ProductReference.Builder, io.opencannabis.schema.base.ProductReferenceOrBuilder> 
          getOriginFieldBuilder() {
        if (originBuilder_ == null) {
          originBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.opencannabis.schema.base.ProductReference, io.opencannabis.schema.base.ProductReference.Builder, io.opencannabis.schema.base.ProductReferenceOrBuilder>(
                  origin_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          origin_ = null;
        }
        return originBuilder_;
      }

      private io.opencannabis.schema.content.ProductContent product_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder> productBuilder_;
      /**
       * <pre>
       * Product content attached to this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public boolean hasProduct() {
        return productBuilder_ != null || product_ != null;
      }
      /**
       * <pre>
       * Product content attached to this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public io.opencannabis.schema.content.ProductContent getProduct() {
        if (productBuilder_ == null) {
          return product_ == null ? io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
        } else {
          return productBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Product content attached to this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public Builder setProduct(io.opencannabis.schema.content.ProductContent value) {
        if (productBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          product_ = value;
          onChanged();
        } else {
          productBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product content attached to this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public Builder setProduct(
          io.opencannabis.schema.content.ProductContent.Builder builderForValue) {
        if (productBuilder_ == null) {
          product_ = builderForValue.build();
          onChanged();
        } else {
          productBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Product content attached to this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public Builder mergeProduct(io.opencannabis.schema.content.ProductContent value) {
        if (productBuilder_ == null) {
          if (product_ != null) {
            product_ =
              io.opencannabis.schema.content.ProductContent.newBuilder(product_).mergeFrom(value).buildPartial();
          } else {
            product_ = value;
          }
          onChanged();
        } else {
          productBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product content attached to this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public Builder clearProduct() {
        if (productBuilder_ == null) {
          product_ = null;
          onChanged();
        } else {
          product_ = null;
          productBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Product content attached to this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public io.opencannabis.schema.content.ProductContent.Builder getProductBuilder() {
        
        onChanged();
        return getProductFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Product content attached to this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      public io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder() {
        if (productBuilder_ != null) {
          return productBuilder_.getMessageOrBuilder();
        } else {
          return product_ == null ?
              io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
        }
      }
      /**
       * <pre>
       * Product content attached to this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder> 
          getProductFieldBuilder() {
        if (productBuilder_ == null) {
          productBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder>(
                  getProduct(),
                  getParentForChildren(),
                  isClean());
          product_ = null;
        }
        return productBuilder_;
      }

      private io.opencannabis.schema.content.MaterialsData material_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.MaterialsData, io.opencannabis.schema.content.MaterialsData.Builder, io.opencannabis.schema.content.MaterialsDataOrBuilder> materialBuilder_;
      /**
       * <pre>
       * Handling and materials data regarding this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public boolean hasMaterial() {
        return materialBuilder_ != null || material_ != null;
      }
      /**
       * <pre>
       * Handling and materials data regarding this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public io.opencannabis.schema.content.MaterialsData getMaterial() {
        if (materialBuilder_ == null) {
          return material_ == null ? io.opencannabis.schema.content.MaterialsData.getDefaultInstance() : material_;
        } else {
          return materialBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Handling and materials data regarding this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public Builder setMaterial(io.opencannabis.schema.content.MaterialsData value) {
        if (materialBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          material_ = value;
          onChanged();
        } else {
          materialBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Handling and materials data regarding this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public Builder setMaterial(
          io.opencannabis.schema.content.MaterialsData.Builder builderForValue) {
        if (materialBuilder_ == null) {
          material_ = builderForValue.build();
          onChanged();
        } else {
          materialBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Handling and materials data regarding this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public Builder mergeMaterial(io.opencannabis.schema.content.MaterialsData value) {
        if (materialBuilder_ == null) {
          if (material_ != null) {
            material_ =
              io.opencannabis.schema.content.MaterialsData.newBuilder(material_).mergeFrom(value).buildPartial();
          } else {
            material_ = value;
          }
          onChanged();
        } else {
          materialBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Handling and materials data regarding this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public Builder clearMaterial() {
        if (materialBuilder_ == null) {
          material_ = null;
          onChanged();
        } else {
          material_ = null;
          materialBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Handling and materials data regarding this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public io.opencannabis.schema.content.MaterialsData.Builder getMaterialBuilder() {
        
        onChanged();
        return getMaterialFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Handling and materials data regarding this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      public io.opencannabis.schema.content.MaterialsDataOrBuilder getMaterialOrBuilder() {
        if (materialBuilder_ != null) {
          return materialBuilder_.getMessageOrBuilder();
        } else {
          return material_ == null ?
              io.opencannabis.schema.content.MaterialsData.getDefaultInstance() : material_;
        }
      }
      /**
       * <pre>
       * Handling and materials data regarding this cannabis plant item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.MaterialsData, io.opencannabis.schema.content.MaterialsData.Builder, io.opencannabis.schema.content.MaterialsDataOrBuilder> 
          getMaterialFieldBuilder() {
        if (materialBuilder_ == null) {
          materialBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.content.MaterialsData, io.opencannabis.schema.content.MaterialsData.Builder, io.opencannabis.schema.content.MaterialsDataOrBuilder>(
                  getMaterial(),
                  getParentForChildren(),
                  isClean());
          material_ = null;
        }
        return materialBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.products.Plant)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.products.Plant)
    private static final io.opencannabis.schema.product.PlantProduct.Plant DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.product.PlantProduct.Plant();
    }

    public static io.opencannabis.schema.product.PlantProduct.Plant getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Plant>
        PARSER = new com.google.protobuf.AbstractParser<Plant>() {
      public Plant parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Plant(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Plant> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Plant> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.product.PlantProduct.Plant getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_products_Plant_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_products_Plant_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\024products/Plant.proto\022\025opencannabis.pro" +
      "ducts\032\025base/ProductKey.proto\032\033content/Ma" +
      "terialsData.proto\032\034content/ProductConten" +
      "t.proto\"\206\002\n\005Plant\022*\n\003key\030\001 \001(\0132\035.opencan" +
      "nabis.base.ProductKey\022.\n\004type\030\002 \001(\0162 .op" +
      "encannabis.products.PlantType\0223\n\006origin\030" +
      "\003 \003(\0132#.opencannabis.base.ProductReferen" +
      "ce\0225\n\007product\030\004 \001(\0132$.opencannabis.conte" +
      "nt.ProductContent\0225\n\010material\030\005 \001(\0132#.op" +
      "encannabis.content.MaterialsData*7\n\tPlan" +
      "tType\022\025\n\021UNSPECIFIED_PLANT\020\000\022\010\n\004SEED\020\001\022\t" +
      "\n\005CLONE\020\002B8\n\036io.opencannabis.schema.prod" +
      "uctB\014PlantProductH\001P\000\242\002\003OCSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.base.BaseProductKey.getDescriptor(),
          io.opencannabis.schema.content.MaterialsContent.getDescriptor(),
          io.opencannabis.schema.content.AttachedContent.getDescriptor(),
        }, assigner);
    internal_static_opencannabis_products_Plant_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_opencannabis_products_Plant_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_products_Plant_descriptor,
        new java.lang.String[] { "Key", "Type", "Origin", "Product", "Material", });
    io.opencannabis.schema.base.BaseProductKey.getDescriptor();
    io.opencannabis.schema.content.MaterialsContent.getDescriptor();
    io.opencannabis.schema.content.AttachedContent.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
