/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: products/Preroll.proto

package io.opencannabis.schema.product;

public final class PrerollProduct {
  private PrerollProduct() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies flags that may be specifically applied to pre-rolled cannabis products.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.products.PrerollFlag}
   */
  public enum PrerollFlag
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Specifies that no flags are set.
     * </pre>
     *
     * <code>NO_PREROLL_FLAGS = 0;</code>
     */
    NO_PREROLL_FLAGS(0),
    /**
     * <pre>
     * Specifies that this pre-rolled item is hash-infused.
     * </pre>
     *
     * <code>HASH_INFUSED = 1;</code>
     */
    HASH_INFUSED(1),
    /**
     * <pre>
     * Specifies that this pre-rolled item is kief-infused.
     * </pre>
     *
     * <code>KIEF_INFUSED = 2;</code>
     */
    KIEF_INFUSED(2),
    /**
     * <pre>
     * Specifies that this pre-rolled item is fortified with extracted cannabis products in some manner.
     * </pre>
     *
     * <code>FORTIFIED = 3;</code>
     */
    FORTIFIED(3),
    /**
     * <pre>
     * Specifies that this pre-rolled item is rolled with "full flower" buds, rather than trimmings, or other discarded
     * cannabis from other production processes.
     * </pre>
     *
     * <code>FULL_FLOWER = 4;</code>
     */
    FULL_FLOWER(4),
    /**
     * <pre>
     * Specifies that this product contains tobacco.
     * </pre>
     *
     * <code>CONTAINS_TOBACCO = 5;</code>
     */
    CONTAINS_TOBACCO(5),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Specifies that no flags are set.
     * </pre>
     *
     * <code>NO_PREROLL_FLAGS = 0;</code>
     */
    public static final int NO_PREROLL_FLAGS_VALUE = 0;
    /**
     * <pre>
     * Specifies that this pre-rolled item is hash-infused.
     * </pre>
     *
     * <code>HASH_INFUSED = 1;</code>
     */
    public static final int HASH_INFUSED_VALUE = 1;
    /**
     * <pre>
     * Specifies that this pre-rolled item is kief-infused.
     * </pre>
     *
     * <code>KIEF_INFUSED = 2;</code>
     */
    public static final int KIEF_INFUSED_VALUE = 2;
    /**
     * <pre>
     * Specifies that this pre-rolled item is fortified with extracted cannabis products in some manner.
     * </pre>
     *
     * <code>FORTIFIED = 3;</code>
     */
    public static final int FORTIFIED_VALUE = 3;
    /**
     * <pre>
     * Specifies that this pre-rolled item is rolled with "full flower" buds, rather than trimmings, or other discarded
     * cannabis from other production processes.
     * </pre>
     *
     * <code>FULL_FLOWER = 4;</code>
     */
    public static final int FULL_FLOWER_VALUE = 4;
    /**
     * <pre>
     * Specifies that this product contains tobacco.
     * </pre>
     *
     * <code>CONTAINS_TOBACCO = 5;</code>
     */
    public static final int CONTAINS_TOBACCO_VALUE = 5;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PrerollFlag valueOf(int value) {
      return forNumber(value);
    }

    public static PrerollFlag forNumber(int value) {
      switch (value) {
        case 0: return NO_PREROLL_FLAGS;
        case 1: return HASH_INFUSED;
        case 2: return KIEF_INFUSED;
        case 3: return FORTIFIED;
        case 4: return FULL_FLOWER;
        case 5: return CONTAINS_TOBACCO;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PrerollFlag>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        PrerollFlag> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<PrerollFlag>() {
            public PrerollFlag findValueByNumber(int number) {
              return PrerollFlag.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.product.PrerollProduct.getDescriptor().getEnumTypes().get(0);
    }

    private static final PrerollFlag[] VALUES = values();

    public static PrerollFlag valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PrerollFlag(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.products.PrerollFlag)
  }

  public interface PrerollOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.products.Preroll)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Product key that uniquely identifies this pre-rolled cannabis product.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    boolean hasKey();
    /**
     * <pre>
     * Product key that uniquely identifies this pre-rolled cannabis product.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKey getKey();
    /**
     * <pre>
     * Product key that uniquely identifies this pre-rolled cannabis product.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder();

    /**
     * <pre>
     * Specifies the flowers used to produce this product, if known.
     * </pre>
     *
     * <code>.opencannabis.base.ProductReference flower = 2;</code>
     */
    boolean hasFlower();
    /**
     * <pre>
     * Specifies the flowers used to produce this product, if known.
     * </pre>
     *
     * <code>.opencannabis.base.ProductReference flower = 2;</code>
     */
    io.opencannabis.schema.base.ProductReference getFlower();
    /**
     * <pre>
     * Specifies the flowers used to produce this product, if known.
     * </pre>
     *
     * <code>.opencannabis.base.ProductReference flower = 2;</code>
     */
    io.opencannabis.schema.base.ProductReferenceOrBuilder getFlowerOrBuilder();

    /**
     * <pre>
     * Specifies the measured length of this prerolled item, if known.
     * </pre>
     *
     * <code>double length = 3;</code>
     */
    double getLength();

    /**
     * <pre>
     * Specifies the measured thickness of this prerolled item, if known.
     * </pre>
     *
     * <code>double thickness = 4;</code>
     */
    double getThickness();

    /**
     * <pre>
     * Specifies flags that may be applied specifically to this prerolled item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
     */
    java.util.List<io.opencannabis.schema.product.PrerollProduct.PrerollFlag> getFlagsList();
    /**
     * <pre>
     * Specifies flags that may be applied specifically to this prerolled item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
     */
    int getFlagsCount();
    /**
     * <pre>
     * Specifies flags that may be applied specifically to this prerolled item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
     */
    io.opencannabis.schema.product.PrerollProduct.PrerollFlag getFlags(int index);
    /**
     * <pre>
     * Specifies flags that may be applied specifically to this prerolled item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
     */
    java.util.List<java.lang.Integer>
    getFlagsValueList();
    /**
     * <pre>
     * Specifies flags that may be applied specifically to this prerolled item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
     */
    int getFlagsValue(int index);

    /**
     * <pre>
     * Specifies product content attached to this prerolled item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 6;</code>
     */
    boolean hasProduct();
    /**
     * <pre>
     * Specifies product content attached to this prerolled item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 6;</code>
     */
    io.opencannabis.schema.content.ProductContent getProduct();
    /**
     * <pre>
     * Specifies product content attached to this prerolled item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 6;</code>
     */
    io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder();

    /**
     * <pre>
     * Specifies handling and materials data associated with this prerolled item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 7;</code>
     */
    boolean hasMaterial();
    /**
     * <pre>
     * Specifies handling and materials data associated with this prerolled item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 7;</code>
     */
    io.opencannabis.schema.content.MaterialsData getMaterial();
    /**
     * <pre>
     * Specifies handling and materials data associated with this prerolled item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 7;</code>
     */
    io.opencannabis.schema.content.MaterialsDataOrBuilder getMaterialOrBuilder();
  }
  /**
   * <pre>
   * Specifies a pre-rolled cannabis product, where a production process consumes cannabis plant material and produces
   * end-products that are already rolled into joints, marijuana cigarettes, blunts, and so on.
   * </pre>
   *
   * Protobuf type {@code opencannabis.products.Preroll}
   */
  public  static final class Preroll extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.products.Preroll)
      PrerollOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Preroll.newBuilder() to construct.
    private Preroll(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Preroll() {
      length_ = 0D;
      thickness_ = 0D;
      flags_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Preroll(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.base.ProductKey.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(io.opencannabis.schema.base.ProductKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              io.opencannabis.schema.base.ProductReference.Builder subBuilder = null;
              if (flower_ != null) {
                subBuilder = flower_.toBuilder();
              }
              flower_ = input.readMessage(io.opencannabis.schema.base.ProductReference.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(flower_);
                flower_ = subBuilder.buildPartial();
              }

              break;
            }
            case 25: {

              length_ = input.readDouble();
              break;
            }
            case 33: {

              thickness_ = input.readDouble();
              break;
            }
            case 40: {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                flags_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000010;
              }
              flags_.add(rawValue);
              break;
            }
            case 42: {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while(input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                  flags_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000010;
                }
                flags_.add(rawValue);
              }
              input.popLimit(oldLimit);
              break;
            }
            case 50: {
              io.opencannabis.schema.content.ProductContent.Builder subBuilder = null;
              if (product_ != null) {
                subBuilder = product_.toBuilder();
              }
              product_ = input.readMessage(io.opencannabis.schema.content.ProductContent.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(product_);
                product_ = subBuilder.buildPartial();
              }

              break;
            }
            case 58: {
              io.opencannabis.schema.content.MaterialsData.Builder subBuilder = null;
              if (material_ != null) {
                subBuilder = material_.toBuilder();
              }
              material_ = input.readMessage(io.opencannabis.schema.content.MaterialsData.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(material_);
                material_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          flags_ = java.util.Collections.unmodifiableList(flags_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.product.PrerollProduct.internal_static_opencannabis_products_Preroll_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.product.PrerollProduct.internal_static_opencannabis_products_Preroll_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.product.PrerollProduct.Preroll.class, io.opencannabis.schema.product.PrerollProduct.Preroll.Builder.class);
    }

    private int bitField0_;
    public static final int KEY_FIELD_NUMBER = 1;
    private io.opencannabis.schema.base.ProductKey key_;
    /**
     * <pre>
     * Product key that uniquely identifies this pre-rolled cannabis product.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <pre>
     * Product key that uniquely identifies this pre-rolled cannabis product.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKey getKey() {
      return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
    }
    /**
     * <pre>
     * Product key that uniquely identifies this pre-rolled cannabis product.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    public static final int FLOWER_FIELD_NUMBER = 2;
    private io.opencannabis.schema.base.ProductReference flower_;
    /**
     * <pre>
     * Specifies the flowers used to produce this product, if known.
     * </pre>
     *
     * <code>.opencannabis.base.ProductReference flower = 2;</code>
     */
    public boolean hasFlower() {
      return flower_ != null;
    }
    /**
     * <pre>
     * Specifies the flowers used to produce this product, if known.
     * </pre>
     *
     * <code>.opencannabis.base.ProductReference flower = 2;</code>
     */
    public io.opencannabis.schema.base.ProductReference getFlower() {
      return flower_ == null ? io.opencannabis.schema.base.ProductReference.getDefaultInstance() : flower_;
    }
    /**
     * <pre>
     * Specifies the flowers used to produce this product, if known.
     * </pre>
     *
     * <code>.opencannabis.base.ProductReference flower = 2;</code>
     */
    public io.opencannabis.schema.base.ProductReferenceOrBuilder getFlowerOrBuilder() {
      return getFlower();
    }

    public static final int LENGTH_FIELD_NUMBER = 3;
    private double length_;
    /**
     * <pre>
     * Specifies the measured length of this prerolled item, if known.
     * </pre>
     *
     * <code>double length = 3;</code>
     */
    public double getLength() {
      return length_;
    }

    public static final int THICKNESS_FIELD_NUMBER = 4;
    private double thickness_;
    /**
     * <pre>
     * Specifies the measured thickness of this prerolled item, if known.
     * </pre>
     *
     * <code>double thickness = 4;</code>
     */
    public double getThickness() {
      return thickness_;
    }

    public static final int FLAGS_FIELD_NUMBER = 5;
    private java.util.List<java.lang.Integer> flags_;
    private static final com.google.protobuf.Internal.ListAdapter.Converter<
        java.lang.Integer, io.opencannabis.schema.product.PrerollProduct.PrerollFlag> flags_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, io.opencannabis.schema.product.PrerollProduct.PrerollFlag>() {
              public io.opencannabis.schema.product.PrerollProduct.PrerollFlag convert(java.lang.Integer from) {
                io.opencannabis.schema.product.PrerollProduct.PrerollFlag result = io.opencannabis.schema.product.PrerollProduct.PrerollFlag.valueOf(from);
                return result == null ? io.opencannabis.schema.product.PrerollProduct.PrerollFlag.UNRECOGNIZED : result;
              }
            };
    /**
     * <pre>
     * Specifies flags that may be applied specifically to this prerolled item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
     */
    public java.util.List<io.opencannabis.schema.product.PrerollProduct.PrerollFlag> getFlagsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.product.PrerollProduct.PrerollFlag>(flags_, flags_converter_);
    }
    /**
     * <pre>
     * Specifies flags that may be applied specifically to this prerolled item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
     */
    public int getFlagsCount() {
      return flags_.size();
    }
    /**
     * <pre>
     * Specifies flags that may be applied specifically to this prerolled item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
     */
    public io.opencannabis.schema.product.PrerollProduct.PrerollFlag getFlags(int index) {
      return flags_converter_.convert(flags_.get(index));
    }
    /**
     * <pre>
     * Specifies flags that may be applied specifically to this prerolled item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
     */
    public java.util.List<java.lang.Integer>
    getFlagsValueList() {
      return flags_;
    }
    /**
     * <pre>
     * Specifies flags that may be applied specifically to this prerolled item.
     * </pre>
     *
     * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
     */
    public int getFlagsValue(int index) {
      return flags_.get(index);
    }
    private int flagsMemoizedSerializedSize;

    public static final int PRODUCT_FIELD_NUMBER = 6;
    private io.opencannabis.schema.content.ProductContent product_;
    /**
     * <pre>
     * Specifies product content attached to this prerolled item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 6;</code>
     */
    public boolean hasProduct() {
      return product_ != null;
    }
    /**
     * <pre>
     * Specifies product content attached to this prerolled item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 6;</code>
     */
    public io.opencannabis.schema.content.ProductContent getProduct() {
      return product_ == null ? io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
    }
    /**
     * <pre>
     * Specifies product content attached to this prerolled item.
     * </pre>
     *
     * <code>.opencannabis.content.ProductContent product = 6;</code>
     */
    public io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder() {
      return getProduct();
    }

    public static final int MATERIAL_FIELD_NUMBER = 7;
    private io.opencannabis.schema.content.MaterialsData material_;
    /**
     * <pre>
     * Specifies handling and materials data associated with this prerolled item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 7;</code>
     */
    public boolean hasMaterial() {
      return material_ != null;
    }
    /**
     * <pre>
     * Specifies handling and materials data associated with this prerolled item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 7;</code>
     */
    public io.opencannabis.schema.content.MaterialsData getMaterial() {
      return material_ == null ? io.opencannabis.schema.content.MaterialsData.getDefaultInstance() : material_;
    }
    /**
     * <pre>
     * Specifies handling and materials data associated with this prerolled item.
     * </pre>
     *
     * <code>.opencannabis.content.MaterialsData material = 7;</code>
     */
    public io.opencannabis.schema.content.MaterialsDataOrBuilder getMaterialOrBuilder() {
      return getMaterial();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (key_ != null) {
        output.writeMessage(1, getKey());
      }
      if (flower_ != null) {
        output.writeMessage(2, getFlower());
      }
      if (length_ != 0D) {
        output.writeDouble(3, length_);
      }
      if (thickness_ != 0D) {
        output.writeDouble(4, thickness_);
      }
      if (getFlagsList().size() > 0) {
        output.writeUInt32NoTag(42);
        output.writeUInt32NoTag(flagsMemoizedSerializedSize);
      }
      for (int i = 0; i < flags_.size(); i++) {
        output.writeEnumNoTag(flags_.get(i));
      }
      if (product_ != null) {
        output.writeMessage(6, getProduct());
      }
      if (material_ != null) {
        output.writeMessage(7, getMaterial());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getKey());
      }
      if (flower_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getFlower());
      }
      if (length_ != 0D) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(3, length_);
      }
      if (thickness_ != 0D) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(4, thickness_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < flags_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeEnumSizeNoTag(flags_.get(i));
        }
        size += dataSize;
        if (!getFlagsList().isEmpty()) {  size += 1;
          size += com.google.protobuf.CodedOutputStream
            .computeUInt32SizeNoTag(dataSize);
        }flagsMemoizedSerializedSize = dataSize;
      }
      if (product_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getProduct());
      }
      if (material_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, getMaterial());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.product.PrerollProduct.Preroll)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.product.PrerollProduct.Preroll other = (io.opencannabis.schema.product.PrerollProduct.Preroll) obj;

      boolean result = true;
      result = result && (hasKey() == other.hasKey());
      if (hasKey()) {
        result = result && getKey()
            .equals(other.getKey());
      }
      result = result && (hasFlower() == other.hasFlower());
      if (hasFlower()) {
        result = result && getFlower()
            .equals(other.getFlower());
      }
      result = result && (
          java.lang.Double.doubleToLongBits(getLength())
          == java.lang.Double.doubleToLongBits(
              other.getLength()));
      result = result && (
          java.lang.Double.doubleToLongBits(getThickness())
          == java.lang.Double.doubleToLongBits(
              other.getThickness()));
      result = result && flags_.equals(other.flags_);
      result = result && (hasProduct() == other.hasProduct());
      if (hasProduct()) {
        result = result && getProduct()
            .equals(other.getProduct());
      }
      result = result && (hasMaterial() == other.hasMaterial());
      if (hasMaterial()) {
        result = result && getMaterial()
            .equals(other.getMaterial());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      if (hasFlower()) {
        hash = (37 * hash) + FLOWER_FIELD_NUMBER;
        hash = (53 * hash) + getFlower().hashCode();
      }
      hash = (37 * hash) + LENGTH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getLength()));
      hash = (37 * hash) + THICKNESS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getThickness()));
      if (getFlagsCount() > 0) {
        hash = (37 * hash) + FLAGS_FIELD_NUMBER;
        hash = (53 * hash) + flags_.hashCode();
      }
      if (hasProduct()) {
        hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
        hash = (53 * hash) + getProduct().hashCode();
      }
      if (hasMaterial()) {
        hash = (37 * hash) + MATERIAL_FIELD_NUMBER;
        hash = (53 * hash) + getMaterial().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.product.PrerollProduct.Preroll parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.PrerollProduct.Preroll parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.PrerollProduct.Preroll parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.PrerollProduct.Preroll parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.PrerollProduct.Preroll parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.product.PrerollProduct.Preroll parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.product.PrerollProduct.Preroll parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.PrerollProduct.Preroll parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.PrerollProduct.Preroll parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.PrerollProduct.Preroll parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.product.PrerollProduct.Preroll parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.product.PrerollProduct.Preroll parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.product.PrerollProduct.Preroll prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a pre-rolled cannabis product, where a production process consumes cannabis plant material and produces
     * end-products that are already rolled into joints, marijuana cigarettes, blunts, and so on.
     * </pre>
     *
     * Protobuf type {@code opencannabis.products.Preroll}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.products.Preroll)
        io.opencannabis.schema.product.PrerollProduct.PrerollOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.product.PrerollProduct.internal_static_opencannabis_products_Preroll_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.product.PrerollProduct.internal_static_opencannabis_products_Preroll_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.product.PrerollProduct.Preroll.class, io.opencannabis.schema.product.PrerollProduct.Preroll.Builder.class);
      }

      // Construct using io.opencannabis.schema.product.PrerollProduct.Preroll.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        if (flowerBuilder_ == null) {
          flower_ = null;
        } else {
          flower_ = null;
          flowerBuilder_ = null;
        }
        length_ = 0D;

        thickness_ = 0D;

        flags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        if (productBuilder_ == null) {
          product_ = null;
        } else {
          product_ = null;
          productBuilder_ = null;
        }
        if (materialBuilder_ == null) {
          material_ = null;
        } else {
          material_ = null;
          materialBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.product.PrerollProduct.internal_static_opencannabis_products_Preroll_descriptor;
      }

      public io.opencannabis.schema.product.PrerollProduct.Preroll getDefaultInstanceForType() {
        return io.opencannabis.schema.product.PrerollProduct.Preroll.getDefaultInstance();
      }

      public io.opencannabis.schema.product.PrerollProduct.Preroll build() {
        io.opencannabis.schema.product.PrerollProduct.Preroll result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.product.PrerollProduct.Preroll buildPartial() {
        io.opencannabis.schema.product.PrerollProduct.Preroll result = new io.opencannabis.schema.product.PrerollProduct.Preroll(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        if (flowerBuilder_ == null) {
          result.flower_ = flower_;
        } else {
          result.flower_ = flowerBuilder_.build();
        }
        result.length_ = length_;
        result.thickness_ = thickness_;
        if (((bitField0_ & 0x00000010) == 0x00000010)) {
          flags_ = java.util.Collections.unmodifiableList(flags_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.flags_ = flags_;
        if (productBuilder_ == null) {
          result.product_ = product_;
        } else {
          result.product_ = productBuilder_.build();
        }
        if (materialBuilder_ == null) {
          result.material_ = material_;
        } else {
          result.material_ = materialBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.product.PrerollProduct.Preroll) {
          return mergeFrom((io.opencannabis.schema.product.PrerollProduct.Preroll)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.product.PrerollProduct.Preroll other) {
        if (other == io.opencannabis.schema.product.PrerollProduct.Preroll.getDefaultInstance()) return this;
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        if (other.hasFlower()) {
          mergeFlower(other.getFlower());
        }
        if (other.getLength() != 0D) {
          setLength(other.getLength());
        }
        if (other.getThickness() != 0D) {
          setThickness(other.getThickness());
        }
        if (!other.flags_.isEmpty()) {
          if (flags_.isEmpty()) {
            flags_ = other.flags_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureFlagsIsMutable();
            flags_.addAll(other.flags_);
          }
          onChanged();
        }
        if (other.hasProduct()) {
          mergeProduct(other.getProduct());
        }
        if (other.hasMaterial()) {
          mergeMaterial(other.getMaterial());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.product.PrerollProduct.Preroll parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.product.PrerollProduct.Preroll) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private io.opencannabis.schema.base.ProductKey key_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> keyBuilder_;
      /**
       * <pre>
       * Product key that uniquely identifies this pre-rolled cannabis product.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this pre-rolled cannabis product.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Product key that uniquely identifies this pre-rolled cannabis product.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this pre-rolled cannabis product.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(
          io.opencannabis.schema.base.ProductKey.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this pre-rolled cannabis product.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder mergeKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              io.opencannabis.schema.base.ProductKey.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this pre-rolled cannabis product.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Product key that uniquely identifies this pre-rolled cannabis product.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Product key that uniquely identifies this pre-rolled cannabis product.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        }
      }
      /**
       * <pre>
       * Product key that uniquely identifies this pre-rolled cannabis product.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }

      private io.opencannabis.schema.base.ProductReference flower_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductReference, io.opencannabis.schema.base.ProductReference.Builder, io.opencannabis.schema.base.ProductReferenceOrBuilder> flowerBuilder_;
      /**
       * <pre>
       * Specifies the flowers used to produce this product, if known.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 2;</code>
       */
      public boolean hasFlower() {
        return flowerBuilder_ != null || flower_ != null;
      }
      /**
       * <pre>
       * Specifies the flowers used to produce this product, if known.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 2;</code>
       */
      public io.opencannabis.schema.base.ProductReference getFlower() {
        if (flowerBuilder_ == null) {
          return flower_ == null ? io.opencannabis.schema.base.ProductReference.getDefaultInstance() : flower_;
        } else {
          return flowerBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies the flowers used to produce this product, if known.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 2;</code>
       */
      public Builder setFlower(io.opencannabis.schema.base.ProductReference value) {
        if (flowerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          flower_ = value;
          onChanged();
        } else {
          flowerBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the flowers used to produce this product, if known.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 2;</code>
       */
      public Builder setFlower(
          io.opencannabis.schema.base.ProductReference.Builder builderForValue) {
        if (flowerBuilder_ == null) {
          flower_ = builderForValue.build();
          onChanged();
        } else {
          flowerBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the flowers used to produce this product, if known.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 2;</code>
       */
      public Builder mergeFlower(io.opencannabis.schema.base.ProductReference value) {
        if (flowerBuilder_ == null) {
          if (flower_ != null) {
            flower_ =
              io.opencannabis.schema.base.ProductReference.newBuilder(flower_).mergeFrom(value).buildPartial();
          } else {
            flower_ = value;
          }
          onChanged();
        } else {
          flowerBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the flowers used to produce this product, if known.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 2;</code>
       */
      public Builder clearFlower() {
        if (flowerBuilder_ == null) {
          flower_ = null;
          onChanged();
        } else {
          flower_ = null;
          flowerBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the flowers used to produce this product, if known.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 2;</code>
       */
      public io.opencannabis.schema.base.ProductReference.Builder getFlowerBuilder() {
        
        onChanged();
        return getFlowerFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies the flowers used to produce this product, if known.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 2;</code>
       */
      public io.opencannabis.schema.base.ProductReferenceOrBuilder getFlowerOrBuilder() {
        if (flowerBuilder_ != null) {
          return flowerBuilder_.getMessageOrBuilder();
        } else {
          return flower_ == null ?
              io.opencannabis.schema.base.ProductReference.getDefaultInstance() : flower_;
        }
      }
      /**
       * <pre>
       * Specifies the flowers used to produce this product, if known.
       * </pre>
       *
       * <code>.opencannabis.base.ProductReference flower = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductReference, io.opencannabis.schema.base.ProductReference.Builder, io.opencannabis.schema.base.ProductReferenceOrBuilder> 
          getFlowerFieldBuilder() {
        if (flowerBuilder_ == null) {
          flowerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductReference, io.opencannabis.schema.base.ProductReference.Builder, io.opencannabis.schema.base.ProductReferenceOrBuilder>(
                  getFlower(),
                  getParentForChildren(),
                  isClean());
          flower_ = null;
        }
        return flowerBuilder_;
      }

      private double length_ ;
      /**
       * <pre>
       * Specifies the measured length of this prerolled item, if known.
       * </pre>
       *
       * <code>double length = 3;</code>
       */
      public double getLength() {
        return length_;
      }
      /**
       * <pre>
       * Specifies the measured length of this prerolled item, if known.
       * </pre>
       *
       * <code>double length = 3;</code>
       */
      public Builder setLength(double value) {
        
        length_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the measured length of this prerolled item, if known.
       * </pre>
       *
       * <code>double length = 3;</code>
       */
      public Builder clearLength() {
        
        length_ = 0D;
        onChanged();
        return this;
      }

      private double thickness_ ;
      /**
       * <pre>
       * Specifies the measured thickness of this prerolled item, if known.
       * </pre>
       *
       * <code>double thickness = 4;</code>
       */
      public double getThickness() {
        return thickness_;
      }
      /**
       * <pre>
       * Specifies the measured thickness of this prerolled item, if known.
       * </pre>
       *
       * <code>double thickness = 4;</code>
       */
      public Builder setThickness(double value) {
        
        thickness_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the measured thickness of this prerolled item, if known.
       * </pre>
       *
       * <code>double thickness = 4;</code>
       */
      public Builder clearThickness() {
        
        thickness_ = 0D;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> flags_ =
        java.util.Collections.emptyList();
      private void ensureFlagsIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          flags_ = new java.util.ArrayList<java.lang.Integer>(flags_);
          bitField0_ |= 0x00000010;
        }
      }
      /**
       * <pre>
       * Specifies flags that may be applied specifically to this prerolled item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
       */
      public java.util.List<io.opencannabis.schema.product.PrerollProduct.PrerollFlag> getFlagsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, io.opencannabis.schema.product.PrerollProduct.PrerollFlag>(flags_, flags_converter_);
      }
      /**
       * <pre>
       * Specifies flags that may be applied specifically to this prerolled item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
       */
      public int getFlagsCount() {
        return flags_.size();
      }
      /**
       * <pre>
       * Specifies flags that may be applied specifically to this prerolled item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
       */
      public io.opencannabis.schema.product.PrerollProduct.PrerollFlag getFlags(int index) {
        return flags_converter_.convert(flags_.get(index));
      }
      /**
       * <pre>
       * Specifies flags that may be applied specifically to this prerolled item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
       */
      public Builder setFlags(
          int index, io.opencannabis.schema.product.PrerollProduct.PrerollFlag value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlagsIsMutable();
        flags_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags that may be applied specifically to this prerolled item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
       */
      public Builder addFlags(io.opencannabis.schema.product.PrerollProduct.PrerollFlag value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlagsIsMutable();
        flags_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags that may be applied specifically to this prerolled item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
       */
      public Builder addAllFlags(
          java.lang.Iterable<? extends io.opencannabis.schema.product.PrerollProduct.PrerollFlag> values) {
        ensureFlagsIsMutable();
        for (io.opencannabis.schema.product.PrerollProduct.PrerollFlag value : values) {
          flags_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags that may be applied specifically to this prerolled item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
       */
      public Builder clearFlags() {
        flags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags that may be applied specifically to this prerolled item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
       */
      public java.util.List<java.lang.Integer>
      getFlagsValueList() {
        return java.util.Collections.unmodifiableList(flags_);
      }
      /**
       * <pre>
       * Specifies flags that may be applied specifically to this prerolled item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
       */
      public int getFlagsValue(int index) {
        return flags_.get(index);
      }
      /**
       * <pre>
       * Specifies flags that may be applied specifically to this prerolled item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
       */
      public Builder setFlagsValue(
          int index, int value) {
        ensureFlagsIsMutable();
        flags_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags that may be applied specifically to this prerolled item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
       */
      public Builder addFlagsValue(int value) {
        ensureFlagsIsMutable();
        flags_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies flags that may be applied specifically to this prerolled item.
       * </pre>
       *
       * <code>repeated .opencannabis.products.PrerollFlag flags = 5;</code>
       */
      public Builder addAllFlagsValue(
          java.lang.Iterable<java.lang.Integer> values) {
        ensureFlagsIsMutable();
        for (int value : values) {
          flags_.add(value);
        }
        onChanged();
        return this;
      }

      private io.opencannabis.schema.content.ProductContent product_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder> productBuilder_;
      /**
       * <pre>
       * Specifies product content attached to this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 6;</code>
       */
      public boolean hasProduct() {
        return productBuilder_ != null || product_ != null;
      }
      /**
       * <pre>
       * Specifies product content attached to this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 6;</code>
       */
      public io.opencannabis.schema.content.ProductContent getProduct() {
        if (productBuilder_ == null) {
          return product_ == null ? io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
        } else {
          return productBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies product content attached to this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 6;</code>
       */
      public Builder setProduct(io.opencannabis.schema.content.ProductContent value) {
        if (productBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          product_ = value;
          onChanged();
        } else {
          productBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies product content attached to this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 6;</code>
       */
      public Builder setProduct(
          io.opencannabis.schema.content.ProductContent.Builder builderForValue) {
        if (productBuilder_ == null) {
          product_ = builderForValue.build();
          onChanged();
        } else {
          productBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies product content attached to this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 6;</code>
       */
      public Builder mergeProduct(io.opencannabis.schema.content.ProductContent value) {
        if (productBuilder_ == null) {
          if (product_ != null) {
            product_ =
              io.opencannabis.schema.content.ProductContent.newBuilder(product_).mergeFrom(value).buildPartial();
          } else {
            product_ = value;
          }
          onChanged();
        } else {
          productBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies product content attached to this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 6;</code>
       */
      public Builder clearProduct() {
        if (productBuilder_ == null) {
          product_ = null;
          onChanged();
        } else {
          product_ = null;
          productBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies product content attached to this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 6;</code>
       */
      public io.opencannabis.schema.content.ProductContent.Builder getProductBuilder() {
        
        onChanged();
        return getProductFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies product content attached to this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 6;</code>
       */
      public io.opencannabis.schema.content.ProductContentOrBuilder getProductOrBuilder() {
        if (productBuilder_ != null) {
          return productBuilder_.getMessageOrBuilder();
        } else {
          return product_ == null ?
              io.opencannabis.schema.content.ProductContent.getDefaultInstance() : product_;
        }
      }
      /**
       * <pre>
       * Specifies product content attached to this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.ProductContent product = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder> 
          getProductFieldBuilder() {
        if (productBuilder_ == null) {
          productBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.content.ProductContent, io.opencannabis.schema.content.ProductContent.Builder, io.opencannabis.schema.content.ProductContentOrBuilder>(
                  getProduct(),
                  getParentForChildren(),
                  isClean());
          product_ = null;
        }
        return productBuilder_;
      }

      private io.opencannabis.schema.content.MaterialsData material_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.MaterialsData, io.opencannabis.schema.content.MaterialsData.Builder, io.opencannabis.schema.content.MaterialsDataOrBuilder> materialBuilder_;
      /**
       * <pre>
       * Specifies handling and materials data associated with this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 7;</code>
       */
      public boolean hasMaterial() {
        return materialBuilder_ != null || material_ != null;
      }
      /**
       * <pre>
       * Specifies handling and materials data associated with this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 7;</code>
       */
      public io.opencannabis.schema.content.MaterialsData getMaterial() {
        if (materialBuilder_ == null) {
          return material_ == null ? io.opencannabis.schema.content.MaterialsData.getDefaultInstance() : material_;
        } else {
          return materialBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies handling and materials data associated with this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 7;</code>
       */
      public Builder setMaterial(io.opencannabis.schema.content.MaterialsData value) {
        if (materialBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          material_ = value;
          onChanged();
        } else {
          materialBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies handling and materials data associated with this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 7;</code>
       */
      public Builder setMaterial(
          io.opencannabis.schema.content.MaterialsData.Builder builderForValue) {
        if (materialBuilder_ == null) {
          material_ = builderForValue.build();
          onChanged();
        } else {
          materialBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies handling and materials data associated with this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 7;</code>
       */
      public Builder mergeMaterial(io.opencannabis.schema.content.MaterialsData value) {
        if (materialBuilder_ == null) {
          if (material_ != null) {
            material_ =
              io.opencannabis.schema.content.MaterialsData.newBuilder(material_).mergeFrom(value).buildPartial();
          } else {
            material_ = value;
          }
          onChanged();
        } else {
          materialBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies handling and materials data associated with this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 7;</code>
       */
      public Builder clearMaterial() {
        if (materialBuilder_ == null) {
          material_ = null;
          onChanged();
        } else {
          material_ = null;
          materialBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies handling and materials data associated with this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 7;</code>
       */
      public io.opencannabis.schema.content.MaterialsData.Builder getMaterialBuilder() {
        
        onChanged();
        return getMaterialFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies handling and materials data associated with this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 7;</code>
       */
      public io.opencannabis.schema.content.MaterialsDataOrBuilder getMaterialOrBuilder() {
        if (materialBuilder_ != null) {
          return materialBuilder_.getMessageOrBuilder();
        } else {
          return material_ == null ?
              io.opencannabis.schema.content.MaterialsData.getDefaultInstance() : material_;
        }
      }
      /**
       * <pre>
       * Specifies handling and materials data associated with this prerolled item.
       * </pre>
       *
       * <code>.opencannabis.content.MaterialsData material = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.content.MaterialsData, io.opencannabis.schema.content.MaterialsData.Builder, io.opencannabis.schema.content.MaterialsDataOrBuilder> 
          getMaterialFieldBuilder() {
        if (materialBuilder_ == null) {
          materialBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.content.MaterialsData, io.opencannabis.schema.content.MaterialsData.Builder, io.opencannabis.schema.content.MaterialsDataOrBuilder>(
                  getMaterial(),
                  getParentForChildren(),
                  isClean());
          material_ = null;
        }
        return materialBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.products.Preroll)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.products.Preroll)
    private static final io.opencannabis.schema.product.PrerollProduct.Preroll DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.product.PrerollProduct.Preroll();
    }

    public static io.opencannabis.schema.product.PrerollProduct.Preroll getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Preroll>
        PARSER = new com.google.protobuf.AbstractParser<Preroll>() {
      public Preroll parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Preroll(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Preroll> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Preroll> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.product.PrerollProduct.Preroll getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_products_Preroll_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_products_Preroll_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\026products/Preroll.proto\022\025opencannabis.p" +
      "roducts\032\025base/ProductKey.proto\032\033content/" +
      "MaterialsData.proto\032\034content/ProductCont" +
      "ent.proto\"\256\002\n\007Preroll\022*\n\003key\030\001 \001(\0132\035.ope" +
      "ncannabis.base.ProductKey\0223\n\006flower\030\002 \001(" +
      "\0132#.opencannabis.base.ProductReference\022\016" +
      "\n\006length\030\003 \001(\001\022\021\n\tthickness\030\004 \001(\001\0221\n\005fla" +
      "gs\030\005 \003(\0162\".opencannabis.products.Preroll" +
      "Flag\0225\n\007product\030\006 \001(\0132$.opencannabis.con" +
      "tent.ProductContent\0225\n\010material\030\007 \001(\0132#." +
      "opencannabis.content.MaterialsData*}\n\013Pr" +
      "erollFlag\022\024\n\020NO_PREROLL_FLAGS\020\000\022\020\n\014HASH_" +
      "INFUSED\020\001\022\020\n\014KIEF_INFUSED\020\002\022\r\n\tFORTIFIED" +
      "\020\003\022\017\n\013FULL_FLOWER\020\004\022\024\n\020CONTAINS_TOBACCO\020" +
      "\005B:\n\036io.opencannabis.schema.productB\016Pre" +
      "rollProductH\001P\000\242\002\003OCSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.base.BaseProductKey.getDescriptor(),
          io.opencannabis.schema.content.MaterialsContent.getDescriptor(),
          io.opencannabis.schema.content.AttachedContent.getDescriptor(),
        }, assigner);
    internal_static_opencannabis_products_Preroll_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_opencannabis_products_Preroll_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_products_Preroll_descriptor,
        new java.lang.String[] { "Key", "Flower", "Length", "Thickness", "Flags", "Product", "Material", });
    io.opencannabis.schema.base.BaseProductKey.getDescriptor();
    io.opencannabis.schema.content.MaterialsContent.getDescriptor();
    io.opencannabis.schema.content.AttachedContent.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
