/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: structs/pricing/PricingDescriptor.proto

package io.opencannabis.schema.product.struct;

/**
 * <pre>
 * Specifies a descriptor for product pricing, which specifies the price configuration for one independent price tier
 * in a given set of pricing tiers for a product.
 * </pre>
 *
 * Protobuf type {@code opencannabis.structs.pricing.PricingDescriptor}
 */
public  final class PricingDescriptor extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.structs.pricing.PricingDescriptor)
    PricingDescriptorOrBuilder {
private static final long serialVersionUID = 0L;
  // Use PricingDescriptor.newBuilder() to construct.
  private PricingDescriptor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private PricingDescriptor() {
    type_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private PricingDescriptor(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();

            type_ = rawValue;
            break;
          }
          case 162: {
            io.opencannabis.schema.product.struct.UnitPricingDescriptor.Builder subBuilder = null;
            if (tierCase_ == 20) {
              subBuilder = ((io.opencannabis.schema.product.struct.UnitPricingDescriptor) tier_).toBuilder();
            }
            tier_ =
                input.readMessage(io.opencannabis.schema.product.struct.UnitPricingDescriptor.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.opencannabis.schema.product.struct.UnitPricingDescriptor) tier_);
              tier_ = subBuilder.buildPartial();
            }
            tierCase_ = 20;
            break;
          }
          case 170: {
            io.opencannabis.schema.product.struct.WeightedPricingDescriptor.Builder subBuilder = null;
            if (tierCase_ == 21) {
              subBuilder = ((io.opencannabis.schema.product.struct.WeightedPricingDescriptor) tier_).toBuilder();
            }
            tier_ =
                input.readMessage(io.opencannabis.schema.product.struct.WeightedPricingDescriptor.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.opencannabis.schema.product.struct.WeightedPricingDescriptor) tier_);
              tier_ = subBuilder.buildPartial();
            }
            tierCase_ = 21;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.product.struct.ProductPricingSpec.internal_static_opencannabis_structs_pricing_PricingDescriptor_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.product.struct.ProductPricingSpec.internal_static_opencannabis_structs_pricing_PricingDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.product.struct.PricingDescriptor.class, io.opencannabis.schema.product.struct.PricingDescriptor.Builder.class);
  }

  private int tierCase_ = 0;
  private java.lang.Object tier_;
  public enum TierCase
      implements com.google.protobuf.Internal.EnumLite {
    UNIT(20),
    WEIGHTED(21),
    TIER_NOT_SET(0);
    private final int value;
    private TierCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TierCase valueOf(int value) {
      return forNumber(value);
    }

    public static TierCase forNumber(int value) {
      switch (value) {
        case 20: return UNIT;
        case 21: return WEIGHTED;
        case 0: return TIER_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public TierCase
  getTierCase() {
    return TierCase.forNumber(
        tierCase_);
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_;
  /**
   * <pre>
   * Type of pricing tier this descriptor is specifying.
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.PricingType type = 1;</code>
   */
  public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Type of pricing tier this descriptor is specifying.
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.PricingType type = 1;</code>
   */
  public io.opencannabis.schema.product.struct.PricingType getType() {
    io.opencannabis.schema.product.struct.PricingType result = io.opencannabis.schema.product.struct.PricingType.valueOf(type_);
    return result == null ? io.opencannabis.schema.product.struct.PricingType.UNRECOGNIZED : result;
  }

  public static final int UNIT_FIELD_NUMBER = 20;
  /**
   * <pre>
   * Unit-based pricing information, with no variance in price change.
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.UnitPricingDescriptor unit = 20;</code>
   */
  public boolean hasUnit() {
    return tierCase_ == 20;
  }
  /**
   * <pre>
   * Unit-based pricing information, with no variance in price change.
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.UnitPricingDescriptor unit = 20;</code>
   */
  public io.opencannabis.schema.product.struct.UnitPricingDescriptor getUnit() {
    if (tierCase_ == 20) {
       return (io.opencannabis.schema.product.struct.UnitPricingDescriptor) tier_;
    }
    return io.opencannabis.schema.product.struct.UnitPricingDescriptor.getDefaultInstance();
  }
  /**
   * <pre>
   * Unit-based pricing information, with no variance in price change.
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.UnitPricingDescriptor unit = 20;</code>
   */
  public io.opencannabis.schema.product.struct.UnitPricingDescriptorOrBuilder getUnitOrBuilder() {
    if (tierCase_ == 20) {
       return (io.opencannabis.schema.product.struct.UnitPricingDescriptor) tier_;
    }
    return io.opencannabis.schema.product.struct.UnitPricingDescriptor.getDefaultInstance();
  }

  public static final int WEIGHTED_FIELD_NUMBER = 21;
  /**
   * <pre>
   * Weight-based pricing information, with prices assgined to specific or known weights.
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.WeightedPricingDescriptor weighted = 21;</code>
   */
  public boolean hasWeighted() {
    return tierCase_ == 21;
  }
  /**
   * <pre>
   * Weight-based pricing information, with prices assgined to specific or known weights.
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.WeightedPricingDescriptor weighted = 21;</code>
   */
  public io.opencannabis.schema.product.struct.WeightedPricingDescriptor getWeighted() {
    if (tierCase_ == 21) {
       return (io.opencannabis.schema.product.struct.WeightedPricingDescriptor) tier_;
    }
    return io.opencannabis.schema.product.struct.WeightedPricingDescriptor.getDefaultInstance();
  }
  /**
   * <pre>
   * Weight-based pricing information, with prices assgined to specific or known weights.
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.WeightedPricingDescriptor weighted = 21;</code>
   */
  public io.opencannabis.schema.product.struct.WeightedPricingDescriptorOrBuilder getWeightedOrBuilder() {
    if (tierCase_ == 21) {
       return (io.opencannabis.schema.product.struct.WeightedPricingDescriptor) tier_;
    }
    return io.opencannabis.schema.product.struct.WeightedPricingDescriptor.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (type_ != io.opencannabis.schema.product.struct.PricingType.UNIT.getNumber()) {
      output.writeEnum(1, type_);
    }
    if (tierCase_ == 20) {
      output.writeMessage(20, (io.opencannabis.schema.product.struct.UnitPricingDescriptor) tier_);
    }
    if (tierCase_ == 21) {
      output.writeMessage(21, (io.opencannabis.schema.product.struct.WeightedPricingDescriptor) tier_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_ != io.opencannabis.schema.product.struct.PricingType.UNIT.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, type_);
    }
    if (tierCase_ == 20) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(20, (io.opencannabis.schema.product.struct.UnitPricingDescriptor) tier_);
    }
    if (tierCase_ == 21) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(21, (io.opencannabis.schema.product.struct.WeightedPricingDescriptor) tier_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.product.struct.PricingDescriptor)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.product.struct.PricingDescriptor other = (io.opencannabis.schema.product.struct.PricingDescriptor) obj;

    boolean result = true;
    result = result && type_ == other.type_;
    result = result && getTierCase().equals(
        other.getTierCase());
    if (!result) return false;
    switch (tierCase_) {
      case 20:
        result = result && getUnit()
            .equals(other.getUnit());
        break;
      case 21:
        result = result && getWeighted()
            .equals(other.getWeighted());
        break;
      case 0:
      default:
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    switch (tierCase_) {
      case 20:
        hash = (37 * hash) + UNIT_FIELD_NUMBER;
        hash = (53 * hash) + getUnit().hashCode();
        break;
      case 21:
        hash = (37 * hash) + WEIGHTED_FIELD_NUMBER;
        hash = (53 * hash) + getWeighted().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.product.struct.PricingDescriptor parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.product.struct.PricingDescriptor parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.PricingDescriptor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.product.struct.PricingDescriptor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.PricingDescriptor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.product.struct.PricingDescriptor parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.PricingDescriptor parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.product.struct.PricingDescriptor parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.PricingDescriptor parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.product.struct.PricingDescriptor parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.PricingDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.product.struct.PricingDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.product.struct.PricingDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a descriptor for product pricing, which specifies the price configuration for one independent price tier
   * in a given set of pricing tiers for a product.
   * </pre>
   *
   * Protobuf type {@code opencannabis.structs.pricing.PricingDescriptor}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.structs.pricing.PricingDescriptor)
      io.opencannabis.schema.product.struct.PricingDescriptorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.product.struct.ProductPricingSpec.internal_static_opencannabis_structs_pricing_PricingDescriptor_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.product.struct.ProductPricingSpec.internal_static_opencannabis_structs_pricing_PricingDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.product.struct.PricingDescriptor.class, io.opencannabis.schema.product.struct.PricingDescriptor.Builder.class);
    }

    // Construct using io.opencannabis.schema.product.struct.PricingDescriptor.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      type_ = 0;

      tierCase_ = 0;
      tier_ = null;
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.product.struct.ProductPricingSpec.internal_static_opencannabis_structs_pricing_PricingDescriptor_descriptor;
    }

    public io.opencannabis.schema.product.struct.PricingDescriptor getDefaultInstanceForType() {
      return io.opencannabis.schema.product.struct.PricingDescriptor.getDefaultInstance();
    }

    public io.opencannabis.schema.product.struct.PricingDescriptor build() {
      io.opencannabis.schema.product.struct.PricingDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.product.struct.PricingDescriptor buildPartial() {
      io.opencannabis.schema.product.struct.PricingDescriptor result = new io.opencannabis.schema.product.struct.PricingDescriptor(this);
      result.type_ = type_;
      if (tierCase_ == 20) {
        if (unitBuilder_ == null) {
          result.tier_ = tier_;
        } else {
          result.tier_ = unitBuilder_.build();
        }
      }
      if (tierCase_ == 21) {
        if (weightedBuilder_ == null) {
          result.tier_ = tier_;
        } else {
          result.tier_ = weightedBuilder_.build();
        }
      }
      result.tierCase_ = tierCase_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.product.struct.PricingDescriptor) {
        return mergeFrom((io.opencannabis.schema.product.struct.PricingDescriptor)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.product.struct.PricingDescriptor other) {
      if (other == io.opencannabis.schema.product.struct.PricingDescriptor.getDefaultInstance()) return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      switch (other.getTierCase()) {
        case UNIT: {
          mergeUnit(other.getUnit());
          break;
        }
        case WEIGHTED: {
          mergeWeighted(other.getWeighted());
          break;
        }
        case TIER_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.product.struct.PricingDescriptor parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.product.struct.PricingDescriptor) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int tierCase_ = 0;
    private java.lang.Object tier_;
    public TierCase
        getTierCase() {
      return TierCase.forNumber(
          tierCase_);
    }

    public Builder clearTier() {
      tierCase_ = 0;
      tier_ = null;
      onChanged();
      return this;
    }


    private int type_ = 0;
    /**
     * <pre>
     * Type of pricing tier this descriptor is specifying.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingType type = 1;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Type of pricing tier this descriptor is specifying.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingType type = 1;</code>
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Type of pricing tier this descriptor is specifying.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingType type = 1;</code>
     */
    public io.opencannabis.schema.product.struct.PricingType getType() {
      io.opencannabis.schema.product.struct.PricingType result = io.opencannabis.schema.product.struct.PricingType.valueOf(type_);
      return result == null ? io.opencannabis.schema.product.struct.PricingType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Type of pricing tier this descriptor is specifying.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingType type = 1;</code>
     */
    public Builder setType(io.opencannabis.schema.product.struct.PricingType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Type of pricing tier this descriptor is specifying.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingType type = 1;</code>
     */
    public Builder clearType() {
      
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.UnitPricingDescriptor, io.opencannabis.schema.product.struct.UnitPricingDescriptor.Builder, io.opencannabis.schema.product.struct.UnitPricingDescriptorOrBuilder> unitBuilder_;
    /**
     * <pre>
     * Unit-based pricing information, with no variance in price change.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.UnitPricingDescriptor unit = 20;</code>
     */
    public boolean hasUnit() {
      return tierCase_ == 20;
    }
    /**
     * <pre>
     * Unit-based pricing information, with no variance in price change.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.UnitPricingDescriptor unit = 20;</code>
     */
    public io.opencannabis.schema.product.struct.UnitPricingDescriptor getUnit() {
      if (unitBuilder_ == null) {
        if (tierCase_ == 20) {
          return (io.opencannabis.schema.product.struct.UnitPricingDescriptor) tier_;
        }
        return io.opencannabis.schema.product.struct.UnitPricingDescriptor.getDefaultInstance();
      } else {
        if (tierCase_ == 20) {
          return unitBuilder_.getMessage();
        }
        return io.opencannabis.schema.product.struct.UnitPricingDescriptor.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Unit-based pricing information, with no variance in price change.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.UnitPricingDescriptor unit = 20;</code>
     */
    public Builder setUnit(io.opencannabis.schema.product.struct.UnitPricingDescriptor value) {
      if (unitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tier_ = value;
        onChanged();
      } else {
        unitBuilder_.setMessage(value);
      }
      tierCase_ = 20;
      return this;
    }
    /**
     * <pre>
     * Unit-based pricing information, with no variance in price change.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.UnitPricingDescriptor unit = 20;</code>
     */
    public Builder setUnit(
        io.opencannabis.schema.product.struct.UnitPricingDescriptor.Builder builderForValue) {
      if (unitBuilder_ == null) {
        tier_ = builderForValue.build();
        onChanged();
      } else {
        unitBuilder_.setMessage(builderForValue.build());
      }
      tierCase_ = 20;
      return this;
    }
    /**
     * <pre>
     * Unit-based pricing information, with no variance in price change.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.UnitPricingDescriptor unit = 20;</code>
     */
    public Builder mergeUnit(io.opencannabis.schema.product.struct.UnitPricingDescriptor value) {
      if (unitBuilder_ == null) {
        if (tierCase_ == 20 &&
            tier_ != io.opencannabis.schema.product.struct.UnitPricingDescriptor.getDefaultInstance()) {
          tier_ = io.opencannabis.schema.product.struct.UnitPricingDescriptor.newBuilder((io.opencannabis.schema.product.struct.UnitPricingDescriptor) tier_)
              .mergeFrom(value).buildPartial();
        } else {
          tier_ = value;
        }
        onChanged();
      } else {
        if (tierCase_ == 20) {
          unitBuilder_.mergeFrom(value);
        }
        unitBuilder_.setMessage(value);
      }
      tierCase_ = 20;
      return this;
    }
    /**
     * <pre>
     * Unit-based pricing information, with no variance in price change.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.UnitPricingDescriptor unit = 20;</code>
     */
    public Builder clearUnit() {
      if (unitBuilder_ == null) {
        if (tierCase_ == 20) {
          tierCase_ = 0;
          tier_ = null;
          onChanged();
        }
      } else {
        if (tierCase_ == 20) {
          tierCase_ = 0;
          tier_ = null;
        }
        unitBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Unit-based pricing information, with no variance in price change.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.UnitPricingDescriptor unit = 20;</code>
     */
    public io.opencannabis.schema.product.struct.UnitPricingDescriptor.Builder getUnitBuilder() {
      return getUnitFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Unit-based pricing information, with no variance in price change.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.UnitPricingDescriptor unit = 20;</code>
     */
    public io.opencannabis.schema.product.struct.UnitPricingDescriptorOrBuilder getUnitOrBuilder() {
      if ((tierCase_ == 20) && (unitBuilder_ != null)) {
        return unitBuilder_.getMessageOrBuilder();
      } else {
        if (tierCase_ == 20) {
          return (io.opencannabis.schema.product.struct.UnitPricingDescriptor) tier_;
        }
        return io.opencannabis.schema.product.struct.UnitPricingDescriptor.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Unit-based pricing information, with no variance in price change.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.UnitPricingDescriptor unit = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.UnitPricingDescriptor, io.opencannabis.schema.product.struct.UnitPricingDescriptor.Builder, io.opencannabis.schema.product.struct.UnitPricingDescriptorOrBuilder> 
        getUnitFieldBuilder() {
      if (unitBuilder_ == null) {
        if (!(tierCase_ == 20)) {
          tier_ = io.opencannabis.schema.product.struct.UnitPricingDescriptor.getDefaultInstance();
        }
        unitBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.product.struct.UnitPricingDescriptor, io.opencannabis.schema.product.struct.UnitPricingDescriptor.Builder, io.opencannabis.schema.product.struct.UnitPricingDescriptorOrBuilder>(
                (io.opencannabis.schema.product.struct.UnitPricingDescriptor) tier_,
                getParentForChildren(),
                isClean());
        tier_ = null;
      }
      tierCase_ = 20;
      onChanged();;
      return unitBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.WeightedPricingDescriptor, io.opencannabis.schema.product.struct.WeightedPricingDescriptor.Builder, io.opencannabis.schema.product.struct.WeightedPricingDescriptorOrBuilder> weightedBuilder_;
    /**
     * <pre>
     * Weight-based pricing information, with prices assgined to specific or known weights.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.WeightedPricingDescriptor weighted = 21;</code>
     */
    public boolean hasWeighted() {
      return tierCase_ == 21;
    }
    /**
     * <pre>
     * Weight-based pricing information, with prices assgined to specific or known weights.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.WeightedPricingDescriptor weighted = 21;</code>
     */
    public io.opencannabis.schema.product.struct.WeightedPricingDescriptor getWeighted() {
      if (weightedBuilder_ == null) {
        if (tierCase_ == 21) {
          return (io.opencannabis.schema.product.struct.WeightedPricingDescriptor) tier_;
        }
        return io.opencannabis.schema.product.struct.WeightedPricingDescriptor.getDefaultInstance();
      } else {
        if (tierCase_ == 21) {
          return weightedBuilder_.getMessage();
        }
        return io.opencannabis.schema.product.struct.WeightedPricingDescriptor.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Weight-based pricing information, with prices assgined to specific or known weights.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.WeightedPricingDescriptor weighted = 21;</code>
     */
    public Builder setWeighted(io.opencannabis.schema.product.struct.WeightedPricingDescriptor value) {
      if (weightedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tier_ = value;
        onChanged();
      } else {
        weightedBuilder_.setMessage(value);
      }
      tierCase_ = 21;
      return this;
    }
    /**
     * <pre>
     * Weight-based pricing information, with prices assgined to specific or known weights.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.WeightedPricingDescriptor weighted = 21;</code>
     */
    public Builder setWeighted(
        io.opencannabis.schema.product.struct.WeightedPricingDescriptor.Builder builderForValue) {
      if (weightedBuilder_ == null) {
        tier_ = builderForValue.build();
        onChanged();
      } else {
        weightedBuilder_.setMessage(builderForValue.build());
      }
      tierCase_ = 21;
      return this;
    }
    /**
     * <pre>
     * Weight-based pricing information, with prices assgined to specific or known weights.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.WeightedPricingDescriptor weighted = 21;</code>
     */
    public Builder mergeWeighted(io.opencannabis.schema.product.struct.WeightedPricingDescriptor value) {
      if (weightedBuilder_ == null) {
        if (tierCase_ == 21 &&
            tier_ != io.opencannabis.schema.product.struct.WeightedPricingDescriptor.getDefaultInstance()) {
          tier_ = io.opencannabis.schema.product.struct.WeightedPricingDescriptor.newBuilder((io.opencannabis.schema.product.struct.WeightedPricingDescriptor) tier_)
              .mergeFrom(value).buildPartial();
        } else {
          tier_ = value;
        }
        onChanged();
      } else {
        if (tierCase_ == 21) {
          weightedBuilder_.mergeFrom(value);
        }
        weightedBuilder_.setMessage(value);
      }
      tierCase_ = 21;
      return this;
    }
    /**
     * <pre>
     * Weight-based pricing information, with prices assgined to specific or known weights.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.WeightedPricingDescriptor weighted = 21;</code>
     */
    public Builder clearWeighted() {
      if (weightedBuilder_ == null) {
        if (tierCase_ == 21) {
          tierCase_ = 0;
          tier_ = null;
          onChanged();
        }
      } else {
        if (tierCase_ == 21) {
          tierCase_ = 0;
          tier_ = null;
        }
        weightedBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Weight-based pricing information, with prices assgined to specific or known weights.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.WeightedPricingDescriptor weighted = 21;</code>
     */
    public io.opencannabis.schema.product.struct.WeightedPricingDescriptor.Builder getWeightedBuilder() {
      return getWeightedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Weight-based pricing information, with prices assgined to specific or known weights.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.WeightedPricingDescriptor weighted = 21;</code>
     */
    public io.opencannabis.schema.product.struct.WeightedPricingDescriptorOrBuilder getWeightedOrBuilder() {
      if ((tierCase_ == 21) && (weightedBuilder_ != null)) {
        return weightedBuilder_.getMessageOrBuilder();
      } else {
        if (tierCase_ == 21) {
          return (io.opencannabis.schema.product.struct.WeightedPricingDescriptor) tier_;
        }
        return io.opencannabis.schema.product.struct.WeightedPricingDescriptor.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Weight-based pricing information, with prices assgined to specific or known weights.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.WeightedPricingDescriptor weighted = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.WeightedPricingDescriptor, io.opencannabis.schema.product.struct.WeightedPricingDescriptor.Builder, io.opencannabis.schema.product.struct.WeightedPricingDescriptorOrBuilder> 
        getWeightedFieldBuilder() {
      if (weightedBuilder_ == null) {
        if (!(tierCase_ == 21)) {
          tier_ = io.opencannabis.schema.product.struct.WeightedPricingDescriptor.getDefaultInstance();
        }
        weightedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.product.struct.WeightedPricingDescriptor, io.opencannabis.schema.product.struct.WeightedPricingDescriptor.Builder, io.opencannabis.schema.product.struct.WeightedPricingDescriptorOrBuilder>(
                (io.opencannabis.schema.product.struct.WeightedPricingDescriptor) tier_,
                getParentForChildren(),
                isClean());
        tier_ = null;
      }
      tierCase_ = 21;
      onChanged();;
      return weightedBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.structs.pricing.PricingDescriptor)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.structs.pricing.PricingDescriptor)
  private static final io.opencannabis.schema.product.struct.PricingDescriptor DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.product.struct.PricingDescriptor();
  }

  public static io.opencannabis.schema.product.struct.PricingDescriptor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PricingDescriptor>
      PARSER = new com.google.protobuf.AbstractParser<PricingDescriptor>() {
    public PricingDescriptor parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new PricingDescriptor(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<PricingDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PricingDescriptor> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.product.struct.PricingDescriptor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

