/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: structs/ProductFlags.proto

package io.opencannabis.schema.product.struct;

/**
 * <pre>
 * Flags that may be applied to an entire product entry, that govern how an independent product and all of its variants
 * or sub-products are processed or treated.
 * </pre>
 *
 * Protobuf enum {@code opencannabis.structs.ProductFlag}
 */
public enum ProductFlag
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * Default flag value. Marks a product as 'VISIBLE,' meaning it is eligible to be displayed in public circumstances.
   * In some cases, this is interpreted to mean 'IN STOCK.' Being that this flag is a default value, the absence of this
   * flag does not designate an item as non-visible - this is accomplished by explicitly specifying the 'HIDDEN' flag.
   * </pre>
   *
   * <code>VISIBLE = 0;</code>
   */
  VISIBLE(0),
  /**
   * <pre>
   * Indicates that this entire product entry should be 'HIDDEN' from public view, or considered 'OUT-OF-STOCK' in back-
   * office systems.
   * </pre>
   *
   * <code>HIDDEN = 1;</code>
   */
  HIDDEN(1),
  /**
   * <pre>
   * Designates a product as 'PREMIUM,' indicating it is a top-shelf or super-high-quality product. In some cases, this
   * flag is used to indicate items that are produced in-house.
   * </pre>
   *
   * <code>PREMIUM = 2;</code>
   */
  PREMIUM(2),
  /**
   * <pre>
   * Designates a product as 'FEATURED,' which makes it eligible for extra promotional display. Featured products are
   * generally highlighted or displayed top-of-the-fold.
   * </pre>
   *
   * <code>FEATURED = 3;</code>
   */
  FEATURED(3),
  /**
   * <pre>
   * Designates a product as 'EXCLUSIVE,' meaning it is only carried or produced by the owning retailer or manufacturer.
   * </pre>
   *
   * <code>EXCLUSIVE = 4;</code>
   */
  EXCLUSIVE(4),
  /**
   * <pre>
   * Designates a product as 'IN-HOUSE,' indicating it is carried and produced by the same organization. In a retail
   * context, this flag is used to indicate items manufactured by the retailer or the retailer's partners.
   * </pre>
   *
   * <code>IN_HOUSE = 5;</code>
   */
  IN_HOUSE(5),
  /**
   * <pre>
   * Indicates that a product will not be around long, or that it is running out. In retail contexts, this designates
   * the product in a way that may trigger extra promotional UI.
   * </pre>
   *
   * <code>LAST_CHANCE = 6;</code>
   */
  LAST_CHANCE(6),
  /**
   * <pre>
   * Indicates that a particular product will only be available for a limited time, or is available only in limited
   * batches.
   * </pre>
   *
   * <code>LIMITED_TIME = 7;</code>
   */
  LIMITED_TIME(7),
  /**
   * <pre>
   * Indicates that a particular product is produced locally. In retail contexts, this may trigger extra promotional UI.
   * </pre>
   *
   * <code>LOCAL = 8;</code>
   */
  LOCAL(8),
  /**
   * <pre>
   * Designates, in general, that a product is 'ON-SALE.' This designation SHOULD be propagated-to by implementing
   * servers, from a product's weighted pricing sale flags. This means, if ANY product weight or variant is marked on
   * sale, the 'ON-SALE' flag SHOULD be sent along with the top-level product information.
   * </pre>
   *
   * <code>ON_SALE = 20;</code>
   */
  ON_SALE(20),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * Default flag value. Marks a product as 'VISIBLE,' meaning it is eligible to be displayed in public circumstances.
   * In some cases, this is interpreted to mean 'IN STOCK.' Being that this flag is a default value, the absence of this
   * flag does not designate an item as non-visible - this is accomplished by explicitly specifying the 'HIDDEN' flag.
   * </pre>
   *
   * <code>VISIBLE = 0;</code>
   */
  public static final int VISIBLE_VALUE = 0;
  /**
   * <pre>
   * Indicates that this entire product entry should be 'HIDDEN' from public view, or considered 'OUT-OF-STOCK' in back-
   * office systems.
   * </pre>
   *
   * <code>HIDDEN = 1;</code>
   */
  public static final int HIDDEN_VALUE = 1;
  /**
   * <pre>
   * Designates a product as 'PREMIUM,' indicating it is a top-shelf or super-high-quality product. In some cases, this
   * flag is used to indicate items that are produced in-house.
   * </pre>
   *
   * <code>PREMIUM = 2;</code>
   */
  public static final int PREMIUM_VALUE = 2;
  /**
   * <pre>
   * Designates a product as 'FEATURED,' which makes it eligible for extra promotional display. Featured products are
   * generally highlighted or displayed top-of-the-fold.
   * </pre>
   *
   * <code>FEATURED = 3;</code>
   */
  public static final int FEATURED_VALUE = 3;
  /**
   * <pre>
   * Designates a product as 'EXCLUSIVE,' meaning it is only carried or produced by the owning retailer or manufacturer.
   * </pre>
   *
   * <code>EXCLUSIVE = 4;</code>
   */
  public static final int EXCLUSIVE_VALUE = 4;
  /**
   * <pre>
   * Designates a product as 'IN-HOUSE,' indicating it is carried and produced by the same organization. In a retail
   * context, this flag is used to indicate items manufactured by the retailer or the retailer's partners.
   * </pre>
   *
   * <code>IN_HOUSE = 5;</code>
   */
  public static final int IN_HOUSE_VALUE = 5;
  /**
   * <pre>
   * Indicates that a product will not be around long, or that it is running out. In retail contexts, this designates
   * the product in a way that may trigger extra promotional UI.
   * </pre>
   *
   * <code>LAST_CHANCE = 6;</code>
   */
  public static final int LAST_CHANCE_VALUE = 6;
  /**
   * <pre>
   * Indicates that a particular product will only be available for a limited time, or is available only in limited
   * batches.
   * </pre>
   *
   * <code>LIMITED_TIME = 7;</code>
   */
  public static final int LIMITED_TIME_VALUE = 7;
  /**
   * <pre>
   * Indicates that a particular product is produced locally. In retail contexts, this may trigger extra promotional UI.
   * </pre>
   *
   * <code>LOCAL = 8;</code>
   */
  public static final int LOCAL_VALUE = 8;
  /**
   * <pre>
   * Designates, in general, that a product is 'ON-SALE.' This designation SHOULD be propagated-to by implementing
   * servers, from a product's weighted pricing sale flags. This means, if ANY product weight or variant is marked on
   * sale, the 'ON-SALE' flag SHOULD be sent along with the top-level product information.
   * </pre>
   *
   * <code>ON_SALE = 20;</code>
   */
  public static final int ON_SALE_VALUE = 20;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static ProductFlag valueOf(int value) {
    return forNumber(value);
  }

  public static ProductFlag forNumber(int value) {
    switch (value) {
      case 0: return VISIBLE;
      case 1: return HIDDEN;
      case 2: return PREMIUM;
      case 3: return FEATURED;
      case 4: return EXCLUSIVE;
      case 5: return IN_HOUSE;
      case 6: return LAST_CHANCE;
      case 7: return LIMITED_TIME;
      case 8: return LOCAL;
      case 20: return ON_SALE;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<ProductFlag>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      ProductFlag> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ProductFlag>() {
          public ProductFlag findValueByNumber(int number) {
            return ProductFlag.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.opencannabis.schema.product.struct.BaseStructs.getDescriptor().getEnumTypes().get(0);
  }

  private static final ProductFlag[] VALUES = values();

  public static ProductFlag valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private ProductFlag(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:opencannabis.structs.ProductFlag)
}

