/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: structs/Shelf.proto

package io.opencannabis.schema.product.struct;

/**
 * <pre>
 * Enumerates available 'shelf' entries, for use in retail contexts, to indicate the quality of a particular product
 * entry (usually flowers).
 * </pre>
 *
 * Protobuf enum {@code opencannabis.structs.Shelf}
 */
public enum Shelf
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * Default value, indicating no specific shelf choice.
   * </pre>
   *
   * <code>GENERIC_SHELF = 0;</code>
   */
  GENERIC_SHELF(0),
  /**
   * <pre>
   * 'Economy' shelf. Best value for the money, generally with a focus on THC-per-gram.
   * </pre>
   *
   * <code>ECONOMY = 1;</code>
   */
  ECONOMY(1),
  /**
   * <pre>
   * 'Midshelf'. Medium-grade products that strike a balance between cost and potency/quality.
   * </pre>
   *
   * <code>MIDSHELF = 2;</code>
   */
  MIDSHELF(2),
  /**
   * <pre>
   * 'Topshelf'. High-grade, or highly-refined products, that focus on potency or quality to the exclusion or detriment
   * of cost.
   * </pre>
   *
   * <code>TOPSHELF = 3;</code>
   */
  TOPSHELF(3),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * Default value, indicating no specific shelf choice.
   * </pre>
   *
   * <code>GENERIC_SHELF = 0;</code>
   */
  public static final int GENERIC_SHELF_VALUE = 0;
  /**
   * <pre>
   * 'Economy' shelf. Best value for the money, generally with a focus on THC-per-gram.
   * </pre>
   *
   * <code>ECONOMY = 1;</code>
   */
  public static final int ECONOMY_VALUE = 1;
  /**
   * <pre>
   * 'Midshelf'. Medium-grade products that strike a balance between cost and potency/quality.
   * </pre>
   *
   * <code>MIDSHELF = 2;</code>
   */
  public static final int MIDSHELF_VALUE = 2;
  /**
   * <pre>
   * 'Topshelf'. High-grade, or highly-refined products, that focus on potency or quality to the exclusion or detriment
   * of cost.
   * </pre>
   *
   * <code>TOPSHELF = 3;</code>
   */
  public static final int TOPSHELF_VALUE = 3;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static Shelf valueOf(int value) {
    return forNumber(value);
  }

  public static Shelf forNumber(int value) {
    switch (value) {
      case 0: return GENERIC_SHELF;
      case 1: return ECONOMY;
      case 2: return MIDSHELF;
      case 3: return TOPSHELF;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<Shelf>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      Shelf> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Shelf>() {
          public Shelf findValueByNumber(int number) {
            return Shelf.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.opencannabis.schema.product.struct.MaterialShelf.getDescriptor().getEnumTypes().get(0);
  }

  private static final Shelf[] VALUES = values();

  public static Shelf valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private Shelf(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:opencannabis.structs.Shelf)
}

