/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: structs/pricing/PricingDescriptor.proto

package io.opencannabis.schema.product.struct;

/**
 * <pre>
 * Specifies pricing information for a unit-priced product, including the price value, tier status, and any discounts
 * that currently apply.
 * </pre>
 *
 * Protobuf type {@code opencannabis.structs.pricing.UnitPricingDescriptor}
 */
public  final class UnitPricingDescriptor extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.structs.pricing.UnitPricingDescriptor)
    UnitPricingDescriptorOrBuilder {
private static final long serialVersionUID = 0L;
  // Use UnitPricingDescriptor.newBuilder() to construct.
  private UnitPricingDescriptor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private UnitPricingDescriptor() {
    discounts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private UnitPricingDescriptor(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            io.opencannabis.schema.currency.CurrencyValue.Builder subBuilder = null;
            if (price_ != null) {
              subBuilder = price_.toBuilder();
            }
            price_ = input.readMessage(io.opencannabis.schema.currency.CurrencyValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(price_);
              price_ = subBuilder.buildPartial();
            }

            break;
          }
          case 18: {
            io.opencannabis.schema.product.struct.PricingTierAvailability.Builder subBuilder = null;
            if (status_ != null) {
              subBuilder = status_.toBuilder();
            }
            status_ = input.readMessage(io.opencannabis.schema.product.struct.PricingTierAvailability.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(status_);
              status_ = subBuilder.buildPartial();
            }

            break;
          }
          case 26: {
            if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
              discounts_ = new java.util.ArrayList<io.opencannabis.schema.product.struct.SaleDescriptor>();
              mutable_bitField0_ |= 0x00000004;
            }
            discounts_.add(
                input.readMessage(io.opencannabis.schema.product.struct.SaleDescriptor.parser(), extensionRegistry));
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
        discounts_ = java.util.Collections.unmodifiableList(discounts_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.product.struct.ProductPricingSpec.internal_static_opencannabis_structs_pricing_UnitPricingDescriptor_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.product.struct.ProductPricingSpec.internal_static_opencannabis_structs_pricing_UnitPricingDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.product.struct.UnitPricingDescriptor.class, io.opencannabis.schema.product.struct.UnitPricingDescriptor.Builder.class);
  }

  private int bitField0_;
  public static final int PRICE_FIELD_NUMBER = 1;
  private io.opencannabis.schema.currency.CurrencyValue price_;
  /**
   * <pre>
   * Unit price value.
   * </pre>
   *
   * <code>.opencannabis.commerce.CurrencyValue price = 1;</code>
   */
  public boolean hasPrice() {
    return price_ != null;
  }
  /**
   * <pre>
   * Unit price value.
   * </pre>
   *
   * <code>.opencannabis.commerce.CurrencyValue price = 1;</code>
   */
  public io.opencannabis.schema.currency.CurrencyValue getPrice() {
    return price_ == null ? io.opencannabis.schema.currency.CurrencyValue.getDefaultInstance() : price_;
  }
  /**
   * <pre>
   * Unit price value.
   * </pre>
   *
   * <code>.opencannabis.commerce.CurrencyValue price = 1;</code>
   */
  public io.opencannabis.schema.currency.CurrencyValueOrBuilder getPriceOrBuilder() {
    return getPrice();
  }

  public static final int STATUS_FIELD_NUMBER = 2;
  private io.opencannabis.schema.product.struct.PricingTierAvailability status_;
  /**
   * <pre>
   * Availability flags for this unit-priced tier.
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.PricingTierAvailability status = 2;</code>
   */
  public boolean hasStatus() {
    return status_ != null;
  }
  /**
   * <pre>
   * Availability flags for this unit-priced tier.
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.PricingTierAvailability status = 2;</code>
   */
  public io.opencannabis.schema.product.struct.PricingTierAvailability getStatus() {
    return status_ == null ? io.opencannabis.schema.product.struct.PricingTierAvailability.getDefaultInstance() : status_;
  }
  /**
   * <pre>
   * Availability flags for this unit-priced tier.
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.PricingTierAvailability status = 2;</code>
   */
  public io.opencannabis.schema.product.struct.PricingTierAvailabilityOrBuilder getStatusOrBuilder() {
    return getStatus();
  }

  public static final int DISCOUNTS_FIELD_NUMBER = 3;
  private java.util.List<io.opencannabis.schema.product.struct.SaleDescriptor> discounts_;
  /**
   * <pre>
   * Discounts that should apply to this tier.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
   */
  public java.util.List<io.opencannabis.schema.product.struct.SaleDescriptor> getDiscountsList() {
    return discounts_;
  }
  /**
   * <pre>
   * Discounts that should apply to this tier.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
   */
  public java.util.List<? extends io.opencannabis.schema.product.struct.SaleDescriptorOrBuilder> 
      getDiscountsOrBuilderList() {
    return discounts_;
  }
  /**
   * <pre>
   * Discounts that should apply to this tier.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
   */
  public int getDiscountsCount() {
    return discounts_.size();
  }
  /**
   * <pre>
   * Discounts that should apply to this tier.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
   */
  public io.opencannabis.schema.product.struct.SaleDescriptor getDiscounts(int index) {
    return discounts_.get(index);
  }
  /**
   * <pre>
   * Discounts that should apply to this tier.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
   */
  public io.opencannabis.schema.product.struct.SaleDescriptorOrBuilder getDiscountsOrBuilder(
      int index) {
    return discounts_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (price_ != null) {
      output.writeMessage(1, getPrice());
    }
    if (status_ != null) {
      output.writeMessage(2, getStatus());
    }
    for (int i = 0; i < discounts_.size(); i++) {
      output.writeMessage(3, discounts_.get(i));
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (price_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getPrice());
    }
    if (status_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getStatus());
    }
    for (int i = 0; i < discounts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, discounts_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.product.struct.UnitPricingDescriptor)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.product.struct.UnitPricingDescriptor other = (io.opencannabis.schema.product.struct.UnitPricingDescriptor) obj;

    boolean result = true;
    result = result && (hasPrice() == other.hasPrice());
    if (hasPrice()) {
      result = result && getPrice()
          .equals(other.getPrice());
    }
    result = result && (hasStatus() == other.hasStatus());
    if (hasStatus()) {
      result = result && getStatus()
          .equals(other.getStatus());
    }
    result = result && getDiscountsList()
        .equals(other.getDiscountsList());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPrice()) {
      hash = (37 * hash) + PRICE_FIELD_NUMBER;
      hash = (53 * hash) + getPrice().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (getDiscountsCount() > 0) {
      hash = (37 * hash) + DISCOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getDiscountsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.product.struct.UnitPricingDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies pricing information for a unit-priced product, including the price value, tier status, and any discounts
   * that currently apply.
   * </pre>
   *
   * Protobuf type {@code opencannabis.structs.pricing.UnitPricingDescriptor}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.structs.pricing.UnitPricingDescriptor)
      io.opencannabis.schema.product.struct.UnitPricingDescriptorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.product.struct.ProductPricingSpec.internal_static_opencannabis_structs_pricing_UnitPricingDescriptor_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.product.struct.ProductPricingSpec.internal_static_opencannabis_structs_pricing_UnitPricingDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.product.struct.UnitPricingDescriptor.class, io.opencannabis.schema.product.struct.UnitPricingDescriptor.Builder.class);
    }

    // Construct using io.opencannabis.schema.product.struct.UnitPricingDescriptor.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getDiscountsFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      if (priceBuilder_ == null) {
        price_ = null;
      } else {
        price_ = null;
        priceBuilder_ = null;
      }
      if (statusBuilder_ == null) {
        status_ = null;
      } else {
        status_ = null;
        statusBuilder_ = null;
      }
      if (discountsBuilder_ == null) {
        discounts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
      } else {
        discountsBuilder_.clear();
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.product.struct.ProductPricingSpec.internal_static_opencannabis_structs_pricing_UnitPricingDescriptor_descriptor;
    }

    public io.opencannabis.schema.product.struct.UnitPricingDescriptor getDefaultInstanceForType() {
      return io.opencannabis.schema.product.struct.UnitPricingDescriptor.getDefaultInstance();
    }

    public io.opencannabis.schema.product.struct.UnitPricingDescriptor build() {
      io.opencannabis.schema.product.struct.UnitPricingDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.product.struct.UnitPricingDescriptor buildPartial() {
      io.opencannabis.schema.product.struct.UnitPricingDescriptor result = new io.opencannabis.schema.product.struct.UnitPricingDescriptor(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (priceBuilder_ == null) {
        result.price_ = price_;
      } else {
        result.price_ = priceBuilder_.build();
      }
      if (statusBuilder_ == null) {
        result.status_ = status_;
      } else {
        result.status_ = statusBuilder_.build();
      }
      if (discountsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) == 0x00000004)) {
          discounts_ = java.util.Collections.unmodifiableList(discounts_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.discounts_ = discounts_;
      } else {
        result.discounts_ = discountsBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.product.struct.UnitPricingDescriptor) {
        return mergeFrom((io.opencannabis.schema.product.struct.UnitPricingDescriptor)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.product.struct.UnitPricingDescriptor other) {
      if (other == io.opencannabis.schema.product.struct.UnitPricingDescriptor.getDefaultInstance()) return this;
      if (other.hasPrice()) {
        mergePrice(other.getPrice());
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (discountsBuilder_ == null) {
        if (!other.discounts_.isEmpty()) {
          if (discounts_.isEmpty()) {
            discounts_ = other.discounts_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureDiscountsIsMutable();
            discounts_.addAll(other.discounts_);
          }
          onChanged();
        }
      } else {
        if (!other.discounts_.isEmpty()) {
          if (discountsBuilder_.isEmpty()) {
            discountsBuilder_.dispose();
            discountsBuilder_ = null;
            discounts_ = other.discounts_;
            bitField0_ = (bitField0_ & ~0x00000004);
            discountsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getDiscountsFieldBuilder() : null;
          } else {
            discountsBuilder_.addAllMessages(other.discounts_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.product.struct.UnitPricingDescriptor parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.product.struct.UnitPricingDescriptor) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private io.opencannabis.schema.currency.CurrencyValue price_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.currency.CurrencyValue, io.opencannabis.schema.currency.CurrencyValue.Builder, io.opencannabis.schema.currency.CurrencyValueOrBuilder> priceBuilder_;
    /**
     * <pre>
     * Unit price value.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyValue price = 1;</code>
     */
    public boolean hasPrice() {
      return priceBuilder_ != null || price_ != null;
    }
    /**
     * <pre>
     * Unit price value.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyValue price = 1;</code>
     */
    public io.opencannabis.schema.currency.CurrencyValue getPrice() {
      if (priceBuilder_ == null) {
        return price_ == null ? io.opencannabis.schema.currency.CurrencyValue.getDefaultInstance() : price_;
      } else {
        return priceBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Unit price value.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyValue price = 1;</code>
     */
    public Builder setPrice(io.opencannabis.schema.currency.CurrencyValue value) {
      if (priceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        price_ = value;
        onChanged();
      } else {
        priceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Unit price value.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyValue price = 1;</code>
     */
    public Builder setPrice(
        io.opencannabis.schema.currency.CurrencyValue.Builder builderForValue) {
      if (priceBuilder_ == null) {
        price_ = builderForValue.build();
        onChanged();
      } else {
        priceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Unit price value.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyValue price = 1;</code>
     */
    public Builder mergePrice(io.opencannabis.schema.currency.CurrencyValue value) {
      if (priceBuilder_ == null) {
        if (price_ != null) {
          price_ =
            io.opencannabis.schema.currency.CurrencyValue.newBuilder(price_).mergeFrom(value).buildPartial();
        } else {
          price_ = value;
        }
        onChanged();
      } else {
        priceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Unit price value.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyValue price = 1;</code>
     */
    public Builder clearPrice() {
      if (priceBuilder_ == null) {
        price_ = null;
        onChanged();
      } else {
        price_ = null;
        priceBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Unit price value.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyValue price = 1;</code>
     */
    public io.opencannabis.schema.currency.CurrencyValue.Builder getPriceBuilder() {
      
      onChanged();
      return getPriceFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Unit price value.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyValue price = 1;</code>
     */
    public io.opencannabis.schema.currency.CurrencyValueOrBuilder getPriceOrBuilder() {
      if (priceBuilder_ != null) {
        return priceBuilder_.getMessageOrBuilder();
      } else {
        return price_ == null ?
            io.opencannabis.schema.currency.CurrencyValue.getDefaultInstance() : price_;
      }
    }
    /**
     * <pre>
     * Unit price value.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyValue price = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.currency.CurrencyValue, io.opencannabis.schema.currency.CurrencyValue.Builder, io.opencannabis.schema.currency.CurrencyValueOrBuilder> 
        getPriceFieldBuilder() {
      if (priceBuilder_ == null) {
        priceBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.currency.CurrencyValue, io.opencannabis.schema.currency.CurrencyValue.Builder, io.opencannabis.schema.currency.CurrencyValueOrBuilder>(
                getPrice(),
                getParentForChildren(),
                isClean());
        price_ = null;
      }
      return priceBuilder_;
    }

    private io.opencannabis.schema.product.struct.PricingTierAvailability status_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.PricingTierAvailability, io.opencannabis.schema.product.struct.PricingTierAvailability.Builder, io.opencannabis.schema.product.struct.PricingTierAvailabilityOrBuilder> statusBuilder_;
    /**
     * <pre>
     * Availability flags for this unit-priced tier.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingTierAvailability status = 2;</code>
     */
    public boolean hasStatus() {
      return statusBuilder_ != null || status_ != null;
    }
    /**
     * <pre>
     * Availability flags for this unit-priced tier.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingTierAvailability status = 2;</code>
     */
    public io.opencannabis.schema.product.struct.PricingTierAvailability getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null ? io.opencannabis.schema.product.struct.PricingTierAvailability.getDefaultInstance() : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Availability flags for this unit-priced tier.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingTierAvailability status = 2;</code>
     */
    public Builder setStatus(io.opencannabis.schema.product.struct.PricingTierAvailability value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
        onChanged();
      } else {
        statusBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Availability flags for this unit-priced tier.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingTierAvailability status = 2;</code>
     */
    public Builder setStatus(
        io.opencannabis.schema.product.struct.PricingTierAvailability.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
        onChanged();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Availability flags for this unit-priced tier.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingTierAvailability status = 2;</code>
     */
    public Builder mergeStatus(io.opencannabis.schema.product.struct.PricingTierAvailability value) {
      if (statusBuilder_ == null) {
        if (status_ != null) {
          status_ =
            io.opencannabis.schema.product.struct.PricingTierAvailability.newBuilder(status_).mergeFrom(value).buildPartial();
        } else {
          status_ = value;
        }
        onChanged();
      } else {
        statusBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Availability flags for this unit-priced tier.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingTierAvailability status = 2;</code>
     */
    public Builder clearStatus() {
      if (statusBuilder_ == null) {
        status_ = null;
        onChanged();
      } else {
        status_ = null;
        statusBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Availability flags for this unit-priced tier.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingTierAvailability status = 2;</code>
     */
    public io.opencannabis.schema.product.struct.PricingTierAvailability.Builder getStatusBuilder() {
      
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Availability flags for this unit-priced tier.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingTierAvailability status = 2;</code>
     */
    public io.opencannabis.schema.product.struct.PricingTierAvailabilityOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null ?
            io.opencannabis.schema.product.struct.PricingTierAvailability.getDefaultInstance() : status_;
      }
    }
    /**
     * <pre>
     * Availability flags for this unit-priced tier.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingTierAvailability status = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.PricingTierAvailability, io.opencannabis.schema.product.struct.PricingTierAvailability.Builder, io.opencannabis.schema.product.struct.PricingTierAvailabilityOrBuilder> 
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.product.struct.PricingTierAvailability, io.opencannabis.schema.product.struct.PricingTierAvailability.Builder, io.opencannabis.schema.product.struct.PricingTierAvailabilityOrBuilder>(
                getStatus(),
                getParentForChildren(),
                isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private java.util.List<io.opencannabis.schema.product.struct.SaleDescriptor> discounts_ =
      java.util.Collections.emptyList();
    private void ensureDiscountsIsMutable() {
      if (!((bitField0_ & 0x00000004) == 0x00000004)) {
        discounts_ = new java.util.ArrayList<io.opencannabis.schema.product.struct.SaleDescriptor>(discounts_);
        bitField0_ |= 0x00000004;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opencannabis.schema.product.struct.SaleDescriptor, io.opencannabis.schema.product.struct.SaleDescriptor.Builder, io.opencannabis.schema.product.struct.SaleDescriptorOrBuilder> discountsBuilder_;

    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public java.util.List<io.opencannabis.schema.product.struct.SaleDescriptor> getDiscountsList() {
      if (discountsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(discounts_);
      } else {
        return discountsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public int getDiscountsCount() {
      if (discountsBuilder_ == null) {
        return discounts_.size();
      } else {
        return discountsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public io.opencannabis.schema.product.struct.SaleDescriptor getDiscounts(int index) {
      if (discountsBuilder_ == null) {
        return discounts_.get(index);
      } else {
        return discountsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public Builder setDiscounts(
        int index, io.opencannabis.schema.product.struct.SaleDescriptor value) {
      if (discountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDiscountsIsMutable();
        discounts_.set(index, value);
        onChanged();
      } else {
        discountsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public Builder setDiscounts(
        int index, io.opencannabis.schema.product.struct.SaleDescriptor.Builder builderForValue) {
      if (discountsBuilder_ == null) {
        ensureDiscountsIsMutable();
        discounts_.set(index, builderForValue.build());
        onChanged();
      } else {
        discountsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public Builder addDiscounts(io.opencannabis.schema.product.struct.SaleDescriptor value) {
      if (discountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDiscountsIsMutable();
        discounts_.add(value);
        onChanged();
      } else {
        discountsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public Builder addDiscounts(
        int index, io.opencannabis.schema.product.struct.SaleDescriptor value) {
      if (discountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDiscountsIsMutable();
        discounts_.add(index, value);
        onChanged();
      } else {
        discountsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public Builder addDiscounts(
        io.opencannabis.schema.product.struct.SaleDescriptor.Builder builderForValue) {
      if (discountsBuilder_ == null) {
        ensureDiscountsIsMutable();
        discounts_.add(builderForValue.build());
        onChanged();
      } else {
        discountsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public Builder addDiscounts(
        int index, io.opencannabis.schema.product.struct.SaleDescriptor.Builder builderForValue) {
      if (discountsBuilder_ == null) {
        ensureDiscountsIsMutable();
        discounts_.add(index, builderForValue.build());
        onChanged();
      } else {
        discountsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public Builder addAllDiscounts(
        java.lang.Iterable<? extends io.opencannabis.schema.product.struct.SaleDescriptor> values) {
      if (discountsBuilder_ == null) {
        ensureDiscountsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, discounts_);
        onChanged();
      } else {
        discountsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public Builder clearDiscounts() {
      if (discountsBuilder_ == null) {
        discounts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        discountsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public Builder removeDiscounts(int index) {
      if (discountsBuilder_ == null) {
        ensureDiscountsIsMutable();
        discounts_.remove(index);
        onChanged();
      } else {
        discountsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public io.opencannabis.schema.product.struct.SaleDescriptor.Builder getDiscountsBuilder(
        int index) {
      return getDiscountsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public io.opencannabis.schema.product.struct.SaleDescriptorOrBuilder getDiscountsOrBuilder(
        int index) {
      if (discountsBuilder_ == null) {
        return discounts_.get(index);  } else {
        return discountsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.product.struct.SaleDescriptorOrBuilder> 
         getDiscountsOrBuilderList() {
      if (discountsBuilder_ != null) {
        return discountsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(discounts_);
      }
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public io.opencannabis.schema.product.struct.SaleDescriptor.Builder addDiscountsBuilder() {
      return getDiscountsFieldBuilder().addBuilder(
          io.opencannabis.schema.product.struct.SaleDescriptor.getDefaultInstance());
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public io.opencannabis.schema.product.struct.SaleDescriptor.Builder addDiscountsBuilder(
        int index) {
      return getDiscountsFieldBuilder().addBuilder(
          index, io.opencannabis.schema.product.struct.SaleDescriptor.getDefaultInstance());
    }
    /**
     * <pre>
     * Discounts that should apply to this tier.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.pricing.SaleDescriptor discounts = 3;</code>
     */
    public java.util.List<io.opencannabis.schema.product.struct.SaleDescriptor.Builder> 
         getDiscountsBuilderList() {
      return getDiscountsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opencannabis.schema.product.struct.SaleDescriptor, io.opencannabis.schema.product.struct.SaleDescriptor.Builder, io.opencannabis.schema.product.struct.SaleDescriptorOrBuilder> 
        getDiscountsFieldBuilder() {
      if (discountsBuilder_ == null) {
        discountsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.opencannabis.schema.product.struct.SaleDescriptor, io.opencannabis.schema.product.struct.SaleDescriptor.Builder, io.opencannabis.schema.product.struct.SaleDescriptorOrBuilder>(
                discounts_,
                ((bitField0_ & 0x00000004) == 0x00000004),
                getParentForChildren(),
                isClean());
        discounts_ = null;
      }
      return discountsBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.structs.pricing.UnitPricingDescriptor)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.structs.pricing.UnitPricingDescriptor)
  private static final io.opencannabis.schema.product.struct.UnitPricingDescriptor DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.product.struct.UnitPricingDescriptor();
  }

  public static io.opencannabis.schema.product.struct.UnitPricingDescriptor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UnitPricingDescriptor>
      PARSER = new com.google.protobuf.AbstractParser<UnitPricingDescriptor>() {
    public UnitPricingDescriptor parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new UnitPricingDescriptor(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<UnitPricingDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UnitPricingDescriptor> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.product.struct.UnitPricingDescriptor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

