/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: structs/labtesting/TestResults.proto

package io.opencannabis.schema.product.struct.testing;

/**
 * <pre>
 * Lab testing results for a given product. Includes cannabinoid, terpene, pesticide, moisture, and subjective testing
 * properties. Only cannabinoid testing is considered required.
 * </pre>
 *
 * Protobuf type {@code opencannabis.structs.labtesting.TestResults}
 */
public  final class TestResults extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.structs.labtesting.TestResults)
    TestResultsOrBuilder {
private static final long serialVersionUID = 0L;
  // Use TestResults.newBuilder() to construct.
  private TestResults(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private TestResults() {
    available_ = false;
    media_ = java.util.Collections.emptyList();
    aroma_ = java.util.Collections.emptyList();
    data_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private TestResults(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {

            available_ = input.readBool();
            break;
          }
          case 18: {
            if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
              media_ = new java.util.ArrayList<io.opencannabis.schema.product.struct.testing.TestMedia>();
              mutable_bitField0_ |= 0x00000002;
            }
            media_.add(
                input.readMessage(io.opencannabis.schema.product.struct.testing.TestMedia.parser(), extensionRegistry));
            break;
          }
          case 26: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (lastUpdated_ != null) {
              subBuilder = lastUpdated_.toBuilder();
            }
            lastUpdated_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(lastUpdated_);
              lastUpdated_ = subBuilder.buildPartial();
            }

            break;
          }
          case 34: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (sealed_ != null) {
              subBuilder = sealed_.toBuilder();
            }
            sealed_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(sealed_);
              sealed_ = subBuilder.buildPartial();
            }

            break;
          }
          case 42: {
            io.opencannabis.schema.product.struct.testing.TestCoordinates.Builder subBuilder = null;
            if (coordinates_ != null) {
              subBuilder = coordinates_.toBuilder();
            }
            coordinates_ = input.readMessage(io.opencannabis.schema.product.struct.testing.TestCoordinates.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(coordinates_);
              coordinates_ = subBuilder.buildPartial();
            }

            break;
          }
          case 242: {
            io.opencannabis.schema.product.struct.testing.Cannabinoids.Builder subBuilder = null;
            if (cannabinoids_ != null) {
              subBuilder = cannabinoids_.toBuilder();
            }
            cannabinoids_ = input.readMessage(io.opencannabis.schema.product.struct.testing.Cannabinoids.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(cannabinoids_);
              cannabinoids_ = subBuilder.buildPartial();
            }

            break;
          }
          case 250: {
            io.opencannabis.schema.product.struct.testing.Terpenes.Builder subBuilder = null;
            if (terpenes_ != null) {
              subBuilder = terpenes_.toBuilder();
            }
            terpenes_ = input.readMessage(io.opencannabis.schema.product.struct.testing.Terpenes.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(terpenes_);
              terpenes_ = subBuilder.buildPartial();
            }

            break;
          }
          case 258: {
            io.opencannabis.schema.product.struct.testing.Pesticides.Builder subBuilder = null;
            if (pesticides_ != null) {
              subBuilder = pesticides_.toBuilder();
            }
            pesticides_ = input.readMessage(io.opencannabis.schema.product.struct.testing.Pesticides.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(pesticides_);
              pesticides_ = subBuilder.buildPartial();
            }

            break;
          }
          case 266: {
            io.opencannabis.schema.product.struct.testing.Moisture.Builder subBuilder = null;
            if (moisture_ != null) {
              subBuilder = moisture_.toBuilder();
            }
            moisture_ = input.readMessage(io.opencannabis.schema.product.struct.testing.Moisture.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(moisture_);
              moisture_ = subBuilder.buildPartial();
            }

            break;
          }
          case 274: {
            io.opencannabis.schema.product.struct.testing.Subjective.Builder subBuilder = null;
            if (subjective_ != null) {
              subBuilder = subjective_.toBuilder();
            }
            subjective_ = input.readMessage(io.opencannabis.schema.product.struct.testing.Subjective.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(subjective_);
              subjective_ = subBuilder.buildPartial();
            }

            break;
          }
          case 280: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000400) == 0x00000400)) {
              aroma_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000400;
            }
            aroma_.add(rawValue);
            break;
          }
          case 282: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000400) == 0x00000400)) {
                aroma_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000400;
              }
              aroma_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
          case 290: {
            if (!((mutable_bitField0_ & 0x00000800) == 0x00000800)) {
              data_ = new java.util.ArrayList<io.opencannabis.schema.product.struct.testing.TestResults>();
              mutable_bitField0_ |= 0x00000800;
            }
            data_.add(
                input.readMessage(io.opencannabis.schema.product.struct.testing.TestResults.parser(), extensionRegistry));
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
        media_ = java.util.Collections.unmodifiableList(media_);
      }
      if (((mutable_bitField0_ & 0x00000400) == 0x00000400)) {
        aroma_ = java.util.Collections.unmodifiableList(aroma_);
      }
      if (((mutable_bitField0_ & 0x00000800) == 0x00000800)) {
        data_ = java.util.Collections.unmodifiableList(data_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.product.struct.testing.LabTesting.internal_static_opencannabis_structs_labtesting_TestResults_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.product.struct.testing.LabTesting.internal_static_opencannabis_structs_labtesting_TestResults_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.product.struct.testing.TestResults.class, io.opencannabis.schema.product.struct.testing.TestResults.Builder.class);
  }

  private int bitField0_;
  public static final int AVAILABLE_FIELD_NUMBER = 1;
  private boolean available_;
  /**
   * <pre>
   * Boolean flag indicating whether results are available for lab testing at all.
   * </pre>
   *
   * <code>bool available = 1;</code>
   */
  public boolean getAvailable() {
    return available_;
  }

  public static final int MEDIA_FIELD_NUMBER = 2;
  private java.util.List<io.opencannabis.schema.product.struct.testing.TestMedia> media_;
  /**
   * <pre>
   * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
   * specifying test results, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
   */
  public java.util.List<io.opencannabis.schema.product.struct.testing.TestMedia> getMediaList() {
    return media_;
  }
  /**
   * <pre>
   * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
   * specifying test results, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
   */
  public java.util.List<? extends io.opencannabis.schema.product.struct.testing.TestMediaOrBuilder> 
      getMediaOrBuilderList() {
    return media_;
  }
  /**
   * <pre>
   * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
   * specifying test results, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
   */
  public int getMediaCount() {
    return media_.size();
  }
  /**
   * <pre>
   * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
   * specifying test results, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
   */
  public io.opencannabis.schema.product.struct.testing.TestMedia getMedia(int index) {
    return media_.get(index);
  }
  /**
   * <pre>
   * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
   * specifying test results, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
   */
  public io.opencannabis.schema.product.struct.testing.TestMediaOrBuilder getMediaOrBuilder(
      int index) {
    return media_.get(index);
  }

  public static final int LAST_UPDATED_FIELD_NUMBER = 3;
  private io.opencannabis.schema.temporal.Instant lastUpdated_;
  /**
   * <pre>
   * Last-updated value for these lab test results. Updated each time the record is updated.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
   */
  public boolean hasLastUpdated() {
    return lastUpdated_ != null;
  }
  /**
   * <pre>
   * Last-updated value for these lab test results. Updated each time the record is updated.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
   */
  public io.opencannabis.schema.temporal.Instant getLastUpdated() {
    return lastUpdated_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : lastUpdated_;
  }
  /**
   * <pre>
   * Last-updated value for these lab test results. Updated each time the record is updated.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getLastUpdatedOrBuilder() {
    return getLastUpdated();
  }

  public static final int SEALED_FIELD_NUMBER = 4;
  private io.opencannabis.schema.temporal.Instant sealed_;
  /**
   * <pre>
   * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
   * test results (unique by their coordinates) is considered immutable.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant sealed = 4;</code>
   */
  public boolean hasSealed() {
    return sealed_ != null;
  }
  /**
   * <pre>
   * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
   * test results (unique by their coordinates) is considered immutable.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant sealed = 4;</code>
   */
  public io.opencannabis.schema.temporal.Instant getSealed() {
    return sealed_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : sealed_;
  }
  /**
   * <pre>
   * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
   * test results (unique by their coordinates) is considered immutable.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant sealed = 4;</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getSealedOrBuilder() {
    return getSealed();
  }

  public static final int COORDINATES_FIELD_NUMBER = 5;
  private io.opencannabis.schema.product.struct.testing.TestCoordinates coordinates_;
  /**
   * <pre>
   * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
   * indicates the coordinates for the active set of test results.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
   */
  public boolean hasCoordinates() {
    return coordinates_ != null;
  }
  /**
   * <pre>
   * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
   * indicates the coordinates for the active set of test results.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
   */
  public io.opencannabis.schema.product.struct.testing.TestCoordinates getCoordinates() {
    return coordinates_ == null ? io.opencannabis.schema.product.struct.testing.TestCoordinates.getDefaultInstance() : coordinates_;
  }
  /**
   * <pre>
   * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
   * indicates the coordinates for the active set of test results.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
   */
  public io.opencannabis.schema.product.struct.testing.TestCoordinatesOrBuilder getCoordinatesOrBuilder() {
    return getCoordinates();
  }

  public static final int CANNABINOIDS_FIELD_NUMBER = 30;
  private io.opencannabis.schema.product.struct.testing.Cannabinoids cannabinoids_;
  /**
   * <pre>
   * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
   * compounds.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
   */
  public boolean hasCannabinoids() {
    return cannabinoids_ != null;
  }
  /**
   * <pre>
   * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
   * compounds.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
   */
  public io.opencannabis.schema.product.struct.testing.Cannabinoids getCannabinoids() {
    return cannabinoids_ == null ? io.opencannabis.schema.product.struct.testing.Cannabinoids.getDefaultInstance() : cannabinoids_;
  }
  /**
   * <pre>
   * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
   * compounds.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
   */
  public io.opencannabis.schema.product.struct.testing.CannabinoidsOrBuilder getCannabinoidsOrBuilder() {
    return getCannabinoids();
  }

  public static final int TERPENES_FIELD_NUMBER = 31;
  private io.opencannabis.schema.product.struct.testing.Terpenes terpenes_;
  /**
   * <pre>
   * Testing for terpene volatiles, which might indicate aroma or flavor notes.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
   */
  public boolean hasTerpenes() {
    return terpenes_ != null;
  }
  /**
   * <pre>
   * Testing for terpene volatiles, which might indicate aroma or flavor notes.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
   */
  public io.opencannabis.schema.product.struct.testing.Terpenes getTerpenes() {
    return terpenes_ == null ? io.opencannabis.schema.product.struct.testing.Terpenes.getDefaultInstance() : terpenes_;
  }
  /**
   * <pre>
   * Testing for terpene volatiles, which might indicate aroma or flavor notes.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
   */
  public io.opencannabis.schema.product.struct.testing.TerpenesOrBuilder getTerpenesOrBuilder() {
    return getTerpenes();
  }

  public static final int PESTICIDES_FIELD_NUMBER = 32;
  private io.opencannabis.schema.product.struct.testing.Pesticides pesticides_;
  /**
   * <pre>
   * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
   */
  public boolean hasPesticides() {
    return pesticides_ != null;
  }
  /**
   * <pre>
   * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
   */
  public io.opencannabis.schema.product.struct.testing.Pesticides getPesticides() {
    return pesticides_ == null ? io.opencannabis.schema.product.struct.testing.Pesticides.getDefaultInstance() : pesticides_;
  }
  /**
   * <pre>
   * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
   */
  public io.opencannabis.schema.product.struct.testing.PesticidesOrBuilder getPesticidesOrBuilder() {
    return getPesticides();
  }

  public static final int MOISTURE_FIELD_NUMBER = 33;
  private io.opencannabis.schema.product.struct.testing.Moisture moisture_;
  /**
   * <pre>
   * Moisture rating and test results.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
   */
  public boolean hasMoisture() {
    return moisture_ != null;
  }
  /**
   * <pre>
   * Moisture rating and test results.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
   */
  public io.opencannabis.schema.product.struct.testing.Moisture getMoisture() {
    return moisture_ == null ? io.opencannabis.schema.product.struct.testing.Moisture.getDefaultInstance() : moisture_;
  }
  /**
   * <pre>
   * Moisture rating and test results.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
   */
  public io.opencannabis.schema.product.struct.testing.MoistureOrBuilder getMoistureOrBuilder() {
    return getMoisture();
  }

  public static final int SUBJECTIVE_FIELD_NUMBER = 34;
  private io.opencannabis.schema.product.struct.testing.Subjective subjective_;
  /**
   * <pre>
   * Results from subjective testing - i.e, opinionated human evaluation.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
   */
  public boolean hasSubjective() {
    return subjective_ != null;
  }
  /**
   * <pre>
   * Results from subjective testing - i.e, opinionated human evaluation.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
   */
  public io.opencannabis.schema.product.struct.testing.Subjective getSubjective() {
    return subjective_ == null ? io.opencannabis.schema.product.struct.testing.Subjective.getDefaultInstance() : subjective_;
  }
  /**
   * <pre>
   * Results from subjective testing - i.e, opinionated human evaluation.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
   */
  public io.opencannabis.schema.product.struct.testing.SubjectiveOrBuilder getSubjectiveOrBuilder() {
    return getSubjective();
  }

  public static final int AROMA_FIELD_NUMBER = 35;
  private java.util.List<java.lang.Integer> aroma_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.opencannabis.schema.product.struct.testing.TasteNote> aroma_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.opencannabis.schema.product.struct.testing.TasteNote>() {
            public io.opencannabis.schema.product.struct.testing.TasteNote convert(java.lang.Integer from) {
              io.opencannabis.schema.product.struct.testing.TasteNote result = io.opencannabis.schema.product.struct.testing.TasteNote.valueOf(from);
              return result == null ? io.opencannabis.schema.product.struct.testing.TasteNote.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
   * available.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
   */
  public java.util.List<io.opencannabis.schema.product.struct.testing.TasteNote> getAromaList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.opencannabis.schema.product.struct.testing.TasteNote>(aroma_, aroma_converter_);
  }
  /**
   * <pre>
   * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
   * available.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
   */
  public int getAromaCount() {
    return aroma_.size();
  }
  /**
   * <pre>
   * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
   * available.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
   */
  public io.opencannabis.schema.product.struct.testing.TasteNote getAroma(int index) {
    return aroma_converter_.convert(aroma_.get(index));
  }
  /**
   * <pre>
   * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
   * available.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
   */
  public java.util.List<java.lang.Integer>
  getAromaValueList() {
    return aroma_;
  }
  /**
   * <pre>
   * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
   * available.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
   */
  public int getAromaValue(int index) {
    return aroma_.get(index);
  }
  private int aromaMemoizedSerializedSize;

  public static final int DATA_FIELD_NUMBER = 36;
  private java.util.List<io.opencannabis.schema.product.struct.testing.TestResults> data_;
  /**
   * <pre>
   * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
   */
  public java.util.List<io.opencannabis.schema.product.struct.testing.TestResults> getDataList() {
    return data_;
  }
  /**
   * <pre>
   * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
   */
  public java.util.List<? extends io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder> 
      getDataOrBuilderList() {
    return data_;
  }
  /**
   * <pre>
   * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
   */
  public int getDataCount() {
    return data_.size();
  }
  /**
   * <pre>
   * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
   */
  public io.opencannabis.schema.product.struct.testing.TestResults getData(int index) {
    return data_.get(index);
  }
  /**
   * <pre>
   * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
   */
  public io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder getDataOrBuilder(
      int index) {
    return data_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (available_ != false) {
      output.writeBool(1, available_);
    }
    for (int i = 0; i < media_.size(); i++) {
      output.writeMessage(2, media_.get(i));
    }
    if (lastUpdated_ != null) {
      output.writeMessage(3, getLastUpdated());
    }
    if (sealed_ != null) {
      output.writeMessage(4, getSealed());
    }
    if (coordinates_ != null) {
      output.writeMessage(5, getCoordinates());
    }
    if (cannabinoids_ != null) {
      output.writeMessage(30, getCannabinoids());
    }
    if (terpenes_ != null) {
      output.writeMessage(31, getTerpenes());
    }
    if (pesticides_ != null) {
      output.writeMessage(32, getPesticides());
    }
    if (moisture_ != null) {
      output.writeMessage(33, getMoisture());
    }
    if (subjective_ != null) {
      output.writeMessage(34, getSubjective());
    }
    if (getAromaList().size() > 0) {
      output.writeUInt32NoTag(282);
      output.writeUInt32NoTag(aromaMemoizedSerializedSize);
    }
    for (int i = 0; i < aroma_.size(); i++) {
      output.writeEnumNoTag(aroma_.get(i));
    }
    for (int i = 0; i < data_.size(); i++) {
      output.writeMessage(36, data_.get(i));
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (available_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(1, available_);
    }
    for (int i = 0; i < media_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, media_.get(i));
    }
    if (lastUpdated_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getLastUpdated());
    }
    if (sealed_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getSealed());
    }
    if (coordinates_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getCoordinates());
    }
    if (cannabinoids_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(30, getCannabinoids());
    }
    if (terpenes_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(31, getTerpenes());
    }
    if (pesticides_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(32, getPesticides());
    }
    if (moisture_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(33, getMoisture());
    }
    if (subjective_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(34, getSubjective());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < aroma_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(aroma_.get(i));
      }
      size += dataSize;
      if (!getAromaList().isEmpty()) {  size += 2;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }aromaMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < data_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(36, data_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.product.struct.testing.TestResults)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.product.struct.testing.TestResults other = (io.opencannabis.schema.product.struct.testing.TestResults) obj;

    boolean result = true;
    result = result && (getAvailable()
        == other.getAvailable());
    result = result && getMediaList()
        .equals(other.getMediaList());
    result = result && (hasLastUpdated() == other.hasLastUpdated());
    if (hasLastUpdated()) {
      result = result && getLastUpdated()
          .equals(other.getLastUpdated());
    }
    result = result && (hasSealed() == other.hasSealed());
    if (hasSealed()) {
      result = result && getSealed()
          .equals(other.getSealed());
    }
    result = result && (hasCoordinates() == other.hasCoordinates());
    if (hasCoordinates()) {
      result = result && getCoordinates()
          .equals(other.getCoordinates());
    }
    result = result && (hasCannabinoids() == other.hasCannabinoids());
    if (hasCannabinoids()) {
      result = result && getCannabinoids()
          .equals(other.getCannabinoids());
    }
    result = result && (hasTerpenes() == other.hasTerpenes());
    if (hasTerpenes()) {
      result = result && getTerpenes()
          .equals(other.getTerpenes());
    }
    result = result && (hasPesticides() == other.hasPesticides());
    if (hasPesticides()) {
      result = result && getPesticides()
          .equals(other.getPesticides());
    }
    result = result && (hasMoisture() == other.hasMoisture());
    if (hasMoisture()) {
      result = result && getMoisture()
          .equals(other.getMoisture());
    }
    result = result && (hasSubjective() == other.hasSubjective());
    if (hasSubjective()) {
      result = result && getSubjective()
          .equals(other.getSubjective());
    }
    result = result && aroma_.equals(other.aroma_);
    result = result && getDataList()
        .equals(other.getDataList());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AVAILABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getAvailable());
    if (getMediaCount() > 0) {
      hash = (37 * hash) + MEDIA_FIELD_NUMBER;
      hash = (53 * hash) + getMediaList().hashCode();
    }
    if (hasLastUpdated()) {
      hash = (37 * hash) + LAST_UPDATED_FIELD_NUMBER;
      hash = (53 * hash) + getLastUpdated().hashCode();
    }
    if (hasSealed()) {
      hash = (37 * hash) + SEALED_FIELD_NUMBER;
      hash = (53 * hash) + getSealed().hashCode();
    }
    if (hasCoordinates()) {
      hash = (37 * hash) + COORDINATES_FIELD_NUMBER;
      hash = (53 * hash) + getCoordinates().hashCode();
    }
    if (hasCannabinoids()) {
      hash = (37 * hash) + CANNABINOIDS_FIELD_NUMBER;
      hash = (53 * hash) + getCannabinoids().hashCode();
    }
    if (hasTerpenes()) {
      hash = (37 * hash) + TERPENES_FIELD_NUMBER;
      hash = (53 * hash) + getTerpenes().hashCode();
    }
    if (hasPesticides()) {
      hash = (37 * hash) + PESTICIDES_FIELD_NUMBER;
      hash = (53 * hash) + getPesticides().hashCode();
    }
    if (hasMoisture()) {
      hash = (37 * hash) + MOISTURE_FIELD_NUMBER;
      hash = (53 * hash) + getMoisture().hashCode();
    }
    if (hasSubjective()) {
      hash = (37 * hash) + SUBJECTIVE_FIELD_NUMBER;
      hash = (53 * hash) + getSubjective().hashCode();
    }
    if (getAromaCount() > 0) {
      hash = (37 * hash) + AROMA_FIELD_NUMBER;
      hash = (53 * hash) + aroma_.hashCode();
    }
    if (getDataCount() > 0) {
      hash = (37 * hash) + DATA_FIELD_NUMBER;
      hash = (53 * hash) + getDataList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.product.struct.testing.TestResults parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.product.struct.testing.TestResults parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.testing.TestResults parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.product.struct.testing.TestResults parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.testing.TestResults parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.product.struct.testing.TestResults parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.testing.TestResults parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.product.struct.testing.TestResults parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.testing.TestResults parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.product.struct.testing.TestResults parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.product.struct.testing.TestResults parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.product.struct.testing.TestResults parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.product.struct.testing.TestResults prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Lab testing results for a given product. Includes cannabinoid, terpene, pesticide, moisture, and subjective testing
   * properties. Only cannabinoid testing is considered required.
   * </pre>
   *
   * Protobuf type {@code opencannabis.structs.labtesting.TestResults}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.structs.labtesting.TestResults)
      io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.product.struct.testing.LabTesting.internal_static_opencannabis_structs_labtesting_TestResults_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.product.struct.testing.LabTesting.internal_static_opencannabis_structs_labtesting_TestResults_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.product.struct.testing.TestResults.class, io.opencannabis.schema.product.struct.testing.TestResults.Builder.class);
    }

    // Construct using io.opencannabis.schema.product.struct.testing.TestResults.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getMediaFieldBuilder();
        getDataFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      available_ = false;

      if (mediaBuilder_ == null) {
        media_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        mediaBuilder_.clear();
      }
      if (lastUpdatedBuilder_ == null) {
        lastUpdated_ = null;
      } else {
        lastUpdated_ = null;
        lastUpdatedBuilder_ = null;
      }
      if (sealedBuilder_ == null) {
        sealed_ = null;
      } else {
        sealed_ = null;
        sealedBuilder_ = null;
      }
      if (coordinatesBuilder_ == null) {
        coordinates_ = null;
      } else {
        coordinates_ = null;
        coordinatesBuilder_ = null;
      }
      if (cannabinoidsBuilder_ == null) {
        cannabinoids_ = null;
      } else {
        cannabinoids_ = null;
        cannabinoidsBuilder_ = null;
      }
      if (terpenesBuilder_ == null) {
        terpenes_ = null;
      } else {
        terpenes_ = null;
        terpenesBuilder_ = null;
      }
      if (pesticidesBuilder_ == null) {
        pesticides_ = null;
      } else {
        pesticides_ = null;
        pesticidesBuilder_ = null;
      }
      if (moistureBuilder_ == null) {
        moisture_ = null;
      } else {
        moisture_ = null;
        moistureBuilder_ = null;
      }
      if (subjectiveBuilder_ == null) {
        subjective_ = null;
      } else {
        subjective_ = null;
        subjectiveBuilder_ = null;
      }
      aroma_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      if (dataBuilder_ == null) {
        data_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
      } else {
        dataBuilder_.clear();
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.product.struct.testing.LabTesting.internal_static_opencannabis_structs_labtesting_TestResults_descriptor;
    }

    public io.opencannabis.schema.product.struct.testing.TestResults getDefaultInstanceForType() {
      return io.opencannabis.schema.product.struct.testing.TestResults.getDefaultInstance();
    }

    public io.opencannabis.schema.product.struct.testing.TestResults build() {
      io.opencannabis.schema.product.struct.testing.TestResults result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.product.struct.testing.TestResults buildPartial() {
      io.opencannabis.schema.product.struct.testing.TestResults result = new io.opencannabis.schema.product.struct.testing.TestResults(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.available_ = available_;
      if (mediaBuilder_ == null) {
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          media_ = java.util.Collections.unmodifiableList(media_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.media_ = media_;
      } else {
        result.media_ = mediaBuilder_.build();
      }
      if (lastUpdatedBuilder_ == null) {
        result.lastUpdated_ = lastUpdated_;
      } else {
        result.lastUpdated_ = lastUpdatedBuilder_.build();
      }
      if (sealedBuilder_ == null) {
        result.sealed_ = sealed_;
      } else {
        result.sealed_ = sealedBuilder_.build();
      }
      if (coordinatesBuilder_ == null) {
        result.coordinates_ = coordinates_;
      } else {
        result.coordinates_ = coordinatesBuilder_.build();
      }
      if (cannabinoidsBuilder_ == null) {
        result.cannabinoids_ = cannabinoids_;
      } else {
        result.cannabinoids_ = cannabinoidsBuilder_.build();
      }
      if (terpenesBuilder_ == null) {
        result.terpenes_ = terpenes_;
      } else {
        result.terpenes_ = terpenesBuilder_.build();
      }
      if (pesticidesBuilder_ == null) {
        result.pesticides_ = pesticides_;
      } else {
        result.pesticides_ = pesticidesBuilder_.build();
      }
      if (moistureBuilder_ == null) {
        result.moisture_ = moisture_;
      } else {
        result.moisture_ = moistureBuilder_.build();
      }
      if (subjectiveBuilder_ == null) {
        result.subjective_ = subjective_;
      } else {
        result.subjective_ = subjectiveBuilder_.build();
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        aroma_ = java.util.Collections.unmodifiableList(aroma_);
        bitField0_ = (bitField0_ & ~0x00000400);
      }
      result.aroma_ = aroma_;
      if (dataBuilder_ == null) {
        if (((bitField0_ & 0x00000800) == 0x00000800)) {
          data_ = java.util.Collections.unmodifiableList(data_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.data_ = data_;
      } else {
        result.data_ = dataBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.product.struct.testing.TestResults) {
        return mergeFrom((io.opencannabis.schema.product.struct.testing.TestResults)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.product.struct.testing.TestResults other) {
      if (other == io.opencannabis.schema.product.struct.testing.TestResults.getDefaultInstance()) return this;
      if (other.getAvailable() != false) {
        setAvailable(other.getAvailable());
      }
      if (mediaBuilder_ == null) {
        if (!other.media_.isEmpty()) {
          if (media_.isEmpty()) {
            media_ = other.media_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMediaIsMutable();
            media_.addAll(other.media_);
          }
          onChanged();
        }
      } else {
        if (!other.media_.isEmpty()) {
          if (mediaBuilder_.isEmpty()) {
            mediaBuilder_.dispose();
            mediaBuilder_ = null;
            media_ = other.media_;
            bitField0_ = (bitField0_ & ~0x00000002);
            mediaBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getMediaFieldBuilder() : null;
          } else {
            mediaBuilder_.addAllMessages(other.media_);
          }
        }
      }
      if (other.hasLastUpdated()) {
        mergeLastUpdated(other.getLastUpdated());
      }
      if (other.hasSealed()) {
        mergeSealed(other.getSealed());
      }
      if (other.hasCoordinates()) {
        mergeCoordinates(other.getCoordinates());
      }
      if (other.hasCannabinoids()) {
        mergeCannabinoids(other.getCannabinoids());
      }
      if (other.hasTerpenes()) {
        mergeTerpenes(other.getTerpenes());
      }
      if (other.hasPesticides()) {
        mergePesticides(other.getPesticides());
      }
      if (other.hasMoisture()) {
        mergeMoisture(other.getMoisture());
      }
      if (other.hasSubjective()) {
        mergeSubjective(other.getSubjective());
      }
      if (!other.aroma_.isEmpty()) {
        if (aroma_.isEmpty()) {
          aroma_ = other.aroma_;
          bitField0_ = (bitField0_ & ~0x00000400);
        } else {
          ensureAromaIsMutable();
          aroma_.addAll(other.aroma_);
        }
        onChanged();
      }
      if (dataBuilder_ == null) {
        if (!other.data_.isEmpty()) {
          if (data_.isEmpty()) {
            data_ = other.data_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureDataIsMutable();
            data_.addAll(other.data_);
          }
          onChanged();
        }
      } else {
        if (!other.data_.isEmpty()) {
          if (dataBuilder_.isEmpty()) {
            dataBuilder_.dispose();
            dataBuilder_ = null;
            data_ = other.data_;
            bitField0_ = (bitField0_ & ~0x00000800);
            dataBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getDataFieldBuilder() : null;
          } else {
            dataBuilder_.addAllMessages(other.data_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.product.struct.testing.TestResults parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.product.struct.testing.TestResults) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private boolean available_ ;
    /**
     * <pre>
     * Boolean flag indicating whether results are available for lab testing at all.
     * </pre>
     *
     * <code>bool available = 1;</code>
     */
    public boolean getAvailable() {
      return available_;
    }
    /**
     * <pre>
     * Boolean flag indicating whether results are available for lab testing at all.
     * </pre>
     *
     * <code>bool available = 1;</code>
     */
    public Builder setAvailable(boolean value) {
      
      available_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Boolean flag indicating whether results are available for lab testing at all.
     * </pre>
     *
     * <code>bool available = 1;</code>
     */
    public Builder clearAvailable() {
      
      available_ = false;
      onChanged();
      return this;
    }

    private java.util.List<io.opencannabis.schema.product.struct.testing.TestMedia> media_ =
      java.util.Collections.emptyList();
    private void ensureMediaIsMutable() {
      if (!((bitField0_ & 0x00000002) == 0x00000002)) {
        media_ = new java.util.ArrayList<io.opencannabis.schema.product.struct.testing.TestMedia>(media_);
        bitField0_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.TestMedia, io.opencannabis.schema.product.struct.testing.TestMedia.Builder, io.opencannabis.schema.product.struct.testing.TestMediaOrBuilder> mediaBuilder_;

    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public java.util.List<io.opencannabis.schema.product.struct.testing.TestMedia> getMediaList() {
      if (mediaBuilder_ == null) {
        return java.util.Collections.unmodifiableList(media_);
      } else {
        return mediaBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public int getMediaCount() {
      if (mediaBuilder_ == null) {
        return media_.size();
      } else {
        return mediaBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestMedia getMedia(int index) {
      if (mediaBuilder_ == null) {
        return media_.get(index);
      } else {
        return mediaBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public Builder setMedia(
        int index, io.opencannabis.schema.product.struct.testing.TestMedia value) {
      if (mediaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMediaIsMutable();
        media_.set(index, value);
        onChanged();
      } else {
        mediaBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public Builder setMedia(
        int index, io.opencannabis.schema.product.struct.testing.TestMedia.Builder builderForValue) {
      if (mediaBuilder_ == null) {
        ensureMediaIsMutable();
        media_.set(index, builderForValue.build());
        onChanged();
      } else {
        mediaBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public Builder addMedia(io.opencannabis.schema.product.struct.testing.TestMedia value) {
      if (mediaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMediaIsMutable();
        media_.add(value);
        onChanged();
      } else {
        mediaBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public Builder addMedia(
        int index, io.opencannabis.schema.product.struct.testing.TestMedia value) {
      if (mediaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMediaIsMutable();
        media_.add(index, value);
        onChanged();
      } else {
        mediaBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public Builder addMedia(
        io.opencannabis.schema.product.struct.testing.TestMedia.Builder builderForValue) {
      if (mediaBuilder_ == null) {
        ensureMediaIsMutable();
        media_.add(builderForValue.build());
        onChanged();
      } else {
        mediaBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public Builder addMedia(
        int index, io.opencannabis.schema.product.struct.testing.TestMedia.Builder builderForValue) {
      if (mediaBuilder_ == null) {
        ensureMediaIsMutable();
        media_.add(index, builderForValue.build());
        onChanged();
      } else {
        mediaBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public Builder addAllMedia(
        java.lang.Iterable<? extends io.opencannabis.schema.product.struct.testing.TestMedia> values) {
      if (mediaBuilder_ == null) {
        ensureMediaIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, media_);
        onChanged();
      } else {
        mediaBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public Builder clearMedia() {
      if (mediaBuilder_ == null) {
        media_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        mediaBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public Builder removeMedia(int index) {
      if (mediaBuilder_ == null) {
        ensureMediaIsMutable();
        media_.remove(index);
        onChanged();
      } else {
        mediaBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestMedia.Builder getMediaBuilder(
        int index) {
      return getMediaFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestMediaOrBuilder getMediaOrBuilder(
        int index) {
      if (mediaBuilder_ == null) {
        return media_.get(index);  } else {
        return mediaBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.product.struct.testing.TestMediaOrBuilder> 
         getMediaOrBuilderList() {
      if (mediaBuilder_ != null) {
        return mediaBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(media_);
      }
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestMedia.Builder addMediaBuilder() {
      return getMediaFieldBuilder().addBuilder(
          io.opencannabis.schema.product.struct.testing.TestMedia.getDefaultInstance());
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestMedia.Builder addMediaBuilder(
        int index) {
      return getMediaFieldBuilder().addBuilder(
          index, io.opencannabis.schema.product.struct.testing.TestMedia.getDefaultInstance());
    }
    /**
     * <pre>
     * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
     * specifying test results, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
     */
    public java.util.List<io.opencannabis.schema.product.struct.testing.TestMedia.Builder> 
         getMediaBuilderList() {
      return getMediaFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.TestMedia, io.opencannabis.schema.product.struct.testing.TestMedia.Builder, io.opencannabis.schema.product.struct.testing.TestMediaOrBuilder> 
        getMediaFieldBuilder() {
      if (mediaBuilder_ == null) {
        mediaBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.opencannabis.schema.product.struct.testing.TestMedia, io.opencannabis.schema.product.struct.testing.TestMedia.Builder, io.opencannabis.schema.product.struct.testing.TestMediaOrBuilder>(
                media_,
                ((bitField0_ & 0x00000002) == 0x00000002),
                getParentForChildren(),
                isClean());
        media_ = null;
      }
      return mediaBuilder_;
    }

    private io.opencannabis.schema.temporal.Instant lastUpdated_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> lastUpdatedBuilder_;
    /**
     * <pre>
     * Last-updated value for these lab test results. Updated each time the record is updated.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
     */
    public boolean hasLastUpdated() {
      return lastUpdatedBuilder_ != null || lastUpdated_ != null;
    }
    /**
     * <pre>
     * Last-updated value for these lab test results. Updated each time the record is updated.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
     */
    public io.opencannabis.schema.temporal.Instant getLastUpdated() {
      if (lastUpdatedBuilder_ == null) {
        return lastUpdated_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : lastUpdated_;
      } else {
        return lastUpdatedBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Last-updated value for these lab test results. Updated each time the record is updated.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
     */
    public Builder setLastUpdated(io.opencannabis.schema.temporal.Instant value) {
      if (lastUpdatedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastUpdated_ = value;
        onChanged();
      } else {
        lastUpdatedBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Last-updated value for these lab test results. Updated each time the record is updated.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
     */
    public Builder setLastUpdated(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (lastUpdatedBuilder_ == null) {
        lastUpdated_ = builderForValue.build();
        onChanged();
      } else {
        lastUpdatedBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Last-updated value for these lab test results. Updated each time the record is updated.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
     */
    public Builder mergeLastUpdated(io.opencannabis.schema.temporal.Instant value) {
      if (lastUpdatedBuilder_ == null) {
        if (lastUpdated_ != null) {
          lastUpdated_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(lastUpdated_).mergeFrom(value).buildPartial();
        } else {
          lastUpdated_ = value;
        }
        onChanged();
      } else {
        lastUpdatedBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Last-updated value for these lab test results. Updated each time the record is updated.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
     */
    public Builder clearLastUpdated() {
      if (lastUpdatedBuilder_ == null) {
        lastUpdated_ = null;
        onChanged();
      } else {
        lastUpdated_ = null;
        lastUpdatedBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Last-updated value for these lab test results. Updated each time the record is updated.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getLastUpdatedBuilder() {
      
      onChanged();
      return getLastUpdatedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Last-updated value for these lab test results. Updated each time the record is updated.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getLastUpdatedOrBuilder() {
      if (lastUpdatedBuilder_ != null) {
        return lastUpdatedBuilder_.getMessageOrBuilder();
      } else {
        return lastUpdated_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : lastUpdated_;
      }
    }
    /**
     * <pre>
     * Last-updated value for these lab test results. Updated each time the record is updated.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getLastUpdatedFieldBuilder() {
      if (lastUpdatedBuilder_ == null) {
        lastUpdatedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getLastUpdated(),
                getParentForChildren(),
                isClean());
        lastUpdated_ = null;
      }
      return lastUpdatedBuilder_;
    }

    private io.opencannabis.schema.temporal.Instant sealed_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> sealedBuilder_;
    /**
     * <pre>
     * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
     * test results (unique by their coordinates) is considered immutable.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant sealed = 4;</code>
     */
    public boolean hasSealed() {
      return sealedBuilder_ != null || sealed_ != null;
    }
    /**
     * <pre>
     * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
     * test results (unique by their coordinates) is considered immutable.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant sealed = 4;</code>
     */
    public io.opencannabis.schema.temporal.Instant getSealed() {
      if (sealedBuilder_ == null) {
        return sealed_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : sealed_;
      } else {
        return sealedBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
     * test results (unique by their coordinates) is considered immutable.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant sealed = 4;</code>
     */
    public Builder setSealed(io.opencannabis.schema.temporal.Instant value) {
      if (sealedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sealed_ = value;
        onChanged();
      } else {
        sealedBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
     * test results (unique by their coordinates) is considered immutable.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant sealed = 4;</code>
     */
    public Builder setSealed(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (sealedBuilder_ == null) {
        sealed_ = builderForValue.build();
        onChanged();
      } else {
        sealedBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
     * test results (unique by their coordinates) is considered immutable.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant sealed = 4;</code>
     */
    public Builder mergeSealed(io.opencannabis.schema.temporal.Instant value) {
      if (sealedBuilder_ == null) {
        if (sealed_ != null) {
          sealed_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(sealed_).mergeFrom(value).buildPartial();
        } else {
          sealed_ = value;
        }
        onChanged();
      } else {
        sealedBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
     * test results (unique by their coordinates) is considered immutable.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant sealed = 4;</code>
     */
    public Builder clearSealed() {
      if (sealedBuilder_ == null) {
        sealed_ = null;
        onChanged();
      } else {
        sealed_ = null;
        sealedBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
     * test results (unique by their coordinates) is considered immutable.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant sealed = 4;</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getSealedBuilder() {
      
      onChanged();
      return getSealedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
     * test results (unique by their coordinates) is considered immutable.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant sealed = 4;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getSealedOrBuilder() {
      if (sealedBuilder_ != null) {
        return sealedBuilder_.getMessageOrBuilder();
      } else {
        return sealed_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : sealed_;
      }
    }
    /**
     * <pre>
     * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
     * test results (unique by their coordinates) is considered immutable.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant sealed = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getSealedFieldBuilder() {
      if (sealedBuilder_ == null) {
        sealedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getSealed(),
                getParentForChildren(),
                isClean());
        sealed_ = null;
      }
      return sealedBuilder_;
    }

    private io.opencannabis.schema.product.struct.testing.TestCoordinates coordinates_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.TestCoordinates, io.opencannabis.schema.product.struct.testing.TestCoordinates.Builder, io.opencannabis.schema.product.struct.testing.TestCoordinatesOrBuilder> coordinatesBuilder_;
    /**
     * <pre>
     * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
     * indicates the coordinates for the active set of test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
     */
    public boolean hasCoordinates() {
      return coordinatesBuilder_ != null || coordinates_ != null;
    }
    /**
     * <pre>
     * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
     * indicates the coordinates for the active set of test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestCoordinates getCoordinates() {
      if (coordinatesBuilder_ == null) {
        return coordinates_ == null ? io.opencannabis.schema.product.struct.testing.TestCoordinates.getDefaultInstance() : coordinates_;
      } else {
        return coordinatesBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
     * indicates the coordinates for the active set of test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
     */
    public Builder setCoordinates(io.opencannabis.schema.product.struct.testing.TestCoordinates value) {
      if (coordinatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        coordinates_ = value;
        onChanged();
      } else {
        coordinatesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
     * indicates the coordinates for the active set of test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
     */
    public Builder setCoordinates(
        io.opencannabis.schema.product.struct.testing.TestCoordinates.Builder builderForValue) {
      if (coordinatesBuilder_ == null) {
        coordinates_ = builderForValue.build();
        onChanged();
      } else {
        coordinatesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
     * indicates the coordinates for the active set of test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
     */
    public Builder mergeCoordinates(io.opencannabis.schema.product.struct.testing.TestCoordinates value) {
      if (coordinatesBuilder_ == null) {
        if (coordinates_ != null) {
          coordinates_ =
            io.opencannabis.schema.product.struct.testing.TestCoordinates.newBuilder(coordinates_).mergeFrom(value).buildPartial();
        } else {
          coordinates_ = value;
        }
        onChanged();
      } else {
        coordinatesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
     * indicates the coordinates for the active set of test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
     */
    public Builder clearCoordinates() {
      if (coordinatesBuilder_ == null) {
        coordinates_ = null;
        onChanged();
      } else {
        coordinates_ = null;
        coordinatesBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
     * indicates the coordinates for the active set of test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestCoordinates.Builder getCoordinatesBuilder() {
      
      onChanged();
      return getCoordinatesFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
     * indicates the coordinates for the active set of test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestCoordinatesOrBuilder getCoordinatesOrBuilder() {
      if (coordinatesBuilder_ != null) {
        return coordinatesBuilder_.getMessageOrBuilder();
      } else {
        return coordinates_ == null ?
            io.opencannabis.schema.product.struct.testing.TestCoordinates.getDefaultInstance() : coordinates_;
      }
    }
    /**
     * <pre>
     * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
     * indicates the coordinates for the active set of test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.TestCoordinates, io.opencannabis.schema.product.struct.testing.TestCoordinates.Builder, io.opencannabis.schema.product.struct.testing.TestCoordinatesOrBuilder> 
        getCoordinatesFieldBuilder() {
      if (coordinatesBuilder_ == null) {
        coordinatesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.product.struct.testing.TestCoordinates, io.opencannabis.schema.product.struct.testing.TestCoordinates.Builder, io.opencannabis.schema.product.struct.testing.TestCoordinatesOrBuilder>(
                getCoordinates(),
                getParentForChildren(),
                isClean());
        coordinates_ = null;
      }
      return coordinatesBuilder_;
    }

    private io.opencannabis.schema.product.struct.testing.Cannabinoids cannabinoids_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.Cannabinoids, io.opencannabis.schema.product.struct.testing.Cannabinoids.Builder, io.opencannabis.schema.product.struct.testing.CannabinoidsOrBuilder> cannabinoidsBuilder_;
    /**
     * <pre>
     * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
     * compounds.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
     */
    public boolean hasCannabinoids() {
      return cannabinoidsBuilder_ != null || cannabinoids_ != null;
    }
    /**
     * <pre>
     * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
     * compounds.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
     */
    public io.opencannabis.schema.product.struct.testing.Cannabinoids getCannabinoids() {
      if (cannabinoidsBuilder_ == null) {
        return cannabinoids_ == null ? io.opencannabis.schema.product.struct.testing.Cannabinoids.getDefaultInstance() : cannabinoids_;
      } else {
        return cannabinoidsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
     * compounds.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
     */
    public Builder setCannabinoids(io.opencannabis.schema.product.struct.testing.Cannabinoids value) {
      if (cannabinoidsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cannabinoids_ = value;
        onChanged();
      } else {
        cannabinoidsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
     * compounds.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
     */
    public Builder setCannabinoids(
        io.opencannabis.schema.product.struct.testing.Cannabinoids.Builder builderForValue) {
      if (cannabinoidsBuilder_ == null) {
        cannabinoids_ = builderForValue.build();
        onChanged();
      } else {
        cannabinoidsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
     * compounds.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
     */
    public Builder mergeCannabinoids(io.opencannabis.schema.product.struct.testing.Cannabinoids value) {
      if (cannabinoidsBuilder_ == null) {
        if (cannabinoids_ != null) {
          cannabinoids_ =
            io.opencannabis.schema.product.struct.testing.Cannabinoids.newBuilder(cannabinoids_).mergeFrom(value).buildPartial();
        } else {
          cannabinoids_ = value;
        }
        onChanged();
      } else {
        cannabinoidsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
     * compounds.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
     */
    public Builder clearCannabinoids() {
      if (cannabinoidsBuilder_ == null) {
        cannabinoids_ = null;
        onChanged();
      } else {
        cannabinoids_ = null;
        cannabinoidsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
     * compounds.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
     */
    public io.opencannabis.schema.product.struct.testing.Cannabinoids.Builder getCannabinoidsBuilder() {
      
      onChanged();
      return getCannabinoidsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
     * compounds.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
     */
    public io.opencannabis.schema.product.struct.testing.CannabinoidsOrBuilder getCannabinoidsOrBuilder() {
      if (cannabinoidsBuilder_ != null) {
        return cannabinoidsBuilder_.getMessageOrBuilder();
      } else {
        return cannabinoids_ == null ?
            io.opencannabis.schema.product.struct.testing.Cannabinoids.getDefaultInstance() : cannabinoids_;
      }
    }
    /**
     * <pre>
     * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
     * compounds.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.Cannabinoids, io.opencannabis.schema.product.struct.testing.Cannabinoids.Builder, io.opencannabis.schema.product.struct.testing.CannabinoidsOrBuilder> 
        getCannabinoidsFieldBuilder() {
      if (cannabinoidsBuilder_ == null) {
        cannabinoidsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.product.struct.testing.Cannabinoids, io.opencannabis.schema.product.struct.testing.Cannabinoids.Builder, io.opencannabis.schema.product.struct.testing.CannabinoidsOrBuilder>(
                getCannabinoids(),
                getParentForChildren(),
                isClean());
        cannabinoids_ = null;
      }
      return cannabinoidsBuilder_;
    }

    private io.opencannabis.schema.product.struct.testing.Terpenes terpenes_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.Terpenes, io.opencannabis.schema.product.struct.testing.Terpenes.Builder, io.opencannabis.schema.product.struct.testing.TerpenesOrBuilder> terpenesBuilder_;
    /**
     * <pre>
     * Testing for terpene volatiles, which might indicate aroma or flavor notes.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
     */
    public boolean hasTerpenes() {
      return terpenesBuilder_ != null || terpenes_ != null;
    }
    /**
     * <pre>
     * Testing for terpene volatiles, which might indicate aroma or flavor notes.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
     */
    public io.opencannabis.schema.product.struct.testing.Terpenes getTerpenes() {
      if (terpenesBuilder_ == null) {
        return terpenes_ == null ? io.opencannabis.schema.product.struct.testing.Terpenes.getDefaultInstance() : terpenes_;
      } else {
        return terpenesBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Testing for terpene volatiles, which might indicate aroma or flavor notes.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
     */
    public Builder setTerpenes(io.opencannabis.schema.product.struct.testing.Terpenes value) {
      if (terpenesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        terpenes_ = value;
        onChanged();
      } else {
        terpenesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Testing for terpene volatiles, which might indicate aroma or flavor notes.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
     */
    public Builder setTerpenes(
        io.opencannabis.schema.product.struct.testing.Terpenes.Builder builderForValue) {
      if (terpenesBuilder_ == null) {
        terpenes_ = builderForValue.build();
        onChanged();
      } else {
        terpenesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Testing for terpene volatiles, which might indicate aroma or flavor notes.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
     */
    public Builder mergeTerpenes(io.opencannabis.schema.product.struct.testing.Terpenes value) {
      if (terpenesBuilder_ == null) {
        if (terpenes_ != null) {
          terpenes_ =
            io.opencannabis.schema.product.struct.testing.Terpenes.newBuilder(terpenes_).mergeFrom(value).buildPartial();
        } else {
          terpenes_ = value;
        }
        onChanged();
      } else {
        terpenesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Testing for terpene volatiles, which might indicate aroma or flavor notes.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
     */
    public Builder clearTerpenes() {
      if (terpenesBuilder_ == null) {
        terpenes_ = null;
        onChanged();
      } else {
        terpenes_ = null;
        terpenesBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Testing for terpene volatiles, which might indicate aroma or flavor notes.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
     */
    public io.opencannabis.schema.product.struct.testing.Terpenes.Builder getTerpenesBuilder() {
      
      onChanged();
      return getTerpenesFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Testing for terpene volatiles, which might indicate aroma or flavor notes.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TerpenesOrBuilder getTerpenesOrBuilder() {
      if (terpenesBuilder_ != null) {
        return terpenesBuilder_.getMessageOrBuilder();
      } else {
        return terpenes_ == null ?
            io.opencannabis.schema.product.struct.testing.Terpenes.getDefaultInstance() : terpenes_;
      }
    }
    /**
     * <pre>
     * Testing for terpene volatiles, which might indicate aroma or flavor notes.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.Terpenes, io.opencannabis.schema.product.struct.testing.Terpenes.Builder, io.opencannabis.schema.product.struct.testing.TerpenesOrBuilder> 
        getTerpenesFieldBuilder() {
      if (terpenesBuilder_ == null) {
        terpenesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.product.struct.testing.Terpenes, io.opencannabis.schema.product.struct.testing.Terpenes.Builder, io.opencannabis.schema.product.struct.testing.TerpenesOrBuilder>(
                getTerpenes(),
                getParentForChildren(),
                isClean());
        terpenes_ = null;
      }
      return terpenesBuilder_;
    }

    private io.opencannabis.schema.product.struct.testing.Pesticides pesticides_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.Pesticides, io.opencannabis.schema.product.struct.testing.Pesticides.Builder, io.opencannabis.schema.product.struct.testing.PesticidesOrBuilder> pesticidesBuilder_;
    /**
     * <pre>
     * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
     */
    public boolean hasPesticides() {
      return pesticidesBuilder_ != null || pesticides_ != null;
    }
    /**
     * <pre>
     * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
     */
    public io.opencannabis.schema.product.struct.testing.Pesticides getPesticides() {
      if (pesticidesBuilder_ == null) {
        return pesticides_ == null ? io.opencannabis.schema.product.struct.testing.Pesticides.getDefaultInstance() : pesticides_;
      } else {
        return pesticidesBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
     */
    public Builder setPesticides(io.opencannabis.schema.product.struct.testing.Pesticides value) {
      if (pesticidesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pesticides_ = value;
        onChanged();
      } else {
        pesticidesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
     */
    public Builder setPesticides(
        io.opencannabis.schema.product.struct.testing.Pesticides.Builder builderForValue) {
      if (pesticidesBuilder_ == null) {
        pesticides_ = builderForValue.build();
        onChanged();
      } else {
        pesticidesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
     */
    public Builder mergePesticides(io.opencannabis.schema.product.struct.testing.Pesticides value) {
      if (pesticidesBuilder_ == null) {
        if (pesticides_ != null) {
          pesticides_ =
            io.opencannabis.schema.product.struct.testing.Pesticides.newBuilder(pesticides_).mergeFrom(value).buildPartial();
        } else {
          pesticides_ = value;
        }
        onChanged();
      } else {
        pesticidesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
     */
    public Builder clearPesticides() {
      if (pesticidesBuilder_ == null) {
        pesticides_ = null;
        onChanged();
      } else {
        pesticides_ = null;
        pesticidesBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
     */
    public io.opencannabis.schema.product.struct.testing.Pesticides.Builder getPesticidesBuilder() {
      
      onChanged();
      return getPesticidesFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
     */
    public io.opencannabis.schema.product.struct.testing.PesticidesOrBuilder getPesticidesOrBuilder() {
      if (pesticidesBuilder_ != null) {
        return pesticidesBuilder_.getMessageOrBuilder();
      } else {
        return pesticides_ == null ?
            io.opencannabis.schema.product.struct.testing.Pesticides.getDefaultInstance() : pesticides_;
      }
    }
    /**
     * <pre>
     * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.Pesticides, io.opencannabis.schema.product.struct.testing.Pesticides.Builder, io.opencannabis.schema.product.struct.testing.PesticidesOrBuilder> 
        getPesticidesFieldBuilder() {
      if (pesticidesBuilder_ == null) {
        pesticidesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.product.struct.testing.Pesticides, io.opencannabis.schema.product.struct.testing.Pesticides.Builder, io.opencannabis.schema.product.struct.testing.PesticidesOrBuilder>(
                getPesticides(),
                getParentForChildren(),
                isClean());
        pesticides_ = null;
      }
      return pesticidesBuilder_;
    }

    private io.opencannabis.schema.product.struct.testing.Moisture moisture_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.Moisture, io.opencannabis.schema.product.struct.testing.Moisture.Builder, io.opencannabis.schema.product.struct.testing.MoistureOrBuilder> moistureBuilder_;
    /**
     * <pre>
     * Moisture rating and test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
     */
    public boolean hasMoisture() {
      return moistureBuilder_ != null || moisture_ != null;
    }
    /**
     * <pre>
     * Moisture rating and test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
     */
    public io.opencannabis.schema.product.struct.testing.Moisture getMoisture() {
      if (moistureBuilder_ == null) {
        return moisture_ == null ? io.opencannabis.schema.product.struct.testing.Moisture.getDefaultInstance() : moisture_;
      } else {
        return moistureBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Moisture rating and test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
     */
    public Builder setMoisture(io.opencannabis.schema.product.struct.testing.Moisture value) {
      if (moistureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        moisture_ = value;
        onChanged();
      } else {
        moistureBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Moisture rating and test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
     */
    public Builder setMoisture(
        io.opencannabis.schema.product.struct.testing.Moisture.Builder builderForValue) {
      if (moistureBuilder_ == null) {
        moisture_ = builderForValue.build();
        onChanged();
      } else {
        moistureBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Moisture rating and test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
     */
    public Builder mergeMoisture(io.opencannabis.schema.product.struct.testing.Moisture value) {
      if (moistureBuilder_ == null) {
        if (moisture_ != null) {
          moisture_ =
            io.opencannabis.schema.product.struct.testing.Moisture.newBuilder(moisture_).mergeFrom(value).buildPartial();
        } else {
          moisture_ = value;
        }
        onChanged();
      } else {
        moistureBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Moisture rating and test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
     */
    public Builder clearMoisture() {
      if (moistureBuilder_ == null) {
        moisture_ = null;
        onChanged();
      } else {
        moisture_ = null;
        moistureBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Moisture rating and test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
     */
    public io.opencannabis.schema.product.struct.testing.Moisture.Builder getMoistureBuilder() {
      
      onChanged();
      return getMoistureFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Moisture rating and test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
     */
    public io.opencannabis.schema.product.struct.testing.MoistureOrBuilder getMoistureOrBuilder() {
      if (moistureBuilder_ != null) {
        return moistureBuilder_.getMessageOrBuilder();
      } else {
        return moisture_ == null ?
            io.opencannabis.schema.product.struct.testing.Moisture.getDefaultInstance() : moisture_;
      }
    }
    /**
     * <pre>
     * Moisture rating and test results.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.Moisture, io.opencannabis.schema.product.struct.testing.Moisture.Builder, io.opencannabis.schema.product.struct.testing.MoistureOrBuilder> 
        getMoistureFieldBuilder() {
      if (moistureBuilder_ == null) {
        moistureBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.product.struct.testing.Moisture, io.opencannabis.schema.product.struct.testing.Moisture.Builder, io.opencannabis.schema.product.struct.testing.MoistureOrBuilder>(
                getMoisture(),
                getParentForChildren(),
                isClean());
        moisture_ = null;
      }
      return moistureBuilder_;
    }

    private io.opencannabis.schema.product.struct.testing.Subjective subjective_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.Subjective, io.opencannabis.schema.product.struct.testing.Subjective.Builder, io.opencannabis.schema.product.struct.testing.SubjectiveOrBuilder> subjectiveBuilder_;
    /**
     * <pre>
     * Results from subjective testing - i.e, opinionated human evaluation.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
     */
    public boolean hasSubjective() {
      return subjectiveBuilder_ != null || subjective_ != null;
    }
    /**
     * <pre>
     * Results from subjective testing - i.e, opinionated human evaluation.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
     */
    public io.opencannabis.schema.product.struct.testing.Subjective getSubjective() {
      if (subjectiveBuilder_ == null) {
        return subjective_ == null ? io.opencannabis.schema.product.struct.testing.Subjective.getDefaultInstance() : subjective_;
      } else {
        return subjectiveBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Results from subjective testing - i.e, opinionated human evaluation.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
     */
    public Builder setSubjective(io.opencannabis.schema.product.struct.testing.Subjective value) {
      if (subjectiveBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        subjective_ = value;
        onChanged();
      } else {
        subjectiveBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Results from subjective testing - i.e, opinionated human evaluation.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
     */
    public Builder setSubjective(
        io.opencannabis.schema.product.struct.testing.Subjective.Builder builderForValue) {
      if (subjectiveBuilder_ == null) {
        subjective_ = builderForValue.build();
        onChanged();
      } else {
        subjectiveBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Results from subjective testing - i.e, opinionated human evaluation.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
     */
    public Builder mergeSubjective(io.opencannabis.schema.product.struct.testing.Subjective value) {
      if (subjectiveBuilder_ == null) {
        if (subjective_ != null) {
          subjective_ =
            io.opencannabis.schema.product.struct.testing.Subjective.newBuilder(subjective_).mergeFrom(value).buildPartial();
        } else {
          subjective_ = value;
        }
        onChanged();
      } else {
        subjectiveBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Results from subjective testing - i.e, opinionated human evaluation.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
     */
    public Builder clearSubjective() {
      if (subjectiveBuilder_ == null) {
        subjective_ = null;
        onChanged();
      } else {
        subjective_ = null;
        subjectiveBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Results from subjective testing - i.e, opinionated human evaluation.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
     */
    public io.opencannabis.schema.product.struct.testing.Subjective.Builder getSubjectiveBuilder() {
      
      onChanged();
      return getSubjectiveFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Results from subjective testing - i.e, opinionated human evaluation.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
     */
    public io.opencannabis.schema.product.struct.testing.SubjectiveOrBuilder getSubjectiveOrBuilder() {
      if (subjectiveBuilder_ != null) {
        return subjectiveBuilder_.getMessageOrBuilder();
      } else {
        return subjective_ == null ?
            io.opencannabis.schema.product.struct.testing.Subjective.getDefaultInstance() : subjective_;
      }
    }
    /**
     * <pre>
     * Results from subjective testing - i.e, opinionated human evaluation.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.Subjective, io.opencannabis.schema.product.struct.testing.Subjective.Builder, io.opencannabis.schema.product.struct.testing.SubjectiveOrBuilder> 
        getSubjectiveFieldBuilder() {
      if (subjectiveBuilder_ == null) {
        subjectiveBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.product.struct.testing.Subjective, io.opencannabis.schema.product.struct.testing.Subjective.Builder, io.opencannabis.schema.product.struct.testing.SubjectiveOrBuilder>(
                getSubjective(),
                getParentForChildren(),
                isClean());
        subjective_ = null;
      }
      return subjectiveBuilder_;
    }

    private java.util.List<java.lang.Integer> aroma_ =
      java.util.Collections.emptyList();
    private void ensureAromaIsMutable() {
      if (!((bitField0_ & 0x00000400) == 0x00000400)) {
        aroma_ = new java.util.ArrayList<java.lang.Integer>(aroma_);
        bitField0_ |= 0x00000400;
      }
    }
    /**
     * <pre>
     * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
     * available.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
     */
    public java.util.List<io.opencannabis.schema.product.struct.testing.TasteNote> getAromaList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.product.struct.testing.TasteNote>(aroma_, aroma_converter_);
    }
    /**
     * <pre>
     * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
     * available.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
     */
    public int getAromaCount() {
      return aroma_.size();
    }
    /**
     * <pre>
     * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
     * available.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TasteNote getAroma(int index) {
      return aroma_converter_.convert(aroma_.get(index));
    }
    /**
     * <pre>
     * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
     * available.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
     */
    public Builder setAroma(
        int index, io.opencannabis.schema.product.struct.testing.TasteNote value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAromaIsMutable();
      aroma_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
     * available.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
     */
    public Builder addAroma(io.opencannabis.schema.product.struct.testing.TasteNote value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAromaIsMutable();
      aroma_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
     * available.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
     */
    public Builder addAllAroma(
        java.lang.Iterable<? extends io.opencannabis.schema.product.struct.testing.TasteNote> values) {
      ensureAromaIsMutable();
      for (io.opencannabis.schema.product.struct.testing.TasteNote value : values) {
        aroma_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
     * available.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
     */
    public Builder clearAroma() {
      aroma_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
     * available.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
     */
    public java.util.List<java.lang.Integer>
    getAromaValueList() {
      return java.util.Collections.unmodifiableList(aroma_);
    }
    /**
     * <pre>
     * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
     * available.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
     */
    public int getAromaValue(int index) {
      return aroma_.get(index);
    }
    /**
     * <pre>
     * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
     * available.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
     */
    public Builder setAromaValue(
        int index, int value) {
      ensureAromaIsMutable();
      aroma_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
     * available.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
     */
    public Builder addAromaValue(int value) {
      ensureAromaIsMutable();
      aroma_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
     * available.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
     */
    public Builder addAllAromaValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureAromaIsMutable();
      for (int value : values) {
        aroma_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<io.opencannabis.schema.product.struct.testing.TestResults> data_ =
      java.util.Collections.emptyList();
    private void ensureDataIsMutable() {
      if (!((bitField0_ & 0x00000800) == 0x00000800)) {
        data_ = new java.util.ArrayList<io.opencannabis.schema.product.struct.testing.TestResults>(data_);
        bitField0_ |= 0x00000800;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.TestResults, io.opencannabis.schema.product.struct.testing.TestResults.Builder, io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder> dataBuilder_;

    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public java.util.List<io.opencannabis.schema.product.struct.testing.TestResults> getDataList() {
      if (dataBuilder_ == null) {
        return java.util.Collections.unmodifiableList(data_);
      } else {
        return dataBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public int getDataCount() {
      if (dataBuilder_ == null) {
        return data_.size();
      } else {
        return dataBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestResults getData(int index) {
      if (dataBuilder_ == null) {
        return data_.get(index);
      } else {
        return dataBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public Builder setData(
        int index, io.opencannabis.schema.product.struct.testing.TestResults value) {
      if (dataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataIsMutable();
        data_.set(index, value);
        onChanged();
      } else {
        dataBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public Builder setData(
        int index, io.opencannabis.schema.product.struct.testing.TestResults.Builder builderForValue) {
      if (dataBuilder_ == null) {
        ensureDataIsMutable();
        data_.set(index, builderForValue.build());
        onChanged();
      } else {
        dataBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public Builder addData(io.opencannabis.schema.product.struct.testing.TestResults value) {
      if (dataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataIsMutable();
        data_.add(value);
        onChanged();
      } else {
        dataBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public Builder addData(
        int index, io.opencannabis.schema.product.struct.testing.TestResults value) {
      if (dataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataIsMutable();
        data_.add(index, value);
        onChanged();
      } else {
        dataBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public Builder addData(
        io.opencannabis.schema.product.struct.testing.TestResults.Builder builderForValue) {
      if (dataBuilder_ == null) {
        ensureDataIsMutable();
        data_.add(builderForValue.build());
        onChanged();
      } else {
        dataBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public Builder addData(
        int index, io.opencannabis.schema.product.struct.testing.TestResults.Builder builderForValue) {
      if (dataBuilder_ == null) {
        ensureDataIsMutable();
        data_.add(index, builderForValue.build());
        onChanged();
      } else {
        dataBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public Builder addAllData(
        java.lang.Iterable<? extends io.opencannabis.schema.product.struct.testing.TestResults> values) {
      if (dataBuilder_ == null) {
        ensureDataIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, data_);
        onChanged();
      } else {
        dataBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public Builder clearData() {
      if (dataBuilder_ == null) {
        data_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        dataBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public Builder removeData(int index) {
      if (dataBuilder_ == null) {
        ensureDataIsMutable();
        data_.remove(index);
        onChanged();
      } else {
        dataBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestResults.Builder getDataBuilder(
        int index) {
      return getDataFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder getDataOrBuilder(
        int index) {
      if (dataBuilder_ == null) {
        return data_.get(index);  } else {
        return dataBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder> 
         getDataOrBuilderList() {
      if (dataBuilder_ != null) {
        return dataBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(data_);
      }
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestResults.Builder addDataBuilder() {
      return getDataFieldBuilder().addBuilder(
          io.opencannabis.schema.product.struct.testing.TestResults.getDefaultInstance());
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestResults.Builder addDataBuilder(
        int index) {
      return getDataFieldBuilder().addBuilder(
          index, io.opencannabis.schema.product.struct.testing.TestResults.getDefaultInstance());
    }
    /**
     * <pre>
     * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
     */
    public java.util.List<io.opencannabis.schema.product.struct.testing.TestResults.Builder> 
         getDataBuilderList() {
      return getDataFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.TestResults, io.opencannabis.schema.product.struct.testing.TestResults.Builder, io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder> 
        getDataFieldBuilder() {
      if (dataBuilder_ == null) {
        dataBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.opencannabis.schema.product.struct.testing.TestResults, io.opencannabis.schema.product.struct.testing.TestResults.Builder, io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder>(
                data_,
                ((bitField0_ & 0x00000800) == 0x00000800),
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      return dataBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.structs.labtesting.TestResults)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.structs.labtesting.TestResults)
  private static final io.opencannabis.schema.product.struct.testing.TestResults DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.product.struct.testing.TestResults();
  }

  public static io.opencannabis.schema.product.struct.testing.TestResults getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TestResults>
      PARSER = new com.google.protobuf.AbstractParser<TestResults>() {
    public TestResults parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new TestResults(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<TestResults> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TestResults> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.product.struct.testing.TestResults getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

