/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: structs/labtesting/TestResults.proto

package io.opencannabis.schema.product.struct.testing;

public interface TestResultsOrBuilder extends
    // @@protoc_insertion_point(interface_extends:opencannabis.structs.labtesting.TestResults)
    com.google.protobuf.MessageOrBuilder {

  /**
   * <pre>
   * Boolean flag indicating whether results are available for lab testing at all.
   * </pre>
   *
   * <code>bool available = 1;</code>
   */
  boolean getAvailable();

  /**
   * <pre>
   * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
   * specifying test results, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
   */
  java.util.List<io.opencannabis.schema.product.struct.testing.TestMedia> 
      getMediaList();
  /**
   * <pre>
   * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
   * specifying test results, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
   */
  io.opencannabis.schema.product.struct.testing.TestMedia getMedia(int index);
  /**
   * <pre>
   * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
   * specifying test results, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
   */
  int getMediaCount();
  /**
   * <pre>
   * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
   * specifying test results, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
   */
  java.util.List<? extends io.opencannabis.schema.product.struct.testing.TestMediaOrBuilder> 
      getMediaOrBuilderList();
  /**
   * <pre>
   * Media attached to a set of lab results. This might include images taken during testing, documents (such as PDFs)
   * specifying test results, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestMedia media = 2;</code>
   */
  io.opencannabis.schema.product.struct.testing.TestMediaOrBuilder getMediaOrBuilder(
      int index);

  /**
   * <pre>
   * Last-updated value for these lab test results. Updated each time the record is updated.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
   */
  boolean hasLastUpdated();
  /**
   * <pre>
   * Last-updated value for these lab test results. Updated each time the record is updated.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
   */
  io.opencannabis.schema.temporal.Instant getLastUpdated();
  /**
   * <pre>
   * Last-updated value for these lab test results. Updated each time the record is updated.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant last_updated = 3;</code>
   */
  io.opencannabis.schema.temporal.InstantOrBuilder getLastUpdatedOrBuilder();

  /**
   * <pre>
   * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
   * test results (unique by their coordinates) is considered immutable.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant sealed = 4;</code>
   */
  boolean hasSealed();
  /**
   * <pre>
   * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
   * test results (unique by their coordinates) is considered immutable.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant sealed = 4;</code>
   */
  io.opencannabis.schema.temporal.Instant getSealed();
  /**
   * <pre>
   * Precise moment that these results were considered 'sealed' and returned. Once this timestamp is set, a given set of
   * test results (unique by their coordinates) is considered immutable.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant sealed = 4;</code>
   */
  io.opencannabis.schema.temporal.InstantOrBuilder getSealedOrBuilder();

  /**
   * <pre>
   * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
   * indicates the coordinates for the active set of test results.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
   */
  boolean hasCoordinates();
  /**
   * <pre>
   * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
   * indicates the coordinates for the active set of test results.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
   */
  io.opencannabis.schema.product.struct.testing.TestCoordinates getCoordinates();
  /**
   * <pre>
   * Coordinate, or ID values, for this set of test results. When specified at the top-level of a set of lab tests,
   * indicates the coordinates for the active set of test results.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.TestCoordinates coordinates = 5;</code>
   */
  io.opencannabis.schema.product.struct.testing.TestCoordinatesOrBuilder getCoordinatesOrBuilder();

  /**
   * <pre>
   * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
   * compounds.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
   */
  boolean hasCannabinoids();
  /**
   * <pre>
   * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
   * compounds.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
   */
  io.opencannabis.schema.product.struct.testing.Cannabinoids getCannabinoids();
  /**
   * <pre>
   * Standard cannabinoid testing, with reading results at least for THC and CBD, and optionally additional cannabinoid
   * compounds.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Cannabinoids cannabinoids = 30;</code>
   */
  io.opencannabis.schema.product.struct.testing.CannabinoidsOrBuilder getCannabinoidsOrBuilder();

  /**
   * <pre>
   * Testing for terpene volatiles, which might indicate aroma or flavor notes.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
   */
  boolean hasTerpenes();
  /**
   * <pre>
   * Testing for terpene volatiles, which might indicate aroma or flavor notes.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
   */
  io.opencannabis.schema.product.struct.testing.Terpenes getTerpenes();
  /**
   * <pre>
   * Testing for terpene volatiles, which might indicate aroma or flavor notes.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Terpenes terpenes = 31;</code>
   */
  io.opencannabis.schema.product.struct.testing.TerpenesOrBuilder getTerpenesOrBuilder();

  /**
   * <pre>
   * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
   */
  boolean hasPesticides();
  /**
   * <pre>
   * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
   */
  io.opencannabis.schema.product.struct.testing.Pesticides getPesticides();
  /**
   * <pre>
   * Pesticide-specific test results. Indicates a pesticide reading, by chemical compound name, and a reading value.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Pesticides pesticides = 32;</code>
   */
  io.opencannabis.schema.product.struct.testing.PesticidesOrBuilder getPesticidesOrBuilder();

  /**
   * <pre>
   * Moisture rating and test results.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
   */
  boolean hasMoisture();
  /**
   * <pre>
   * Moisture rating and test results.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
   */
  io.opencannabis.schema.product.struct.testing.Moisture getMoisture();
  /**
   * <pre>
   * Moisture rating and test results.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Moisture moisture = 33;</code>
   */
  io.opencannabis.schema.product.struct.testing.MoistureOrBuilder getMoistureOrBuilder();

  /**
   * <pre>
   * Results from subjective testing - i.e, opinionated human evaluation.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
   */
  boolean hasSubjective();
  /**
   * <pre>
   * Results from subjective testing - i.e, opinionated human evaluation.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
   */
  io.opencannabis.schema.product.struct.testing.Subjective getSubjective();
  /**
   * <pre>
   * Results from subjective testing - i.e, opinionated human evaluation.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.Subjective subjective = 34;</code>
   */
  io.opencannabis.schema.product.struct.testing.SubjectiveOrBuilder getSubjectiveOrBuilder();

  /**
   * <pre>
   * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
   * available.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
   */
  java.util.List<io.opencannabis.schema.product.struct.testing.TasteNote> getAromaList();
  /**
   * <pre>
   * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
   * available.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
   */
  int getAromaCount();
  /**
   * <pre>
   * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
   * available.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
   */
  io.opencannabis.schema.product.struct.testing.TasteNote getAroma(int index);
  /**
   * <pre>
   * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
   * available.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
   */
  java.util.List<java.lang.Integer>
  getAromaValueList();
  /**
   * <pre>
   * Computed taste notes for this product, based on the combination of terpene testing and subjective testing, if
   * available.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote aroma = 35;</code>
   */
  int getAromaValue(int index);

  /**
   * <pre>
   * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
   */
  java.util.List<io.opencannabis.schema.product.struct.testing.TestResults> 
      getDataList();
  /**
   * <pre>
   * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
   */
  io.opencannabis.schema.product.struct.testing.TestResults getData(int index);
  /**
   * <pre>
   * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
   */
  int getDataCount();
  /**
   * <pre>
   * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
   */
  java.util.List<? extends io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder> 
      getDataOrBuilderList();
  /**
   * <pre>
   * Raw test result data, stored under a master set of test results. Only one level of nesting is allowed.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TestResults data = 36;</code>
   */
  io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder getDataOrBuilder(
      int index);
}
