/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: proximity/BluetoothBeacon.proto

package io.opencannabis.schema.proximity;

/**
 * <pre>
 * Specifies a Blutooth beacon signal, detected or emitted by a BLE device.
 * </pre>
 *
 * Protobuf type {@code opencannabis.proximity.BluetoothBeacon}
 */
public  final class BluetoothBeacon extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.proximity.BluetoothBeacon)
    BluetoothBeaconOrBuilder {
private static final long serialVersionUID = 0L;
  // Use BluetoothBeacon.newBuilder() to construct.
  private BluetoothBeacon(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private BluetoothBeacon() {
    uuid_ = "";
    major_ = 0;
    minor_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private BluetoothBeacon(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            uuid_ = s;
            break;
          }
          case 16: {

            major_ = input.readUInt32();
            break;
          }
          case 24: {

            minor_ = input.readUInt32();
            break;
          }
          case 34: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (seen_ != null) {
              subBuilder = seen_.toBuilder();
            }
            seen_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(seen_);
              seen_ = subBuilder.buildPartial();
            }

            break;
          }
          case 42: {
            io.opencannabis.schema.geo.Location.Builder subBuilder = null;
            if (location_ != null) {
              subBuilder = location_.toBuilder();
            }
            location_ = input.readMessage(io.opencannabis.schema.geo.Location.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(location_);
              location_ = subBuilder.buildPartial();
            }

            break;
          }
          case 50: {
            io.opencannabis.schema.geo.LocationAccuracy.Builder subBuilder = null;
            if (accuracy_ != null) {
              subBuilder = accuracy_.toBuilder();
            }
            accuracy_ = input.readMessage(io.opencannabis.schema.geo.LocationAccuracy.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(accuracy_);
              accuracy_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.proximity.BluetoothBeaconOuterClass.internal_static_opencannabis_proximity_BluetoothBeacon_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.proximity.BluetoothBeaconOuterClass.internal_static_opencannabis_proximity_BluetoothBeacon_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.proximity.BluetoothBeacon.class, io.opencannabis.schema.proximity.BluetoothBeacon.Builder.class);
  }

  public static final int UUID_FIELD_NUMBER = 1;
  private volatile java.lang.Object uuid_;
  /**
   * <pre>
   * UUID for the device, as observed or broadcasted.
   * </pre>
   *
   * <code>string uuid = 1;</code>
   */
  public java.lang.String getUuid() {
    java.lang.Object ref = uuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uuid_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * UUID for the device, as observed or broadcasted.
   * </pre>
   *
   * <code>string uuid = 1;</code>
   */
  public com.google.protobuf.ByteString
      getUuidBytes() {
    java.lang.Object ref = uuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      uuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAJOR_FIELD_NUMBER = 2;
  private int major_;
  /**
   * <pre>
   * 'Major' value in the BLE signal.
   * </pre>
   *
   * <code>uint32 major = 2;</code>
   */
  public int getMajor() {
    return major_;
  }

  public static final int MINOR_FIELD_NUMBER = 3;
  private int minor_;
  /**
   * <pre>
   * 'Minor' value in the BLE signal.
   * </pre>
   *
   * <code>uint32 minor = 3;</code>
   */
  public int getMinor() {
    return minor_;
  }

  public static final int SEEN_FIELD_NUMBER = 4;
  private io.opencannabis.schema.temporal.Instant seen_;
  /**
   * <pre>
   * Timestamp for when this beacon was witnessed.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant seen = 4;</code>
   */
  public boolean hasSeen() {
    return seen_ != null;
  }
  /**
   * <pre>
   * Timestamp for when this beacon was witnessed.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant seen = 4;</code>
   */
  public io.opencannabis.schema.temporal.Instant getSeen() {
    return seen_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : seen_;
  }
  /**
   * <pre>
   * Timestamp for when this beacon was witnessed.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant seen = 4;</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getSeenOrBuilder() {
    return getSeen();
  }

  public static final int LOCATION_FIELD_NUMBER = 5;
  private io.opencannabis.schema.geo.Location location_;
  /**
   * <pre>
   * Location of the emitting or reporting (receiving) beacon.
   * </pre>
   *
   * <code>.opencannabis.geo.Location location = 5;</code>
   */
  public boolean hasLocation() {
    return location_ != null;
  }
  /**
   * <pre>
   * Location of the emitting or reporting (receiving) beacon.
   * </pre>
   *
   * <code>.opencannabis.geo.Location location = 5;</code>
   */
  public io.opencannabis.schema.geo.Location getLocation() {
    return location_ == null ? io.opencannabis.schema.geo.Location.getDefaultInstance() : location_;
  }
  /**
   * <pre>
   * Location of the emitting or reporting (receiving) beacon.
   * </pre>
   *
   * <code>.opencannabis.geo.Location location = 5;</code>
   */
  public io.opencannabis.schema.geo.LocationOrBuilder getLocationOrBuilder() {
    return getLocation();
  }

  public static final int ACCURACY_FIELD_NUMBER = 6;
  private io.opencannabis.schema.geo.LocationAccuracy accuracy_;
  /**
   * <pre>
   * Estimate as to the distance accuracy of this beacon.
   * </pre>
   *
   * <code>.opencannabis.geo.LocationAccuracy accuracy = 6;</code>
   */
  public boolean hasAccuracy() {
    return accuracy_ != null;
  }
  /**
   * <pre>
   * Estimate as to the distance accuracy of this beacon.
   * </pre>
   *
   * <code>.opencannabis.geo.LocationAccuracy accuracy = 6;</code>
   */
  public io.opencannabis.schema.geo.LocationAccuracy getAccuracy() {
    return accuracy_ == null ? io.opencannabis.schema.geo.LocationAccuracy.getDefaultInstance() : accuracy_;
  }
  /**
   * <pre>
   * Estimate as to the distance accuracy of this beacon.
   * </pre>
   *
   * <code>.opencannabis.geo.LocationAccuracy accuracy = 6;</code>
   */
  public io.opencannabis.schema.geo.LocationAccuracyOrBuilder getAccuracyOrBuilder() {
    return getAccuracy();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getUuidBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uuid_);
    }
    if (major_ != 0) {
      output.writeUInt32(2, major_);
    }
    if (minor_ != 0) {
      output.writeUInt32(3, minor_);
    }
    if (seen_ != null) {
      output.writeMessage(4, getSeen());
    }
    if (location_ != null) {
      output.writeMessage(5, getLocation());
    }
    if (accuracy_ != null) {
      output.writeMessage(6, getAccuracy());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getUuidBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uuid_);
    }
    if (major_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt32Size(2, major_);
    }
    if (minor_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt32Size(3, minor_);
    }
    if (seen_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getSeen());
    }
    if (location_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getLocation());
    }
    if (accuracy_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getAccuracy());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.proximity.BluetoothBeacon)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.proximity.BluetoothBeacon other = (io.opencannabis.schema.proximity.BluetoothBeacon) obj;

    boolean result = true;
    result = result && getUuid()
        .equals(other.getUuid());
    result = result && (getMajor()
        == other.getMajor());
    result = result && (getMinor()
        == other.getMinor());
    result = result && (hasSeen() == other.hasSeen());
    if (hasSeen()) {
      result = result && getSeen()
          .equals(other.getSeen());
    }
    result = result && (hasLocation() == other.hasLocation());
    if (hasLocation()) {
      result = result && getLocation()
          .equals(other.getLocation());
    }
    result = result && (hasAccuracy() == other.hasAccuracy());
    if (hasAccuracy()) {
      result = result && getAccuracy()
          .equals(other.getAccuracy());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + UUID_FIELD_NUMBER;
    hash = (53 * hash) + getUuid().hashCode();
    hash = (37 * hash) + MAJOR_FIELD_NUMBER;
    hash = (53 * hash) + getMajor();
    hash = (37 * hash) + MINOR_FIELD_NUMBER;
    hash = (53 * hash) + getMinor();
    if (hasSeen()) {
      hash = (37 * hash) + SEEN_FIELD_NUMBER;
      hash = (53 * hash) + getSeen().hashCode();
    }
    if (hasLocation()) {
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
    }
    if (hasAccuracy()) {
      hash = (37 * hash) + ACCURACY_FIELD_NUMBER;
      hash = (53 * hash) + getAccuracy().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.proximity.BluetoothBeacon parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.proximity.BluetoothBeacon parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.proximity.BluetoothBeacon parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.proximity.BluetoothBeacon parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.proximity.BluetoothBeacon parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.proximity.BluetoothBeacon parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.proximity.BluetoothBeacon parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.proximity.BluetoothBeacon parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.proximity.BluetoothBeacon parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.proximity.BluetoothBeacon parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.proximity.BluetoothBeacon parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.proximity.BluetoothBeacon parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.proximity.BluetoothBeacon prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a Blutooth beacon signal, detected or emitted by a BLE device.
   * </pre>
   *
   * Protobuf type {@code opencannabis.proximity.BluetoothBeacon}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.proximity.BluetoothBeacon)
      io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.proximity.BluetoothBeaconOuterClass.internal_static_opencannabis_proximity_BluetoothBeacon_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.proximity.BluetoothBeaconOuterClass.internal_static_opencannabis_proximity_BluetoothBeacon_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.proximity.BluetoothBeacon.class, io.opencannabis.schema.proximity.BluetoothBeacon.Builder.class);
    }

    // Construct using io.opencannabis.schema.proximity.BluetoothBeacon.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      uuid_ = "";

      major_ = 0;

      minor_ = 0;

      if (seenBuilder_ == null) {
        seen_ = null;
      } else {
        seen_ = null;
        seenBuilder_ = null;
      }
      if (locationBuilder_ == null) {
        location_ = null;
      } else {
        location_ = null;
        locationBuilder_ = null;
      }
      if (accuracyBuilder_ == null) {
        accuracy_ = null;
      } else {
        accuracy_ = null;
        accuracyBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.proximity.BluetoothBeaconOuterClass.internal_static_opencannabis_proximity_BluetoothBeacon_descriptor;
    }

    public io.opencannabis.schema.proximity.BluetoothBeacon getDefaultInstanceForType() {
      return io.opencannabis.schema.proximity.BluetoothBeacon.getDefaultInstance();
    }

    public io.opencannabis.schema.proximity.BluetoothBeacon build() {
      io.opencannabis.schema.proximity.BluetoothBeacon result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.proximity.BluetoothBeacon buildPartial() {
      io.opencannabis.schema.proximity.BluetoothBeacon result = new io.opencannabis.schema.proximity.BluetoothBeacon(this);
      result.uuid_ = uuid_;
      result.major_ = major_;
      result.minor_ = minor_;
      if (seenBuilder_ == null) {
        result.seen_ = seen_;
      } else {
        result.seen_ = seenBuilder_.build();
      }
      if (locationBuilder_ == null) {
        result.location_ = location_;
      } else {
        result.location_ = locationBuilder_.build();
      }
      if (accuracyBuilder_ == null) {
        result.accuracy_ = accuracy_;
      } else {
        result.accuracy_ = accuracyBuilder_.build();
      }
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.proximity.BluetoothBeacon) {
        return mergeFrom((io.opencannabis.schema.proximity.BluetoothBeacon)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.proximity.BluetoothBeacon other) {
      if (other == io.opencannabis.schema.proximity.BluetoothBeacon.getDefaultInstance()) return this;
      if (!other.getUuid().isEmpty()) {
        uuid_ = other.uuid_;
        onChanged();
      }
      if (other.getMajor() != 0) {
        setMajor(other.getMajor());
      }
      if (other.getMinor() != 0) {
        setMinor(other.getMinor());
      }
      if (other.hasSeen()) {
        mergeSeen(other.getSeen());
      }
      if (other.hasLocation()) {
        mergeLocation(other.getLocation());
      }
      if (other.hasAccuracy()) {
        mergeAccuracy(other.getAccuracy());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.proximity.BluetoothBeacon parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.proximity.BluetoothBeacon) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object uuid_ = "";
    /**
     * <pre>
     * UUID for the device, as observed or broadcasted.
     * </pre>
     *
     * <code>string uuid = 1;</code>
     */
    public java.lang.String getUuid() {
      java.lang.Object ref = uuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * UUID for the device, as observed or broadcasted.
     * </pre>
     *
     * <code>string uuid = 1;</code>
     */
    public com.google.protobuf.ByteString
        getUuidBytes() {
      java.lang.Object ref = uuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        uuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * UUID for the device, as observed or broadcasted.
     * </pre>
     *
     * <code>string uuid = 1;</code>
     */
    public Builder setUuid(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      uuid_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * UUID for the device, as observed or broadcasted.
     * </pre>
     *
     * <code>string uuid = 1;</code>
     */
    public Builder clearUuid() {
      
      uuid_ = getDefaultInstance().getUuid();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * UUID for the device, as observed or broadcasted.
     * </pre>
     *
     * <code>string uuid = 1;</code>
     */
    public Builder setUuidBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      uuid_ = value;
      onChanged();
      return this;
    }

    private int major_ ;
    /**
     * <pre>
     * 'Major' value in the BLE signal.
     * </pre>
     *
     * <code>uint32 major = 2;</code>
     */
    public int getMajor() {
      return major_;
    }
    /**
     * <pre>
     * 'Major' value in the BLE signal.
     * </pre>
     *
     * <code>uint32 major = 2;</code>
     */
    public Builder setMajor(int value) {
      
      major_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * 'Major' value in the BLE signal.
     * </pre>
     *
     * <code>uint32 major = 2;</code>
     */
    public Builder clearMajor() {
      
      major_ = 0;
      onChanged();
      return this;
    }

    private int minor_ ;
    /**
     * <pre>
     * 'Minor' value in the BLE signal.
     * </pre>
     *
     * <code>uint32 minor = 3;</code>
     */
    public int getMinor() {
      return minor_;
    }
    /**
     * <pre>
     * 'Minor' value in the BLE signal.
     * </pre>
     *
     * <code>uint32 minor = 3;</code>
     */
    public Builder setMinor(int value) {
      
      minor_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * 'Minor' value in the BLE signal.
     * </pre>
     *
     * <code>uint32 minor = 3;</code>
     */
    public Builder clearMinor() {
      
      minor_ = 0;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.temporal.Instant seen_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> seenBuilder_;
    /**
     * <pre>
     * Timestamp for when this beacon was witnessed.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4;</code>
     */
    public boolean hasSeen() {
      return seenBuilder_ != null || seen_ != null;
    }
    /**
     * <pre>
     * Timestamp for when this beacon was witnessed.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4;</code>
     */
    public io.opencannabis.schema.temporal.Instant getSeen() {
      if (seenBuilder_ == null) {
        return seen_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : seen_;
      } else {
        return seenBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Timestamp for when this beacon was witnessed.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4;</code>
     */
    public Builder setSeen(io.opencannabis.schema.temporal.Instant value) {
      if (seenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        seen_ = value;
        onChanged();
      } else {
        seenBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this beacon was witnessed.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4;</code>
     */
    public Builder setSeen(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (seenBuilder_ == null) {
        seen_ = builderForValue.build();
        onChanged();
      } else {
        seenBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this beacon was witnessed.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4;</code>
     */
    public Builder mergeSeen(io.opencannabis.schema.temporal.Instant value) {
      if (seenBuilder_ == null) {
        if (seen_ != null) {
          seen_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(seen_).mergeFrom(value).buildPartial();
        } else {
          seen_ = value;
        }
        onChanged();
      } else {
        seenBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this beacon was witnessed.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4;</code>
     */
    public Builder clearSeen() {
      if (seenBuilder_ == null) {
        seen_ = null;
        onChanged();
      } else {
        seen_ = null;
        seenBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this beacon was witnessed.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4;</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getSeenBuilder() {
      
      onChanged();
      return getSeenFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Timestamp for when this beacon was witnessed.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getSeenOrBuilder() {
      if (seenBuilder_ != null) {
        return seenBuilder_.getMessageOrBuilder();
      } else {
        return seen_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : seen_;
      }
    }
    /**
     * <pre>
     * Timestamp for when this beacon was witnessed.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getSeenFieldBuilder() {
      if (seenBuilder_ == null) {
        seenBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getSeen(),
                getParentForChildren(),
                isClean());
        seen_ = null;
      }
      return seenBuilder_;
    }

    private io.opencannabis.schema.geo.Location location_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.Location, io.opencannabis.schema.geo.Location.Builder, io.opencannabis.schema.geo.LocationOrBuilder> locationBuilder_;
    /**
     * <pre>
     * Location of the emitting or reporting (receiving) beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 5;</code>
     */
    public boolean hasLocation() {
      return locationBuilder_ != null || location_ != null;
    }
    /**
     * <pre>
     * Location of the emitting or reporting (receiving) beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 5;</code>
     */
    public io.opencannabis.schema.geo.Location getLocation() {
      if (locationBuilder_ == null) {
        return location_ == null ? io.opencannabis.schema.geo.Location.getDefaultInstance() : location_;
      } else {
        return locationBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Location of the emitting or reporting (receiving) beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 5;</code>
     */
    public Builder setLocation(io.opencannabis.schema.geo.Location value) {
      if (locationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        onChanged();
      } else {
        locationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Location of the emitting or reporting (receiving) beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 5;</code>
     */
    public Builder setLocation(
        io.opencannabis.schema.geo.Location.Builder builderForValue) {
      if (locationBuilder_ == null) {
        location_ = builderForValue.build();
        onChanged();
      } else {
        locationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Location of the emitting or reporting (receiving) beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 5;</code>
     */
    public Builder mergeLocation(io.opencannabis.schema.geo.Location value) {
      if (locationBuilder_ == null) {
        if (location_ != null) {
          location_ =
            io.opencannabis.schema.geo.Location.newBuilder(location_).mergeFrom(value).buildPartial();
        } else {
          location_ = value;
        }
        onChanged();
      } else {
        locationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Location of the emitting or reporting (receiving) beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 5;</code>
     */
    public Builder clearLocation() {
      if (locationBuilder_ == null) {
        location_ = null;
        onChanged();
      } else {
        location_ = null;
        locationBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Location of the emitting or reporting (receiving) beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 5;</code>
     */
    public io.opencannabis.schema.geo.Location.Builder getLocationBuilder() {
      
      onChanged();
      return getLocationFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Location of the emitting or reporting (receiving) beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 5;</code>
     */
    public io.opencannabis.schema.geo.LocationOrBuilder getLocationOrBuilder() {
      if (locationBuilder_ != null) {
        return locationBuilder_.getMessageOrBuilder();
      } else {
        return location_ == null ?
            io.opencannabis.schema.geo.Location.getDefaultInstance() : location_;
      }
    }
    /**
     * <pre>
     * Location of the emitting or reporting (receiving) beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.Location, io.opencannabis.schema.geo.Location.Builder, io.opencannabis.schema.geo.LocationOrBuilder> 
        getLocationFieldBuilder() {
      if (locationBuilder_ == null) {
        locationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.geo.Location, io.opencannabis.schema.geo.Location.Builder, io.opencannabis.schema.geo.LocationOrBuilder>(
                getLocation(),
                getParentForChildren(),
                isClean());
        location_ = null;
      }
      return locationBuilder_;
    }

    private io.opencannabis.schema.geo.LocationAccuracy accuracy_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.LocationAccuracy, io.opencannabis.schema.geo.LocationAccuracy.Builder, io.opencannabis.schema.geo.LocationAccuracyOrBuilder> accuracyBuilder_;
    /**
     * <pre>
     * Estimate as to the distance accuracy of this beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 6;</code>
     */
    public boolean hasAccuracy() {
      return accuracyBuilder_ != null || accuracy_ != null;
    }
    /**
     * <pre>
     * Estimate as to the distance accuracy of this beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 6;</code>
     */
    public io.opencannabis.schema.geo.LocationAccuracy getAccuracy() {
      if (accuracyBuilder_ == null) {
        return accuracy_ == null ? io.opencannabis.schema.geo.LocationAccuracy.getDefaultInstance() : accuracy_;
      } else {
        return accuracyBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Estimate as to the distance accuracy of this beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 6;</code>
     */
    public Builder setAccuracy(io.opencannabis.schema.geo.LocationAccuracy value) {
      if (accuracyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accuracy_ = value;
        onChanged();
      } else {
        accuracyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Estimate as to the distance accuracy of this beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 6;</code>
     */
    public Builder setAccuracy(
        io.opencannabis.schema.geo.LocationAccuracy.Builder builderForValue) {
      if (accuracyBuilder_ == null) {
        accuracy_ = builderForValue.build();
        onChanged();
      } else {
        accuracyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Estimate as to the distance accuracy of this beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 6;</code>
     */
    public Builder mergeAccuracy(io.opencannabis.schema.geo.LocationAccuracy value) {
      if (accuracyBuilder_ == null) {
        if (accuracy_ != null) {
          accuracy_ =
            io.opencannabis.schema.geo.LocationAccuracy.newBuilder(accuracy_).mergeFrom(value).buildPartial();
        } else {
          accuracy_ = value;
        }
        onChanged();
      } else {
        accuracyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Estimate as to the distance accuracy of this beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 6;</code>
     */
    public Builder clearAccuracy() {
      if (accuracyBuilder_ == null) {
        accuracy_ = null;
        onChanged();
      } else {
        accuracy_ = null;
        accuracyBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Estimate as to the distance accuracy of this beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 6;</code>
     */
    public io.opencannabis.schema.geo.LocationAccuracy.Builder getAccuracyBuilder() {
      
      onChanged();
      return getAccuracyFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Estimate as to the distance accuracy of this beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 6;</code>
     */
    public io.opencannabis.schema.geo.LocationAccuracyOrBuilder getAccuracyOrBuilder() {
      if (accuracyBuilder_ != null) {
        return accuracyBuilder_.getMessageOrBuilder();
      } else {
        return accuracy_ == null ?
            io.opencannabis.schema.geo.LocationAccuracy.getDefaultInstance() : accuracy_;
      }
    }
    /**
     * <pre>
     * Estimate as to the distance accuracy of this beacon.
     * </pre>
     *
     * <code>.opencannabis.geo.LocationAccuracy accuracy = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.geo.LocationAccuracy, io.opencannabis.schema.geo.LocationAccuracy.Builder, io.opencannabis.schema.geo.LocationAccuracyOrBuilder> 
        getAccuracyFieldBuilder() {
      if (accuracyBuilder_ == null) {
        accuracyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.geo.LocationAccuracy, io.opencannabis.schema.geo.LocationAccuracy.Builder, io.opencannabis.schema.geo.LocationAccuracyOrBuilder>(
                getAccuracy(),
                getParentForChildren(),
                isClean());
        accuracy_ = null;
      }
      return accuracyBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.proximity.BluetoothBeacon)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.proximity.BluetoothBeacon)
  private static final io.opencannabis.schema.proximity.BluetoothBeacon DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.proximity.BluetoothBeacon();
  }

  public static io.opencannabis.schema.proximity.BluetoothBeacon getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BluetoothBeacon>
      PARSER = new com.google.protobuf.AbstractParser<BluetoothBeacon>() {
    public BluetoothBeacon parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new BluetoothBeacon(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<BluetoothBeacon> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BluetoothBeacon> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.proximity.BluetoothBeacon getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

