/*
 * Decompiled with CFR 0.152.
 */
package bloombox.client;

import bloombox.client.ClientException;
import bloombox.client.interfaces.ClientError;
import bloombox.client.services.menu.MenuClientError;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import org.junit.Test;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Lbloombox/client/ClientExceptionTests;", "", "()V", "testClientError", "", "testClientExceptionUncaught", "testStatusRuntimeException", "java-client"})
public final class ClientExceptionTests {
    @Test
    public final void testClientExceptionUncaught() {
        ClientException exc = ClientException.Companion.fromUncaughtException$java_client((Throwable)new IllegalStateException("testing 123"));
        AssertionsKt.assertEquals((Object)"testing 123", (Object)exc.message(), (String)"exception message should make it through");
        AssertionsKt.assertNotNull((Object)exc.getCause(), (String)"client exception should take on its cause when created from an uncaught exception");
        AssertionsKt.assertEquals((Object)exc.toString(), (Object)exc.message(), (String)"toString() should match exception message");
    }

    @Test
    public final void testStatusRuntimeException() {
        StatusRuntimeException statusExc;
        StatusRuntimeException statusRuntimeException = statusExc = Status.ABORTED.asRuntimeException();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusRuntimeException, (String)"statusExc");
        ClientException exc = ClientException.Companion.fromStatusRuntimeException$java_client(statusRuntimeException);
        AssertionsKt.assertEquals((Object)Status.ABORTED, (Object)exc.status(), (String)"cause should pass through for ClientException from StatusRuntimeException");
        AssertionsKt.assertNotNull((Object)exc.getMessage(), (String)"ClientException message for StatusRuntimeException should not be null");
        AssertionsKt.assertNotNull((Object)exc.getCause(), (String)"ClientException cause for StatusRuntimeException should not be null");
        AssertionsKt.assertEquals((Object)exc.toString(), (Object)exc.message(), (String)"toString() should match exception message");
    }

    @Test
    public final void testClientError() {
        ClientException exc = ClientException.Companion.fromClientError$java_client((ClientError)MenuClientError.PARTNER_INVALID);
        AssertionsKt.assertEquals((Object)MenuClientError.PARTNER_INVALID.message(), (Object)exc.message(), (String)"client error message should be adopted in wrapped exception");
        AssertionsKt.assertEquals((Object)exc.toString(), (Object)exc.message(), (String)"toString() should match exception message");
    }
}

