/*
 * Decompiled with CFR 0.152.
 */
package bloombox.client;

import bloombox.client.Bloombox;
import bloombox.client.ClientConfigTests;
import bloombox.client.test.ClientRPCTest;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007\u00a8\u0006\r"}, d2={"Lbloombox/client/ClientConfigTests;", "Lbloombox/client/test/ClientRPCTest;", "()V", "testApiEnvironmentCodes", "", "testApiRegionCodes", "testClientDefaultSettings", "testClientEnableLogging", "testConfigEnvironments", "testConfigPassthroughProduction", "testDefaultGrpcPort", "testProductionSandboxEndpoints", "Companion", "java-client"})
public final class ClientConfigTests
extends ClientRPCTest {
    public static final int expectedPort = 443;
    public static final int expectedLocalShopPort = 1091;
    public static final int expectedLocalTelemetryPort = 1090;
    public static final Companion Companion = new Companion(null);

    @Test
    public final void testDefaultGrpcPort() {
        AssertionsKt.assertEquals((Object)443, (Object)443, (String)"grpc port should be 465");
    }

    @Test
    public final void testApiRegionCodes() {
        AssertionsKt.assertEquals((Object)"usw1", (Object)Bloombox.APIRegion.USW1.getCode(), (String)"USW1 region code should be 'usw1'");
        AssertionsKt.assertEquals((Object)"usc1", (Object)Bloombox.APIRegion.USC1.getCode(), (String)"USC1 region code should be 'usc1'");
    }

    @Test
    public final void testApiEnvironmentCodes() {
        AssertionsKt.assertEquals((Object)"prod", (Object)Bloombox.APIEnvironment.PRODUCTION.getCode(), (String)"PRODUCTION environment code should be 'prod'");
        AssertionsKt.assertEquals((Object)"staging", (Object)Bloombox.APIEnvironment.STAGING.getCode(), (String)"STAGING environment code should be 'staging'");
        AssertionsKt.assertEquals((Object)"sandbox", (Object)Bloombox.APIEnvironment.SANDBOX.getCode(), (String)"SANDBOX environment code should be 'sandbox'");
    }

    @Test
    public final void testClientDefaultSettings() {
        Bloombox.Settings defauls = Bloombox.Settings.Companion.defaults("apikey123", "partner123", "location123");
        AssertionsKt.assertEquals((Object)"apikey123", (Object)defauls.getApiKey$java_client(), (String)"API key should be adopted via 'defaults'");
        AssertionsKt.assertEquals((Object)"partner123", (Object)defauls.getPartner$java_client(), (String)"partner code should be adopted via 'defaults'");
        AssertionsKt.assertEquals((Object)"location123", (Object)defauls.getLocation$java_client(), (String)"location code should be adopted via 'defaults'");
        AssertionsKt.assertEquals((Object)false, (Object)defauls.getEnableLogging$java_client(), (String)"logging should default to being off");
    }

    @Test
    public final void testClientEnableLogging() {
        Bloombox.Settings defauls = Bloombox.Settings.Companion.withLogging("apikey123", "partner123", "location123");
        AssertionsKt.assertEquals((Object)"apikey123", (Object)defauls.getApiKey$java_client(), (String)"API key should be adopted via 'defaults'");
        AssertionsKt.assertEquals((Object)"partner123", (Object)defauls.getPartner$java_client(), (String)"partner code should be adopted via 'defaults'");
        AssertionsKt.assertEquals((Object)"location123", (Object)defauls.getLocation$java_client(), (String)"location code should be adopted via 'defaults'");
        AssertionsKt.assertEquals((Object)true, (Object)defauls.getEnableLogging$java_client(), (String)"logging should be active when it is requested");
    }

    @Test
    public final void testProductionSandboxEndpoints() {
        AssertionsKt.assertEquals((Object)"api.bloombox.cloud", (Object)"api.bloombox.cloud", (String)"production endpoint domain should be set to api.bloombox.cloud");
        AssertionsKt.assertTrue((StringsKt.contains$default((CharSequence)"sandbox.usw1.bloombox.services", (CharSequence)"sandbox", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)"sandbox.usw1.bloombox.services", (CharSequence)"bloombox.services", (boolean)false, (int)2, null) ? 1 : 0) != 0, (String)"sandbox endpoint domain should contain sandbox and bloombox.services");
    }

    @Test
    public final void testConfigPassthroughProduction() {
        this.withClient(testConfigPassthroughProduction.1.INSTANCE);
    }

    @Test
    public final void testConfigEnvironments() {
        this.withClient(testConfigEnvironments.1.INSTANCE);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lbloombox/client/ClientConfigTests$Companion;", "", "()V", "expectedLocalShopPort", "", "expectedLocalTelemetryPort", "expectedPort", "java-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

