/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client;

import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import io.castle.client.api.CastleApi;
import io.castle.client.internal.CastleApiImpl;
import io.castle.client.internal.config.CastleConfiguration;
import io.castle.client.internal.config.CastleConfigurationBuilder;
import io.castle.client.internal.config.CastleSdkInternalConfiguration;
import io.castle.client.internal.json.CastleGsonModel;
import io.castle.client.internal.utils.CastleContextBuilder;
import io.castle.client.model.CastleSdkConfigurationException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Castle {
    public static final Logger logger = LoggerFactory.getLogger(Castle.class);
    private final CastleSdkInternalConfiguration internalConfiguration;
    private static Castle instance;

    public Castle(CastleSdkInternalConfiguration internalConfiguration) {
        this.internalConfiguration = internalConfiguration;
    }

    public static Castle instance() throws IllegalStateException {
        if (instance == null) {
            throw new IllegalStateException("Castle SDK must be initialized. Call `Castle.initialize()` first");
        }
        return instance;
    }

    public static void setSingletonInstance(Castle sdk) {
        if (instance == null) {
            instance = sdk;
        }
    }

    public CastleApi client() throws IllegalStateException {
        return this.buildApiClient(false);
    }

    public CastleApi client(boolean doNotTrack) throws IllegalStateException {
        return this.buildApiClient(doNotTrack);
    }

    public static Castle verifySdkConfigurationAndInitialize() throws CastleSdkConfigurationException {
        return Castle.initializeSDK();
    }

    private static synchronized Castle initializeSDK() throws CastleSdkConfigurationException {
        CastleSdkInternalConfiguration loadedConfig = CastleSdkInternalConfiguration.getInternalConfiguration();
        return new Castle(loadedConfig);
    }

    public static synchronized Castle initialize(CastleConfiguration config) throws CastleSdkConfigurationException {
        return new Castle(CastleSdkInternalConfiguration.buildFromConfiguration(config));
    }

    public static Castle initialize() throws CastleSdkConfigurationException {
        return Castle.initialize(Castle.configurationBuilder().build());
    }

    public static Castle initialize(String secret) throws CastleSdkConfigurationException {
        return Castle.initialize(Castle.configurationBuilder().apiSecret(secret).build());
    }

    public static CastleConfigurationBuilder configurationBuilder() {
        return CastleSdkInternalConfiguration.builderFromConfigurationLoader();
    }

    public CastleContextBuilder contextBuilder() {
        return this.buildContextBuilder();
    }

    public CastleContextBuilder buildContextBuilder() {
        return new CastleContextBuilder(this.getSdkConfiguration(), this.getGsonModel());
    }

    public CastleApi buildApiClient() {
        return this.buildApiClient(false);
    }

    public CastleApi buildApiClient(boolean doNotTrack) {
        return new CastleApiImpl(this.internalConfiguration, doNotTrack);
    }

    public CastleApi onRequest(HttpServletRequest request) {
        return this.onRequest(request, false);
    }

    public CastleApi onRequest(HttpServletRequest request, boolean doNotTrack) {
        return new CastleApiImpl(request, doNotTrack, this.internalConfiguration);
    }

    public CastleConfiguration getSdkConfiguration() {
        return this.internalConfiguration.getConfiguration();
    }

    private CastleGsonModel getGsonModel() {
        return this.internalConfiguration.getModel();
    }

    CastleSdkInternalConfiguration getInternalConfiguration() {
        return this.internalConfiguration;
    }

    public String secureUserID(String userId) {
        HashFunction hashFunction = this.internalConfiguration.getSecureHashFunction();
        return hashFunction.hashString((CharSequence)userId, Charsets.UTF_8).toString();
    }
}

