/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.castle.client.api.CastleApi;
import io.castle.client.internal.backend.RestApi;
import io.castle.client.internal.config.CastleSdkInternalConfiguration;
import io.castle.client.internal.utils.CastleContextBuilder;
import io.castle.client.internal.utils.ContextMerge;
import io.castle.client.internal.utils.Timestamp;
import io.castle.client.internal.utils.VerdictBuilder;
import io.castle.client.model.AsyncCallbackHandler;
import io.castle.client.model.AuthenticateAction;
import io.castle.client.model.CastleContext;
import io.castle.client.model.CastleMessage;
import io.castle.client.model.CastleRuntimeException;
import io.castle.client.model.CastleSuccess;
import io.castle.client.model.CastleUser;
import io.castle.client.model.CastleUserDevice;
import io.castle.client.model.CastleUserDevices;
import io.castle.client.model.Review;
import io.castle.client.model.Verdict;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public class CastleApiImpl
implements CastleApi {
    private final boolean doNotTrack;
    private final CastleSdkInternalConfiguration configuration;
    private final JsonObject contextJson;

    public CastleApiImpl(HttpServletRequest request, boolean doNotTrack, CastleSdkInternalConfiguration configuration) {
        this.doNotTrack = doNotTrack;
        this.configuration = configuration;
        CastleContext castleContext = this.buildContext(request);
        this.contextJson = configuration.getModel().getGson().toJsonTree((Object)castleContext).getAsJsonObject();
    }

    public CastleApiImpl(CastleSdkInternalConfiguration configuration, boolean doNotTrack) {
        this.doNotTrack = doNotTrack;
        this.configuration = configuration;
        this.contextJson = null;
    }

    private CastleApiImpl(boolean doNotTrack, CastleSdkInternalConfiguration configuration, JsonObject contextJson) {
        this.doNotTrack = doNotTrack;
        this.configuration = configuration;
        this.contextJson = contextJson;
    }

    private CastleContext buildContext(HttpServletRequest request) {
        CastleContextBuilder builder = new CastleContextBuilder(this.configuration.getConfiguration(), this.configuration.getModel());
        CastleContext context = builder.fromHttpServletRequest(request).build();
        return context;
    }

    @Override
    public CastleApi mergeContext(Object additionalContext) {
        JsonObject contextToMerge = null;
        if (additionalContext != null) {
            contextToMerge = this.configuration.getModel().getGson().toJsonTree(additionalContext).getAsJsonObject();
        }
        JsonObject mergedContext = new ContextMerge().merge(this.contextJson, contextToMerge);
        return new CastleApiImpl(this.doNotTrack, this.configuration, mergedContext);
    }

    @Override
    public CastleApi doNotTrack(boolean doNotTrack) {
        return new CastleApiImpl(doNotTrack, this.configuration, this.contextJson);
    }

    @Override
    public Verdict authenticate(String event, String userId) {
        return this.authenticate(event, userId, null, null);
    }

    @Override
    public Verdict authenticate(String event, String userId, @Nullable Object properties, @Nullable Object traits) {
        return this.authenticate(this.buildMessage(event, userId, properties, traits));
    }

    @Override
    public Verdict authenticate(CastleMessage message) {
        JsonElement request = this.buildAuthenticateRequest(message);
        return this.sendAuthenticateRequest(request);
    }

    @Override
    public JsonElement buildAuthenticateRequest(CastleMessage message) {
        return this.buildJson(message);
    }

    @Override
    public Verdict sendAuthenticateRequest(JsonElement request) {
        Preconditions.checkNotNull((Object)request, (Object)"Request json can not be null");
        if (this.doNotTrack) {
            return this.buildVerdictForDoNotTrack(request.getAsJsonObject().get("user_id").getAsString());
        }
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendAuthenticateSync(request);
    }

    @Override
    public void sendAuthenticateRequest(JsonElement request, AsyncCallbackHandler<Verdict> asyncCallbackHandler) {
        Preconditions.checkNotNull((Object)request, (Object)"Request json can not be null");
        if (this.doNotTrack) {
            asyncCallbackHandler.onResponse(this.buildVerdictForDoNotTrack(request.getAsJsonObject().get("user_id").getAsString()));
        } else {
            Preconditions.checkNotNull(asyncCallbackHandler, (Object)"The async handler can not be null");
            RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
            restApi.sendAuthenticateAsync(request, asyncCallbackHandler);
        }
    }

    private Verdict buildVerdictForDoNotTrack(String userId) {
        return VerdictBuilder.failover("Castle set to do not track.").withAction(AuthenticateAction.ALLOW).withUserId(userId).build();
    }

    @Override
    public void authenticateAsync(String event, String userId, @Nullable Object properties, @Nullable Object traits, AsyncCallbackHandler<Verdict> asyncCallbackHandler) {
        this.authenticateAsync(this.buildMessage(event, userId, properties, traits), asyncCallbackHandler);
    }

    @Override
    public void authenticateAsync(String event, String userId, AsyncCallbackHandler<Verdict> asyncCallbackHandler) {
        this.authenticateAsync(CastleMessage.builder(event).userId(userId).build(), asyncCallbackHandler);
    }

    @Override
    public void authenticateAsync(CastleMessage message, AsyncCallbackHandler<Verdict> asyncCallbackHandler) {
        JsonElement request = this.buildAuthenticateRequest(message);
        this.sendAuthenticateRequest(request, asyncCallbackHandler);
    }

    @Override
    public void track(String event) {
        this.track(event, null, null, null, null);
    }

    @Override
    public void track(String event, String userId) {
        this.track(event, userId, null, null, null);
    }

    @Override
    public void track(String event, @Nullable String userId, @Nullable String reviewId) {
        this.track(event, userId, reviewId, null, null, null);
    }

    @Override
    public void track(String event, String userId, String reviewId, Object properties) {
        this.track(event, userId, reviewId, properties, null, null);
    }

    @Override
    public void track(String event, @Nullable String userId, @Nullable String reviewId, @Nullable Object properties, @Nullable Object traits) {
        this.track(event, userId, reviewId, properties, traits, null);
    }

    @Override
    public void track(String event, @Nullable String userId, @Nullable String reviewId, @Nullable Object properties, @Nullable Object traits, AsyncCallbackHandler<Boolean> asyncCallbackHandler) {
        CastleMessage message = this.buildMessage(event, userId, properties, traits);
        if (reviewId != null) {
            message.setReviewId(reviewId);
        }
        this.track(message, asyncCallbackHandler);
    }

    @Override
    public void track(CastleMessage message) {
        this.track(message, null);
    }

    @Override
    public JsonElement buildTrackRequest(CastleMessage message) {
        Preconditions.checkNotNull((Object)message.getEvent());
        return this.buildJson(message);
    }

    @Override
    public void sendTrackRequest(JsonElement request) {
        this.sendTrackRequest(request, null);
    }

    @Override
    public void sendTrackRequest(JsonElement request, AsyncCallbackHandler<Boolean> asyncCallbackHandler) {
        Preconditions.checkNotNull((Object)request, (Object)"Request json can not be null");
        if (this.doNotTrack) {
            if (asyncCallbackHandler != null) {
                asyncCallbackHandler.onResponse(true);
            }
            return;
        }
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        restApi.sendTrackRequest(request, asyncCallbackHandler);
    }

    @Override
    public void track(CastleMessage message, @Nullable AsyncCallbackHandler<Boolean> asyncCallbackHandler) {
        JsonElement messageJson = this.buildTrackRequest(message);
        this.sendTrackRequest(messageJson, asyncCallbackHandler);
    }

    @Override
    public void identify(String userId, @Nullable Object traits, boolean active) {
        Preconditions.checkNotNull((Object)userId);
        if (this.doNotTrack) {
            return;
        }
        JsonElement traitsJson = null;
        if (traits != null) {
            traitsJson = this.configuration.getModel().getGson().toJsonTree(traits);
        }
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        restApi.sendIdentifyRequest(userId, this.contextJson, active, traitsJson);
    }

    @Override
    public void identify(String userId) {
        this.identify(userId, null, true);
    }

    @Override
    public void identify(String userId, @Nullable Object traits) {
        Preconditions.checkNotNull((Object)userId);
        this.identify(userId, traits, true);
    }

    @Override
    public Review review(String reviewId) {
        Preconditions.checkNotNull((Object)reviewId);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendReviewRequestSync(reviewId);
    }

    @Override
    public void reviewAsync(String reviewId, AsyncCallbackHandler<Review> asyncCallbackHandler) {
        Preconditions.checkNotNull((Object)reviewId);
        Preconditions.checkNotNull(asyncCallbackHandler);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        restApi.sendReviewRequestAsync(reviewId, asyncCallbackHandler);
    }

    @Override
    public Boolean removeUser(String userId) {
        Preconditions.checkNotNull((Object)userId);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendPrivacyRemoveUser(userId);
    }

    @Override
    public CastleUserDevice approve(String deviceToken) {
        Preconditions.checkNotNull((Object)deviceToken);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendApproveDeviceRequestSync(deviceToken);
    }

    @Override
    public CastleUserDevice report(String deviceToken) {
        Preconditions.checkNotNull((Object)deviceToken);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendReportDeviceRequestSync(deviceToken);
    }

    @Override
    public CastleUserDevices userDevices(String userId) {
        Preconditions.checkNotNull((Object)userId);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendGetUserDevicesRequestSync(userId);
    }

    @Override
    public CastleUser archiveUserDevices(String userId) {
        Preconditions.checkNotNull((Object)userId);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendArchiveUserDevicesRequestSync(userId);
    }

    @Override
    public CastleUserDevice device(String deviceToken) {
        Preconditions.checkNotNull((Object)deviceToken);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendGetUserDeviceRequestSync(deviceToken);
    }

    @Override
    public CastleSuccess impersonateStart(String userId) {
        Preconditions.checkNotNull((Object)userId);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendImpersonateStartRequestSync(userId, null, this.contextJson);
    }

    @Override
    public CastleSuccess impersonateStart(String userId, String impersonator) {
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)impersonator);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendImpersonateStartRequestSync(userId, impersonator, this.contextJson);
    }

    @Override
    public CastleSuccess impersonateEnd(String userId) {
        Preconditions.checkNotNull((Object)userId);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendImpersonateEndRequestSync(userId, "", this.contextJson);
    }

    @Override
    public CastleSuccess impersonateEnd(String userId, String impersonator) {
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)impersonator);
        RestApi restApi = this.configuration.getRestApiFactory().buildBackend();
        return restApi.sendImpersonateEndRequestSync(userId, impersonator, this.contextJson);
    }

    private CastleMessage buildMessage(String event, String userId, @Nullable Object properties, @Nullable Object traits) {
        CastleMessage message = new CastleMessage(event);
        message.setUserId(userId);
        if (properties != null) {
            JsonElement propertiesJson = this.configuration.getModel().getGson().toJsonTree(properties);
            message.setProperties(propertiesJson);
        }
        if (traits != null) {
            JsonElement traitsJson = this.configuration.getModel().getGson().toJsonTree(traits);
            message.setUserTraits(traitsJson);
        }
        return message;
    }

    private JsonElement buildJson(CastleMessage message) throws CastleRuntimeException {
        CastleContext context = message.getContext();
        JsonObject contextJson = context == null ? this.contextJson : this.configuration.getModel().getGson().toJsonTree((Object)context).getAsJsonObject();
        JsonElement messageJson = this.configuration.getModel().getGson().toJsonTree((Object)message);
        JsonObject messageObj = messageJson.getAsJsonObject();
        messageObj.add("context", (JsonElement)contextJson);
        messageObj.addProperty("sent_at", Timestamp.timestamp());
        return messageObj;
    }
}

