/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal.backend;

import com.google.common.collect.ImmutableList;
import io.castle.client.internal.backend.OkRestApiBackend;
import io.castle.client.internal.backend.RestApi;
import io.castle.client.internal.backend.RestApiFactory;
import io.castle.client.internal.config.CastleConfiguration;
import io.castle.client.internal.json.CastleGsonModel;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.TlsVersion;
import okhttp3.logging.HttpLoggingInterceptor;

public class OkHttpFactory
implements RestApiFactory {
    private final OkHttpClient client;
    private final CastleGsonModel modelInstance;
    private final CastleConfiguration configuration;

    public OkHttpFactory(CastleConfiguration configuration, CastleGsonModel modelInstance) {
        this.configuration = configuration;
        this.modelInstance = modelInstance;
        this.client = this.createOkHttpClient();
    }

    private OkHttpClient createOkHttpClient() {
        final String credential = Credentials.basic((String)"", (String)this.configuration.getApiSecret());
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder().connectTimeout((long)this.configuration.getTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)this.configuration.getTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)this.configuration.getTimeout(), TimeUnit.MILLISECONDS);
        if (this.configuration.isLogHttpRequests()) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            builder = builder.addInterceptor((Interceptor)logging);
        }
        ConnectionSpec sslSpec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_1, TlsVersion.TLS_1_2, TlsVersion.TLS_1_3}).build();
        ConnectionSpec cleartextSpec = new ConnectionSpec.Builder(ConnectionSpec.CLEARTEXT).build();
        OkHttpClient client = builder.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Request authenticatedRequest = request.newBuilder().header("Authorization", credential).build();
                return chain.proceed(authenticatedRequest);
            }
        }).connectionSpecs((List)ImmutableList.of((Object)sslSpec, (Object)cleartextSpec)).build();
        return client;
    }

    @Override
    public RestApi buildBackend() {
        return new OkRestApiBackend(this.client, this.modelInstance, this.configuration);
    }
}

