/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal.config;

import io.castle.client.internal.backend.CastleBackendProvider;
import io.castle.client.model.AuthenticateFailoverStrategy;
import io.castle.client.model.CastleRuntimeException;
import java.util.List;

public class CastleConfiguration {
    private final String apiBaseUrl;
    private final int timeout;
    private final AuthenticateFailoverStrategy authenticateFailoverStrategy;
    private final List<String> whiteListHeaders;
    private final List<String> blackListHeaders;
    private final String apiSecret;
    private final String castleAppId;
    private final CastleBackendProvider backendProvider;
    private final boolean logHttpRequests;
    private final List<String> ipHeaders;

    public CastleConfiguration(String apiBaseUrl, int timeout, AuthenticateFailoverStrategy authenticateFailoverStrategy, List<String> whiteListHeaders, List<String> blackListHeaders, String apiSecret, String castleAppId, CastleBackendProvider backendProvider, boolean logHttpRequests, List<String> ipHeaders) {
        this.apiBaseUrl = apiBaseUrl;
        this.timeout = timeout;
        this.authenticateFailoverStrategy = authenticateFailoverStrategy;
        this.whiteListHeaders = whiteListHeaders;
        this.blackListHeaders = blackListHeaders;
        this.apiSecret = apiSecret;
        this.castleAppId = castleAppId;
        this.backendProvider = backendProvider;
        this.logHttpRequests = logHttpRequests;
        this.ipHeaders = ipHeaders;
    }

    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public AuthenticateFailoverStrategy getAuthenticateFailoverStrategy() {
        return this.authenticateFailoverStrategy;
    }

    public List<String> getWhiteListHeaders() {
        return this.whiteListHeaders;
    }

    public List<String> getBlackListHeaders() {
        return this.blackListHeaders;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getCastleAppId() throws CastleRuntimeException {
        if (this.castleAppId == null || this.castleAppId.isEmpty()) {
            throw new CastleRuntimeException("AppId was not specified");
        }
        return this.castleAppId;
    }

    public CastleBackendProvider getBackendProvider() {
        return this.backendProvider;
    }

    public boolean isLogHttpRequests() {
        return this.logHttpRequests;
    }

    public List<String> getIpHeaders() {
        return this.ipHeaders;
    }
}

