/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal.config;

import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.castle.client.internal.backend.OkHttpFactory;
import io.castle.client.internal.backend.RestApiFactory;
import io.castle.client.internal.config.CastleConfiguration;
import io.castle.client.internal.config.CastleConfigurationBuilder;
import io.castle.client.internal.config.ConfigurationLoader;
import io.castle.client.internal.json.CastleGsonModel;
import io.castle.client.model.CastleSdkConfigurationException;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CastleSdkInternalConfiguration {
    private final RestApiFactory restApiFactory;
    private final CastleGsonModel model;
    private final CastleConfiguration configuration;
    private final SecretKey sha256Key;

    private CastleSdkInternalConfiguration(RestApiFactory restApiFactory, CastleGsonModel model, CastleConfiguration configuration) {
        this.restApiFactory = restApiFactory;
        this.model = model;
        this.configuration = configuration;
        this.sha256Key = new SecretKeySpec(configuration.getApiSecret().getBytes(Charsets.UTF_8), "HmacSHA256");
    }

    public static CastleSdkInternalConfiguration getInternalConfiguration() throws CastleSdkConfigurationException {
        CastleGsonModel modelInstance = new CastleGsonModel();
        CastleConfiguration configuration = new ConfigurationLoader().loadConfiguration();
        RestApiFactory apiFactory = CastleSdkInternalConfiguration.loadRestApiFactory(modelInstance, configuration);
        return new CastleSdkInternalConfiguration(apiFactory, modelInstance, configuration);
    }

    public static CastleSdkInternalConfiguration buildFromConfiguration(CastleConfiguration config) {
        CastleGsonModel modelInstance = new CastleGsonModel();
        RestApiFactory apiFactory = CastleSdkInternalConfiguration.loadRestApiFactory(modelInstance, config);
        return new CastleSdkInternalConfiguration(apiFactory, modelInstance, config);
    }

    public static CastleConfigurationBuilder builderFromConfigurationLoader() {
        return new ConfigurationLoader().loadConfigurationBuilder();
    }

    private static RestApiFactory loadRestApiFactory(CastleGsonModel modelInstance, CastleConfiguration configuration) {
        return new OkHttpFactory(configuration, modelInstance);
    }

    public CastleGsonModel getModel() {
        return this.model;
    }

    public RestApiFactory getRestApiFactory() {
        return this.restApiFactory;
    }

    public CastleConfiguration getConfiguration() {
        return this.configuration;
    }

    public HashFunction getSecureHashFunction() {
        return Hashing.hmacSha256((Key)this.sha256Key);
    }
}

