/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.internal.json;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.castle.client.model.CastleHeader;
import io.castle.client.model.CastleHeaders;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

public class CastleHeadersDeserializer
implements JsonDeserializer<CastleHeaders> {
    public CastleHeaders deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        CastleHeaders headers = new CastleHeaders();
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonObject root = json.getAsJsonObject();
        Set keys = root.keySet();
        for (String key : keys) {
            JsonElement jsonElement = root.get(key);
            if (!jsonElement.isJsonPrimitive()) continue;
            CastleHeader header = new CastleHeader();
            header.setKey(key);
            header.setValue(jsonElement.getAsString());
            builder.add((Object)header);
        }
        headers.setHeaders((List<CastleHeader>)builder.build());
        return headers;
    }
}

