/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model;

public class CastleDevice {
    private String id;
    private String manufacturer;
    private String model;
    private String name;
    private String type;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static Builder builder() {
        return new Builder(new CastleDevice());
    }

    public String toString() {
        return "CastleDevice{id='" + this.id + '\'' + ", manufacturer='" + this.manufacturer + '\'' + ", model='" + this.model + '\'' + ", name='" + this.name + '\'' + ", type='" + this.type + '\'' + '}';
    }

    public static class Builder {
        private CastleDevice device;

        public Builder(CastleDevice device) {
            this.device = device;
        }

        public Builder id(String id) {
            this.device.setId(id);
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.device.setManufacturer(manufacturer);
            return this;
        }

        public Builder model(String model) {
            this.device.setModel(model);
            return this;
        }

        public Builder name(String name) {
            this.device.setName(name);
            return this;
        }

        public Builder type(String type) {
            this.device.setType(type);
            return this;
        }

        public CastleDevice build() {
            return this.device;
        }
    }
}

