/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model;

import io.castle.client.Castle;
import io.castle.client.internal.config.PropertiesReader;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;

public class CastleSdkRef {
    private String name = "castle-java";
    private String version = this.loadSdkVersion().getProperty("sdk.version");
    private String platform;
    private String platformVersion = CastleSdkRef.getJavaVersion();

    CastleSdkRef() {
        this.platform = CastleSdkRef.getJavaPlatform();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return "CastleSdkRef{name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", platform='" + this.platform + '\'' + ", platformVersion='" + this.platformVersion + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CastleSdkRef that = (CastleSdkRef)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.platform, that.platform) && Objects.equals(this.platformVersion, that.platformVersion);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.platform, this.platformVersion);
    }

    private Properties loadSdkVersion() {
        Properties versionProperties = new Properties();
        PropertiesReader reader = new PropertiesReader();
        InputStream resourceAsStream = Castle.class.getClassLoader().getResourceAsStream("version.properties");
        return reader.loadPropertiesFromStream(versionProperties, resourceAsStream);
    }

    public static String getJavaVersion() {
        return System.getProperty("java.vm.version");
    }

    public static String getJavaPlatform() {
        return System.getProperty("java.vm.name");
    }
}

