/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model;

import io.castle.client.Castle;
import io.castle.client.model.CastleRuntimeException;
import java.io.IOException;
import okhttp3.Response;

public class CastleServerErrorException
extends CastleRuntimeException {
    private final int responseCode;
    private final String responseMessage;
    private String response;

    public CastleServerErrorException(Response response) {
        super(response.toString());
        this.responseCode = response.code();
        this.responseMessage = response.message();
        try {
            this.response = response.body().string();
        }
        catch (IOException | IllegalStateException | NullPointerException e) {
            Castle.logger.error("CastleServerErrorException. No response body.", (Throwable)e);
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getResponse() {
        return this.response;
    }
}

