/*
 * Decompiled with CFR 0.152.
 */
package io.cloudstate.javasupport;

import akka.Done;
import com.google.protobuf.Descriptors;
import io.cloudstate.javasupport.CloudStateRunner;
import io.cloudstate.javasupport.StatefulService;
import io.cloudstate.javasupport.crdt.CrdtEntity;
import io.cloudstate.javasupport.crdt.CrdtEntityFactory;
import io.cloudstate.javasupport.eventsourced.EventSourcedEntity;
import io.cloudstate.javasupport.eventsourced.EventSourcedEntityFactory;
import io.cloudstate.javasupport.impl.AnySupport;
import io.cloudstate.javasupport.impl.crdt.AnnotationBasedCrdtSupport;
import io.cloudstate.javasupport.impl.crdt.CrdtStatefulService;
import io.cloudstate.javasupport.impl.eventsourced.AnnotationBasedEventSourcedSupport;
import io.cloudstate.javasupport.impl.eventsourced.EventSourcedStatefulService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public final class CloudState {
    private final Map<String, StatefulService> services = new HashMap<String, StatefulService>();
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private String typeUrlPrefix = AnySupport.DefaultTypeUrlPrefix();
    private AnySupport.Prefer prefer = AnySupport.PREFER_JAVA();

    public CloudState withClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public CloudState withTypeUrlPrefix(String string) {
        this.typeUrlPrefix = string;
        return this;
    }

    public CloudState preferJavaProtobufs() {
        this.prefer = AnySupport.PREFER_JAVA();
        return this;
    }

    public CloudState preferScalaProtobufs() {
        this.prefer = AnySupport.PREFER_SCALA();
        return this;
    }

    public CloudState registerEventSourcedEntity(Class<?> clazz, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.FileDescriptor ... fileDescriptorArray) {
        int n;
        String string;
        EventSourcedEntity eventSourcedEntity = clazz.getAnnotation(EventSourcedEntity.class);
        if (eventSourcedEntity == null) {
            throw new IllegalArgumentException(clazz + " does not declare an " + EventSourcedEntity.class + " annotation!");
        }
        if (eventSourcedEntity.persistenceId().isEmpty()) {
            string = clazz.getSimpleName();
            n = 0;
        } else {
            string = eventSourcedEntity.persistenceId();
            n = eventSourcedEntity.snapshotEvery();
        }
        AnySupport anySupport = this.newAnySupport(fileDescriptorArray);
        this.services.put(serviceDescriptor.getFullName(), new EventSourcedStatefulService(new AnnotationBasedEventSourcedSupport(clazz, anySupport, serviceDescriptor), serviceDescriptor, anySupport, string, n));
        return this;
    }

    public CloudState registerEventSourcedEntity(EventSourcedEntityFactory eventSourcedEntityFactory, Descriptors.ServiceDescriptor serviceDescriptor, String string, int n, Descriptors.FileDescriptor ... fileDescriptorArray) {
        this.services.put(serviceDescriptor.getFullName(), new EventSourcedStatefulService(eventSourcedEntityFactory, serviceDescriptor, this.newAnySupport(fileDescriptorArray), string, n));
        return this;
    }

    public CloudState registerCrdtEntity(Class<?> clazz, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.FileDescriptor ... fileDescriptorArray) {
        CrdtEntity crdtEntity = clazz.getAnnotation(CrdtEntity.class);
        if (crdtEntity == null) {
            throw new IllegalArgumentException(clazz + " does not declare an " + CrdtEntity.class + " annotation!");
        }
        AnySupport anySupport = this.newAnySupport(fileDescriptorArray);
        this.services.put(serviceDescriptor.getFullName(), new CrdtStatefulService(new AnnotationBasedCrdtSupport(clazz, anySupport, serviceDescriptor), serviceDescriptor, anySupport));
        return this;
    }

    public CloudState registerCrdtEntity(CrdtEntityFactory crdtEntityFactory, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.FileDescriptor ... fileDescriptorArray) {
        this.services.put(serviceDescriptor.getFullName(), new CrdtStatefulService(crdtEntityFactory, serviceDescriptor, this.newAnySupport(fileDescriptorArray)));
        return this;
    }

    public CompletionStage<Done> start() {
        return new CloudStateRunner(this.services).run();
    }

    private AnySupport newAnySupport(Descriptors.FileDescriptor[] fileDescriptorArray) {
        return new AnySupport(fileDescriptorArray, this.classLoader, this.typeUrlPrefix, this.prefer);
    }
}

