/*
 * Decompiled with CFR 0.152.
 */
package io.codef.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.codef.api.EasyCodefConstant;
import io.codef.api.EasyCodefMessageConstant;
import io.codef.api.EasyCodefProperties;
import io.codef.api.EasyCodefResponse;
import io.codef.api.EasyCodefTokenMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;

public class EasyCodefConnector {
    private static ObjectMapper mapper = new ObjectMapper();
    private static final int REPEAT_COUNT = 3;

    protected static EasyCodefResponse execute(String urlPath, int serviceType, HashMap<String, Object> bodyMap, EasyCodefProperties properties) throws InterruptedException {
        String bodyString;
        String clientSecret;
        String clientId;
        String domain;
        if (serviceType == 0) {
            domain = "https://api.codef.io";
            clientId = properties.getClientId();
            clientSecret = properties.getClientSecret();
        } else if (serviceType == 1) {
            domain = "https://development.codef.io";
            clientId = properties.getDemoClientId();
            clientSecret = properties.getDemoClientSecret();
        } else {
            domain = "https://sandbox.codef.io";
            clientId = "ef27cfaa-10c1-4470-adac-60ba476273f9";
            clientSecret = "83160c33-9045-4915-86d8-809473cdf5c3";
        }
        String accessToken = EasyCodefConnector.getToken(clientId, clientSecret);
        try {
            bodyString = mapper.writeValueAsString(bodyMap);
            bodyString = URLEncoder.encode(bodyString, "UTF-8");
        }
        catch (JsonProcessingException e) {
            EasyCodefResponse response = new EasyCodefResponse(EasyCodefMessageConstant.INVALID_JSON);
            return response;
        }
        catch (UnsupportedEncodingException e) {
            EasyCodefResponse response = new EasyCodefResponse(EasyCodefMessageConstant.UNSUPPORTED_ENCODING);
            return response;
        }
        HashMap<String, Object> responseMap = EasyCodefConnector.requestProduct(domain + urlPath, accessToken, bodyString);
        if (EasyCodefConstant.INVALID_TOKEN.equals(responseMap.get("error")) || "CF-00401".equals(((HashMap)responseMap.get("result")).get("code"))) {
            System.out.println("\ucd5c\ucd08 \uc694\uccad \uc2e4\ud328!!! " + responseMap);
            EasyCodefTokenMap.setToken(clientId, null);
            accessToken = EasyCodefConnector.getToken(clientId, clientSecret);
            responseMap = EasyCodefConnector.requestProduct(domain + urlPath, accessToken, bodyString);
        } else if (EasyCodefConstant.ACCESS_DENIED.equals(responseMap.get("error")) || "CF-00403".equals(((HashMap)responseMap.get("result")).get("code"))) {
            EasyCodefResponse response = new EasyCodefResponse(EasyCodefMessageConstant.UNAUTHORIZED, EasyCodefConstant.ACCESS_DENIED);
            return response;
        }
        EasyCodefResponse response = new EasyCodefResponse(responseMap);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, Object> requestProduct(String urlPath, String token, String bodyString) {
        HashMap hashMap;
        BufferedReader br = null;
        try {
            String inputLine;
            URL url = new URL(urlPath);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Accept", "application/json");
            if (token != null && !"".equals(token)) {
                con.setRequestProperty("Authorization", "Bearer " + token);
            }
            OutputStream os = con.getOutputStream();
            if (bodyString != null && !"".equals(bodyString)) {
                os.write(bodyString.getBytes());
            }
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                EasyCodefResponse response;
                if (responseCode == 400) {
                    EasyCodefResponse response2;
                    EasyCodefResponse easyCodefResponse = response2 = new EasyCodefResponse(EasyCodefMessageConstant.BAD_REQUEST, urlPath);
                    return easyCodefResponse;
                }
                if (responseCode == 401) {
                    EasyCodefResponse response3;
                    EasyCodefResponse easyCodefResponse = response3 = new EasyCodefResponse(EasyCodefMessageConstant.UNAUTHORIZED, urlPath);
                    return easyCodefResponse;
                }
                if (responseCode == 403) {
                    EasyCodefResponse response4;
                    EasyCodefResponse easyCodefResponse = response4 = new EasyCodefResponse(EasyCodefMessageConstant.FORBIDDEN, urlPath);
                    return easyCodefResponse;
                }
                if (responseCode == 404) {
                    EasyCodefResponse response5;
                    EasyCodefResponse easyCodefResponse = response5 = new EasyCodefResponse(EasyCodefMessageConstant.NOT_FOUND, urlPath);
                    return easyCodefResponse;
                }
                EasyCodefResponse easyCodefResponse = response = new EasyCodefResponse(EasyCodefMessageConstant.SERVER_ERROR, urlPath);
                return easyCodefResponse;
            }
            br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer responseStr = new StringBuffer();
            while ((inputLine = br.readLine()) != null) {
                responseStr.append(inputLine);
            }
            br.close();
            hashMap = (HashMap)mapper.readValue(URLDecoder.decode(responseStr.toString(), "UTF-8"), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (Exception e) {
            EasyCodefResponse response;
            EasyCodefResponse easyCodefResponse = response = new EasyCodefResponse(EasyCodefMessageConstant.LIBRARY_SENDER_ERROR, e.getMessage());
            return easyCodefResponse;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return hashMap;
    }

    private static String getToken(String clientId, String clientSecret) throws InterruptedException {
        String accessToken = EasyCodefTokenMap.getToken(clientId);
        if (accessToken == null || "".equals(accessToken)) {
            for (int i = 0; i < 3; ++i) {
                HashMap<String, Object> tokenMap = EasyCodefConnector.publishToken(clientId, clientSecret);
                if (tokenMap != null) {
                    String newToken = (String)tokenMap.get("access_token");
                    EasyCodefTokenMap.setToken(clientId, newToken);
                    accessToken = newToken;
                }
                if (accessToken != null || !"".equals(accessToken)) break;
                Thread.sleep(20L);
            }
        }
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HashMap<String, Object> publishToken(String clientId, String clientSecret) {
        HashMap hashMap;
        BufferedReader br = null;
        try {
            HashMap tokenMap;
            String inputLine;
            URL url = new URL("https://oauth.codef.io/oauth/token");
            String params = "grant_type=client_credentials&scope=read";
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String auth = clientId + ":" + clientSecret;
            byte[] authEncBytes = Base64.encodeBase64((byte[])auth.getBytes());
            String authStringEnc = new String(authEncBytes);
            String authHeader = "Basic " + authStringEnc;
            con.setRequestProperty("Authorization", authHeader);
            con.setDoInput(true);
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(params.getBytes());
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                HashMap<String, Object> hashMap2 = null;
                return hashMap2;
            }
            br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer responseStr = new StringBuffer();
            while ((inputLine = br.readLine()) != null) {
                responseStr.append(inputLine);
            }
            br.close();
            hashMap = tokenMap = (HashMap)mapper.readValue(URLDecoder.decode(responseStr.toString(), "UTF-8"), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (Exception e) {
            HashMap<String, Object> hashMap3 = null;
            return hashMap3;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return hashMap;
    }
}

