package io.codemodder.providers.sarif.codeql;

import com.contrastsecurity.sarif.Result;
import com.github.javaparser.ast.Node;
import io.codemodder.FixOnlyCodeChanger;
import io.codemodder.RuleSarif;
import io.codemodder.SarifPluginJavaParserChanger;
import io.codemodder.SourceCodeRegionExtractor;

/**
 * Provides foundational functionality for modifying Java code using JavaParser based on findings
 * from a SARIF file generated by CodeQL analysis.
 */
public abstract class CodeQLSarifJavaParserChanger<T extends Node>
    extends SarifPluginJavaParserChanger<T> implements FixOnlyCodeChanger {
  protected CodeQLSarifJavaParserChanger(
      final RuleSarif sarif,
      final Class<? extends Node> nodeType,
      final SourceCodeRegionExtractor<Result> regionExtractor) {
    super(sarif, nodeType, regionExtractor);
  }

  @Override
  public String vendorName() {
    return "CodeQL";
  }
}
