/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.CodeTFResult;
import io.codemodder.codetf.CodeTFRun;
import io.codemodder.codetf.CodeTFValidator;
import java.util.List;
import java.util.Objects;

public final class CodeTFReport {
    private final CodeTFRun run;
    private final List<CodeTFResult> results;

    @JsonCreator
    public CodeTFReport(@JsonProperty(value="run") CodeTFRun run, @JsonProperty(value="results") List<CodeTFResult> results) {
        this.run = Objects.requireNonNull(run, "run");
        this.results = CodeTFValidator.toImmutableCopyOrEmptyOnNull(results);
    }

    public CodeTFRun getRun() {
        return this.run;
    }

    public List<CodeTFResult> getResults() {
        return this.results;
    }

    public boolean hasCodeChanges() {
        return this.results.stream().anyMatch(result -> result.getChangeset() != null && !result.getChangeset().isEmpty());
    }
}

