/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.CodeTFValidator;
import java.util.Objects;

public final class CodeTFPackageAction {
    private final String packageUrl;
    private final CodeTFPackageActionResult result;
    private final CodeTFPackageActionType action;

    @JsonCreator
    public CodeTFPackageAction(@JsonProperty(value="action") CodeTFPackageActionType action, @JsonProperty(value="result") CodeTFPackageActionResult result, @JsonProperty(value="package") String packageUrl) {
        this.packageUrl = CodeTFValidator.requireNonBlank(packageUrl);
        this.result = Objects.requireNonNull(result);
        this.action = Objects.requireNonNull(action);
    }

    public String getPackage() {
        return this.packageUrl;
    }

    public CodeTFPackageActionResult getResult() {
        return this.result;
    }

    public CodeTFPackageActionType getAction() {
        return this.action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeTFPackageAction that = (CodeTFPackageAction)o;
        if (!this.packageUrl.equals(that.packageUrl)) {
            return false;
        }
        if (this.result != that.result) {
            return false;
        }
        return this.action == that.action;
    }

    public int hashCode() {
        int result1 = this.packageUrl.hashCode();
        result1 = 31 * result1 + this.result.hashCode();
        result1 = 31 * result1 + this.action.hashCode();
        return result1;
    }

    public String toString() {
        return "CodeTFPackageAction{packageUrl='" + this.packageUrl + "', result=" + this.result + ", action=" + this.action + "}";
    }

    public static enum CodeTFPackageActionResult {
        COMPLETED,
        FAILED,
        SKIPPED;

    }

    public static enum CodeTFPackageActionType {
        ADD,
        REMOVE;

    }
}

