/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.CodeTFAiMetadata;
import io.codemodder.codetf.CodeTFChange;
import io.codemodder.codetf.CodeTFValidator;
import java.util.List;
import java.util.Objects;

public final class CodeTFChangesetEntry {
    private final String path;
    private final String diff;
    private final List<CodeTFChange> changes;
    private final CodeTFAiMetadata ai;

    @JsonCreator
    public CodeTFChangesetEntry(@JsonProperty(value="path") String path, @JsonProperty(value="diff") String diff, @JsonProperty(value="changes") List<CodeTFChange> changes, @JsonProperty(value="ai") CodeTFAiMetadata ai) {
        this.path = CodeTFValidator.requireRelativePath(path);
        this.diff = CodeTFValidator.requireNonBlank(diff);
        this.changes = CodeTFValidator.toImmutableCopyOrEmptyOnNull(changes);
        this.ai = ai;
    }

    public CodeTFChangesetEntry(String path, String diff, List<CodeTFChange> changes) {
        this(path, diff, changes, null);
    }

    public String getPath() {
        return this.path;
    }

    public String getDiff() {
        return this.diff;
    }

    public List<CodeTFChange> getChanges() {
        return this.changes;
    }

    public CodeTFAiMetadata getAi() {
        return this.ai;
    }

    public boolean usesAi() {
        return this.ai != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeTFChangesetEntry entry = (CodeTFChangesetEntry)o;
        return Objects.equals(this.path, entry.path) && Objects.equals(this.diff, entry.diff) && Objects.equals(this.changes, entry.changes) && Objects.equals(this.ai, entry.ai);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.diff, this.changes, this.ai);
    }

    public String toString() {
        return "CodeTFChangesetEntry{path='" + this.path + "', diff='" + this.diff + "', changes=" + this.changes + "}";
    }
}

