/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.CodeTFValidator;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.Finding;
import java.util.Objects;

public final class UnfixedFinding
extends Finding {
    private final String path;
    private final Integer line;
    private final String reason;

    @JsonCreator
    public UnfixedFinding(@JsonProperty(value="id", index=1) String id, @JsonProperty(value="rule", index=2) DetectorRule rule, @JsonProperty(value="path", index=3) String path, @JsonProperty(value="line", index=4) Integer line, @JsonProperty(value="reason", index=5) String reason) {
        super(id, rule);
        this.path = CodeTFValidator.requireNonBlank(path);
        this.line = line;
        this.reason = CodeTFValidator.requireNonBlank(reason);
    }

    public UnfixedFinding(@JsonProperty(value="rule", index=2) DetectorRule rule, @JsonProperty(value="path", index=3) String path, @JsonProperty(value="line", index=4) Integer line, @JsonProperty(value="reason", index=5) String reason) {
        this(null, rule, path, line, reason);
    }

    public String getPath() {
        return this.path;
    }

    public String getReason() {
        return this.reason;
    }

    public Integer getLine() {
        return this.line;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnfixedFinding)) {
            return false;
        }
        UnfixedFinding that = (UnfixedFinding)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.path.equals(that.path) && Objects.equals(this.line, that.line) && this.reason.equals(that.reason);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + Objects.hashCode(this.line);
        result = 31 * result + this.reason.hashCode();
        return result;
    }
}

