package io.contextmap.annotations.client;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation used to mark a dependency to an external component.
 * The dependency could be a REST, SOAP, gRPC, etc API which is used,
 * and the external component could be a webservice, microservice, gateway, etc.
 *
 * This annotation is intended to be used on a class (or method) which responsibility it is to
 * abstract the communication to the external component.
 * Only needed in case the dependency is not automatically detected.
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ContextClient {

    /**
     * @return the name to uniquely identify the external component
     */
    String name();

}
