package io.contextmap.annotations.rest;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation used to document a single endpoint of a REST API.
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ContextRestEndpoint {

    /**
     * @return the description of the endpoint (optional)
     */
    String description() default "";

}
