package io.contextmap.annotations.storage;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation used to mark a dependency to a storage.
 *
 * This annotation is intended to be used on a class which responsibility it is to
 * abstract the communication to the storage.
 * Only needed in case the storage is not automatically detected.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ContextStorage {

    /**
     * @return the name to uniquely identify the storage
     */
    String name();

    StorageType type() default StorageType.FILE_SYSTEM;

    enum StorageType {
        CACHE,
        ELASTIC,
        JDBC,
        MONGODB,
        SOLR,
        FILE_SYSTEM
    }

}
