package io.contextmap.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * Annotation used to customize the documentation of a property.
 */
@Target({ElementType.FIELD, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ContextApiProperty {

    /**
     * Can be used to override the class' simple-name documentation for a property.
     * @return the name of the data type of the property
     */
    String dataType() default "";

    /**
     * @return the description for a property
     */
    String description() default "";

    /**
     * Only Enums are automatically documented with an example, which contains
     * the potential values of the Enum.
     *
     * @return an example for a property
     */
    String example() default "";

}
