/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.mongodb;

import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.model.Storage;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoStorageScanner
extends AbstractRuntimeScanner {
    private final ScanApplicationContext context;

    public MongoStorageScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        data.getExecution().setScannedStorages(true);
        List<Storage> storages = this.getMongoStorages();
        data.addStorages(storages);
    }

    private List<Storage> getMongoStorages() {
        Map<String, ?> templates = this.context.getBeansOfType("org.springframework.data.mongodb.core.MongoTemplate");
        if (templates.isEmpty()) {
            return Collections.emptyList();
        }
        return templates.values().stream().map(this::convertToStorage).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<Storage> convertToStorage(MongoTemplate mongoTemplate) {
        Document buildInfoDocument = mongoTemplate.executeCommand("{ buildInfo: 1 }");
        Object dbVersion = buildInfoDocument.get((Object)"version");
        String dbName = mongoTemplate.getDb().getName();
        if (dbName == null || dbName.isEmpty()) {
            dbName = "MongoDB";
        }
        Storage storage = new Storage();
        storage.setName(dbName);
        if (dbVersion != null) {
            storage.addProperty("Version", String.valueOf(dbVersion));
            storage.addProperty("Name", "MongoDB");
        }
        return Optional.of(storage);
    }
}

